//
// edge_pigment.inc
//
// 2007 Sam Benge
//
// requires: pts_sphere.inc
//
// edge_pigment( object ep_obj, float ep_r, float ep_rr, float ep_q )
// ep_obj       = a predeclared object
// ep_r         = radius of effect (range: 0-?)
// ep_rr        = jitter (range: 0-?, increases radius, keep at ep_r/2 to reduce artifacts)
// ep_q         = quality of effect (range: 0-1)
//
// usage:
// pigment{ edge_pigment( my_object, 1.5, 1.0 ) }
//
#include"pts_sphere.inc"

#declare eps=seed(001);

#macro edge_pigment(ep_obj,ep_r, ep_rr, ep_q)
 pigment_pattern{
  average
  pigment_map{
   #local V=0;
   #while(V<dimension_size(pts_sphere,1))
    [1
     object{ep_obj rgb 1, rgb 0}
     translate pts_sphere[V]*ep_r+<rand(eps)-rand(eps),rand(eps)-rand(eps),rand(eps)-rand(eps)>*ep_rr
    ]
    #local V=V+1/ep_q;
   #end
  }
 }
#end