#include "colors.inc"

#declare cloudMult = 1.25;

#declare CloudsLow5 =
density{
 bozo 
 turbulence 0.7
 octaves 7 
 omega 0.49876 
 lambda 2.5432
 density_map {
  [0.0 rgbf <0.1,0.1,0.1,0.05>]
  [0.4 rgbf <0.2,0.2,0.2,0.2>]
  [0.7 rgbf <0.2,0.2,0.2,0.2>]
 }
 scale 0.60 
 scale <20,0.2,0.2>
}

#declare CloudsHigh5 =
density {
 bozo
 turbulence .7 
 octaves 7 
 omega 0.49876 
 lambda 2.5432
 density_map {
  [0.0 rgbf <0.9,0.9,0.9,0.1>]
  [0.4 rgbf <0.95,0.95,0.95,0.9>]
  [0.7 rgbf <1,1,1,1>]
 }
}
         
#declare CloudsLow4 =
density {
 bozo 
 turbulence 0.3
 omega 0.7
 density_map {
  [ 0.750 bumps 
    turbulence 0.3 
    omega 0.7 
    color_map{
     [0 rgb 1.0]
     [1 rgb 1.5]
    }
    scale 0.4 
  ]
 }
}
 
#declare CloudsHigh4 =
density {
 bozo 
 turbulence 0.3
 omega 0.7
  density_map {
   [ 0.750 
    bumps
    turbulence 0.3 
    omega 0.7 
    color_map{
     [0 rgb 1.0 ]
     [1 color Clear]
     [2 color Clear]
     [3 rgb 1.7]
     [4 color Clear]
     [5 rgb 1.2]
    }
    scale 0.6
   ]
  } 
 scale 4000 
}


intersection {
 plane {
  -y,0
 }
 plane {
  y,1
 }
 pigment {
  rgbft .85*cloudMult//1.95
 }
 interior {
  media{
  samples 20 // could need more
  absorption <0.45,0.45,0.45>/2
  scattering {
   1,<0.45,0.45,0.45>*2
  }
  density{
   gradient y
   density_map {
    [0 rgb 0.2]
    [0.1 CloudsLow5]
    [0.5 CloudsHigh5]
    [1 rgb <0.1,0.1,0.1>]
   }
   ramp_wave
  }
 }
}
rotate 5*x
translate 18*y
hollow on
}

intersection {
 plane {
  -y,0
 }
 plane {
  y,1
 }
 pigment {
  rgbft .85*cloudMult//1.95
 }
 interior {
  media{
  samples 20 // could need more
  absorption <0.45,0.45,0.45>/2
  scattering {
   1,<0.45,0.45,0.45>*2
  }
  density{
   gradient y
   density_map {
    [0 rgb 0.2]
    [0.1 CloudsLow4]
    [0.5 CloudsHigh4]
    [1 rgb <0.1,0.1,0.1>]
   }
   ramp_wave
  }
 }
}
rotate 5*x
translate 15*y
hollow on
}

#declare CloudsLow3 =
density{
 bozo 
 turbulence 0.7
 octaves 7 
 omega 0.49876 
 lambda 2.5432
 density_map {
  [0.0 rgbf <0.1,0.1,0.1,0.5>]
  [0.4 rgbf <0.2,0.2,0.2,0.75>]
  [0.7 rgbf <0.2,0.2,0.2,0.72>]
 }
 scale 0.60 
 scale <20,0.2,0.2>
}

#declare CloudsHigh3 =
density {
 bozo
 turbulence .7 
 octaves 7 
 omega 0.49876 
 lambda 2.5432
 density_map {
  [0.0 rgbf <0.9,0.9,0.9,0.5>]
  [0.4 rgbf <0.95,0.95,0.95,0.9>]
  [0.7 rgbf <1,1,1,1>]
 }
}
         
#declare CloudsLow2 =
density {
 bozo 
 turbulence 0.5
 density_map {
  [0 rgbf <0.7,0.9,1,0.75>]
  [0.5 rgbf <0.8,0.9,1,0.75>]
  [0.55 rgbf <0,0,0,0.75>]
 }
}

#declare CloudsHigh2 =
density {
 bozo 
 turbulence 0.3
 omega 0.7
  density_map {
   [ 0.750 
    bumps
    turbulence 0.3 
    omega 0.7 
    color_map{
     [0 rgbf <1,1,1,0.75> ]
     [1 color Clear]
     [2 color Clear]
     [3 rgbf <1.7,1.7,1.7,0.75>]
     [4 color Clear]
     [5 rgbf <1.2,1.2,1.2,0.75>]
    }
    scale 0.6
   ]
  } 
 scale 4000 
}


intersection {
 plane {
  -y,0
 }
 plane {
  y,1
 }
 pigment {
  rgbft .75*cloudMult//1.75
 }
 interior {
  media{
  samples 20 // could need more
  absorption <0.45,0.45,0.4>/2
  scattering {
   1,<0.45,0.45,0.45>*2
  }
  density{
   gradient y
   density_map {
    [0 rgb 0.2]
    [0.1 CloudsLow3]
    [0.5 CloudsHigh3]
    [1 rgb <0.1,0.1,0.1>]
   }
   ramp_wave
  }
 }
}
rotate 5*x
translate 12*y
hollow on
}

intersection {
 plane {
  -y,0
 }
 plane {
  y,1
 }
 pigment {
  rgbft .75*cloudMult//1.75
 }
 interior {
  media{
  samples 20 // could need more
  absorption <0.45,0.45,0.45>/2
  scattering {
   1,<0.45,0.45,0.45>*2
  }
  density{
   gradient y
   density_map {
    [0 rgb 0.2]
    [0.1 CloudsLow2]
    [0.5 CloudsHigh2]
    [1 rgb <0.1,0.1,0.1>]
   }
   ramp_wave
  }
 }
}
rotate 5*x
translate 9*y
hollow on
}

#declare CloudsLow0 =
density{
 bozo 
 turbulence 0.7
 octaves 7 
 omega 0.49876 
 lambda 2.5432
 density_map {
  [0.0 rgbf <0.1,0.1,0.1,1>]
  [0.4 rgbf <0.2,0.2,0.2,1>]
  [0.7 rgbf <0.2,0.2,0.2,1>]
 }
 scale 0.60 
 scale <20,0.2,0.2>
}

#declare CloudsHigh0 =
density {
 bozo 
 turbulence 0.5
 density_map {
  [0 rgbf 1]
  [0.5 rgbf <0.99,0.99,0.9,1>*2]
  [0.525 rgbf <0,0,0,1>]
 }
}

         
#declare CloudsLow1 =
density {
 bozo 
 turbulence 0.5
 density_map {
  [0 rgbf <0.7,0.9,1,1>]
  [0.5 rgbf <0.8,0.9,1,1>]
  [0.55 rgbf <0,0,0,1>]
 }
}

#declare CloudsHigh1 =
density {
 bozo 
 turbulence 0.3
 omega 0.7
  density_map {
   [ 0.750 
    bumps
    turbulence 0.3 
    omega 0.7 
    color_map{
     [0 rgb 1.0 ]
     [1 color Clear]
     [2 color Clear]
     [3 rgb 1.7]
     [4 color Clear]
     [5 rgb 1.2]
    }
    scale 0.6
   ]
  } 
 scale 4000 
}


intersection {
 plane {
  -y,0
 }
 plane {
  y,1
 }
 pigment {
  rgbft .65*cloudMult//1.5
 }
 interior {
  media{
  samples 20 // could need more
  absorption <0.45,0.45,0.45,0.9>/2
  scattering {
   1,<0.45,0.45,0.45,0.9>*2
  }
  density{
   gradient y
   density_map {
    [0 rgbf <0.2,0.2,0.2,0.9>]
    [0.1 CloudsLow0]
    [0.5 CloudsHigh0]
    [1 rgbf <0.1,0.1,0.1,0.9>]
   }
   ramp_wave
  }
 }
}
rotate 5*x
translate 6*y
hollow on
}

intersection {
 plane {
  -y,0
 }
 plane {
  y,1
 }
 pigment {
  rgbft .65*cloudMult//1.5
 }
 interior {
  media{
  samples 20 // could need more
  absorption <0.45,0.45,0.45,0.9>/2
  scattering {
   1,<0.45,0.45,0.45,0.9>*2
  }
  density{
   gradient y
   density_map {
    [0 rgbf <0.2,0.2,0.2,0.9>]
    [0.1 CloudsLow1]
    [0.5 CloudsHigh1]
    [1 rgbf <0.1,0.1,0.1,0.9>]
   }
   ramp_wave
  }
 }
}
rotate 5*x
translate 3*y
hollow on
}


light_source{<100,100,-100>,1}

camera{location -z/2 look_at y/8}

sky_sphere{
        pigment{gradient y
        color_map{[0 rgb <0.5,0.5,0.55>][1 rgb <0.2,0.2,0.22>]}
        rotate 5*x
}}

fog{fog_type 2 color <0.5,0.45,0.4> distance 5 fog_alt 0.1 fog_offset -0.1}

plane{y,-0.1 pigment {bozo}}
/* END */  
