#include "colors.inc"

/* BEGIN */

#declare CloudsLow =
density{
 bozo 
 turbulence 0.7
 octaves 7 
 omega 0.49876 
 lambda 2.5432
 density_map {
  [0.0 rgbf <0.1,0.1,0.1,0.05>]
  [0.4 rgbf <0.2,0.2,0.2,0.2>]
  [0.7 rgbf <0.2,0.2,0.2,0.2>]
 }
 scale 0.60 
 scale <20,0.2,0.2>
}

#declare CloudsHigh =
density {
 bozo 
 turbulence 0.5
 density_map {
  [0 rgb 1]
  [0.5 rgb <0.99,0.99,0.9>*2]
  [0.525 rgb 0]
 }
}

         
#declare CloudsLow1 =
density {
 bozo 
 turbulence 0.5
 density_map {
  [0 rgb <0.7,0.9,1>]
  [0.5 rgb <0.8,0.9,1>]
  [0.55 rgb 0]
 }
}

#declare CloudsHigh1 =
density {
 bozo 
 turbulence 0.3
 omega 0.7
  density_map {
   [ 0.750 
    bumps
    turbulence 0.3 
    omega 0.7 
    color_map{
     [0 rgb 1.0 ]
     [1 color Clear]
     [2 color Clear]
     [3 rgb 1.7]
     [4 color Clear]
     [5 rgb 1.2]
    }
    scale 0.6
   ]
  } 
 scale 4000 
}


intersection {
 plane {
  -y,0
 }
 plane {
  y,1
 }
 pigment {
  rgbt 1
 }
 interior {
  media{
  samples 20 // could need more
  absorption <0.5,0.45,0.4>/2
  scattering {
   1,<0.4,0.45,0.5>*2
  }
  density{
   gradient y
   density_map {
    [0 rgb 0.2]
    [0.1 CloudsLow]
    [0.5 CloudsHigh]
    [1 rgb <0.1,0.1,0.1>]
   }
   ramp_wave
  }
 }
}
rotate 5*x
translate 6*y
hollow on
}

intersection {
 plane {
  -y,0
 }
 plane {
  y,1
 }
 pigment {
  rgbt 1
 }
 interior {
  media{
  samples 20 // could need more
  absorption <0.5,0.45,0.4>/2
  scattering {
   1,<0.4,0.45,0.5>*2
  }
  density{
   gradient y
   density_map {
    [0 rgb 0.2]
    [0.1 CloudsLow1]
    [0.5 CloudsHigh1]
    [1 rgb <0.1,0.1,0.1>]
   }
   ramp_wave
  }
 }
}
rotate 5*x
translate 3*y
hollow on
}

light_source{<100,100,-100>,1}

camera{location -z/2 look_at y/8}

sky_sphere{
        pigment{gradient y
        color_map{[0 rgb <0.5,0.5,0.55>][1 rgb <0.2,0.2,0.22>]}
        rotate 5*x
}}

fog{fog_type 2 color <0.5,0.45,0.4> distance 5 fog_alt 0.1 fog_offset -0.1}

plane{y,-0.1 pigment {bozo}}
/* END */  
