//---------------------------------------//
//      Glacier texture by [GDS|Entropy] |
//                         Ian McDonald  |    
//                                       |
//      Modification of Bob Hughes slope |
//      texture from rmfMountains.pov    |
//---------------------------------------//

#declare _C_ = -2;

#declare SnowIce = 
texture {
 pigment { 
  color rgb 1 
 }
 finish { 
  ambient 0 
  diffuse 1 
  brilliance 0.1 
  specular 0.5 
  roughness 0.001 
  reflection 0.3 
 }
 normal { 
  wrinkles 0.1 
  scale 0.00001 
 }
}     

#declare Ice =
texture {
 pigment {
  bumps 
  turbulence 0.6 
  color_map {
   [.3 color rgb <0.15,0.425,0.45>]
   [.5 color rgb <0.3,0.5,0.525>]
  }
 }
 normal {
  bumps 1.3 
  turbulence 0.6
 }
 finish {
  ambient 0.125 
  diffuse 0.8 
  specular 0.1 
  roughness 0.045
 }
 scale .003
}

#declare Ice2 =
texture {
 pigment {
  bumps 
  turbulence 0.7 
  color_map {
   [.3 color rgb <0.25,0.55,0.75>]
   [.5 color rgb <0.375,0.6,0.8>]
  }
 }
 normal {
  bumps 1.2 
  turbulence 0.7
 }
 finish {
  ambient 0.15 
  diffuse 0.7 
  specular 0.15 
  roughness 0.02
 }
 scale 0.00275
}

#declare Slush =
texture {
 pigment {
  dents 
  turbulence 0.3 
  color_map {
   [0 color rgb <0.4,0.7,0.8>]
   [1 color rgb <0.45,0.55,0.525>]
  }
 }
 normal {
  dents 0.6 
  turbulence 0.3
 }
 finish {
  ambient 0.175 
  diffuse 0.8 
  specular 0.075 
  roughness 0.075
 }
 scale 0.00225
}       

#declare Slush2 =
texture {
 pigment {
  bozo 
  turbulence 0.3 
  color_map {
   [0 color rgb <0.4,0.5,0.6>*1.3]
   [1 color rgb <0.5,0.55,0.65>*1.2]
  }
 }
 normal {
  bozo 0.6 
  turbulence 0.3
 }
 finish {
  ambient 0.175 
  diffuse 0.8 
  specular 0.075 
  roughness 0.075
 }
 scale 0.002
}

#declare Snow =
texture {
 pigment {
  color rgb <0.96,0.97,0.99>*1.1
 }
 normal {
  wrinkles 0.4 
  ramp_wave 
  turbulence 0.3 
  scale 0.039
 }
 finish {
  ambient 0.35 
  diffuse 0.425 
  specular 0.125 
  roughness 0.1
 }
}

#declare Snow2 =
texture {
 pigment {
  color rgb <0.98,0.97,0.96>
 }
 normal {
  wrinkles 0.3 
  ramp_wave 
  turbulence 0.25 
  scale 0.036
 }
 finish {
  ambient 0.325 
  diffuse 0.4 
  specular 0.15 
  roughness 0.075
 }
}

#declare Rock =
texture {
 pigment {
  crackle 
  turbulence 0.2 
  color_map {
   [0 color  rgb <0.75,0.75,0.75>]
   [1 color  rgb <0.67,0.67,0.67>*0.8]
  }
 }
 normal {
  crackle 0.6 
  turbulence 0.2
 }
 finish {
  ambient 0.125 
  diffuse 0.3 
  specular 0.05 
  roughness 0.6
 }
 scale 0.016
}    

#declare Rock2 =
texture {
 pigment {
  crackle 
  turbulence 0.4 
  color_map {
   [0 color  rgb <0.8,0.775,0.75>]
   [1 color  rgb <0.75,0.7,0.67>*0.8]
  }
 }
 normal {
  crackle 0.9 
  turbulence 0.4
 }
 finish {
  ambient 0.15 
  diffuse 0.25 
  specular 0.05 
  roughness 0.6
 }
 scale 0.018
}       

#declare Dirt =
texture {
 pigment {
  crackle 
  turbulence 0.5 
  color_map {
   [0 color rgb <0.6,0.5,0.4>*0.8]
   [1 color rgb <0.625,0.525,0.45>]
  }
 }
 normal {
  crackle 1.5 
  turbulence 0.5
 }
 finish {
  ambient 0.2 
  diffuse 0.7 
  specular 0.075 
  roughness 0.1
 }
 scale 0.009
}       

#declare Dirt2 =
texture {
 pigment {
  spotted 
  turbulence 0.5 
  color_map {
   [0 color rgb <0.5,0.475,0.35>*1.6]
   [1 color rgb <0.55,0.525,0.4>*1.3]
  }
 }
 normal {
  spotted 0.25 
  turbulence 0.5
 }
 finish {
  ambient 0.2 
  diffuse 0.7 
  specular 0.075 
  roughness 0.1
 }
 scale 0.007
}

#declare GlacierTex1 =
texture {
  slope -y
  texture_map {
    [0.0225             SnowIce]
    [0.03-(0.05*_C_)    Slush]
    [0.035-(0.01*_C_)   Ice2]
    [0.04+(0.133*_C_)   Ice]
    [0.05+(0.149*_C_)   Ice2]
    [0.07+(0.133*_C_)   Slush2]
    [0.1+(0.199*_C_)    Dirt2]
    [0.15+(0.15*_C_)    Dirt]
    [0.199+(0.2*_C_)    Rock2]
    [0.2+(0.55*_C_)     Rock2]
    [0.25+(0.445*_C_)   Snow2]
    [0.425+(0.2725*_C_) Snow]
    [0.925-(0.2225*_C_) Snow]
    [0.933-(0.15*_C_)   Rock]
  } rotate -5*z
}