// Initial Authors: Chris Huff/Bob Hughes
//
// Modified by [GDS|Entropy]

#version unofficial megapov 1.1;
#include "functions.inc"
#include "ridgedMF_SlopeGlacier.inc"

global_settings {
	assumed_gamma 1.0
}

camera {
	location <-5, 6,-18>
	up y*image_height right x*image_width
	look_at < 0, 1.5, 0>
	angle 45
}

fog {
 fog_type 2
 distance 40
 color rgbt <0.5,0.5,0.5,0>
 turbulence 1
 turb_depth 1
 omega 0.1
 lambda 5
 octaves 2
 fog_offset 1.25
 fog_alt 1
}

//      Steelblue1 is the default glow color used in all old files
#declare SteelBlue            =  rgb <0.1370, 0.4190, 0.5560>; 
#declare SteelBlue1           =  rgb <0.2734, 0.5078, 0.7031>; 
#declare SteelBlue2           =  rgb <0.3867, 0.7188, 1.0000>; 
#declare SteelBlue3           =  rgb <0.3594, 0.6719, 0.9297>; 
#declare SteelBlue4           =  rgb <0.3086, 0.5781, 0.8008>; 
#declare SteelBlue5           =  rgb <0.2109, 0.3906, 0.5430>;

//Types:
#local Float = 0;
#local Vector = < 0, 0, 0>;
#local Color = color rgb < 0, 0, 0>;

#macro SRand(RS) (rand(RS)*2 - 1) #end
#macro RRand(RS, Min, Max) (rand(RS)*(Max-Min) + Min) #end
#macro Clamp(V, Min, Max) (min(Max, max(Min, V))) #end
#macro Range(V, Rmn, Rmx) (V*(Rmx-Rmn) + Rmn) #end
#macro RClamp(V, Rmn, Rmx, Min, Max) (Clamp(Range(V, Rmn, Rmx), Min, Max)) #end

#local RsA = seed(574647);

#local J = Float;
#local J = 0;
 #while(J<52)
 
 #local rodX = SRand(RsA)*8;
 #local rodY = rand(RsA)*4;
 #local rodZ = SRand(RsA)*8;
 
 union {
  light_source {
   <rodX,rodY+1,rodZ>
   color rgb 0.045*<0.2734*rand(RsA), 0.5078*rand(RsA), 0.7031*rand(RsA)>
   glow { 
    size rand(RsA)*0.65 type int(rand(RsA))
   }
   fade_distance 4 fade_power 2
  }
  cylinder {
      <rodX,0,rodZ>, <rodX,(rodY)+1-0.125,rodZ>,  0.025
       pigment{color rgb <0.1,0.1,0.11>}  
  }  
 }
 #set J = J + 1;
#end

#declare H = .3;                // roughening<>smoothing
#declare Lacunarity = 4;        // roughening<>smoothing
#declare Octaves = 6;           // smoothing<>roughening
#declare Offset = -.1;          // height
#declare Gain= 1.9;             // smoothing<>roughening

#declare F0 = function {
 f_ridged_mf(x,y,z, H, Lacunarity, Octaves, Offset, Gain, 3)
}

#declare Fs = function {
 pigment {
  spotted 
  turbulence .5 
  color_map {
   [0 color rgb .67]
   [1 color rgb .75]
  } 
  scale 0.03
 }
}

isosurface {
 function { 
  y-(F0(x,y*1.5,z)*(f_noise3d(x*.1,y*.125,z*.1)/.333))*Fs(x,y,z).gray
 }
 accuracy 0.0005
 max_gradient 8
 contained_by {
 box {
  <-12, 0, -12>, <12, 0.55, 12>
 }
}
texture {
 GlacierTex1
}
scale <100,20,100>
translate <1000,0,1000>
}

sphere {
 < 0, 2, 0>, 2
 pigment {rgb 1}
 finish {
  conserve_energy  
  reflection { 
   0.5, 0.85 
   metallic 
  }
  diffuse 0.15 
  ambient 0
 }
}

