

#include "woods.inc"

// Textures and materials ------------------------------------------
/*
#declare t_grass = texture {
	pigment{color rgb<0.35,0.65,0.0>}
	normal {bumps 1.75 scale 0.015  }
	finish {ambient 0.1 diffuse 0.8 }
} 
*/
#declare t_grass=texture {
    pigment {
      agate
      color_map {
			 	[0.0 rgb 0]
			 	[0.12 rgb <0.57,0.825,0.35>*.8]
			 	[0.6 rgb <0.57,0.825,0.35>*0.4]
      }
      scale .25
      turbulence 0.2
    }
    normal { agate 0.75 scale 0.25  turbulence 0.2}
    finish { phong 0.1 } 
	scale 0.01
}
#declare t_sabbia = texture {
     pigment {
        granite
        color_map {
           [ 0.0     rgbft <0.670588, 0.505882, 0.321569, 0.0, 0.0> ]
           [ 1.0     rgbft <0.941176, 0.878431, 0.792157, 0.0, 0.0> ]
        }
        turbulence 0.75
        ramp_wave
        //scale 0.1 // Too big at high resolutions
        scale  0.01
     }
}
/*
#declare t_bordo = texture {
	pigment {
		granite
		color_map {
			[0.0 rgbft <0.7,0.7,0.7,0,0>]
			[1.0 rgbft <1,1,1,0,0>]
		}
		turbulence 0.5
		scale 0.2
	}
} 
*/
#declare t_bordo=texture {
	pigment {
		granite
		color_map {
			[0.0 rgbft <0.7,0.7,0.7,0,0>]
			[0.2 rgbft <0.7,0.7,0.7,0,0>]
			[0.3 rgb <0.9, 0.8, 0.7>]
			[0.5 rgbft <1,1,1,0,0>]
			[1.0 rgbft <1,1,1,0,0>]
		}
		turbulence 0.5
		scale 1.2
	}
	normal {
		granite
		turbulence 0.5
	    slope_map {
	        [ 0.0    <1,0> ]
	        [ 0.6    <1,0> ]
	        [ 0.6    <1,-1> ]
	        [ 1.0    <0,0> ]
	    }
		scale 1.2
	}
	scale 0.01 	
}
// Thank you to Bob
#declare t_bordo=texture {
    pigment {
        granite
        color_map {
            [0.0 rgbft <0.7,0.7,0.7,0,0>]
            [0.2 rgbft <0.7,0.7,0.7,0,0>]
            [0.3 rgb <0.9, 0.8, 0.7>]
            [0.5 rgbft <1,1,1,0,0>]
            [1.0 rgbft <1,1,1,0,0>]
        }
        turbulence 0.5
        scale 1.2
    }
    }
    texture {
    pigment {
           gradient y
        color_map {
            [0.0 rgbf 1/5]
            [0.525 rgbf 1/4]
            [0.55 rgbft <0.25,0.25,0.25,0.5,0.5>]
            [0.575 rgbft <0,0,0,1,1>]
            [1.0 rgbft 1]
        }
        scale 50
    }
    normal {
        granite
        turbulence 0.5
        slope_map {
            [ 0.0    <1,0> ]
            [ 0.6    <1,0> ]
            [ 0.6    <1,-1> ]
            [ 1.0    <0,0> ]
        }
        scale 1.2
    }
    scale 0.01
} 
#declare p_pink = pigment{color rgb <1,0.5,0.5>};
#declare p_violet = pigment{color rgb <0.7,0.5,0.8>};

// The water
#declare c_water = color_map {
	[ 0.00 rgbt <0.4,0.5,0.8, 0.9> ]
	[ 0.90 rgbt <0.4,0.5,0.8, 1> ]
	[ 1.00 rgb <1,1,1> ]
}

#declare t_water = texture {
    pigment{
    	//rgbt <0.4,0.5,0.8, 0.9>
    	gradient z 
    	color_map {c_water}
	    turbulence 0.9
    }
               
    normal {
        ripples 0.75
        frequency 1
        translate <-3,0,3>
    }            
    finish {
		diffuse 0.3
		ambient 0.0
        reflection {0.3, 1 fresnel}
        conserve_energy
		specular 0.4
		roughness 0.003
    }
}
#declare i_water = interior {
    ior 1.33
    fade_distance 0.3
    //fade_power 1001
    //fade_color <0.4, 0.5, 0.47>
}

#declare m_water = material {
    texture {t_water}
    interior {i_water}
}

// The sky
#declare p_sky=pigment{      
    bozo
    color_map {
       [ 0.0     rgbft <0.196078, 0.6, 0.8, 0.0, 0.0> ]
       [ 0.1     rgbft <0.196078, 0.6, 0.8, 0.0, 0.0> ]
       [ 0.7     rgbft <0.8, 0.8, 0.833333, 0.0, 0.0> ]
       [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
    }
    turbulence 0.5
    octaves 3
    lambda 6.0
    ramp_wave
    scale  5.0
}
#declare t_sky=texture{      
	pigment {p_sky}
	finish {ambient 1 diffuse 0}
}

#declare t_yell_grass=texture{
	pigment {
		spotted
	    color_map {
	        [0.0, 0.2  color Tan*0.1 color Tan*0.4]
	        [0.2, 0.3  color Tan*0.4 color rgb <1,0.9,0>]
	        [0.3, 1.01 color rgb <1,0.9,0> color rgb <1,0.9,0>*1.2]
	    }
	    scale 0.01
	}
}
// -----------------------------------------------------------------

// Truchet patterns ------------------------------------------------
#declare r_truchet=0.15;
#declare r_border=0.03;
//0<r_truchet<0.5
#if((r_truchet<=0) | (r_truchet>=0.5))
	#declare r_truchet=0.15; //default
#end
//0<r_border<0.5
#if((r_border<=0) | (r_border>=0.5))
	#declare r_border=0.04; //default
#end
 
// The field with the rivers
#declare tru_pattern=difference {
	box {<-0.5,0,-0.5> <0.5,0.3,0.5> texture {t_grass}}
	union {
		// Upper arc
		difference {
			cylinder {<0.5,-0.05,0.5> <0.5,0.35,0.5> 0.5+r_truchet}
			cylinder {<0.5,-0.1,0.5>  <0.5,0.4,0.5>  0.5-r_truchet}
		}
		// Lower arc
		difference {
			cylinder {<-0.5,-0.05,-0.5> <-0.5,0.35,-0.5> 0.5+r_truchet}
			cylinder {<-0.5,-0.1,-0.5>  <-0.5,0.4,-0.5>  0.5-r_truchet}
		}
	}
}

// Border of the river
#declare tru_border=intersection {
	box {<-0.5,0,-0.5> <0.5,1,0.5>}
	union {
		// Internal upper arc
		difference {
			cylinder {<0.5,-0.05,0.5> <0.5,0.32,0.5> 0.5+r_truchet+r_border}
			cylinder {<0.5,-0.1,0.5>  <0.5,0.4,0.5>  0.5+r_truchet-r_border}
		}
		// External upper arc
		difference {
			cylinder {<0.5,-0.05,0.5> <0.5,0.32,0.5> 0.5-r_truchet+r_border}
			cylinder {<0.5,-0.1,0.5>  <0.5,0.4,0.5>  0.5-r_truchet-r_border}
		}
		// Internal lower arc
		difference {
			cylinder {<-0.5,-0.05,-0.5> <-0.5,0.32,-0.5> 0.5-r_truchet+r_border}
			cylinder {<-0.5,-0.1,-0.5>  <-0.5,0.4,-0.5>  0.5-r_truchet-r_border}
		}
		// External upper arc
		difference {
			cylinder {<-0.5,-0.05,-0.5> <-0.5,0.32,-0.5> 0.5+r_truchet+r_border}
			cylinder {<-0.5,-0.1,-0.5>  <-0.5,0.4,-0.5>  0.5+r_truchet-r_border}
		}
	}
	texture {t_bordo}
}


#declare tru_water=box{<-0.5,0,-0.5> <0.5,0.25,0.5>}
// -----------------------------------------------------------------


// The boat --------------------------------------------------------
#macro boat(feed)
union {
	prism { 0.0 ,0.1 , 6
	       <-1.00, -1.0>,
	       < 1.00, -1.00>, 
	       < 1.00, 1.00>, 
	       < 0.00, 2.00>, 
	       <-1.00, 1.00>, 
	       <-1.00, -1.00>
	
	    texture{T_Wood30}
	       
	    scale <0.5,1,1>       
		translate <0,0.2,0> 
		translate <.5,0.24,.5>
	}
	cylinder {<0,0,0> <0,2,0> 0.03
		texture{T_Wood17}
		translate <.5,0.24,.5>
	}
	triangle {
		< 0,2.3,0>
		< 0,0.6,-1.2>  
		< 0,0.6,1.2>
		//pigment {rgb 1}
		pigment {rgb <rand(feed)*255,rand(feed)*255,rand(feed)*255>/255}
		translate <.5,0.24,.5>
	}
	scale 0.1
}
#end

// -----------------------------------------------------------------
