/*
 * @file 	test_truchet
 * @desc 	Landscapes generated with a Truchet pattern
 * @auth	Paolo Gibellini
 * @date	03/02/2009
 * @date	16/01/2009
 * @date	05/06/2008
 * @begin	17/01/2007
 * @note	Inspired by excellent Lightbeam works on zoologique newsgroup
 * @note	After Paul Bourke works I was stimulated to resume my wip
 * @note	Finally, after wikipedia voice I needed to end the wip
 */

// ToDo: bridges
// ToDo: some people?
// ToDo: a better sky and light
// ToDo: a better grass?

#include "colors.inc"

#declare show_field=0;
#declare show_border=1;
#declare show_boat=0;
#declare show_water=0;
#declare do_grass=0;

#declare rad_on=0;

#include "truchet22.inc"

#if (rad_on)
    global_settings {
      radiosity {
        pretrace_start 0.08           // start pretrace at this size
        pretrace_end   0.04           // end pretrace at this size
        count 35                      // higher -> higher quality (1..1600) [35]
        nearest_count 5               // higher -> higher quality (1..10) [5]
        error_bound 1.8               // higher -> smoother, less accurate [1.8]
        recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
        low_error_factor .5           // reduce error_bound during last pretrace step
        gray_threshold 0.0            // increase for weakening colors (0..1) [0]
        minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
        brightness 1                  // brightness of radiosity effects (0..1) [1]
    
        adc_bailout 0.01/2
        //normal on                   // take surface normals into account [off]
        //media on                    // take media into account [off]
        //save_file "file_name"       // save radiosity data
        //load_file "file_name"       // load saved radiosity data
        //always_sample off           // turn sampling in final trace off [on]
        //max_sample 1.0              // maximum brightness of samples
      }
    }
#else
    global_settings {
      assumed_gamma 1.0
    }
#end
// ----------------------------------------

camera {
  location <0, 2, -1.5>
  look_at  <0.0, 0.0,  0.0>
}

sky_sphere {
    pigment {p_sky}
}

// sun
light_source{<1500,2500,-2500> color rgb 1}
// ----------------------------------------

plane { y, 0.1 
    texture {t_bordo_old scale 20 }
}

// Scene ----------------------------------
#declare R1 = seed(5);
#declare R2 = seed(5);
#declare R3 = seed(7);

#declare s_boat=0.9;

// Full size
//#declare nx=5;
//#declare nz=8;

#declare nx=3;
#declare nz=3;

#local ix=-nx;
#local the_field=sphere{0 0.1}

// Builds the Truchet and show the border
#while(ix<nx)
    #local iz=-nz;
    #while(iz<nz)
        #local na=int(rand(R1)*4);
        // Incremental Truchet
        #local the_field=union{
        	// Previous field
        	object{the_field}
	        // Truchet
	        difference {
	        	object{tru_pattern}
	        	object{tru_border}
	            rotate 90*na*y
	            translate <ix,0,iz>
	            //texture {t_grass}
	        }
	    }
	    // Border
		#if(show_border)
            object {tru_border
	            rotate 90*na*y
	            translate <ix,0,iz>
            }
		#end
        // Boat
        #if (show_boat)
            #if (rand(R3)<=s_boat)
                object {boat(R2)
                    rotate <0,10*rand(R1)-45,0>
                    translate <0.15,0,0.15>
                    rotate 90*na*y
                    translate <ix,0.2,iz>
                }
            #end
        #end
        #local iz=iz+1;
    #end
    #local ix=ix+1;
#end

#declare m_min=min_extent(the_field);
#declare m_max=max_extent(the_field);

// The grass
#if(do_grass)
	#declare h_leave=0.3;
	#declare R_leave=0.003;
	#declare r_leave=0.001;
	#declare wind_dir=<-0.04,0.5,-0.04>;
	#declare wind_range=<0.02,0.2,0.03>;
	#declare Normal=<0,0,0>;
	//#declare m_min=min_extent(the_field);
	//#declare m_max=max_extent(the_field);
	#declare m_steps=70;
	#declare m_steps=m_steps*max(nx,nz);
	#declare R4 = seed(9);
	#declare r_stop=0.8;
	#local i=0;
	#while (i<=m_steps)
		#local j=0;
		#local m_x=m_min.x+(m_max.x-m_min.x)*i/m_steps;
		#while (j<=m_steps)
			#local m_z=m_min.z+(m_max.z-m_min.z)*j/m_steps;
			#if(rand(R4)<=r_stop)
				#declare Intersection=trace(the_field, <m_x,10,m_z>, -y, Normal);
				#if(vlength(Normal) > 0)
					#local x_correction=wind_dir.x+2*(rand(R2)-0.5)*wind_range.x;
					#local y_correction=wind_dir.y+2*(rand(R2)-0.5)*wind_range.y;
					#local z_correction=wind_dir.z+2*(rand(R2)-0.5)*wind_range.z;
					// Leaves
					cone{Intersection-0.001*y R_leave Intersection+<x_correction,h_leave*y_correction,z_correction> r_leave 
						texture{t_yell_grass}
					}
				#end
			#end
			#local j=j+1;
		#end
		#local i=i+1;
	#end
#end

// The field
#if(show_field)
	object{the_field texture {t_sabbia}}
#end


// The water
#if(show_water)
	#declare the_water =box{<m_min.x,0,m_min.z> <m_max.x,0.15,m_max.z>};
	object {the_water material {m_water} translate 0.1*y}
#end
