/*
Christmas 2008 - Pinewood
Paolo Gibellini

Credits:
 - Lit tapered candle scene file by Ken Tyler 1-16-1999 tylereng [at] pacbellnet
 - Realsky by Nick Stevens, starbase1@cix.compulink.co.uk
*/

// Parameters ---------------------
#declare show_mountain=1;
#declare pinewood=1;
#declare walking=1;
#declare light_from_cave=1;
#declare show_comet=1;
#declare light_from_comet=1;
#declare show_moon=1;
#declare light_from_moon=1;
#declare show_sky_and_stars=1;
#declare rad_on=0;
#declare normal_camera=1;
// --------------------------------


// Global settings ------------------------------------
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.9
	hf_gray_16 off
	irid_wavelength <0.247059,0.176471,0.137255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
	noise_generator 2
	charset ascii
	#if(rad_on)
		radiosity {
			pretrace_start 0.08           // start pretrace at this size
			pretrace_end   0.04           // end pretrace at this size
			count 35                      // higher -> higher quality (1..1600) [35]
			nearest_count 5               // higher -> higher quality (1..10) [5]
			error_bound 1.8               // higher -> smoother, less accurate [1.8]
			recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
			low_error_factor .5           // reduce error_bound during last pretrace step
			gray_threshold 0.0            // increase for weakening colors (0..1) [0]
			minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
			brightness 1                  // brightness of radiosity effects (0..1) [1]
			
			adc_bailout 0.01/2
			//normal on                   // take surface normals into account [off]
			//media on                    // take media into account [off]
			//save_file "file_name"       // save radiosity data
			//load_file "file_name"       // load saved radiosity data
			//always_sample off           // turn sampling in final trace off [on]
			//max_sample 1.0              // maximum brightness of samples
		}
	#end
}


// Camera & lights -------------
#if(walking)
	#declare camera_location = <0,0.5,-14>;
	#declare camera_look_at = <0,2,0> ;
#else
	#declare camera_location = <0,10.5,-14>;
	#declare camera_look_at = <0,0,0> ;
#end

#if(normal_camera)
	camera {
		location camera_location
		angle 40
		look_at camera_look_at
		normal {
			bozo 0.12 
			scale 0.00001
		}
}
#else
	camera {
		location camera_location
		angle 40
		look_at camera_look_at
	}
#end

// Light ----------
light_source {
  <0, 0, 0>
  color rgb <1, 1, 1>
  photons {}
  translate  <-2, 15, -12>
}

// Textures -----------------
// Moss texture
#declare t_moss=texture {
    pigment {
      agate
      color_map {
			 	[0.0 rgb 0]
			 	[0.12 rgb <0.57,0.825,0.35>*.8*.6]
			 	[0.6 rgb <0.57,0.825,0.35>*0.4*.6]
      }
      scale .25
      turbulence 0.2
    }
    normal { agate 0.75 scale 0.25  turbulence 0.2}
    finish { phong 0.1 } 
	//scale 0.01
	scale 0.1
}

// Cave light: Ken Tyler's Lit tapered candle material
/*
 Lit tapered candle scene file.
 BY: Ken Tyler 1-16-1999 tylereng [at] pacbellnet
 You are free to use this as you wish without my permission.
 If you do something really good with it send me a small image to look_at.
*/
#declare m_cave_light=material {
	texture{
		pigment{rgbt 1}
	}
	interior {
		media {
			emission 1
			scattering{1,.01}
			intervals 10
			samples 1, 15
			confidence 0.9999
			variance 1/1000
			density {
				radial
				turbulence .35
				color_map{
					[ 0 rgb<1.0,1.0,0.0>]
					[.1 rgb<1.0,.50,0.0>]
					[.5 rgb<1.0,.75,.25>]
					[.7 rgb<0.7,.45,0.0>]
					[ 1 rgb<1.0,.65,0.0>]
				}
			}
		}
	}
}

// Visible moon texture
#declare t_moon_light=texture{
	pigment {
		agate
		color_map{
			[ 0 rgb<1,0.98,0.76>*.98]
			[.3 rgb<1,0.98,0.76>*.76]
			[.5 rgb<1,0.98,0.76>*.65]
			[.7 rgb<1,0.98,0.76>*.76]
			[ 1 rgb<1,0.98,0.76>*.98]
		}
		turbulence .61
		scale 2.3
	}
	normal {
		agate
		turbulence .61
		scale 2.3
	}
}

// Hollow moon material
#declare m_moon_light=material {
	texture{
		t_moon_light
	}
	interior {
		media {
			emission 1
			scattering{1,.01}
			intervals 10
			samples 1, 15
			confidence 0.9999
			variance 1/1000
			density {
				radial
				turbulence .35
				color_map{
					[ 0 rgb<1.0,1.0,0.0>]
					[.1 rgb<1.0,.50,0.0>]
					[.5 rgb<1.0,.75,.25>]
					[.7 rgb<0.7,.45,0.0>]
					[ 1 rgb<1.0,.65,0.0>]
				}
			}
		}
	}
}

// Better effect
#declare m_moon_light=m_cave_light;

// COmet light
#declare m_comet_light=material {
	texture{
		pigment{rgbt <1,0.626,0,0.6>}
		finish{diffuse 0.3 ambient 0.0 specular 0.6 reflection {0.8 metallic}}
	}
}

// Trees trunk texture
#declare t_trunk=texture{
	pigment {
		marble
		color_map {
			[0.0 rgb <0.737, 0.585, 0.415>]
			[0.2 rgb <0.737, 0.585, 0.415>*0.2]
			[0.9 rgb <0.737, 0.585, 0.415>*0.9]
		}
		turbulence 0.2
		octaves 4
	}
	normal {
		marble
		turbulence 0.2
		octaves 4
	}
	scale 0.03
}

// Trees leaves texture
#declare t_leaves=texture {      
	pigment {
		agate
		color_map {
			[ 0.0     rgbt <0.3663, 0.5682, 0.0687, 1.0> ]
			[ 0.25    rgbt <0.3663, 0.5682, 0.0687, 0.82> ]
			[ 0.31    rgbt <0.0887, 0.9886, 0.4438, 0.01> ]
			[ 0.39    rgbt <0.1308, 0.9083, 0.5524, 0.2> ]
			[ 0.80    rgbt <0.1755, 0.5095, 0.448, 0.43> ]
			[ 1.0     rgbt <0.1755, 0.5095, 0.448, 1.0> ]
		}
		turbulence 0.6
		ramp_wave
	}
	normal {
		agate
		turbulence 0.6
		ramp_wave
	}      
	finish {
		ambient 0.1
		diffuse 0.5
		phong_size 81.0
		roughness 0.0
	}
	// scale 2.1 // mmm... to be tested
	scale 0.3
}

// Leaves material
#declare m_foglie=material{
	texture{t_leaves}
	interior {
		
	}
}


// Scene -------------------------------------------------------
// Sky and stars
#if(show_sky_and_stars)
	// Sky ------------------------------------------------------------------------
	sky_sphere {
		pigment{
			bozo
			turbulence 0.76
			color_map { 
				//[0.5  rgbf<0.2,0.2,0.2,1.0> ]
				[0.3  rgb<0.1,0.3,0.8> ]
				[0.5  rgbf<0.1,0.3,0.8,1> ]
				[0.6  rgb <0.2,0.2,0.2>     ]
				[0.65 rgb <0.4,0.4,0.4>     ]
				[1.0  rgb <0.1,0.1,0.1>     ] 
			}
		}
	}
	
	// Stars -----------------------------------------------------------------------
	// This file by Nick Stevens, starbase1@cix.compulink.co.uk
	#include "REALSKY.INC"
	object {realsky finish {ambient 0.5}}
#else
	background { color <0.100,0.300,0.800> }
#end

// Comet --------------------------
#if (show_comet)
	#declare R3=seed(23);
	#declare c_stop=0.2;
	#declare c_comet=<1.8,5.6,12>;
	#declare c_tail=<-3,10,12>;
	#declare r_comet=0.3;
	#declare R_comet=5;
	// Core
	#declare comet_core=sphere {
		0, r_comet
		translate c_comet-<r_comet,0,r_comet>/2
	}
	
	// Sparkle
	#declare sparkle=sphere {0 0.05}
	
	// Tail
	#local steps_comet=20;
	#local steps_fetta=10;
	#local i=0;
	#declare tail_comet=union {
		#while (i<=steps_comet)
			#local xs=c_tail.x+(c_comet.x+r_comet-c_tail.x)*i/steps_comet;
			#local ys=c_tail.y+(c_comet.y+r_comet-c_tail.y)*i/steps_comet;
			#local zs=c_tail.z+(c_comet.z+r_comet-c_tail.z)*i/steps_comet;
			
			#local j=0;
			#local r_tail=R_comet-(R_comet-r_comet)*i/steps_comet;
			#while (j<=steps_fetta)
				#local k=0;
				#while (k<=steps_fetta)
					#if(rand(R3)<c_stop)
						//object{sparkle translate <xs+-r_tail/2+r_tail*j/steps_fetta,ys,zs+-r_tail/2+r_tail*k/steps_fetta>}
						object{sparkle translate <xs-2*r_tail+r_tail*j/steps_fetta+3*(1-i/steps_comet),ys-r_tail*i/steps_comet+3*(1-i/steps_comet),zs-2*r_tail+r_tail*k/steps_fetta+8*(1-i/steps_comet)>}
					#end
					#local k=k+1;
				#end
				#local j=j+1;
			#end
			#local i=i+1;
		#end
	}
	
	#declare comet=union {
		object {comet_core}
		object {tail_comet}
	}
	
	#if(light_from_comet)
		#declare luce_comet=light_source{
			<0,0,0>
			color rgb <1,0.98,0.76>
			looks_like{
				object{
					comet
					hollow
					material {
						m_comet_light
					}
				}
			}
		}
		light_source{luce_comet}
	#else
		object{
			comet
			texture { pigment {rgb 1}	}
		}
	#end
#end



// Moon --------------------------
#if (show_moon)
	#declare c_moon=<7,8,10>;
	#declare moon=sphere {
		c_moon, 1
	}
	
	#if(light_from_moon)
		#declare luce_moon=light_source{
			<0,0,0>
			color rgb <1,0.98,0.76>
			looks_like{
				object{
					moon
					hollow
					material {
						m_moon_light
					}
				}
			}
		}
		light_source{luce_moon}
		// I need to hyde some stars...
		sphere {
			c_moon, 0.9
			texture {t_moon_light}
		}
	#else
		object{
			moon
			texture { pigment {rgb 1}	}
		}
	#end
#end


// Cave --------------------------
#declare cave=sphere {
	0, 1
	translate <1,0.5,-0.1>
}

#if(light_from_cave)
	#declare luce_cave=light_source{
		<0,0,0>
		color rgb <1,0.98,0.76>
		looks_like{
			object{
				cave
				hollow
				material {
					m_cave_light
				}
			}
		}
	}
	light_source{luce_cave}
#end


// Mountain ------------------------
#if(show_mountain)
	#local Mountain=height_field {
	        png "hf_base_02.png"  // Gimp       
	        smooth
	        no_shadow
	        translate <-0.5, -0.5, -0.5>
	        scale < 21, 5, 21 >
	}
	
	#declare mountain=difference{
		object{Mountain}
		object{cave}
	}
	
	object { mountain
		texture {
			t_moss
			scale 0.2
		}
	}
#end


// Pineta --------------------------
#if(pinewood)
	#declare R1=seed(2);
	#declare R2=seed(41);
	#declare h_tree=3.8;
	#declare R_tree=0.06;
	#declare r_tree=0.01;
	#declare y1_leaves=4;
	#declare r1_leaves=0.09;
	#declare h1_leaves=1.2;
	#declare y2_leaves=3;
	#declare r2_leaves=0.14;
	#declare h2_leaves=1;
	#declare y3_leaves=2.4;
	#declare r3_leaves=0.2;
	#declare h3_leaves=0.8;
	#declare Normal=<0,0,0>;
	#declare m_min=min_extent(Mountain); // Using mountain I have strange numbers
	#declare m_max=max_extent(Mountain);
	
	#declare m_steps=37;
	#declare r_stop=0.25;
	// Empirical
	#declare no_x_min=-2;
	#declare no_x_max=3;
	#declare no_z_min=-4;
	#declare no_z_max=-0.5;
	// Zone without pines
	//box{<no_x_min,0,no_z_min> <no_x_max,2,no_z_max> texture{pigment {color rgbt <1,0,0,.9>}}}
	
	#local i=0;
	#while (i<=m_steps)
		#local j=0;
		#local m_x=m_min.x+(m_max.x-m_min.x)*i/m_steps;
		#while (j<=m_steps)
			#local m_z=m_min.z+(m_max.z-m_min.z)*j/m_steps;
			// No pines in front of the cave
			#if(!((m_x>no_x_min) & (m_x<no_x_max) & (m_z>no_z_min) & (m_z<no_z_max)))
				#if(rand(R1)<=r_stop)
					#declare Intersection=trace(Mountain, <m_x,10,m_z>, -y, Normal);
					#if(vlength(Normal) > 0)
						#local correction=0.8+rand(R2)*.4;
						union {
							// Trunk
							cone{Intersection-0.1*y R_tree Intersection+h_tree*y r_tree texture{t_trunk}}
							// Leaves
							union {
								cone{Intersection+y1_leaves*y r_tree Intersection+(y1_leaves-h1_leaves)*y r1_leaves}
								cone{Intersection+y2_leaves*y R_tree Intersection+(y2_leaves-h2_leaves)*y r2_leaves}
								cone{Intersection+y3_leaves*y R_tree Intersection+(y3_leaves-h3_leaves)*y r3_leaves}
								//hollow
								material{m_foglie}
							}
							scale correction
						}
					#end
				#end
			#end
			#local j=j+1;
		#end
		#local i=i+1;
	#end
#end

