/*
 * Invasion of the reflective killer spheres
 * 
 * Copyright 2008 Christian Froeschlin 
 *
 * www.chrfr.de
 *
 * Not really cleaned up. Sphere placement macro can get
 * stuck in infinite loops with unlucky randomizations.
 *
 */

// -w800 -h600 +a0.1

#default {finish {ambient 0}}

#include "colors.inc"
#include "metals.inc"
#include "stones.inc"
#include "strings.inc"
#include "stars.inc"
#include "rand.inc"
#include "woods.inc"
#include "rad_def.inc"
#include "functions.inc"
#include "control.inc"

global_settings 
{
  assumed_gamma 1.0
  max_trace_level 10
  radiosity {Rad_Settings(Radiosity_Normal, off, off)}
}


camera 
{
  location  < 0.0, 0.8, -5.0>
  look_at   <-0.5, 1.0,  0.0>
  angle 70
}

light_source 
{
  <-10,  10, -10> color 0.5*<0.4,0.4,0.25>
  area_light 2*x, 2*z, 5, 5 circular orient
}


sphere
{
  0, 1000 
  pigment {color <0.4,0.4,0.1>}
  finish {ambient 0.5}
  hollow
}


fog 
{
  distance 100
  color rgb <0.65, 0.65, 0.65>
  fog_type 2
  fog_offset -1
  fog_alt 20
}



#declare f_ground = function {f_ridged_mf(x,y,0,0.3,1,7,-0.15,0.4,2)};

#local hf_ground = height_field
{
  function 512, 512 {0.9*f_ground(x*25,y*25,z)} 
  smooth
  translate -0.5*(x+z)
  scale y+40*(x+z)
}


#local NUM_SPHERES = 500;
#local R  = seed(21);

union
{
  #local T_ENERGY_COIL = texture
  {
    pigment {color rgbt 1}
    normal  {ripples 1 scale 0.1}
    finish {reflection 0.5}  
  }
  
  #local M_ENERGY_COIL = material
  {
    texture  {T_ENERGY_COIL}
    interior {ior 1.3}
  }
  
  #local SUPER_NODE = union
  {
  
    difference
    {
      sphere {0, 1.5}
      sphere {0, 1.0}
      #macro FOR(I)
        #local A = I*2*pi/12;
        cylinder {1.5*<cos(A),-0.5,-sin(A)>, 0, 0.15}
      #end FROM_TO(0,11)
      plane {-y,-1}
    }

    intersection
    {
      plane {-y,-1}
      sphere {0, 1.5}
      translate 0.3*y
    }
  
    cylinder 
    {
      0,1.3*y,0.7
      material {M_ENERGY_COIL}
    }
  }


  object {SUPER_NODE translate <2,1.5,3>}
  
  object {SUPER_NODE translate <-8,1.5,20>}

  object {SUPER_NODE translate <-3,1.5,70>}

  object {SUPER_NODE translate <-54,1.5,80>}
  
  #macro FOR(I)
    #local X = rand(R)*20-10;
    #local Z = rand(R)*20-10;
    #local D = 0.05 + rand(R)/5;
    #local S = <X,100,Z>;
    #local N = <-1,0,0>;
    #local P = trace(hf_ground, S, -y, N) + 0.5*D*y;
    #while ((vdot(y,N)/vlength(N)) < 0.85 | P.y > 0.6)
      #local S = S + N;
      #local P = trace(hf_ground, S, -y, N) + 0.5*D*y;
    #end
    sphere {P, D/2}
  #end FROM_TO(0,NUM_SPHERES-1)
  
  pigment {color White}
  finish  {diffuse 0.1 reflection 0.5 specular 0.5 roughness 0.004}
}

object
{
  hf_ground
  pigment 
  {
    checker color ForestGreen color 0.9*ForestGreen
    scale 0.5
  }  
  normal {bozo 2.5 scale 0.006}
}

plane
{
  y,0
  pigment {color ForestGreen}
}

