
#include "colors.inc"

#if(on) 
  camera {
    location vrotate ( <0, 0, -600>, <  40,  5, 0> )                                                
    look_at vrotate ( <0, 0,     0>, <   0, 0, 0> )+ <20,0,-60>  
    angle 50    
  } 
  
  
  #declare BaseRadius=300; 
  
  #include "inset_floor_texture.inc"                                      
  
  cylinder {                    
    y*0,y*-.1,BaseRadius
    material { M_Inlaid_Floor }
  }  
  
#end  

#if(off) 

  camera {
    location vrotate ( <0, 0, -10>, <40, 10, 0> )                                                 
    look_at  <0, 0, 0> 
    angle 20   
  } 
  
  #local ImageDay =    
  pigment {
    image_map { jpeg "earth_day.jpg"  } 
    scale <2,1,1>
    rotate x*90
  };
    
  #local ImageNight =   
  pigment {
    image_map { jpeg "earth_night.jpg"  }
    scale <2,1,1> 
    rotate x*90
  };
    
  box { 
                   
    <-4,0,-4>,<4,-.1,4>
    pigment {
      pigment_pattern {
        checker   
        
        color 0
        color 1
        scale <2,1,1>
        scale 6 
        warp {
          turbulence <.1,0,.1> 
          octaves 5
          lambda 2.4
          omega 1.8
        }
        scale 1/6      
      } 
      pigment_map {
        [0 ImageDay]
        [1 ImageNight]
      } 
    } 
    finish{ambient 1}
  }
  
#end  
 