// Kepler CGSphere WIP Textures
// Written by: Matthew Goulet <povray@bherring.cotse.net>
// Last updated: September 29, 2008

#ifndef(Kepler_Cgsphere_Textures_Inc)
#declare Kepler_Cgsphere_Textures_Inc = version;
#version 3.61;

#ifdef(View_POV_Include_Stack)
  #debug "including kepler_cgsphere_textures.inc\n"
#end

#include "glass.inc"
#include "metals.inc"

#declare Brass_1 =
  texture {
    pigment { P_Brass3 }
    finish { 
      ambient 0
      diffuse 0.15
      specular 1.7
      roughness 0.009157
      metallic
      reflection {
        0.425, 0.85
        metallic
      }
      conserve_energy
      brilliance 3
    }
  }
  
#declare Brass_2 =
  texture {
    pigment { P_Brass1 }
    finish {
      ambient 0
      diffuse 0.3
      specular 1.4
      roughness 0.020962
      metallic
      reflection {
        0.35, 0.7
        metallic
      }
      conserve_energy
      brilliance 2
    }
  }
  
#declare Brass =
  texture {
    #if(Use_Textures)
      bozo
      noise_generator 3
      texture_map {
        [0 Brass_2]
        [0.3 Brass_2]
        [0.5 Brass_1]
        [1   Brass_1]
      }
      scale Radius/2
    #else
      pigment { P_Brass3 }
    #end
  }

#declare Tin =
  texture {
    pigment { P_Chrome2 }
    finish {
      ambient 0
      diffuse 0.2
      specular 1.6
      roughness 0.012068
      metallic
      reflection {
        0.4, 0.8
        metallic
      }
      conserve_energy
      brilliance 2
    }
  }
  
#declare Glass =
  material {
    texture {
      pigment { Col_Glass_Clear }
      finish { F_Glass7 }
    }
    interior {
      ior 1.51
      fade_power 1001
      fade_distance 1
    }
  }

#declare Silver_1 =
  texture {
    pigment { P_Silver3 }
    finish {
      ambient 0
      diffuse 0.15
      specular 1.7
      roughness 0.009157
      metallic
      reflection {
        0.425, 0.85
        metallic
      }
      conserve_energy
      brilliance 4
    }
  }
  
#declare Silver_2 =
  texture {
    pigment { P_Silver1 }
    finish {
      ambient 0
      diffuse 0.3
      specular 1.4
      roughness 0.020962
      metallic
      reflection {
        0.35, 0.7
        metallic
      }
      conserve_energy
      brilliance 2
    }
  }

#declare Silver =
  texture {
    #if(Use_Textures)
      bozo
      texture_map {
        [0 Silver_1]
        [1 Silver_2]
      }
      warp {
        turbulence 0.5
        octaves 4
        lambda 1.6
        omega 0.5
      }
      scale 2
    #else
      pigment { P_Silver3 }
    #end
  }        
  
#declare Model_Grey =
  texture {
    pigment { rgb 0.81 }
    finish {
      specular 1
      roughness 0.01
    }
  }

#version Kepler_Cgsphere_Textures_Inc;
#end
