// Kepler CGSphere WIP
// Written by: Matthew Goulet <povray@bherring.cotse.net>
// Last updated: September 29, 2008

#version 3.61;

#declare Use_Area = yes;
#declare Use_Radiosity = yes;
#declare Use_Textures = no;
#declare Use_Blur = yes;
#declare Use_Grey = yes;

#declare Load_Radiosity = no;

#declare Radiosity_File = "kepler_cgsphere.rad";

#declare Radius = 30;
#declare Thickness = 0.5;

#default { finish { ambient 0 diffuse 1 } }

#include "colors.inc"
#include "kepler_cgsphere_textures.inc"
#include "platonic.inc"
#include "rad_def.inc"
#include "shapes.inc"
#include "CGSphere.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level (Use_Textures ? 10 : 5)
  #if(Use_Radiosity)
    radiosity {
      pretrace_start 64/image_width
      pretrace_end 1/image_width
      count 100
      nearest_count 7
      error_bound 1
      recursion_limit 2
      low_error_factor 0.5
      gray_threshold 0
      minimum_reuse 0.02
      brightness 1.0
      adc_bailout 0.01/3
      #if(Load_Radiosity & file_exists(Radiosity_File))
        pretrace_start 1
        pretrace_end 1
        always_sample no
        load_file Radiosity_File
      #else
        save_file Radiosity_File
      #end
    }
  #end
}

camera {
  location z * -201.5
  up y
  right x * image_width/image_height
  angle 41
  look_at 0
  #if(Use_Blur)
    aperture 1.5
    focal_point 0
    blur_samples 300
    confidence 0.92
    variance 0
  #end
}

#declare Cool_Fluorescent = rgb <212, 235, 255>/255;

#declare Light =
  light_source {
    0, Cool_Fluorescent
    #if(Use_Area)
      area_light
      x * 10, y * 10, 33, 33
      adaptive 0
      circular
      orient
    #end
    fade_power 2
    fade_distance 130
  }

light_source {
  Light
  translate <60, 60, -250>
}

light_source {
  Light
  //translate <60, 120, -250>
  translate <20, 30, -250>
}

/*
#declare Warm_Fluorescent = rgb <255, 244, 229>/255;

light_source {
  y * 400, Warm_Fluorescent
  spotlight
  radius 0
  falloff 90
  tightness 45
  point_at 0
  #if(Use_Area)
    area_light
    x * 10, y * 10, 33, 33
    adaptive 0
    circular
    orient
  #end    
}
*/
/*
sphere {
  0, 1
  inverse
  no_image
  texture {
    pigment { rgb <0.6, 0.6, 1> }
    finish {
      ambient 1
      diffuse 0
    }
  }
  scale 1000
}
*/

sphere {
  0, 1000
  inverse
  pigment { White }
}

#macro Get_Thickness(Radius)
  (Thickness < 0 ? Radius * Thickness : Thickness)
#end

#macro Hollow_Hemisphere(Radius)
  #declare Inner_Radius = Radius - Get_Thickness(Radius);

  difference {
    sphere { 0, Radius }
    sphere { 0, Inner_Radius }
    plane { -y, 0 }
    bounded_by {
      box { -Radius, <Radius, 0, Radius> }
    }
  }
#end

#declare Hemisphere_1 =
  object {
    Hollow_Hemisphere(Radius)
  }
  
#declare Cube_Scale = (Inner_Radius * 2 / sqrt(3)) / Cube_Side;
#declare New_Cube_Side_Inner = Cube_Side_Inner * Cube_Scale;
  
#declare Kepler_Cube =
  object { 
    Hollow_Cube 
    scale Cube_Scale
  }
  
#declare Radius_2 = New_Cube_Side_Inner / 2;
  
#declare Hemisphere_2 =
  object {
    Hollow_Hemisphere(Radius_2)
  }
  
#declare Tetrahedron_Scale = (Inner_Radius / sqrt(9/24)) / Tetrahedron_Side;
#declare New_Tetrahedron_Side_Inner = Tetrahedron_Side_Inner * Tetrahedron_Scale;
  
#declare Kepler_Tetrahedron =
  object {
    Hollow_Tetrahedron
    scale Tetrahedron_Scale
  }
  
#declare Radius_3 = sqrt(1/24) * New_Tetrahedron_Side_Inner;

#declare Hemisphere_3 =
  object {
    Hollow_Hemisphere(Radius_3)
  }

#declare Dodecahedron_Scale = (Inner_Radius / (sqrt(3) * (1 + sqrt(5)) / 4)) / Dodecahedron_Side;
#declare New_Dodecahedron_Side_Inner = Dodecahedron_Side_Inner * Dodecahedron_Scale;

#declare Kepler_Dodecahedron =
  object { 
    Hollow_Dodecahedron 
    scale Dodecahedron_Scale
  }

#declare Radius_4 = New_Dodecahedron_Side_Inner / 20 * sqrt(250 + 110 * sqrt(5));
  
#declare Hemisphere_4 =
  object {
    Hollow_Hemisphere(Radius_4)
  }

#declare Icosahedron_Scale = (Inner_Radius / (1/4 * sqrt(10 + 2 * sqrt(5)))) / Icosahedron_Side;
#declare New_Icosahedron_Side_Inner = Icosahedron_Side_Inner * Icosahedron_Scale;

#declare Kepler_Icosahedron =
  object {
    Hollow_Icosahedron
    scale Icosahedron_Scale
  }
  
#declare Radius_5 = New_Icosahedron_Side_Inner * 1/12 * sqrt(3) * (3 + sqrt(5));

#declare Hemisphere_5 =
  object {
    Hollow_Hemisphere(Radius_5)
  }

#declare Octahedron_Scale = (Inner_Radius * 2 / sqrt(2)) / Octahedron_Side;
#declare New_Octahedron_Side_Inner = Octahedron_Side_Inner * Octahedron_Scale;

#declare Kepler_Octahedron =
  object {
    Hollow_Octahedron
    scale Octahedron_Scale
    rotate y * 45
  }
  
#declare Radius_6 = New_Octahedron_Side_Inner * sqrt(6) / 6;
  
#declare Hemisphere_6 =
  object {
    Hollow_Hemisphere(Radius_6)
  }
  
#declare Frame =
  union {
    difference {
      object {
        Supertorus(Radius * 11/10, Radius/30, 1, 0.3, 0.001, 5)
        rotate x * 90
      }      
      plane { -y, 0 }
      difference {
        union {
          torus {
            Radius * 11/10, Radius/60
            rotate x * 90
            scale <1, 1, 0.5>
            translate z * -Radius/30
          }
          torus {
            Radius * 11/10, Radius/60
            rotate x * 90
            scale <1, 1, 0.5>
            translate z * Radius/30
          }
        }
        plane { 
          -y, 0 
          rotate z * 15
        }
        plane { 
          -y, 0 
          rotate z * -15
        }
        bounded_by {
          box { <-Radius * 23/20, -Radius * 23/20, -Radius/20>,
                <Radius * 23/20, 0, Radius/20> }
        }
      }
      sphere {
        0, Radius/60
        scale <1, 1, 0.5>
        translate <Radius * 11/10, 0, -Radius/30>
        rotate z * -15
      }
      sphere {
        0, Radius/60
        scale <1, 1, 0.5>
        translate <Radius * 11/10, 0, Radius/30>
        rotate z * -15
      }
      sphere {
        0, Radius/60
        scale <1, 1, 0.5>
        translate <-Radius * 11/10, 0, -Radius/30>
        rotate z * 15
      }
      sphere {
        0, Radius/60
        scale <1, 1, 0.5>
        translate <-Radius * 11/10, 0, Radius/30>
        rotate z * 15
      }
      bounded_by {
        box { <-Radius * 23/20, -Radius * 23/20, -Radius/20>,
              <Radius * 23/20, 0, Radius/20> }
      }
    }
    superellipsoid {
      <0.3, 0.3>
      scale <Radius/30, 1.5, Radius/30>
      translate x * Radius * 11/10
    }
    superellipsoid {
      <0.3, 0.3>
      scale <Radius/30, 1.5, Radius/30>
      translate -x * Radius * 11/10
    }
    
    #if(! Use_Grey)
      texture { Brass }
    #end
  }


#declare Axis =
  union {
    cylinder { x * Radius, x * Radius * 1.2, Radius/40 }
    difference {
      cylinder { x * -Radius, x * -Radius * 1.2, Radius/40 }
      cylinder { <-Radius * 1.15, -Radius, 0>, <-Radius * 1.15, Radius, 0>, Radius/150 }
      bounded_by {
        cylinder { x * -Radius, x * -Radius * 1.2, Radius/40 }
      }
    }
    
    torus {
      Radius/70, Radius/200
      rotate x * 90
      scale <0.8, 1, 1>
      translate <-Radius * 1.15, Radius/60 + Radius/40, 0>
    }    
    
    cylinder { 
      <-Radius * 1.15, -Radius/40, 0>, <-Radius * 1.15, Radius/40 + Radius/200>, Radius/200
    }
            
    cylinder {
      0, y * -Radius/20, Radius/200
      translate <-Radius * 1.15, -Radius/40, 0>
    }
    cylinder {
      0, y * -Radius/20, Radius/200
      rotate z * -15 
      translate <-Radius * 1.15, -Radius/40, 0>
    }
    
    difference {
      Round_Cylinder_Union(x * Radius * 1.15, x * Radius * 1.25, Radius/10, Radius/60)
      #declare Count = 15;
      #declare Ct = 0;
      #while(Ct < Count)
        cylinder { 
          <Radius, Radius/10, 0>, <Radius * 2, Radius/10, 0>, Radius/60
          rotate x * Ct/Count * 360
        }
        #declare Ct = Ct + 1;
      #end
      bounded_by {
        cylinder { x * Radius * 1.15, x * Radius * 1.25, Radius/10 }
      }
    }
  }
    
#declare Rim = 
  difference {
    Round_Cylinder_Union(y * -Radius/50, 0, Radius * 1.05, Radius/101)
    cylinder { y * -Radius, y, Radius * 0.97 }
    #declare Count = 60;
    #declare Ct = 0;
    #while(Ct < Count)
      box { 
        <-Get_Thickness(Radius)/4, -Radius/200, -Radius * 2>,
        <Get_Thickness(Radius)/4, 1, 0> 
        rotate y * Ct/Count * 360
      }
      #declare Ct = Ct + 1;
    #end     
    
    bounded_by {
      cylinder { y * -Radius/50, 0, Radius * 1.2 }
    }
  }
  
#declare Base =
  union {
    lathe {
      bezier_spline
      40 //nr points
      /*   0*/ <0.00000000, 5.00000000>, <0.00000000, 5.00000000>, <4.00000000, 5.00000000>, <4.00000000, 5.00000000>,
      /*   1*/ <4.00000000, 5.00000000>, <6.24327060, 5.00000000>, <8.26497140, 3.56570400>, <10.57040900, 3.56570400>,
      /*   2*/ <10.57040900, 3.56570400>, <11.83635100, 3.56570400>, <13.04911200, 3.57813000>, <14.45270200, 3.56570400>,
      /*   3*/ <14.45270200, 3.56570400>, <15.74372500, 3.55427600>, <17.19582100, 3.56570400>, <19.00000000, 3.56570400>,
      /*   4*/ <19.00000000, 3.56570400>, <19.57763100, 3.56570400>, <20.19553800, 3.29466200>, <20.19553800, 2.78691000>,
      /*   5*/ <20.19553800, 2.78691000>, <20.19553800, 2.27915800>, <21.00000000, 2.41591500>, <21.00000000, 2.00000000>,
      /*   6*/ <21.00000000, 2.00000000>, <21.00000000, 1.58408500>, <21.81939400, 1.60486100>, <21.81939400, 1.21411600>,
      /*   7*/ <21.81939400, 1.21411600>, <21.81939400, 0.82337000>, <22.52362700, 0.82584400>, <22.74978500, 0.59968600>,
      /*   8*/ <22.74978500, 0.59968600>, <23.00554500, 0.34392700>, <23.00000000, 0.00000000>, <23.00000000, 0.00000000>,
      /*   9*/ <23.00000000, 0.00000000>, <23.00000000, 0.00000000>, <0.00000000, 0.00000000>, <0.00000000, 0.00000000>
      scale Radius/30
      translate y * -40
    }
    cylinder { y * (-40 + 5 * Radius/30), y * -(Radius * 11/10 + Radius/30), Radius/10 }
    prism {
      linear_spline
      0, Radius/30
      7
      #declare Ct = 0;
      #while(Ct < 7)
        #declare Pt = vrotate(z * Radius/30, y * Ct * 360/6);
        <Pt.x, Pt.z>
        #declare Ct = Ct + 1;
      #end
      rotate y * 20
      translate y * -(Radius * 11/10 - Radius/30)
    }
    sphere { y * -(Radius * 11/10 - 2 * Radius/30), Radius/30 * cos(pi / 6) }
    
    #if(! Use_Grey)
      texture { Brass }
    #end
  }
    

#declare Kepler_Sphere =
  union {
    union {
      union {
        object { Hemisphere_1 }
        object { Hemisphere_2 }
        object { Hemisphere_3 }
        object { Hemisphere_4 }
        object { Hemisphere_5 }
        object { Hemisphere_6 }
    
        object { Rim }
        
        translate y * Radius/20
      }
      
      object { Axis }

      #if(! Use_Grey)
        texture { Brass }
      #end
    }

    union {
      object { Kepler_Cube }
      object { Kepler_Tetrahedron }
      object { Kepler_Dodecahedron }
      object { Kepler_Icosahedron }
      object { Kepler_Octahedron }
    
      #if(! Use_Grey)
        texture { Silver }
      #end
    }
    
    rotate x * -30
  }
  
  

union { 
  union {
    object { Kepler_Sphere }
    object { Frame }
    rotate y * -15
  }

  object { Base }

  #if(Use_Grey)
    texture { Model_Grey }
  #end
}

object { Ground }
