// An alternative spin on the "rounded prism"
// Written by:    Matthew Goulet <povray@bherring.cotse.net>
// Created on:    May 13, 2008
// Last modified: August 1, 2008
//
// This file is licensed under the terms of the CC-LGPL
//
#version 3.61;

#declare Res = 400; // How many prisms will be stacked
#declare N = 2;     // Steepness of the rounding, larger = steeper.

global_settings {
  assumed_gamma 1.0
  max_trace_level 6
}

#include "colors.inc"
#include "math.inc"
#include "pointarrays.inc"  // Available from the POV-Ray Object Collection: http://lib.povray.org
#include "transforms.inc"

camera {
  location <0, 9, -12>
  up y
  right x * image_width/image_height
  look_at 0
}

light_source {
  <10, 50, -70>, White
}

background { rgb <0.6, 0.6, 1> }

#declare P =
  array[80] {
    /*   0*/ <1.49657140, 3.63239000>, <1.66625380, 3.91137000>, <1.99516830, 4.17347000>, <2.28513230, 4.37659000>,
    /*   1*/ <2.28513230, 4.37659000>, <2.58410720, 4.52924000>, <2.84901680, 4.82332000>, <3.21665450, 4.75886000>,
    /*   2*/ <3.21665450, 4.75886000>, <3.70736460, 4.79420000>, <4.13387860, 4.52151000>, <4.59410100, 4.40908000>,
    /*   3*/ <4.59410100, 4.40908000>, <4.95740520, 4.21677000>, <5.02892650, 3.76293000>, <5.19177710, 3.42095000>,
    /*   4*/ <5.19177710, 3.42095000>, <5.33887930, 3.01598000>, <5.71169690, 2.67590000>, <6.16067590, 2.68837000>,
    /*   5*/ <6.16067590, 2.68837000>, <6.56380700, 2.55567000>, <7.04528240, 2.45825000>, <7.41512260, 2.73482000>,
    /*   6*/ <7.41512260, 2.73482000>, <7.74926280, 3.01774000>, <8.20414750, 3.10552000>, <8.59589190, 2.87998000>,
    /*   7*/ <8.59589190, 2.87998000>, <8.96302280, 2.67989000>, <9.39093900, 2.54385000>, <9.67507000, 2.22398000>,
    /*   8*/ <9.67507000, 2.22398000>, <9.99406260, 1.88485000>, <10.05284100, 1.37940000>, <9.93358980, 0.94454000>,
    /*   9*/ <9.93358980, 0.94454000>, <9.74409710, 0.58208000>, <9.46643420, 0.19279000>, <9.05157650, 0.07770000>,
    /*  10*/ <9.05157650, 0.07770000>, <8.68503020, 0.03210000>, <8.30534060, 0.10519000>, <7.94085570, 0.16821000>,
    /*  11*/ <7.94085570, 0.16821000>, <7.54626020, 0.25800000>, <7.15160810, 0.33330000>, <6.75151570, 0.38440000>,
    /*  12*/ <6.75151570, 0.38440000>, <6.32444030, 0.47587000>, <5.88975500, 0.54206000>, <5.45460440, 0.58041000>,
    /*  13*/ <5.45460440, 0.58041000>, <4.67879300, 0.57777000>, <3.86444340, 0.77083000>, <3.12359100, 0.45542000>,
    /*  14*/ <3.12359100, 0.45542000>, <2.75931440, 0.25177000>, <2.43999980, -0.09706000>, <1.97258880, 0.00007000>,
    /*  15*/ <1.97258880, 0.00007000>, <1.48791110, -0.01110000>, <1.09839170, 0.35033000>, <0.73099910, 0.61897000>,
    /*  16*/ <0.73099910, 0.61897000>, <0.36499083, 0.90911000>, <0.16466070, 1.33632000>, <0.05285359, 1.77886000>,
    /*  17*/ <0.05285359, 1.77886000>, <-0.12984810, 2.27784000>, <0.25417594, 2.72470000>, <0.36779733, 3.19073000>,
    /*  18*/ <0.36779733, 3.19073000>, <0.55470291, 3.50444000>, <0.99600044, 3.97988000>, <1.39696330, 3.74608000>,
    /*  19*/ <1.39696330, 3.74608000>, <1.43654720, 3.71424000>, <1.46640640, 3.67268000>, <1.49657140, 3.63239000>
  };
  
#declare Ct = 1;

#declare Trans =
  transform {
    translate <-5, -2.5, 0>
  }

#declare Y1 = pow(sin(0), 2/N);
#declare X1 = pow(cos(0), 2/N);

union {
  #while(Ct <= Res)
    #declare T = pi/2 * Ct/Res;
    
    #declare Y2 = pow(sin(T), 2/N);
    #declare X2 = pow(cos(T), 2/N);
    
    object {
      PA_Prism_Scaled(PA_Bezier, Y2 - Y1, X1, X2, P, no, no, Trans)
      translate y * Y1
    }
    
    #declare Ct = Ct + 1;
    #declare Y1 = Y2;
    #declare X1 = X2;
  #end
  
  rotate y * 180
  
  texture {
    pigment { Red }
    finish { 
      ambient 0
      diffuse 0.8
      specular 0.85
      roughness 0.00508
      reflection {
        0.1, 0.4
      }
      conserve_energy
    }
  }
}
    


