/*

 KingdomBasic.pov
 2008 Sam Benge

*/

#declare R=seed(0004);
global_settings{
 assumed_gamma 2.2
 noise_generator 3
}

#default{finish{ambient 1 diffuse 0}}

camera{
 orthographic 
 location -z*100
}

// the starting pattern
#declare patt=
pigment{
 pigment_pattern{
  pigment_pattern{
   granite
   scale 100*<.1,1,1>
   warp{turbulence .5 lambda 2.5}
  }
  pigment_map{
   #declare V=0;
   #while(V<1)
    [V
     pigment_pattern{
      granite scale 3*<1,2,1>
      pigment_map{
       [0
        granite
        scale 1+rand(R)*3
        poly_wave 2
        translate z*rand(R)*100
       ]
       [1
        granite
        poly_wave .25
        scale 1+rand(R)*3
        translate -z*rand(R)*100
       ]
      }
     }
     poly_wave .125+V*1.8
    ]
    #declare V=V+1/8;
   #end
  }
 }
}

// This value will skew the pattern in the
// +z direction one tenth of a unit.
#declare offs = .1;

// the repeating pattern, skewed
#declare echo1=
function{
 pigment{
  patt
  warp{repeat x flip x}
  matrix<1,0,offs,0,1,0,0,0,1,0,0,0>
  scale 16
 }
}

// the repeating, skewed pattern added to itself
// with scaling and translation
#declare echo=
pigment{
 pigment_pattern{
 function{
  (
   0
   // 'V' will count upon itself (1+1=2, 2+2=4, etc.)
   #declare V=1;
   #while(V<=512)
    #declare rv=rand(R);
    +echo1(x*V/2,y*V,z+rv*1000).grey/(1+V/80)
    #declare V=V+V;
   #end
  )/5
 }
 cubic_wave
 }
 poly_wave 2
}

// the pattern, displayed
plane{-z,0
 pigment{
  echo
  scale 4
 }
}