/*

 tessel.pov
 
 2008 Sam Benge stbenge@hotmail.com
 
 +a0.1 +r3 +w500 +h500
 
 Description: An example showing how to make a tessellating pattern with
 "stbHexPatterns.inc."

 Dependencies:
  - stbHexPatterns.inc
  - POV-Ray 3.6 and above

*/

#default{finish{ ambient 1}}

camera{
 orthographic 
 right x*2 up y*2
 location y*8
 look_at 0
}

#include"stbHexPatterns.inc"

// This enables/disables grid overlay (below).
#declare skewed_grid_overlay = 1;

/*
 This pigment will be copied into each hexagon. En-
 abling random rotation is not recommended for center
 point tessellations.
*/
#declare myHexPattern=
pigment{
 /*
  This is the basic shape which will be copied and
  rotated several times before being passed as a pigment
  to the hexPattern() macro.
 */
 #declare tessel_part=
 prism{
  // object must intersect y=0 plane
  -1,1,15,
  /*
   The points start from the center of the hexagon
   and cover the forward triangle in a clockwise
   fashion. The ht(x,y) macro traverses points along a
   square grid skewed to 60 degrees. See include file
   for more details.
  */
  ht(0,0)
  ht(-1,1)
  ht(-1,2)
  ht(-2,3)
  ht(-3,3)
  
  ht(-4,4)
  ht(-3,4)
  ht(-3,5)
  ht(-1,3)
  ht(-1,4)
  
  ht(0,4)
  ht(0,3)
  ht(1,2)
  ht(1,1)
  ht(0,1)
  
  /* Since I used whole numbers above, the object
  must be scaled down so that its corers fit into
  a 1-unit hexagon. Notice that I used the 'h2'
  variable for ths purpose.
  */
  scale h2/4
 }
 
 
 /*
  Here the shape is rotated and translated several
  times to cover the hexagon.
 */
 #declare tessel_whole=
 union{
  object{tessel_part}
  object{tessel_part translate -z}
  
  object{tessel_part rotate y*120}
  object{tessel_part translate -z rotate y*120}
  
  object{tessel_part rotate y*240}
  object{tessel_part translate -z rotate y*240}
 }
 
 /*
  And here is where we turn the union of objects
  into a pigment. It is necessary to explicitly
  assign colors to it now, so problems do not
  arise later.
 */
 object{tessel_whole rgb 0, rgb 1}
 
}

plane{y,0
 pigment{
  /*
   The invoked pattern. The value '0' means no
   random rotation is performed.
  */
  hexPattern(0)
  
  color_map{[0 rgb<.25,.5,1>][1 rgb 1]}
  scale 1/2
 }
}

/*
 This a grid to help find points in trigonal space.
 The skewed grid pattern comes from stbHexPatterns.inc.
*/ 
#if(skewed_grid_overlay)
 //plane{y,.01
 disc{y*.01,y,h1/2
  pigment{
   skewedGrid()
   scale 1/8
   color_map{
    [.0 rgb 0 transmit .33]
    [.125 rgb 0 transmit 1]
   }
  }
 }
#end
