/*

 rockhead1.pov
 2007 Sam Benge
 stbenge@hotmail.com

*/

#include"transforms.inc"

#declare global_illumination = on;
global_settings{
 #if(global_illumination=1)
  radiosity{
   count 10 error_bound .05
   nearest_count 1
   recursion_limit 1
   normal on
   brightness 1
   gray_threshold 0
   adc_bailout 0.1
  }
 #end
}

#default{ finish{ambient 0 } }

camera{ 
 right x up y
 location<0,-4,-25>
 look_at<0,-.5,0>
 angle 9
}

#declare res = 2;
#declare lpos = <-1,.25,0>;
#declare lcol = <1,.975,.9>*3;
#declare earthy = <1,.875,.75>;
#declare air = <.1 .3 .5>;

plane{y,-8 pigment{rgb earthy}}

fog{rgb(air*4+lcol)/8 distance 10000 fog_type 2 fog_alt 250 fog_offset 0}

light_source{lpos*100000,lcol }

sky_sphere{
 pigment{
  spherical scale 2 translate y
  Point_At_Trans(lpos)
  poly_wave 2
  pigment_map{
   [0
    granite scale .5 turbulence .05 lambda 4
    poly_wave 2
    color_map{
     [0 rgb air-.5]
     [1 rgb lcol/2]
    }
   ]
   [1 rgb lcol]
  }
 }
}

#declare granite_rock=
texture{
 pigment{
  pigment_pattern{
   bumps scale .15
  }
  pigment_map{
   [-.2 rgb 1]
   [.5
    crackle solid scale .0125/4
    color_map{
     [0 rgb 1]
     [.5 rgb earthy-.5]
     [1 rgb 0]
    }
   ]
  }
 }
 normal{crackle 1 solid  scale .0125/4}
 finish{brilliance .5 diffuse .785}
}

#declare rock=
function{
 pigment{
  spherical
  pigment_map{
   [0 rgb 0]
   [.5
    pigment_pattern{
     image_map{
      png"rockman.png" interpolate 2
     }
     translate-(x+y)/2 scale 2
    }
    pigment_map{
     [0 rgb 0]
     [.5
      granite scale<5,.5,5>
      poly_wave .5
      rotate z*12
      color_map{[0 rgb .25][1 rgb .75]}
     ]
     [1 rgb 1]
    }
   ]
   [1 rgb 1]
  }
 }
}

#declare rock2=
function{
 pigment{
  pigment_pattern{
   cylindrical
   pigment_map{
    [0 rgb 0]
    [.5 planar scale 2 translate -y]
   }
  }
  pigment_map{
   [0 rgb 0]
   [.5
    pigment_pattern{
     image_map{
      png"rockbody.png" interpolate 2
     }
     translate-(x+y)/2 scale 2
    }
    pigment_map{
     [0 rgb 0]
     [.5
      granite scale<5,.5,5>/1.5
      poly_wave .5
      rotate z*12
      color_map{[0 rgb .25][1 rgb .75]}
      translate-<.125,-2,.5>
     ]
     [1 rgb 1]
     
    }
   ]
   [1 rgb 1]
  }
 }
}

isosurface{
 function{
  0-rock(x,y,z).grey+.05
 }
 accuracy .001
 max_gradient 2
 contained_by{box{<-1,-1,-1>,<1,1,1>}}
 texture{granite_rock}
}

isosurface{
 function{
  0-rock2(x,y,z).grey+.05
 }
 accuracy .001
 max_gradient 2
 contained_by{box{<-1,-1,-1>,<1,1,1>}}
 texture{granite_rock}
 scale 1.5
 translate<.125,-2,.5>
}