
#local HQ = 0;			/* general high quality */
//#local FT = 0; //<0,0,0,.3,.68>;	/* filter/transmit */
#local FT = <0,0,0,.6,.38>;	/* filter/transmit */
#local AREALIGHTS = 1;
#local NORMALS = 1;
#local DOF = 1;			/* depth of field camera blur */
#local REFLECTIONS = 1;
#local REFRACTION = 1.55; 	/* 0, nothing; 1.55 glass; 1.33 water etc */
#local MEDIA = 0;
#local CAUSTICS = 1;
#local CAUSTICSgather = 0;
#local CRAZY = 0;


global_settings { 
	#if (CRAZY)
	max_trace_level 40
	//adc_bailout .08
	#end
	#if (HQ)
	max_trace_level 30
	adc_bailout .02
	#else
	max_trace_level 50
	adc_bailout .06
	#end

	#if (CAUSTICS)
	photons { 
		#if (CAUSTICSgather)
		save_file "cups-wip2.phm"
		count image_width*image_height
		radius .09
		max_trace_level 60
		adc_bailout .01
		#else
		load_file "cups-wip2.phm"
		#end
	}
	#end
}

background { rgb 1 }


#local cup = 
	lathe { bezier_spline 
    48, //nr points
    /*   0*/ <0, 2.8571826>, <174.28571, 2.8571826>, <197.14286,2.8571826>, <197.14286,2.8571826>,
    /*   1*/ <197.14286, 2.8571826>, <197.14286, 2.8571826>, <211.42857,-2.8571174>, <228.57143,14.285683>,
    /*   2*/ <228.57143, 14.285683>, <245.71429, 31.428583>, <242.85714,85.714283>, <242.85714,85.714283>,
    /*   3*/ <242.85714, 85.714283>, <242.85714, 85.714283>, <265.71429,80.000003>, <291.42857,105.71428>,
    /*   4*/ <291.42857, 105.71428>, <317.14286, 131.42857>, <308.57143,108.57143>, <308.57143,185.71428>,
    /*   5*/ <308.57143, 185.71428>, <308.57143, 262.85714>, <308.57143,742.85714>, <308.57143,742.85714>,
    /*   6*/ <308.57143, 742.85714>, <308.57143, 742.85714>, <317.14286,737.14285>, <308.57143,754.28571>,
    /*   7*/ <308.57143, 754.28571>, <300, 771.42857>, <288.57143,780>, <280,768.57143>,
    /*   8*/ <280, 768.57143>, <271.42857, 757.14285>, <294.28571,165.71428>, <277.14286,148.57143>,
    /*   9*/ <277.14286, 148.57143>, <260, 131.42857>, <231.42857,131.42857>, <217.14286,105.71428>,
    /*  10*/ <217.14286, 105.71428>, <202.85714, 80.000003>, <205.71429,54.285713>, <185.71429,45.714283>,
    /*  11*/ <185.71429, 45.714283>, <165.71429, 37.142883>, <2.8571429,2.8571826>, <0,2.8571826>

		sturm
		scale y*.8
		scale 1/1000
	}

#local cup2 = lathe { bezier_spline
    60, //nr points
    /*   0*/ <0, -1.7382813e-05>, <0, 18.571383>, <0,15.178483>, <0,15.178483>,
    /*   1*/ <0, 15.178483>, <6.25, 16.964183>, <27.321429,13.571383>, <31.250001,14.642783>,
    /*   2*/ <31.250001, 14.642783>, <31.250001, 14.642783>, <47.197559,12.769183>, <57.321429,20.675883>,
    /*   3*/ <57.321429, 20.675883>, <64.070661, 25.946983>, <67.105608,35.385283>, <69.58272,39.821383>,
    /*   4*/ <69.58272, 39.821383>, <72.837451, 45.650183>, <84.294576,84.731483>, <86.071436,102.5>,
    /*   5*/ <86.071436, 102.5>, <87.857146, 120.35714>, <85.357146,145>, <82.142856,165.71429>,
    /*   6*/ <82.142856, 165.71429>, <78.966586, 186.1836>, <91.342866,204.15811>, <96.071426,208.57143>,
    /*   7*/ <96.071426, 208.57143>, <101.42857, 213.57142>, <106.78572,215>, <107.5,210.71428>,
    /*   8*/ <107.5, 210.71428>, <108.21429, 206.42857>, <103.92858,210.71428>, <99.642856,187.85714>,
    /*   9*/ <99.642856, 187.85714>, <95.357146, 165>, <103.92858,148.57143>, <104.64286,125.71428>,
    /*  10*/ <104.64286, 125.71428>, <105.35715, 102.85714>, <101.42858,87.142853>, <97.857149,75.000003>,
    /*  11*/ <97.857149, 75.000003>, <94.285715, 62.857143>, <80.115281,24.737083>, <76.428572,19.821483>,
    /*  12*/ <76.428572, 19.821483>, <72.142858, 14.107183>, <64.730914,9.7242826>, <64.464285,5.7142826>,
    /*  13*/ <64.464285, 5.7142826>, <64.071714, -0.18991738>, <61.964286,-1.7382813e-05>, <61.964286,-1.7382813e-05>,
    /*  14*/ <61.964286, -1.7382813e-05>, <61.964286, -1.7382813e-05>, <0,-1.7382813e-05>, <0,-1.7382813e-05>
	sturm
	scale .002*2
	scale (x+z)*.7
	translate y*1.7382813e-05
}

#local vase = lathe { bezier_spline
    72, //nr points
    /*   0*/ <0, -1.7382813e-05>, <65, -1.7382813e-05>, <65,-1.7382813e-05>, <65,-1.7382813e-05>,
    /*   1*/ <65, -1.7382813e-05>, <65, -1.7382813e-05>, <75,1.5151826>, <75,6.0608826>,
    /*   2*/ <75, 6.0608826>, <75, 10.606583>, <70.205602,14.647183>, <75.761441,19.192883>,
    /*   3*/ <75.761441, 19.192883>, <99.906044, 31.597383>, <119.65154,70.164543>, <125.25892,97.984793>,
    /*   4*/ <125.25892, 97.984793>, <127.8521, 109.92726>, <128.69802,141.42135>, <109.09648,164.65486>,
    /*   5*/ <109.09648, 164.65486>, <96.118472, 180.03755>, <73.793767,188.41044>, <54.599,228.79955>,
    /*   6*/ <54.599, 228.79955>, <32.724951, 274.82633>, <38.960507,304.03218>, <42.982245,317.69297>,
    /*   7*/ <42.982245, 317.69297>, <49.029803, 338.23494>, <67.671929,346.09291>, <73.661165,350.35334>,
    /*   8*/ <73.661165, 350.35334>, <82.254764, 355.49003>, <88.58598,352.59228>, <88.144783,357.06299>,
    /*   9*/ <88.144783, 357.06299>, <85.545436, 362.47362>, <72.227313,362.09496>, <65.912454,357.92893>,
    /*  10*/ <65.912454, 357.92893>, <53.538086, 349.76532>, <33.765955,339.434>, <25.505076,316.01015>,
    /*  11*/ <25.505076, 316.01015>, <19.968352, 300.31069>, <14.22259,247.57133>, <49.461579,197.49534>,
    /*  12*/ <49.461579, 197.49534>, <70.184892, 168.0467>, <91.793472,155.28198>, <99.500026,135.86551>,
    /*  13*/ <99.500026, 135.86551>, <107.58125, 115.50508>, <105.96621,100.15476>, <88.776129,59.040533>,
    /*  14*/ <88.776129, 59.040533>, <88.286298, 57.414553>, <77.262811,33.567783>, <61.114229,25.253783>,
    /*  15*/ <61.114229, 25.253783>, <55.454314, 22.728483>, <34.345187,16.365483>, <23.233509,18.182783>,
    /*  16*/ <23.233509, 18.182783>, <12.121831, 19.999983>, <0,14.999983>, <0,14.999983>,
    /*  17*/ <0, 14.999983>, <0, 14.999983>, <0,-1.7382813e-05>, <0,-1.7382813e-05>
	scale .002*2
}

#macro tex( col, nor )
material {
	texture {
	pigment { rgbft col + FT }
	//pigment { rgbt 1 }
	#if (NORMALS & nor) normal { bumps .07 scale .002 } #end
	#if (1)
	finish { ambient .06 diffuse .46 brilliance 1.2 
			#if (NORMALS & nor)
			specular .86 roughness .04
			#else
			specular .97 roughness .02
			#end
			metallic .06
			#if (REFLECTIONS)
			reflection { .06,.4 metallic .06 fresnel 1 exponent 1 falloff 2 }
			conserve_energy
			#end
	}
	#end
	}
	interior { 
		#if (REFRACTION) ior REFRACTION #end
		fade_power 2 fade_distance .02 fade_color rgbft col+FT
		#if (MEDIA)
	    media { 
                intervals 8 samples 2,6 
                emission 3.81*(col)
                absorption 12*(1-col)
                #if (CRAZY) scattering { 0, (col)*7 extinction 1 } #end
				scale .2 
                #if (1)
                density {
					bumps scale .002
                    color_map {[0 rgb 1][.5 rgb 1][.56 rgb 0][1 rgb 0]}
                }
                #end
        }
		#end
	}
}
	photons { target refraction on }
hollow
#end

union {
	union {
	plane { y 0  
		pigment { rgb 1 }
		//pigment { checker rgb .6 rgb 1 rotate y*35 } 
		finish { ambient .1 diffuse .7  specular 1 roughness .2 }
		photons { collect on refraction on }
	}
	object { vase scale 1.2 translate z*.9*3+x*1.6 tex( <.9,.86,.4>, 0 ) }
	object { cup translate z*.7 tex( <.9,.86,.4>, 1 ) }
	#if (1)
	object { cup translate z*(.7+1.3) tex( <1,.96,.84>, 0 ) }
	object { cup translate 0 tex( <.7,.8,1>, 0 ) }
	object { cup translate x*.7 tex( <1,1,1>, 1 )}
	object { cup2 translate x*.7+z*.7 tex( <.96,1,.67>, 1 )}
	object { cup translate x*.7+z*.7*2 tex( <.7,1,.7>, 0 )}
	object { cup2 translate -x*.7 tex(<1,.6,.6>, 1 ) }
	object { cup2 translate -x*.7+z*(.0+1.3) tex(<.5,.5,.8>, 0 ) }
	object { cup translate -x*.7*2+z*(-.7+1.3) tex(<.7,1,.94>, 0 ) }
	#end
	hollow
	}
	light_source { 1.8*(3-z*5) 1.2 
		#if (AREALIGHTS)
		area_light x,y,5,5 jitter circular adaptive 0
		#end
		photons { refraction on }
	}

	//rotate -y*45
	rotate -x*25
	translate <.1,-1/1.6,4.2> //z*2.6-y/3+x*.1
}

 light_source { -z*8 .7 shadowless }
 
 camera { angle 50
	#if (DOF)
	aperture .044 blur_samples 60 confidence 1 focal_point y/1.8+z*3.5
	#end
}
 
