                     // Persistence of Vision Ray Tracer Include File
// File: escherish.inc
// Vers: 3.6
// Desc: Impossible Figure Like Escher Triangle
// Date: 01/01/08
// Auth: Stephen R. Hall
//
// ----------------------------------------

#macro Create_Figure(w,r,s,th,ht,flat_border)
        #local pigments = array[s]
        #local textures = array[s]
        #ifndef (textures_def)
                #local seeder = seed(seedish);
                #local Loop_One = 0;
                #while ( Loop_One < s)
                        #local pigments[Loop_One] = pigment{color rgb<rand(seeder),rand(seeder),rand(seeder)>};
                        #local textures[Loop_One] = texture{pigment{pigments[Loop_One]} finish {ambient .6}};
                        #local Loop_One = Loop_One + 1;
                #end                
        #else
                #local Loop_One = 0;
                #while ( Loop_One < s)
                        #local textures[Loop_One] = textures_def[Loop_One];
                        #local Loop_One = Loop_One + 1;
                #end
        #end
        #local givens = array[4 * s][2]
        #local figureds = array[2 * s][2]
        #ifndef (outline_tex_def)
                #local outline_tex=texture{pigment{color rgb <1,1,1>} finish{diffuse .8}};
        #else
                #local outline_tex=outline_tex_def;        
        #end

        
        #declare figure=
        union
        {
        #local Loop_One = 0;
        #while ( Loop_One < 4 )
                #local givens[Loop_One][0] = ((Loop_One - 1.5) * w);
                #local givens[Loop_One][1] = -1 * r;
                #if ((Loop_One=1)|(Loop_One=2))
                        #if (flat_border=off)
                                sphere
                                {
                                        <givens[Loop_One][0],givens[Loop_One][1],0>,
                                        th
                                        texture{outline_tex}
                                }
                        #else
                                cylinder
                                {
                                        <givens[Loop_One][0],givens[Loop_One][1],-1*ht/2>,
                                        <givens[Loop_One][0],givens[Loop_One][1],ht/2>,
                                        th
                                        texture{outline_tex}
                                }
                        #end
                #end
                #local Loop_One = Loop_One + 1;
        #end

        #local rot_angle = (2 * pi) / s;
        #local Loop_One = 1;
        #while ( Loop_One < s )
                #local Loop_Two = 0;
                #while ( Loop_Two < 4 )
                        #local givens[(Loop_One * 4)+Loop_Two][0] = 
                                givens[Loop_Two][0]*cos(rot_angle*Loop_One)+-1*givens[Loop_Two][1]*sin(rot_angle*Loop_One);
                        #local givens[(Loop_One * 4)+Loop_Two][1] =
                                givens[Loop_Two][0]*sin(rot_angle*Loop_One)+givens[Loop_Two][1]*cos(rot_angle*Loop_One);
                        #if ((Loop_Two=1)|(Loop_Two=2))
                                #if (flat_border=off)
                                        sphere
                                        {
                                                <givens[(Loop_One * 4)+Loop_Two][0],givens[(Loop_One * 4)+Loop_Two][1],0>,
                                                th 
                                                texture{outline_tex}
                                        }
                                #else
                                        cylinder
                                        {
                                                <givens[(Loop_One * 4)+Loop_Two][0],givens[(Loop_One * 4)+Loop_Two][1],-1*ht/2>,
                                                <givens[(Loop_One * 4)+Loop_Two][0],givens[(Loop_One * 4)+Loop_Two][1],ht/2>,
                                                th 
                                                texture{outline_tex}
                                        }
                                #end        
                        #end        
                        #local Loop_Two = Loop_Two + 1;
                #end
                #local Loop_One = Loop_One + 1;
        #end
        
        #local Loop_One = 0;
        #while ( Loop_One < (s-1) )
                #if (flat_border=off)
                        cylinder
                        {
                                <givens[(Loop_One * 4)+2][0],givens[(Loop_One * 4)+2][1],0>,
                                <givens[(Loop_One * 4)+5][0],givens[(Loop_One * 4)+5][1],0>,
                                th
                                texture{outline_tex}
                        }
                #else
                        #local xx = givens[(Loop_One * 4)+5][0]-givens[(Loop_One * 4)+2][0];
                        #local yy = givens[(Loop_One * 4)+5][1]-givens[(Loop_One * 4)+2][1];
                        #local theta = atan2(yy,xx)*180/pi;
                        #local length = sqrt((xx*xx)+(yy*yy));
                        box
                        {
                                <0,th,ht/2>,
                                <length,-1*th,-1*ht/2>
                                texture{outline_tex}
                                rotate<0,0,theta>
                                translate<givens[(Loop_One * 4)+2][0],givens[(Loop_One * 4)+2][1],0>
                        }
                #end
                #if (flat_border=off)
                        cylinder
                        {
                                <givens[(Loop_One * 4)+1][0],givens[(Loop_One * 4)+1][1],0>,
                                <givens[(Loop_One * 4)+2][0],givens[(Loop_One * 4)+2][1],0>,
                                th
                                texture{outline_tex}
                        }
                #else
                        #local xx = givens[(Loop_One * 4)+2][0]-givens[(Loop_One * 4)+1][0];
                        #local yy = givens[(Loop_One * 4)+2][1]-givens[(Loop_One * 4)+1][1];
                        #local theta = atan2(yy,xx)*180/pi;
                        #local length = sqrt((xx*xx)+(yy*yy));
                        box
                        {
                                <0,th,ht/2>,
                                <length,-1*th,-1*ht/2>
                                texture{outline_tex}
                                rotate<0,0,theta>
                                translate<givens[(Loop_One * 4)+1][0],givens[(Loop_One * 4)+1][1],0>
                        }
                #end                
                #local Loop_One = Loop_One + 1;
        #end
        #if (flat_border=off)
                cylinder
                {
                        <givens[(s * 4) - 2][0],givens[(s * 4) - 2][1],0>,
                        <givens[1][0],givens[1][1],0>,
                        th
                        texture{outline_tex}
                }
        #else
                #local xx = givens[(s * 4) - 2][0]-givens[1][0];
                #local yy = givens[(s * 4) - 2][1]-givens[1][1];
                #local theta = atan2(yy,xx)*180/pi;
                #local length = sqrt((xx*xx)+(yy*yy));
                box
                {
                        <0,th,ht/2>,
                        <length,-1*th,-1*ht/2>
                        texture{outline_tex}
                        rotate<0,0,theta>
                        translate<givens[1][0],givens[1][1],0>
                }
        #end
        #if (flat_border=off)
                cylinder
                {
                        <givens[(s * 4) - 3][0],givens[(s * 4) - 3][1],0>,
                        <givens[(s * 4) - 2][0],givens[(s * 4) - 2][1],0>,
                        th
                        texture{outline_tex}
                }
        #else
                #local xx = givens[(s * 4) - 3][0]-givens[(s * 4) - 2][0];
                #local yy = givens[(s * 4) - 3][1]-givens[(s * 4) - 2][1];
                #local theta = atan2(yy,xx)*180/pi;
                #local length = sqrt((xx*xx)+(yy*yy));
                box
                {
                        <0,th,ht/2>,
                        <length,-1*th,-1*ht/2>
                        texture{outline_tex}
                        rotate<0,0,theta>
                        translate<givens[(s * 4) - 2][0],givens[(s * 4) - 2][1],0>
                }
        #end

        #local Loop_One=0;
        #while ( Loop_One < s )
                #local a = (Loop_One * 4)+1;
                #local x1 = givens[a][0];
                #local y1 = givens[a][1];
                #local a = (Loop_One * 4)+6;
                #if ( a >= (s*4))
                        #local a = a - (s*4);
                #end
                #local x2 = givens[a][0];
                #local y2 = givens[a][1];
                #local a = (Loop_One * 4)+11;
                #if ( a >= (s*4))
                        #local a = a - (s*4);
                #end
                #local x3 = givens[a][0];
                #local y3 = givens[a][1];
                #local a = (Loop_One * 4)+4;
                #if ( a >= (s*4))
                        #local a = a - (s*4);
                #end
                #local x4 = givens[a][0];
                #local y4 = givens[a][1];
                #local x5 = givens[Loop_One * 4][0];
                #local y5 = givens[Loop_One * 4][1];
                #local a = (Loop_One * 4)+7;
                #if ( a >= (s*4) )
                        #local a = a - (s*4);
                #end
                #local x6 = givens[a][0];
                #local y6 = givens[a][1];
                #if (x1=x2)
                        #local x2 = x2 + .00001;
                #end
                #if (x3=x4)
                        #local x4 = x4 + .00001;
                #end
                #if (x5=x6)
                        #local x6 = x6 + .00001;
                #end                                
                #local m11 = (y2-y1)/(x2-x1);
                #local m21 = (y4-y3)/(x4-x3);
                #local m12 = (y6-y5)/(x6-x5);
                #local m22 = (y4-y3)/(x4-x3);
                #local figureds[Loop_One * 2][0] = (y3-y1+(m11*x1)-(m21*x3))/(m11-m21);
                #local figureds[Loop_One * 2][1] = m11*(figureds[Loop_One * 2][0]-x1)+y1;
                #local figureds[Loop_One * 2+1][0] = (y3-y5+(m12*x5)-(m22*x3))/(m12-m22);
                #local figureds[Loop_One * 2+1][1] = m12*(figureds[Loop_One * 2+1][0]-x5)+y5;
                #if (flat_border=off)
                        sphere
                        {
                                <figureds[Loop_One * 2][0],figureds[Loop_One * 2][1],0>,
                                th 
                                texture{outline_tex}
                        }
                        sphere
                        {
                                <figureds[Loop_One * 2+1][0],figureds[Loop_One * 2+1][1],0>,
                                th 
                                texture{outline_tex}
                        }
                #else
                        cylinder
                        {
                                <figureds[Loop_One * 2][0],figureds[Loop_One * 2][1],-1*ht/2>,
                                <figureds[Loop_One * 2][0],figureds[Loop_One * 2][1],ht/2>,
                                th 
                                texture{outline_tex}
                        }
                        cylinder
                        {
                                <figureds[Loop_One * 2+1][0],figureds[Loop_One * 2+1][1],-1*ht/2>,
                                <figureds[Loop_One * 2+1][0],figureds[Loop_One * 2+1][1],ht/2>,
                                th 
                                texture{outline_tex}
                        }       
                #end
                #local Loop_One = Loop_One + 1;
        #end

        #local Loop_One = 0;
        #while ( Loop_One < s )
                #if (flat_border=off)
                        cylinder
                        {
                                <givens[(Loop_One * 4)+1][0],givens[(Loop_One * 4)+1][1],0>,
                                <figureds[Loop_One * 2][0],figureds[Loop_One * 2][1],0>,
                                th
                                texture{outline_tex}
                        }
                #else
                        #local xx = givens[(Loop_One * 4)+1][0]-figureds[Loop_One * 2][0];
                        #local yy = givens[(Loop_One * 4)+1][1]-figureds[Loop_One * 2][1];
                        #local theta = atan2(yy,xx)*180/pi;
                        #local length = sqrt((xx*xx)+(yy*yy));
                        box
                        {
                                <0,th,ht/2>,
                                <length,-1*th,-1*ht/2>
                                texture{outline_tex}
                                rotate<0,0,theta>
                                translate<figureds[Loop_One * 2][0],figureds[Loop_One * 2][1],0>
                        }                
                #end
                #local a = (Loop_One * 2) + 3;
                #if ( a >= (s*2))
                        #local a = a - (s*2);
                #end
                #if (flat_border=off)
                        cylinder
                        {
                                <figureds[Loop_One * 2][0],figureds[Loop_One * 2][1],0>,
                                <figureds[a][0],figureds[a][1],0>,
                                th
                                texture{outline_tex}
                        }
                #else
                        #local xx = figureds[Loop_One * 2][0]-figureds[a][0];
                        #local yy = figureds[Loop_One * 2][1]-figureds[a][1];
                        #local theta = atan2(yy,xx)*180/pi;
                        #local length = sqrt((xx*xx)+(yy*yy));
                        box
                        {
                                <0,th,ht/2>,
                                <length,-1*th,-1*ht/2>
                                texture{outline_tex}
                                rotate<0,0,theta>
                                translate<figureds[a][0],figureds[a][1],0>
                        }
                #end                
                #local Loop_One = Loop_One + 1;
        #end

        #local Loop_One = 0;
        #while ( Loop_One < s )
                #local a = (Loop_One * 4) + 1;
                #local b = (Loop_One * 4) + 2;
                #local c = (Loop_One * 4) + 5;
                #if ( c >= (s*4) )
                        #local c = c - (s*4);
                #end
                #local d = (Loop_One * 2) + 2;
                #if ( d >= (s*2) )
                        #local d = d - (s*2);
                #end
                #local e = (Loop_One * 2) + 3;
                #if ( e >= (s*2) )
                        #local e = e - (s*2);
                #end
                #local f = Loop_One * 2;
                polygon
                {
                        6,
                        <givens[a][0],givens[a][1]>,
                        <givens[b][0],givens[b][1]>,
                        <givens[c][0],givens[c][1]>,
                        <figureds[d][0],figureds[d][1]>,
                        <figureds[e][0],figureds[e][1]>,
                        <figureds[f][0],figureds[f][1]>
                        texture{textures[Loop_One]}
                }

                #local Loop_One = Loop_One + 1;
        #end
        }
#end