/*

 stereogram2.pov
 
 2007 Sam Benge
 
 Dependencies:
  1) POV-Ray 3.6 or above
  2) an input image

 Suggested command line options:
 +ft +f +a0.1 +am2 +r2
 
 The options listed below will affect other settings. Rather
 than describe them all, my suggestion for you is to inde-
 pendently figure out the interactions. (experiment!)
 
*/

// a couple of basic settings
global_settings{ assumed_gamma 2.2 }
#default{finish{ ambient 1 }}

// there should be no reason to change the camera
camera{
 orthographic 
 right x*2 up y*2
 location y*8 look_at 0
}

// *************************************************************
// beginning of recommended editable code

// number_of_strips
// This value determines how many strips span the image.
// Since the effect starts from the center, the total number of
// strips will be: 1+number_of_strips+extra_elements
// High values will diminish the effect, so be careful with it.
// integer, range 1-???
#declare number_of_strips = 7;

// extra_elements
// If there is a white region on either side of the
// image, add more strips with this value.
// integer, range 0-???
#declare extra_elements = 3;

// strip_extra_scale
// If you are getting white spaces between strips, increase this
// value. If you are getting too much overlap, decrease it.
// float, range 0.0-???
#declare strip_extra_scale = 0.02;

// strip_fuzzy
// Increase this value for more blending between strips.
// Decrease it for a sharper transition.
// float, range 0.0-1.0
#declare strip_fuzzy = 0.25;

// effect_depth
// Change how much depth is produced with this value.
// float, range 0.0-1.0
#declare effect_depth = 0.5;

// effect_reverse
// Cross your eyes or relax them? Your preference goes here.
// bool, yes/no
#declare effect_reverse = no;

// curve_correction
// On flat surfaces there will sometimes be a noticable curvature.
// Fiddle with this value until the effect looks right.
// float, range 0.0-???
#declare curve_correction = 1.5;

// repeating_pattern
// This predeclared pigment will be used for (you guessed it) the
// repeating pattern. Try to avoid using extremely sharp pigments,
// or you will need to increase the antialiasing depth.
#declare repeating_pattern=
pigment{
 bumps
 scale .025
 
}

// colormap
// Add your own color_map to the final image.
#declare colormap=
color_map{
 [0 rgb 1.33]
 [.4 rgb<0,.7,0>]
 [.5 rgb<0,0,.35>]
 [1 rgb<.3,.8,1>]
}

// depth_map
// This pigment is also a no-brainer. You will have obtained it
// from 'starter.pov' or from some other source.
#declare depth_map=
pigment{
 image_map{
  tga"starter.tga"
  interpolate 2
  once
 }
}

// end of recommended editable code
// *************************************************************
////////////////////////////////////////////////////////////////
//                                                            //
// All structures and values below this point should not be   //
// edited unless you are some sort of hacker!                 //
//                                                            //
////////////////////////////////////////////////////////////////
//
#declare strip_width = 2/number_of_strips;

#declare base=
 function{
  pigment{
   pigment_pattern{
    planar rotate z*90 scale strip_width/4+strip_extra_scale
   }
   pigment_map{
    [0 rgb 0]
    [strip_fuzzy
     repeating_pattern
    ]
   }
  }
 }

#declare bwarp=
 function{
  pigment{
   pigment_pattern{
    depth_map
    rotate x*90
    scale 2
    translate-(x+z)
    translate x*strip_width/4
   }
   poly_wave curve_correction
   #if(effect_reverse=yes)
    color_map{[0 rgb effect_depth][1 rgb 0]}
    #else
    color_map{[0 rgb 0][1 rgb effect_depth]}
   #end
  }
 }

#declare nelems=int(2/strip_width)+extra_elements+1;

#declare base_array=array[nelems];
#declare base_array[0]=function{base(x,y,z).grey}
#declare V=1;
#while(V<nelems)
 #declare base_array[V]=function{base_array[V-1](x+bwarp(x+strip_width*V/2,y,z).grey/10,y,z)}
 #declare V=V+1;
#end

#declare base_array2=array[nelems];
#declare base_array2[0]=function{base(x,y,z).grey}
#declare V=1;
#while(V<nelems)
 #declare base_array2[V]=function{base_array2[V-1](x-bwarp(x-strip_width*V/2-strip_width/2,y,z).grey/10,y,z)}
 #declare V=V+1;
#end

box{<0,0,-1>,<1,0,1>
 pigment{
  function{
   max(
    base_array[0](x,y,z)
    #declare V=1;
    #while(V<nelems)
     ,base_array[V](x-strip_width*V/2,y,z)
     #declare V=V+1;
    #end
   )
   
  }
  color_map{colormap}
 }
}

box{<-1,0,-1>,<0,0,1>
 pigment{
  function{
   max(
    base_array[0](x,y,z)
    #declare V=1;
    #while(V<nelems)
     ,base_array2[V](x+strip_width*V/2,y,z)
     #declare V=V+1;
    #end
   )
   
  }
  color_map{colormap}
 }
}
