/*

 starter.pov

 2007 Sam Benge

 This is a helper file to precalculate the depth
 map for the stereogram file.

 Dependencies:
  1) POV-Ray 3.6 or above
 
 Suggested command line options:
 +ft +f +a0.1 +am2 +r2

*/

global_settings{
 assumed_gamma 2.2
}

#default{ finish{ambient 1 } }

// The camera. Change as needed (and edit 'z_pigment', below).
camera{ 
 right x*4/3 up y
 location<0,50,-105>
 look_at<0,0,0>
 angle 40
}

// This pigment acts as a 'z-buffer'. Adjust
// as needed (and according to the camera)
#declare z_pigment=
pigment{
 planar rotate x*90
 scale 28
 translate<0,0,-42>
}

// your object here
// if 'povlogo.ttf' doesn't load, just make your own object
#declare my_obj=
union{
 text{
  ttf"povlogo.ttf"
  "P"
  .1,0
  translate<-.25,-.05,-.05>
  rotate -y*35
  scale 32
  
  translate<0,0,-33>
 }
 intersection{
  height_field{
   function 400,200{
    pigment{crackle scale<.2,.3>}
   }
   translate -x/2
   scale<80,20,32>
   
  }
  plane{z,.01 inverse}
  translate<0,-5,-42>
 }
}

//
// this puts the predeclared elements together
union{
 object{my_obj}
 pigment{z_pigment}
}