/*

snowflake example
2007 Sam Benge

*/

#include"transforms.inc"

global_settings{
 assumed_gamma 2.2
 max_trace_level 10
}

#default{ finish{ambient 0 } }

camera{ 
 location <0,0,-20>
 look_at 0
 angle 40
 right x*.5*1.33 up y*.5
}
#declare lpos = <.5,1,.25>;
#declare lcol = <1,.975,.9>*3;
#declare air = <.3 .4 .5>;

light_source{lpos*100000,lcol }

sky_sphere{
 pigment{
  spherical
  scale 2 translate y
  turbulence .05 lambda 3
  Point_At_Trans(lpos)
  poly_wave 1.75
  color_map{
   [0 rgb air-.5]
   [1 rgb lcol]
  }
 }
}


#declare sf=
height_field{
 function 700,700{
  pigment{
   image_map{png"snowflake.png"interpolate 2}
  }
 }
 translate -(x+z)/2
 scale<10,.1,10>
 rotate -x*90
 translate z*.002
}

intersection{
 object{sf}
 object{sf scale<1,1,-1>}
 pigment{rgbt 1}
 finish{
  reflection{0,1 fresnel}conserve_energy
  specular 1 roughness .01
 }
 interior{ior 1.33 }
 no_shadow
}