#ifndef(Flares_Types_Inc_Temp)
#declare Flares_Types_Inc_Temp = version;

#ifndef(Flares_Inc_Temp) #include "flares.inc" #end
#ifndef(Flares_Parts_Inc_Temp) #include "flares_parts.inc" #end
#macro Flares_Predefined(effect_type)
	#local effect_type = strupr(effect_type)
	Flares_Reset()
	#if (strlen(effect_type)>7)
		#if (strcmp(substr(effect_type,1,7), "NATURAL") = 0)
		#local N=max(val(substr(effect_type,8,strlen(effect_type)-7)),3);
		
		Flares_CausticSpot(<.5,.7,.3>/3,.5,.2,.25)
		Flares_FlareGlow(<.95,1,.9>,3,.05,16)
		#declare Flares_Glow_Transform=transform {scale .5};
		Flares_FlareGlow(<.5,.6,.4>,2,.0125,1)
		Flares_Ring(.0825*<.9,1,.8>,.125,.095,1,2,.3,.8075)
		#declare Flares_Streak_Color=.125;
		#declare Flares_Streak_Transform=transform {rotate <0,90,0>};
		Flares_FlareStreak(<1.01,1.02,1>*5,N,N*10,2,.75,.8)
		#declare Flares_Spot_Color=<.6,.65,.55>/1;
		#declare Flares_Spot_Seed=35;
		#declare Flares_Spot_Spacing=2;
		#declare Flares_Spot_Transform=transform {scale .5 rotate -y*90}
		Flares_PolygonSpots(N,.25,.25,.25,0)
		#declare Flares_Spot_Seed=128;
		#declare Flares_Spot_Spacing=4;
		#declare Flares_Spot_Transform=transform {scale 3 rotate -y*90}
		Flares_PolygonSpots(N,.25,.25,.25,0)
		#end#end
	#if (strcmp(effect_type, "CAMERA") = 0)
      #declare Flares_Glow_Color = <1.1, .3, .4>+.5;
      #declare Flares_Spots_Color = <1.3,1,.8>;
      #declare Flares_Spot_Seed = 60;
      Flares_Glow(4)
      Flares_Rays(1)
      Flares_Spots(1)
		#end
	#if (strcmp(effect_type, "CAMERA2") = 0)
      #declare Flares_Glow_Color = <.9, 1, 1.1>+.25;
      #declare Flares_Glow_Transform = transform {scale 1.2}
      #declare Flares_Rays_Frequency = .5;
      #declare Flares_Streak_Color = .2;
      #declare Flares_Spot_Color = <1.1, 1.2, 1.3>;
      #declare Flares_Spot_Seed = 45;
      Flares_Glow(3)
      Flares_Rays(1)
      Flares_Streak(2)
      Flares_Spots(1)
		#end
   #if (strcmp(effect_type, "CANDLE") = 0)
      #declare Flares_Glow_Color = <1.2, 1.1, .6>+.5;
      #declare Flares_Glow_Transform = transform {scale <1, 1, 1> * .6}
      #declare Flares_Rays_Color = <1.1, 1.05, .5>;
      #declare Flares_Rays_Transform = transform {scale <1, 1, 1> * .6}
      #declare Flares_Rays_Frequency = .4;
      #declare Flares_Streak_Color = <1.3, 1.1, .6>;
      #declare Flares_Streak_Transform = transform {scale <1, 1, 1> * .7}
      Flares_Glow(5)
      Flares_Rays(1)
      Flares_Streak(1)
      #end
   #if (strcmp(effect_type, "DIAMOND") = 0)
      #declare Flares_Glow_Color = <.7, .3, 1.1>+.7;
      #declare Flares_Spot_Color = <1.1, .5, 1.2>;
      #declare Flares_Spot_Frequency = 1.4;
      Flares_Glow(2)
      Flares_Rays(7)
      Flares_Spots(4)
      #end
   #if (strcmp(effect_type, "HEADLIGHT") = 0)
      #declare Flares_Glow_Color = <.6, 1, 1.6>+.5;
      #declare Flares_Glow_Transform = transform {scale <1, .75, 1>}
      #declare Flares_Rays_Color = .5;
      #declare Flares_Streak_Color = <.6, .9, 1.4>;
      #declare Flares_Streak_Transform = transform {scale <.8, .5, 1>}
      Flares_Glow(5)
      Flares_Rays(6)
      Flares_Streak(7)
      #end
   #if (strcmp(effect_type, "HEADLIGHT2") = 0)
      #declare Flares_Glow_Color = <1, 1.4, .9>+.25;
      #declare Flares_Glow_Transform = transform {scale <1.4, .8, 1>}
      #declare Flares_Rays_Transform = transform {scale <.6, .4, .4>}
      #declare Flares_Streak_Color = <1.3, 1, .8>;
      #declare Flares_Streak_Transform = transform {scale <1, 1, 1> * .6}
      #declare Flares_Spot_Color = <1.5, 1.3, 1>;
      #declare Flares_Spot_Transform = transform {scale <1.4, .8, 1>}
      #declare Flares_Spot_Frequency = 1.5;
      #declare Flares_Spot_Seed = 10;
      Flares_Glow(5)
      Flares_Rays(2)
      Flares_Streak(7)
      Flares_Spots(5)
      #end
   #if (strcmp(effect_type, "RAINBOW") = 0)
      #declare Flares_Glow_Transform = transform {scale <1, 1, 1> * 1.2}
      #declare Flares_Streak_Color = .3;
      #declare Flares_Spot_Seed = 10;
      #declare Flares_Spot_Frequency = .8;
      Flares_Glow(6)
      Flares_Rays(3)
      Flares_Streak(6)
      Flares_Spots(8)
      #end

   #if (strcmp(effect_type, "RAINBOW2") = 0)
   	#declare Flares_Glow_Color = 1.25;
   	#declare Flares_Streak_Color = .8;
      #declare Flares_Streak_Transform = transform {scale <1, 1, 1> * .7}
      #declare Flares_Spot_Color = 1.3;
      Flares_Glow(7)
      Flares_Rays(5)
      Flares_Streak(3)
      Flares_Spots(3)
      #end
   #if (strcmp(effect_type, "SOFTGLOW") = 0)
      #declare Flares_Glow_Color = <1.2, 1, .5>+.125;
      #declare Flares_Rays_Color = <1.2, 1.1, .7>;
      #declare Flares_Spot_Color = <1.2, 1.1, .7>;
      #declare Flares_Spot_Seed = 80;
      Flares_Glow(1)
      Flares_Rays(4)
      Flares_Spots(2)
      #end
   #if (strcmp(effect_type, "SPARKLE") = 0)
      #declare Flares_Glow_Color = <1, .9, .7>;
      #declare Flares_Glow_Transform = transform {scale .3}
      #declare Flares_Rays_Transform = transform {scale .4}
      #declare Flares_Streak_Color = .5;
      #declare Flares_Streak_Transform = transform {scale .4 rotate -y*15}
      Flares_Glow(2)
      Flares_Rays(3)
      Flares_Streak(5)
		#end
   #if (strcmp(effect_type, "SPARKLE2") = 0)
   	#declare Flares_Glow_Color = 1.125;
      #declare Flares_Glow_Transform = transform {scale .6}
      #declare Flares_Rays_Transform = transform {scale .6}
      Flares_Glow(5)
      Flares_Rays(2)
      #end
   #if (strcmp(effect_type, "SPOTLIGHT") = 0)
   	#declare Flares_Glow_Color = 1.5;
   	#declare Flares_Streak_Color = .75;
      #declare Flares_Glow_Transform = transform {scale .4}
      #declare Flares_Rays_Transform = transform {scale .5}
      Flares_Glow(1)
      Flares_Rays(2)
      Flares_Streak(4)
      #end
   #if (strcmp(effect_type, "SPOTLIGHT2") = 0)
      #declare Flares_Glow_Color = <.6, 1, 1.4>+.75;
      #declare Flares_Glow_Transform = transform {scale .5}
      #declare Flares_Rays_Color = 2*<.6, 1, 1.4>;
      #declare Flares_Rays_Frequency = 7/9;
      #declare Flares_Spot_Color = <.6, 1, 1.4>;
      #declare Flares_Spot_Transform = transform {scale .4}
      #declare Flares_Spot_Seed = 20;
      #declare Flares_Spot_Frequency = 1.5;
      Flares_Glow(1)
      Flares_Rays(6)
      Flares_Spots(8)
      #end
   #if (strcmp(effect_type, "STAR") = 0)
      #declare Flares_Glow_Color = <.6, .9, 1.2>*1.5;
      #declare Flares_Glow_Transform = transform {scale .3}
      #declare Flares_Rays_Transform = transform {scale .5}
      #declare Flares_Rays_Frequency = .6;
      #declare Flares_Rays_Color = 3;
      #declare Flares_Streak_Color = <.8, .9, 1.1>/1.5;
      #declare Flares_Streak_Transform = transform {scale .5 rotate -y*15}
      Flares_Glow(1)
      Flares_Rays(3)
      Flares_Streak(6)
      #end
   #if (strcmp(effect_type, "STAR2") = 0)
      #declare Flares_Glow_Color = <.8, 1, 1.2>*1.5;
      #declare Flares_Glow_Transform = transform {scale .5}
      #declare Flares_Rays_Transform = transform {scale <.5,.7,1>}
      #declare Flares_Rays_Frequency = 1.5;
      #declare Flares_Streak_Color = <.9, 1, 1.1>/1.25;
      #declare Flares_Streak_Transform = transform {scale .6 rotate y*90}
      Flares_Glow(1)
      Flares_Rays(2)
      Flares_Streak(8)
      #end
   #if (strcmp(effect_type, "SUN") = 0)
      #declare Flares_Glow_Color = <1.5, 1.1, .6>+.4;
      #declare Flares_Glow_Transform = transform {scale 1.3}
      #declare Flares_Rays_Frequency = 1.5;
      #declare Flares_Spot_Color = <1.3, .9, .6>;
      #declare Flares_Spot_Frequency = 1.4;
      Flares_Glow(4)
      Flares_Rays(3)
      Flares_Spots(6)
      #end
   #if (strcmp(effect_type, "SUN2") = 0)
      #declare Flares_Glow_Color = <1.1, .6, .2>+.8;
      #declare Flares_Rays_Color = 2*<1.1, .8, .2>;
      #declare Flares_Rays_Transform = transform {scale 1.2}
      #declare Flares_Rays_Seed = 4;
      #declare Flares_Streak_Color = <1.1, .7, .2>;
      #declare Flares_Streak_Transform = transform {scale .8 Flares_TransformToCenter()}
      #declare Flares_Spot_Color = .5*<1.1, .8, .2>;
      #declare Flares_Spot_Transform = transform {scale .8}
      #declare Flares_Spot_Seed = 4;
      Flares_Glow(2)
      Flares_Rays(1)
      Flares_Streak(7)
      Flares_Spots(5)
      #end
   #if (strcmp(effect_type, "SUN3") = 0)
      #declare Flares_Glow_Color = <1.5, 1.2, .3>+.7;
      #declare Flares_Glow_Transform = transform {scale 1.3}
      #declare Flares_Spot_Color = <1.5, 1.2, .3>;
      #declare Flares_Spot_Frequency = 2;
      Flares_Glow(5)
      Flares_Rays(7)
      Flares_Spots(1)
      #end
   #if (strcmp(effect_type, "UNDERSEA") = 0)
      #declare Flares_Glow_Color = 1.25*<.5, 1.3, .8>+.5;
      #declare Flares_Streak_Color = <.6, 1.1, .9>*.75;
      #declare Flares_Streak_Transform = transform {scale .7*.8 Flares_TransformToCenter()}
      Flares_Glow(1)
      Flares_Rays(8)
      Flares_Streak(8)
      #end
   #if (strcmp(effect_type,"50-300MM")=0)
   	#declare Flares_Glow_Color = 1.25;
      Flares_Glow(9)
      Flares_Rays(9)
      Flares_Spots(9)
   	#end
   #if (strcmp(effect_type, "RANDOM") = 0)
   	//directly copied from Colefax's random-lensflare
      #ifndef (Flares_Effect_Seed) #declare Flares_Effect_Seed = 0; #end
      #local _LE_rseed = seed(Flares_Effect_Seed);
      #local Flare_Color = vnormalize(<rand(_LE_rseed), rand(_LE_rseed), rand(_LE_rseed)>);
      #local glow_type = int(rand(_LE_rseed) * 7.9) + 1;
      #local rays_type = int(rand(_LE_rseed) * 8.9);
      #local streak_type = int(rand(_LE_rseed) * 8.9);
      #local spots_type = int(rand(_LE_rseed) * 8.9);
      
      #declare Flares_Glow_Transform = transform {scale (.7 + rand(_LE_rseed) * .6)}
      #declare Flares_Glow_Color = (1 + rand(_LE_rseed) * .6)*Flare_Color;
      
      #declare Flares_Rays_Transform = transform {scale (.7 + rand(_LE_rseed) * .6)}
      #declare Flares_Rays_Color = (.7 + rand(_LE_rseed) * .6)*Flare_Color;
      #declare Flares_Rays_Frequency = .8 + rand(_LE_rseed) * 1.2;
      #declare Flares_Rays_Seed = int(rand(_LE_rseed) * 10000);
      
		#declare Flares_Streak_Color = (.7 + rand(_LE_rseed) * .6)*Flare_Color;
		#declare Flares_Streak_Transform = transform {
			scale .5+rand(_LE_rseed)
			rotate y*int(rand(_LE_rseed) * 7.9) * 15
			#if (int(rand(_LE_rseed) * 1.25))
				Flares_TransformToCenter()
			#end
		}
      #declare Flares_Streak_Seed = int(rand(_LE_rseed) * 10000);
      
      #declare Flares_Spot_Transform = transform {scale (.7 + rand(_LE_rseed) * .6)}
      #declare Flares_Spot_Color = (.7 + rand(_LE_rseed) * .6)*Flare_Color;
      #declare Flares_Spot_Frequency = .8 + rand(_LE_rseed) * 1.2;
      #declare Flares_Spot_Seed = int(rand(_LE_rseed) * 10000);

      Flares_Glow(glow_type)
      Flares_Rays(rays_type)
      Flares_Streak(streak_type)
      Flares_Spots(spots_type)
		#end
#end
#macro Flares_PredefinedLensflareAt(effect_type,effect_location,effect_radius)
	Flares_New(effect_location, effect_radius)
	Flares_Predefined(effect_type)
#end

#macro Flares_VisualEffect(effect_type,Argument)
	#local effect_type = strupr(effect_type)
	Flares_Reset()
	#local Location=Flares_Camera_Location+vnormalize(Flares_Camera_Look_At-Flares_Camera_Location);
	#if (strcmp(effect_type, "NOISE") = 0)
		Flares_New(Location,1)
		Flares_AddFlareParticle(0,
      	pigment {
      		average
      		pigment_map {
	      		[1
		      		granite
		      		color_map {
		      			[.5 Flares_Additive_Blend(0)]
		      			[.5 Flares_Additive_Blend(x*Argument)]
		      		}
		      	]
	      		[1
		      		granite
		      		color_map {
		      			[.5 Flares_Additive_Blend(0)]
		      			[.5 Flares_Additive_Blend(y*Argument)]
		      		}
		      		translate 500
		      	]
	      		[1
		      		granite
		      		color_map {
		      			[.5 Flares_Additive_Blend(0)]
		      			[.5 Flares_Additive_Blend(z*Argument)]
		      		}
		      		translate 5000
		      	]
		      }
	      	scale 7.5/max(image_width,image_height)
	      	scale Flares_Camera_Angle/1000
      	}
      	, transform {scale 1})
		Flares_Add()
	#end
	#if (strcmp(effect_type, "NEGATIVE") = 0)
		Flares_New(Location,1)
		Flares_AddFlareParticle(0,
      	pigment {
      		rgb .5 transmit -1
      	}
      	, transform {scale 1})
		Flares_Add()
	#end
	#if (strcmp(effect_type, "CONTRAST") = 0)
		Flares_New(Location,1)
		Flares_AddFlareParticle(0,
      	pigment {
      		rgb .5 transmit Argument
      	}
      	, transform {scale 1})
		Flares_Add()
	#end
	#if (strcmp(effect_type, "BRIGHTNESS") = 0)
		Flares_New(Location,1)
		Flares_AddFlareParticle(0,
      	pigment {
      		rgb 0 transmit Argument
      	}
      	, transform {scale 1})
		Flares_Add()
	#end
#end

#end //Flares_Types.inc