// Flares V2 Testscene!
#include "flares_types.inc"
#declare Flares_Type=2;
Flares_Camera_Set(y*3,z*20+y*3)
Flares_Camera()

Flares_VisualEffect("noise",.1)
Flares_VisualEffect("brightness",.5)
Flares_VisualEffect("contrast",1.5)
//Flares_PredefinedLensflareAt("camera",LS,5000)
//Flares_PredefinedLensflareAt("camera2",LS,5000)
//Flares_PredefinedLensflareAt("headlight2",LS,5000)
//Flares_PredefinedLensflareAt("sun",LS,5000)
//Flares_PredefinedLensflareAt("softglow",LS,5000)
//Flares_PredefinedLensflareAt("rainbow",LS,5000)


//a boat on the water, just to have another lensflare :p
#declare Boat=
union {
	difference {
		sphere {0,1 scale <2,1,1>}
		sphere {0,1 scale <1.9,.25,.9>}
		plane {-y,0}
	}
	box {<0,-.3,-.3>,<.3,.3,.3>}
	pigment {rgb 1}
	scale 3
	rotate y*60 translate <5,1,20>
}
Flares_Set_Scene(Boat)


#declare LS=<-40,50,150>*1000;
#declare Flares_Color=<1,.6,.3>*1.5;
Flares_PredefinedLensflareAt("natural6",LS,10000)


object {Boat}

#declare Flares_Color=<.8,.9,1>*1.5;
Flares_PredefinedLensflareAt(
	"natural6",
	vrotate(<.35,.2,0>*3,y*60)+<5,1,20>,
	.25
)


//cloudlike-background
light_source {
	LS
	rgb <1,.8,.6>/.4
}
plane {y,-.1
	pigment {rgb <.4,.5,.9>}
	normal {granite -.5 scale 5}
	finish {ambient 0 diffuse .5 specular 1
		conserve_energy
		reflection {
			0,1
			metallic 1
			fresnel on
		}
	}
	interior {ior 4/3}
}


fog {
  fog_type 2
  distance 75
  color rgb <213,205,194>/255 //<.6,.7,1> 
  transmit 0
  fog_offset -1
  fog_alt 2
}

sky_sphere {
	pigment {
		planar
		color_map {
			[0 rgb <22,44,68>/255]
			[.5 rgb <88,120,179>/255]
			[1 rgb <213,205,194>/255]			
		}
	}
	pigment {
		wrinkles
		scale <1,.5,.5>
		translate 5080
		color_map {
			[.5 rgb 1*.975 transmit 1]
			[.86 rgb 1*.975]
		}
		warp {turbulence .5 lambda 3}
	}
}



global_settings {
	//just to proove a high max_trace_level is not needed :)
	max_trace_level 5
}


// add the flares to the scene
Flares_Add()