#ifndef(Flares_Parts_Inc_Temp)
#declare Flares_Parts_Inc_Temp = version;
#ifndef (Functions_Inc_Temp) #include "functions.inc" #end
#ifndef(Flares_Inc_Temp) #include "flares.inc" #end

//These are actually Chris Colefax's lensflare-textures, translated to the syntax of this lensflare-include-file
// Glows
#macro Flares_Glow(glow_type)
   #switch (glow_type) #case (0) #break

      #case (1) Flares_AddFlareParticle(1,
      	pigment {cylindrical color_map {
					[0 Flares_Additive_Blend(0)]
					[.5 Flares_Additive_Blend(.5*Flares_Glow_Color)]
					[1 Flares_Additive_Blend(1*Flares_Glow_Color)]
				}
            poly_wave 2}
      	, transform {scale .3 Flares_Glow_Transform})
			#break
      
      #case (2) Flares_AddFlareParticle(1,
      	pigment {cylindrical color_map {
      		[0 Flares_Additive_Blend(0)]
      		[.7 Flares_Additive_Blend(<1.1,1,.8>*.9*Flares_Glow_Color)]
      		[1 Flares_Additive_Blend(1*Flares_Glow_Color)]
			}
            poly_wave 2 }
      	, transform {scale .3 Flares_Glow_Transform})
			#break
      
      #case (3) Flares_AddFlareParticle(1,
      	pigment {cylindrical color_map {
      		[0 Flares_Additive_Blend(0)]
      		[.53 Flares_Additive_Blend(<.9,1,1.1>*.4*Flares_Glow_Color)]
      		[.54 Flares_Additive_Blend(<.9,1,1.1>*.5*Flares_Glow_Color)]
      		[.55 Flares_Additive_Blend(<.9,1,1.1>*.4*Flares_Glow_Color)]
      		[1 Flares_Additive_Blend(1*Flares_Glow_Color)]
      		}
      		poly_wave 2 }
      	, transform {scale .3 Flares_Glow_Transform})
         #break
      
      #case (4) Flares_AddFlareParticle(1,
      	pigment {cylindrical color_map {
      		[0 Flares_Additive_Blend(0)]
      		[.51 Flares_Additive_Blend(<1,.9,.9>*.3*Flares_Glow_Color)]
      		[.54 Flares_Additive_Blend(<1.1,.8,.8>*.5*Flares_Glow_Color)]
      		[.56 Flares_Additive_Blend(<1.1,.8,.8>*.5*Flares_Glow_Color)]
      		[.59 Flares_Additive_Blend(<1,.9,.9>*.4*Flares_Glow_Color)]
      		[1 Flares_Additive_Blend(1.2*.9*Flares_Glow_Color)]
      	}
      	poly_wave 2 }
      	, transform {scale .3 Flares_Glow_Transform})
      	#break
      
      #case (5) Flares_AddFlareParticle(1,
      	pigment {cylindrical color_map {
      		[0 Flares_Additive_Blend(0)]
      		[.05 Flares_Additive_Blend(.1*Flares_Glow_Color)]
      		[.08 Flares_Additive_Blend(1.2*.2*Flares_Glow_Color)]
      		[.1 Flares_Additive_Blend(.1*Flares_Glow_Color)]
      		[.15 Flares_Additive_Blend(0)]
      		[(1+.15)/2 Flares_Additive_Blend(.5*Flares_Glow_Color)]
      		[1 Flares_Additive_Blend(1*Flares_Glow_Color)]
      	} poly_wave 2 }
      	, transform {scale .2 Flares_Glow_Transform})
			#break
      
      #case (6) Flares_AddFlareParticle(1,
      	pigment {cylindrical color_map {
      		[0 Flares_Additive_Blend(0)]
      		[.02 Flares_Additive_Blend(<1.2,.3,1.2>*.1*Flares_Glow_Color)]
      		[.03 Flares_Additive_Blend(<.3,.6,1.2>*.1*Flares_Glow_Color)]
      		[.04 Flares_Additive_Blend(<.3,1.2,.6>*.1*Flares_Glow_Color)]
      		[.06 Flares_Additive_Blend(<1.2,1.2,.3>*.1*Flares_Glow_Color)]
      		[.09 Flares_Additive_Blend(<1.2,.3,.3>*.1*Flares_Glow_Color)]
      		[.15 Flares_Additive_Blend(0)]
      		[.2 Flares_Additive_Blend(0)]
      		[(1+.2)/2 Flares_Additive_Blend(.5*Flares_Glow_Color)]
      		[1 Flares_Additive_Blend(1*Flares_Glow_Color)]
      	} poly_wave 2 }
      	, transform {scale .2 Flares_Glow_Transform})
      	#break
      
      #case (7) Flares_AddFlareParticle(1,
      	pigment {cylindrical pigment_map {
      		[0 Flares_Additive_Blend(0)]
      		[.2 radial color_map {
               [0 Flares_Additive_Blend(<1.1, 1.1, .4>*.2*Flares_Glow_Color)]
               [1/3 Flares_Additive_Blend(<.4, 1.1, 1.1>*.2*Flares_Glow_Color)]
               [2/3 Flares_Additive_Blend(<1.1, .4, 1.1>*.2*Flares_Glow_Color)]
               [1 Flares_Additive_Blend(<1.1, 1.1, .4>*.2*Flares_Glow_Color)]}
            ]
            [.6 radial color_map {
               [0 Flares_Additive_Blend(<1.1, 1.1, .4>*.6*Flares_Glow_Color)]
               [1/3 Flares_Additive_Blend(<.4, 1.1, 1.1>*.6*Flares_Glow_Color)]
               [2/3 Flares_Additive_Blend(<1.1, .4, 1.1>*.6*Flares_Glow_Color)]
               [1 Flares_Additive_Blend(<1.1, 1.1, .4>*.6*Flares_Glow_Color)]}
            ]
            [1 Flares_Additive_Blend(1*Flares_Glow_Color)]
      	} poly_wave 2 }
      	, transform {scale .3 Flares_Glow_Transform})
         #break
      
      #case (8) Flares_AddFlareParticle(1,
      	pigment {cylindrical pigment_map {
      		[0 Flares_Additive_Blend(0)]
            [.5 radial color_map {
               [0 Flares_Additive_Blend(1.1*Flares_Glow_Color*.5)]
               [1 Flares_Additive_Blend(<1, 1, 1.1>*Flares_Glow_Color*.5)]}
               sine_wave frequency 7]
            [1 radial color_map {
               [0 Flares_Additive_Blend(1.1*Flares_Glow_Color)]
               [1 Flares_Additive_Blend(<1, 1, 1.1>*Flares_Glow_Color)]}
               sine_wave frequency 7]
      	} poly_wave 2}
      	, transform {scale .3 Flares_Glow_Transform})
      	#break
      #case (9)
			//Very Big Glow
			Flares_AddFlareParticle(1,
				pigment {
					cylindrical
					color_map {
						[0 Flares_Additive_Blend(0)]
						[1 Flares_Additive_Blend(.1*Flares_Glow_Color)]
					}
					poly_wave 1
				},transform {Flares_Glow_Transform})
			
			//Big Glow
			Flares_AddFlareParticle(1,
				pigment {
					cylindrical
					color_map {
						[0 Flares_Additive_Blend(0)]
						[1 Flares_Additive_Blend(<1,.2,.3>*.75*Flares_Glow_Color)]
					}
					poly_wave 2
				},transform {scale .5 Flares_Glow_Transform})
			
			//Flare Source
			Flares_AddFlareParticle(1,
				pigment {
					cylindrical
					color_map {
						[0 Flares_Additive_Blend(0)]
						[1 Flares_Additive_Blend(.7*Flares_Glow_Color)]
					}
					poly_wave 2
				}, transform {scale .15 Flares_Glow_Transform})
				
			//Ring-effect
			Flares_AddFlareParticle(1,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.05 Flares_Additive_Blend(<1,.4,.6>*.075*Flares_Glow_Color)]
					[.1 Flares_Additive_Blend(0)]
				}
				poly_wave 1
			},transform {scale .125 Flares_Glow_Transform})
      	#break
      #else
         #warning "Invalid glow_type specified.  No glow created.\r\n"
      #end
#end


//Rays
#macro Flares_Rays(rays_type)
	#local _raysseed=seed(Flares_Rays_Seed);
   #switch (rays_type) #case (0) #break
      #case (1) 
      #local Teller = rand(_raysseed) * 3; #while (Teller < 360)
         Flares_AddFlareParticle(1,
         pigment {cylindrical color_map {
         		[0 Flares_Additive_Blend(0)]
         		[1 Flares_Additive_Blend(.05*Flares_Rays_Color)]}
         	}
			, transform {
         	translate z
         	scale <.04,1,1>*(1+(<rand(_raysseed),1,rand(_raysseed)>-.5)*2)
         	rotate y*Teller scale .1 Flares_Rays_Transform
         	}
         )
         #local Teller=Teller+(4/Flares_Rays_Frequency); #end #break
      
      #case (2) 
      	#local Teller = rand(_raysseed) * 10; #while (Teller < 360)
	         Flares_AddFlareParticle(1,
	         pigment {cylindrical color_map {
	         	[0 Flares_Additive_Blend(0)]
	         	[1 Flares_Additive_Blend((.2-rand(_raysseed)*.1)*Flares_Rays_Color)]}
					poly_wave 2 
					
	         },transform {translate z scale <.06,1,1>*(1+(rand(_raysseed)-.5)*.6)
	         rotate y*Teller scale.15 Flares_Rays_Transform}
	         )
				#local Teller=Teller+((20+rand(_raysseed)*10)/Flares_Rays_Frequency);
      	#end #break
      
      #case (3) #local Teller = rand(_raysseed) * 10; #while (Teller < 360)
      		Flares_AddFlareParticle(1,
      			pigment {
      				cylindrical color_map {
	      				[0 Flares_Additive_Blend(0)]
	      				[1 Flares_Additive_Blend(.05*Flares_Rays_Color)]
      				} 
      			},transform {
      				translate z*1.1 scale <.1,1,1>*(1+(rand(_raysseed)-.5)*.7)
      				rotate y*Teller scale .12 Flares_Rays_Transform
					}) #local Teller=Teller+(18/Flares_Rays_Frequency); #end
      		#local Teller=rand(_raysseed)*20; #while (Teller<360)
      		Flares_AddFlareParticle(1,
      			pigment {
      				cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[1 Flares_Additive_Blend(.05*Flares_Rays_Color)]
      				}
      			},transform {
						translate z*1.1 scale <.15,1,1>*(1+(rand(_raysseed)-.5)*.7)
						rotate y*Teller scale .12 Flares_Rays_Transform
      			}
      			) #local Teller=Teller+(24/Flares_Rays_Frequency);
      	#end #break
      
      #case (4) 
      	#local Teller=rand(_raysseed)*30;
      	#while(Teller<180)
      		Flares_AddFlareParticle(1,
      			pigment {
      				cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[1 Flares_Additive_Blend(.2*Flares_Rays_Color)]
      				}
      				poly_wave 2
      				
      			},transform {scale <.2,1,1>*(1+(rand(_raysseed)-.5)*.3) rotate y*Teller scale .35 Flares_Rays_Transform}
      		)
      		#local Teller=Teller+(36/Flares_Rays_Frequency);
      	#end #break
      
      #case (5) 
      	#local Teller=rand(_raysseed)*5; #while (Teller<360)
      		Flares_AddFlareParticle(1,
      			pigment {
      				cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[1 Flares_Additive_Blend((.3+<rand(_raysseed),rand(_raysseed),rand(_raysseed)>)*(.2-rand(_raysseed)*.15)*Flares_Rays_Color)]
      				}
      				poly_wave 2
      			},transform {
						translate z scale <.03,1,1>*(1+(rand(_raysseed)-.5)*.7)
						rotate y*Teller scale .13 Flares_Rays_Transform
      			}
      		)
      		#local Teller=Teller+(6/Flares_Rays_Frequency);
      	#end #break
      
      #case (6) 
      	Flares_AddFlareParticle(1,
      		pigment {cylindrical pigment_map {
      				[0 Flares_Additive_Blend(0)]
      				[1 radial color_map {
      						[.2 Flares_Additive_Blend(0)]
      						[1 Flares_Additive_Blend(.2*Flares_Rays_Color)]
      					}
      					sine_wave frequency int(9 * Flares_Rays_Frequency) 
      				]
      			}
      			poly_wave 2
      			
      		},transform {rotate y*rand(_raysseed) * 360 scale .3 Flares_Rays_Transform}
      	) #break
      
      #case (7) 
      	Flares_AddFlareParticle(1,
      		pigment {
      			cylindrical pigment_map {
      				[0 Flares_Additive_Blend(0)]
      				[.8 radial color_map {
								[0 Flares_Additive_Blend(.25*Flares_Rays_Color)]
								[.4 Flares_Additive_Blend(0)]
								[.6 Flares_Additive_Blend(.05*Flares_Rays_Color)]
								[.8 Flares_Additive_Blend(0)]
								[1 Flares_Additive_Blend(.15*Flares_Rays_Color)]
				         }
 							triangle_wave frequency int(9 * Flares_Rays_Frequency) 
               	]
      			}
      			poly_wave 2
      			
      		},transform {rotate y*rand(_raysseed) * 360 scale .3 Flares_Rays_Transform}
      	) #break
      
      #case (8) 
      	Flares_AddFlareParticle(1,
      		pigment {
      			cylindrical pigment_map {
      				[0 Flares_Additive_Blend(0)]
      				[.5 radial color_map {
								[0 Flares_Additive_Blend(.1*Flares_Rays_Color)]
								[1 Flares_Additive_Blend(0)]
							}
							triangle_wave frequency int((100 + rand(_raysseed) * 20) * Flares_Rays_Frequency)
							
						]
      			}
      			poly_wave 2
      			
      		},transform {rotate y*rand(_raysseed) * 360 scale .3 Flares_Rays_Transform}
      	) #break
      #case (9)
			#local Aantal=50*Flares_Rays_Frequency;
			#local Seed=seed(Flares_Rays_Seed);
			#local Teller=0;
			#while (Teller<Aantal)
				#local Ray=pigment {
					cylindrical
					color_map {
						[0 Flares_Additive_Blend(0)]
						[1 Flares_Additive_Blend(.025*Flares_Rays_Color)] //<1,.4,.6>
					}
					translate x
					poly_wave 2
				}
				Flares_AddFlareParticle(1,Ray,transform {scale <1+rand(Seed)*1,1,.05>*.125 rotate y*360*rand(Seed) Flares_Rays_Transform})
				#local Teller=Teller+1;
			#end
      #break
      #else
         #warning "Invalid rays_type specified.  No rays created.\r\n"
      #end
#end



// Streaks
#macro Flares_Streak(streak_type)
	#local _streakseed=seed(Flares_Streak_Seed);
   #switch (streak_type) #case (0) #break

      #case (1) 
      	Flares_AddFlareParticle(1,
      		pigment {
      			cylindrical color_map {
      				[0 Flares_Additive_Blend(0)]
      				[.6 Flares_Additive_Blend(1.1*.3*Flares_Streak_Color)]
      			}
      			poly_wave 2
      		},transform {
      			scale <.5,1,.04> rotate y*-45
      			Flares_Streak_Transform
				}) #break
      
      #case (2)
      	#local SPig =
      		pigment {cylindrical color_map {
      			[0 Flares_Additive_Blend(0)]
      			[1 Flares_Additive_Blend(1.1*.9*Flares_Streak_Color)]
      		}
      		poly_wave 2
      		}

      	Flares_AddFlareParticle(1,pigment {SPig},transform {scale <.01,1,.4> Flares_Streak_Transform})
      	Flares_AddFlareParticle(1,pigment {SPig},transform {scale 1.2 scale <.01,1,.4> rotate y*-7 Flares_Streak_Transform})
      	#break
      #case (3) 
      	#local SPig =
      		pigment {cylindrical color_map {
      			[0 Flares_Additive_Blend(0)]
      			[1 Flares_Additive_Blend(1.1*.9*Flares_Streak_Color)]
      		}
      		poly_wave 2
      		translate z*.3
      		scale <.02,1,.35>}
			Flares_AddFlareParticle(1,pigment {SPig},transform { rotate y*((rand(_streakseed)-.5)*60) Flares_Streak_Transform})
			Flares_AddFlareParticle(1,pigment {SPig},transform {rotate y*(120+(rand(_streakseed)-.5)*60) Flares_Streak_Transform})
			Flares_AddFlareParticle(1,pigment {SPig},transform {rotate y*(240+(rand(_streakseed)-.5)*60) Flares_Streak_Transform})
         #break
      
      #case (4) 
      	#local SPig =
      		pigment {cylindrical color_map {
      			[0 Flares_Additive_Blend(0)]
      			[.6 Flares_Additive_Blend(.6*Flares_Streak_Color)]
      		}
      		poly_wave 2
      		}
      	Flares_AddFlareParticle(1,pigment{SPig},transform {scale <.5,1,.02> rotate y*45 Flares_Streak_Transform})
      	Flares_AddFlareParticle(1,pigment{SPig},transform {scale <.5,1,.02> rotate -y*45 Flares_Streak_Transform})
      	#break
      
      #case (5) 
      	#local Teller=0; #while (Teller<360)
      		Flares_AddFlareParticle(1,
      			pigment {
      				cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[1 Flares_Additive_Blend(1.1*.9*Flares_Streak_Color)]
      				}
      				poly_wave 2
      			},transform {
      				translate z*.2 scale <.02,1,.35> rotate y*Teller
      				Flares_Streak_Transform
      			}
      		)
      		#local Teller=Teller+72;
      	#end
      	#break
      
      #case (6) 
      	#local Teller=0; #while (Teller<360)
      		Flares_AddFlareParticle(1,
      			pigment {
      				cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[1 Flares_Additive_Blend(1.1*.9*Flares_Streak_Color)]
      				}
      				poly_wave 2
      			},transform {
      				scale <.02,1,.45> rotate y*Teller
      				Flares_Streak_Transform
      			}
      		)
      		#local Teller=Teller+120;
      	#end
      	#break
      
      #case (7) 
      	Flares_AddFlareParticle(1,
      		pigment {
      			cylindrical color_map {
      				[0 Flares_Additive_Blend(0)]
      				[1 Flares_Additive_Blend(.7*Flares_Streak_Color)]
      			}
      			poly_wave 2
      		},transform {scale <1.3,1,.04> Flares_Streak_Transform}
      	) #break
      
      #case (8) 
      	#local SPig =
      		pigment {cylindrical color_map {
      			[0 Flares_Additive_Blend(0)]
      			[1 Flares_Additive_Blend(1.1*.8*Flares_Streak_Color)]
      		}
      		poly_wave 2}
      	Flares_AddFlareParticle(1,pigment{SPig}, transform {scale <.02,1,.5> Flares_Streak_Transform})
      	Flares_AddFlareParticle(1,pigment{SPig},transform {scale <.8,1,.02> Flares_Streak_Transform})
      	#break
      #else
         #warning "Invalid streak_type specified.  No streak created.\r\n"
      #end
#end



// Spots
#macro Flares_Spots(spots_type)
	#local _spotseed=seed(Flares_Spot_Seed);
   #switch (spots_type) #case (0) #break

      #case (1) 
      	#local Teller=-1;
      	#while (Teller<1)
      		#local Kleur=(<rand(_spotseed),rand(_spotseed),rand(_spotseed)>*.6+.5)*Flares_Spot_Color;
      		#switch (rand(_spotseed))
      			#range(0,.65)
      				#local SPig=pigment {cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[.4-rand(_spotseed)*.38 Flares_Additive_Blend(Kleur*(.2-rand(_spotseed)*.2))]
      					[1-rand(_spotseed)*.5 Flares_Additive_Blend(Kleur*(.2-rand(_spotseed)*.2))]
      					} #local Scale = (.02+rand(_spotseed)*.1);}
      			#break
      			#range(.65,.9)
      				#local SPig=pigment {cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[1 Flares_Additive_Blend(Kleur*1.7*.9)]
      					} poly_wave 2 #local Scale = (.005+rand(_spotseed)*.01);}
      			#break
      			#range(.9,1)
      				#local SPig=pigment {cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[.01 Flares_Additive_Blend(Kleur*.05)]
      					} #local Scale = (.15+rand(_spotseed)*.3);}
      		#end
      		Flares_AddFlareParticle((Teller*2+1)*Flares_Spot_Spacing,
      			pigment {SPig},transform {scale Scale Flares_Spot_Transform}
      		)
      		#local Teller=Teller+((.01+rand(_spotseed)*.14)/Flares_Spot_Frequency);
      		#if (Teller>-.15 & Teller<.15) #local Teller=.15; #end
      	#end
      	#break
      
      #case (2) 
      	#local Teller=-1;
      	#while (Teller<1)
      		#switch (rand(_spotseed))
      			#range(0,.7)
      				#local SPig=pigment {cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[1 Flares_Additive_Blend(1.3*Flares_Spot_Color*(.5-rand(_spotseed)*.4))]
      					} poly_wave 2 #local Scale = (.05+rand(_spotseed)*.1);}
      			#break
      			#range(.7,1)
      				#local SPig=pigment {cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[1 Flares_Additive_Blend(1.2*Flares_Spot_Color*.9)]
      					} poly_wave 2 #local Scale = (.01+rand(_spotseed)*.02);}
      		#end
      		Flares_AddFlareParticle((Teller*2+1)*Flares_Spot_Spacing,
      			pigment {SPig},transform {scale Scale Flares_Spot_Transform}
      		)
      		#local Teller=Teller+((.05+rand(_spotseed)*.05)/Flares_Spot_Frequency);
      		#if (Teller>-.15 & Teller<.15) #local Teller=.15; #end
      	#end
      	#break
      
      #case (3) 
      	#local Teller=-1;
      	#while (Teller<1)
      		#switch (rand(_spotseed))
      			#range(0,.5)
      				#local SPig=
      				pigment {
      					cylindrical
      					pigment_map {
      						[0 Flares_Additive_Blend(0)]
      						[.01
		      					planar triangle_wave translate y/5
		      					pigment_map {
		      						[.4 planar triangle_wave translate y/5
		      							pigment_map {
					      					[.4 planar triangle_wave translate y/5
					      						color_map {
					      							[.4 Flares_Additive_Blend(Flares_Spot_Color*(.4-.2*rand(_spotseed)))]
					      							[.5 Flares_Additive_Blend(0)]
					      						}
					      						rotate z*120
					      					]
					      					[.5 Flares_Additive_Blend(0)]
		      							}
		      							rotate z*120
		      						]
		      						[.5 Flares_Additive_Blend(0)]
		      					}
		      					translate <.05,-.1,0> 
		      					rotate x*90
		      					scale 3.5/2
		      				]
		      			}
		      			#local Transform = transform {
			      			rotate y * 15 scale abs(Teller) * .12
							}
      				}
      			#break
               #range (.5, .8)
               	#local SPig=pigment {
               		cylindrical
               		pigment_map {
               			[0 Flares_Additive_Blend(0)]
               			[.5 radial  
               				color_map {
		                        [0 Flares_Additive_Blend(<1.2, 1.2, .4>*Flares_Spot_Color*.2)]
		                        [1/3 Flares_Additive_Blend(<.4, 1.2, 1.2>*Flares_Spot_Color*.2)]
		                        [2/3 Flares_Additive_Blend(<1.2, .4, 1.2>*Flares_Spot_Color*.2)]
		                        [1 Flares_Additive_Blend(<1.2, 1.2, .4>*Flares_Spot_Color*.2)]
									}
                        ]
               		}
               		#local Transform = transform {
               			rotate y*rand(_spotseed)*360
               			scale (.02+rand(_spotseed)*.1)
               		}
               	}
                  #break
      			#range(.8,1)
      				#local SPig=pigment {cylindrical color_map {
      					[0 Flares_Additive_Blend(0)]
      					[1 Flares_Additive_Blend(1.3*Flares_Spot_Color*.9)]
      					} poly_wave 2 #local Transform = transform {scale (.01+rand(_spotseed)*.01)}}
      		#end
      		Flares_AddFlareParticle((Teller*2+1)*Flares_Spot_Spacing,
      			pigment {SPig},transform {Transform Flares_Spot_Transform}
      		)
      		#local Teller=Teller+((.04+rand(_spotseed)*.04)/Flares_Spot_Frequency);
      		#if (Teller>-.15 & Teller<.15) #local Teller=.15; #end
      	#end
      	#break
      
      #case (4) 
      	#local Teller=-1;
      	#while (Teller<1)
      		#local Kleur=(<rand(_spotseed),rand(_spotseed),rand(_spotseed)>*.4+.7)*Flares_Spot_Color;
      		Flares_AddFlareParticle((Teller*2+1)*Flares_Spot_Spacing,
      			pigment {
      				planar
      				pigment_map {
      					[.5 Flares_Additive_Blend(0)]
      					[.6 planar
      						color_map {
      							[.5 Flares_Additive_Blend(0)]
      							[.6 Flares_Additive_Blend(Kleur*(.2-.1*rand(_spotseed)))]
      						}
      						rotate z*90
      					]
      				}
      				#local Transform = transform {
      				rotate x*90
      				rotate y*45
      				scale .5*<1,1,.7>*(abs(Teller)*.15+rand(_spotseed)*.02)
      				Flares_Spot_Transform
      				}
      			},Transform
      		)
      		#if (rand(_spotseed)<.5)
      			Flares_AddFlareParticle(((Teller + (rand(_spotseed) - .5) * .1)*2+1)*Flares_Spot_Spacing,
      				pigment {
      					cylindrical
      					color_map {
      						[0 Flares_Additive_Blend(0)]
      						[1 Flares_Additive_Blend(1.2*.7*Flares_Spot_Color)]
      					}
      					poly_wave 2
      					#local Transform = transform {
      						scale (.005+rand(_spotseed)*.01)
      						Flares_Spot_Transform
      					}
      				},Transform
      			)
      		#end
      		#local Teller=Teller+((.1+rand(_spotseed)*.02)/Flares_Spot_Frequency);
      		#if (Teller>-.15 & Teller<.15) #local Teller=.15; #end
      	#end
      	#break
      
      #case (5) 
      	#local Teller=-1;
      	#while (Teller<1)
      		#local Kleur= (<rand(_spotseed), rand(_spotseed), rand(_spotseed)> * .4 + .7) * Flares_Spot_Color;
      		#switch (rand(_spotseed))
      			#range (0,.6)
      				#local SPig=pigment {
      					cylindrical
      					color_map {
      						[0 Flares_Additive_Blend(0)]
      						[1 Flares_Additive_Blend(Kleur*.1)]
      					}
      					#local Scale = (.05+rand(_spotseed)*.06);
      				}
      			#break
      			#range (.6,1)
      				#local SPig=pigment {
      					cylindrical
      					color_map {
      						[0 Flares_Additive_Blend(0)]
      						[.2 Flares_Additive_Blend(Kleur*1.2*(.2-rand(_spotseed)*.1))]
      						[.3 Flares_Additive_Blend(0)]
      					}
      					#local Scale = (.05+rand(_spotseed)*.08);
      				}
      		#end
      		Flares_AddFlareParticle((Teller*2+1)*Flares_Spot_Spacing,
      			pigment {SPig},transform {scale Scale Flares_Spot_Transform}
      		)
      		#local Teller=Teller+((.05+rand(_spotseed)*.05)/Flares_Spot_Frequency);
      		#if (Teller>-.15 & Teller<.15) #local Teller=.15; #end
      	#end
      	#break
             
      #case (6) 
      	#local Teller=-1;
      	#while (Teller<1)
      		#local Kleur= (<rand(_spotseed), rand(_spotseed), rand(_spotseed)> * .5 + .7) * Flares_Spot_Color;
      		#local Scale=<1,1,1>;
      		#switch (rand(_spotseed))
      			#range (0,.4)
      				#local SPig=pigment {
      					cylindrical
      					pigment_map {
      						[0 planar
      							pigment_map {
      								[.5 Flares_Additive_Blend(0)]
      								[.55 planar
      									pigment_map {
      										[.5 Flares_Additive_Blend(0)]
      										[.55 planar
      											color_map {
      												[.5 Flares_Additive_Blend(0)]
      												[.55 Flares_Additive_Blend(Kleur*(.2-rand(_spotseed)*.1))]
      											}
      											rotate z*120
      										]
      									}
      									rotate z*120
      								]
      							}
      							rotate x*90
      							scale 3/2
      						]
      						[1-(rand(_spotseed)*.5) Flares_Additive_Blend(Kleur*(.2-rand(_spotseed)*.15))]
      					}
      					#local Scale = (.02+abs(Teller)*.05);
      				}
      			#break
      			#range (.4,.7)
      				#local SPig=pigment {
      					cylindrical
      					color_map {
      						[0 Flares_Additive_Blend(0)]
      						[.4-rand(_spotseed)*.38 Flares_Additive_Blend(Kleur*(.1-rand(_spotseed)*.05))]
      						[1-rand(_spotseed)*.5 Flares_Additive_Blend(Kleur*(.1 -rand(_spotseed)*.05))]
      					}
      					#local Scale = (.05+rand(_spotseed)*.1);
      				}
      			#break
      			#range (.7,1)
      				#local SPig=pigment {
      					cylindrical
      					color_map {
      						[0 Flares_Additive_Blend(0)]
      						[1 Flares_Additive_Blend(Kleur*1.7*.1)]
      					}
      					poly_wave 2
      					#local Scale = (.005+rand(_spotseed)*.015);
      				}
      		#end
      		Flares_AddFlareParticle((Teller*2+1)*Flares_Spot_Spacing,
      			pigment {SPig},transform {scale Scale Flares_Spot_Transform}
      		)
      		#local Teller=Teller+((.05+rand(_spotseed)*.05)/Flares_Spot_Frequency);
      		#if (Teller>-.15 & Teller<.15) #local Teller=.15; #end
      	#end
      	#break
      
      #case (7) 
      	#local Teller=-1;
      	#while (Teller<1)
      		#local Kleur= (<rand(_spotseed), rand(_spotseed), rand(_spotseed)> * .6 + .5) * Flares_Spot_Color;
      		Flares_AddFlareParticle((Teller*2+1)*Flares_Spot_Spacing,
      			pigment {
      				cylindrical
      				color_map {
      					[0 Flares_Additive_Blend(0)]
      					[.7 Flares_Additive_Blend(Kleur*1.2*.9)]
      				}
      				poly_wave 2
      				
      			},transform {scale (.01+rand(_spotseed)*.03) Flares_Spot_Transform}
      		)
      		#local Teller=Teller+((.005+rand(_spotseed)*.2)/Flares_Spot_Frequency);
      		#if (Teller>-.15 & Teller<.15) #local Teller=.15; #end
      	#end
      	#break
      
      #case (8) 
      	#local Teller=-1;
      	#while (Teller<1)
      		#local Kleur= (<rand(_spotseed), rand(_spotseed), rand(_spotseed)> * .6 + .5) * Flares_Spot_Color;
      		#local Kleur2= (<rand(_spotseed), rand(_spotseed), rand(_spotseed)> * .7 + .6) * Flares_Spot_Color;
      		#switch (rand(_spotseed))
      			#range (0,.8)
      				#local SPig=pigment {
      					cylindrical
      					color_map {
      						[0 Flares_Additive_Blend(0)]
      						[.3-rand(_spotseed)*.28 Flares_Additive_Blend(Kleur2*(.2-rand(_spotseed)*.15))]
      						[1-rand(_spotseed)*.6 Flares_Additive_Blend(Kleur*(.15-rand(_spotseed)*.1))]
      					}
      					#local Scale = (.03+rand(_spotseed)*.1);
      				}
      			#break
      			#range (.8,1)
      				#local SPig=pigment {
      					cylindrical
      					color_map {
      						[0 Flares_Additive_Blend(0)]
      						[1 Flares_Additive_Blend(Kleur*1.7*.9)]
      					}
      					poly_wave 2
      					#local Scale = (.005+rand(_spotseed)*.015);
      				}
      		#end
      		Flares_AddFlareParticle((Teller*2+1)*Flares_Spot_Spacing,
      			pigment {SPig},transform {scale Scale Flares_Spot_Transform}
      		)
      		#local Teller=Teller+((.005+rand(_spotseed)*.1)/Flares_Spot_Frequency);
      		#if (Teller>-.15 & Teller<.15) #local Teller=.15; #end
      	#end
      	#break
      #case (9)
			#local Flares_Spot_Brightness2=Flares_Spot_Color*.05;
			
			//Big spot (inside biggest spot)
			Flares_AddFlareParticle(1.5,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)] 
					[.02 Flares_Additive_Blend(<10/4,7/4,1>*.25*Flares_Spot_Brightness2)]
				}
			},transform {scale .15})
			
			//Biggest spot
			Flares_AddFlareParticle(1.5,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.02 Flares_Additive_Blend(<10/4,7/4,1>*.25*Flares_Spot_Brightness2)]
				}
			},transform {scale .5})
			
			//Small green spot in the middle of the screen
			Flares_AddFlareParticle(0,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[1 Flares_Additive_Blend(<1,10/6,1>*2*Flares_Spot_Brightness2)]
				}
			},transform {scale .005})
			
			//Greenyellow spot behind source
			Flares_AddFlareParticle(1.26,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.07 Flares_Additive_Blend(<7/4,7/4,1>*.5*Flares_Spot_Brightness2)]
					[.11 Flares_Additive_Blend(<6/4,7.7/4,1>*.5*Flares_Spot_Brightness2)]
					[.13 Flares_Additive_Blend(<1,2,1>*.5*Flares_Spot_Brightness2)]
					[.7 Flares_Additive_Blend(0)]
				}
			},transform {scale .05})
			
			//Biggest blue spot
			Flares_AddFlareParticle(.44,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.09 Flares_Additive_Blend(<1,2,7>*.3*Flares_Spot_Brightness2)]
					[1 Flares_Additive_Blend(<1,2,7>*.1*Flares_Spot_Brightness2)]
				}
			},transform {scale .09})
			
			//Small blue spot
			Flares_AddFlareParticle(.4,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.09 Flares_Additive_Blend(<1,2,8>*.2*Flares_Spot_Brightness2)]
				}
			},transform {scale .05})
			
			//Smallest blue spot
			Flares_AddFlareParticle(.5,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.08 Flares_Additive_Blend(<3,1,8>*.2*Flares_Spot_Brightness2)]
				}
			},transform {scale .03})
			
			//Lonely brown spot
			Flares_AddFlareParticle(.16,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.08 Flares_Additive_Blend(<6,3,1>*.25*Flares_Spot_Brightness2)]
				}
			},transform {scale .03})
			
			//Biggest brown spot
			Flares_AddFlareParticle(-.5,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.08 Flares_Additive_Blend(<6,3,1>*.3*Flares_Spot_Brightness2)]
					[1 Flares_Additive_Blend(<6,3,1>*.5*Flares_Spot_Brightness2)]
				}
			},transform {scale .1})
			
			//Small brown spot
			Flares_AddFlareParticle(-.46,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.08 Flares_Additive_Blend(<6,3,1>*.15*Flares_Spot_Brightness2)]
					[1 Flares_Additive_Blend(<6,3,1>*.05*Flares_Spot_Brightness2)]
				}
			},transform {scale .06})
			
			//Smallest brown spot
			Flares_AddFlareParticle(-.51,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.08 Flares_Additive_Blend(<6,3,1>*.1*Flares_Spot_Brightness2)]
				}
			},transform {scale .06})
			
			//Blurry brightgreen dot
			Flares_AddFlareParticle(-.36,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.75 Flares_Additive_Blend(<1,9/3,1>*Flares_Spot_Brightness2)]
					[1 Flares_Additive_Blend(<1,10/8,1>*3*Flares_Spot_Brightness2)]
				}
			},transform {scale .02})
			
			
			//Green spot (with blurry blue spot in it)
			Flares_AddFlareParticle(-.66,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.09 Flares_Additive_Blend(<4/3,3,1>*.25*Flares_Spot_Brightness2)]
					[1 Flares_Additive_Blend(<5/4,10/4,1>*.25*Flares_Spot_Brightness2)]
				}
			},transform {scale .05})
			
			//Blurry blue spot (inside green spot)
			Flares_AddFlareParticle(-.67,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[1 Flares_Additive_Blend(<1,1,15>*.3*Flares_Spot_Brightness2)]
				}
			},transform {scale .02})
			
			//Greenyellow spot nearby rainbowring
			Flares_AddFlareParticle(-1,
			pigment {
				cylindrical
				color_map {
					[0 Flares_Additive_Blend(0)]
					[.05 Flares_Additive_Blend(<10/5,7/5,1>*.8*Flares_Spot_Brightness2)]
					[.08 Flares_Additive_Blend(<10/5,7/5,1>*.8*Flares_Spot_Brightness2)]
					[.11 Flares_Additive_Blend(<10/5,10/5,1>*.8*Flares_Spot_Brightness2)]
					[.12 Flares_Additive_Blend(<6/5,7.7/5,1>*.8*Flares_Spot_Brightness2)]
					[.18 Flares_Additive_Blend(<1,8/5,1>*.8*Flares_Spot_Brightness2)]
					[.7 Flares_Additive_Blend(0)]
				}
			},transform {scale .13})
			
			
			//Rainbow-ring
			Flares_AddFlareParticle(-1.12,
			pigment {
				cylindrical
				color_map {
					[1-1 Flares_Additive_Blend(0)]
					[1-.995 Flares_Additive_Blend(<3,1,1>*.4*Flares_Spot_Brightness2)]
					[1-.975 Flares_Additive_Blend(<3,3,1>*.4*Flares_Spot_Brightness2)]
					[1-.955 Flares_Additive_Blend(<1,3,1>*.4*Flares_Spot_Brightness2)]
					[1-.935 Flares_Additive_Blend(<1,3,3>*.4*Flares_Spot_Brightness2)]
					[1-.915 Flares_Additive_Blend(<1,1,3>*.4*Flares_Spot_Brightness2)]
					[1-.895 Flares_Additive_Blend(<3,1,3>*.4*Flares_Spot_Brightness2)]
					[1-.888 Flares_Additive_Blend(0)]
				}
			},transform {scale .25})
			#break
      #else
         #warning "Invalid spots_type specified.  No spots created.\r\n"
      #end
#end




#macro Flares_PolygonPattern(N,Blur,Curve)
	#local Curve=max(Curve,.001);
	#local Blur=max(min(Blur,1),0);
	#if (N>0)
		#local N=max(N,3);
		#local LijnFunction=function {1-max(min(x,1),0)}
		#local LijnPigment=function {
				pigment {function {LijnFunction(x,y,z)}
					pigment_map {
						[0
							cylindrical
							color_map {
								[0 rgb 0]
								[Blur rgb 1]
							}
							scale <1,1,1/Curve>
						]
						[1 rgb 1]
					}
			}}
		#local Lijn=function{LijnPigment(x,y,z).gray}
		#local Pattern=function {
			Lijn(x,y,z)
			#local Teller=1;
			#while (Teller < N)
				#local Hoek=radians(Teller*360/N);
				*Lijn(x*cos(Hoek)-sin(Hoek)*z,y,x*sin(Hoek)+z*cos(Hoek))
				#local Teller=Teller+1;
			#end
		}
	#else
		#local LijnPigment=function {
				pigment {
					cylindrical
					color_map {
						[0 rgb 0]
						[Blur rgb 1]
					}
				}}
		#local Pattern=function{LijnPigment(x,y,z).gray}
	#end
	function {Pattern(x,y,z)}
#end

   	#macro Flares_PolygonSpots(N,Blur,Curve,Center,ToCenter)
			#ifndef (_spotseed) #local _spotseed=seed(Flares_Spot_Seed); #end
	     	#declare Teller=-1;
	     	#if (N>0) #local Radius=vlength(<1,tan(radians(.5*360/N)),0>); #else #declare Radius=1; #end
	      	#while (Teller<1)
	      		#local Kleur=(<rand(_spotseed),rand(_spotseed),rand(_spotseed)>*.6+.5)*Flares_Spot_Color;
	      				#local SK=.5*Kleur*Flares_Spot_Color*(.41-rand(_spotseed)*.4);
	      				#local SPig=pigment {
	      					cylindrical
	      					pigment_map {
	      						[0 Flares_Additive_Blend(0)]
	      						[.1 Flares_PolygonPattern(N,Blur,Curve) scale 1/Radius //.75
				      					color_map {
				      						[0 Flares_Additive_Blend(0)]
				      						[1 Flares_Additive_Blend(1*SK)]
				      					}
				      			]
	      						[1 Flares_PolygonPattern(N,Blur,Curve) scale 1/Radius //.75
				      					color_map {
				      						[0 Flares_Additive_Blend(0)]
				      						[1 Flares_Additive_Blend(Center*SK)]
				      					}
				      			]
	      					}
	      					
	      				}
	      		Flares_AddFlareParticle((Teller*2*Flares_Spot_Spacing+1),
	      			pigment {SPig }
	      			, transform {
	      				scale abs(-(Teller*2-1)) * (.1+rand(_spotseed)*.05)*.5
	      				Flares_Spot_Transform
	      			}
	      		)
	      		#declare Teller=Teller+((.05+rand(_spotseed)*.025)/Flares_Spot_Frequency);
	      		#if (Teller>-.15 & Teller<.15) #declare Teller=.15; #end
	      	#end
      #end
      
      #macro Flares_CausticSpot(Kleur,Sharpness,Feather,Dirtyness)
      	#local Sharpness=min(max(Sharpness,0),1);
      	#local Feather=180*min(max(Feather,0),1);
			#local LijnFunction=function {1-max(min(z,1),f_noise3d(x,y,z*5)*Dirtyness)}
			#local LijnPigment=function {
					pigment {
						function {LijnFunction(x*cos(radians(Feather))-sin(radians(Feather))*z,y,x*sin(radians(Feather))+z*cos(radians(Feather)))}
						color_map {
							[Sharpness rgb 0]
							[1 rgb 1]
						}
						scale .1
				}}
			#local Lijn=function{LijnPigment(x,y,z).gray}
			#local Pattern=function {Lijn(x,y,z)*Lijn(x,y,-z)}
	     	Flares_AddFlareParticle(-1,
      		pigment {
      			cylindrical
      			pigment_map {
      				[Sharpness Flares_Additive_Blend(0)]
      				[1
      					function{Pattern(x,y,z)}
      					color_map {
      						[0 Flares_Additive_Blend(0)]
      						[1 Flares_Additive_Blend(2*Kleur*Flares_Spot_Color)]
      					}
      				]
      			}
      			poly_wave 5
      			
      		}, transform {scale .3*<2,1,1>
      			Flares_Spot_Transform
      			scale <.5+2*pow(vlength(Flares_FlareParticleLocation(-1)-Flares_FlarePlaneCenter)/Flares_Distance,1),1,1>
      			Flares_TransformToCenter()}
      	)
      	Flares_AddFlareParticle(-1,
      		pigment {
      			cylindrical
      			pigment_map {
      				[0 Flares_Additive_Blend(0)]
      				[1
      					function{Pattern(x,y,z)}
      					color_map {
      						[0 Flares_Additive_Blend(0)]
      						[1 Flares_Additive_Blend(1*Kleur*Flares_Spot_Color)]
      					}
      				]
      			}
      			poly_wave 7
      			
      		}, transform {scale .3*<-2,1,1>
      			Flares_Spot_Transform
      			scale <.5+2.5*pow(vlength(Flares_FlareParticleLocation(-1)-Flares_FlarePlaneCenter)/Flares_Distance,1),1,1>
      			Flares_TransformToCenter()}
      	)
      #end
      
		#macro Flares_FlareGlow(Color,Power,RadialRainbow,RainbowFrequency)
			Flares_AddFlareParticle(1,
				pigment {
					cylindrical
					pigment_map {
						[0 Flares_Additive_Blend(0)]
						[.5 average
							pigment_map {
								[1-RadialRainbow Flares_Additive_Blend(.5*Color*Flares_Glow_Color)]
								[RadialRainbow
									radial
									color_map {
										[0 Flares_Additive_Blend(Flares_Glow_Color*(x+y)/2)]
										[1/3 Flares_Additive_Blend(Flares_Glow_Color*(y+z)/2)]
										[2/3 Flares_Additive_Blend(Flares_Glow_Color*(z+x)/2)]
										[1 Flares_Additive_Blend(Flares_Glow_Color*(x+y)/2)]
									}
									frequency RainbowFrequency
								]
							}
						]
						[1 Flares_Additive_Blend(1*Color*Flares_Glow_Color)]
					}
					poly_wave Power
      			
				}, transform {scale .5
      			Flares_Glow_Transform}
			)
		#end
		#macro Flares_Ring(Color,Radius,Width,Frequency,RingPower,TotalPower,Rainbow)
			#ifndef (Flares_Ring_Color) 
				#ifndef (Flares_Glow_Color)
					#local Flares_Ring_Color=1; 
				#else
					#local Flares_Ring_Color=Flares_Glow_Color;
				#end
			#end
			Flares_AddFlareParticle(1,
				pigment {
					cylindrical
					pigment_map {
						[0 Flares_Additive_Blend(0)]
						[1
							pigment_pattern {
								cylindrical
								color_map {
									[0 rgb 0]
									[Width rgb 1]
									[Width*2 rgb 0]
								}
								frequency Frequency
							}
							pigment_map {
								[0 Flares_Additive_Blend(0)]
								[1 average
									pigment_map {
										[1-Rainbow Flares_Additive_Blend(Color*Flares_Ring_Color)]
										[Rainbow cylindrical
											color_map {
								      		[0 Flares_Additive_Blend(0)]
								      		[.2*Width*2 Flares_Additive_Blend(Color*<1.2,.3,1.2>*1*Flares_Ring_Color)]
								      		[.3*Width*2 Flares_Additive_Blend(Color*<.3,.6,1.2>*1*Flares_Ring_Color)]
								      		[.4*Width*2 Flares_Additive_Blend(Color*<.3,1.2,.6>*1*Flares_Ring_Color)]
								      		[.6*Width*2 Flares_Additive_Blend(Color*<1.2,1.2,.3>*1*Flares_Ring_Color)]
								      		[.9*Width*2 Flares_Additive_Blend(Color*<1.2,.3,.3>*1*Flares_Ring_Color)]
								      		[1*Width*2 Flares_Additive_Blend(0)]
											}
											frequency Frequency
										]
									}
								]
							}
							poly_wave RingPower
						]
					}
					poly_wave TotalPower
					
				}, transform {scale Radius}
			)
		#end

		#macro Flares_FlareStreak(Color,Frequency1,Frequency2,Power,MinBrightness,Sharpness)
			#ifndef (Flares_FlareSeed) #declare Flares_FlareSeed=seed(0); #end
			#ifndef (Flares_Streak_Color) 
				#ifndef (Flares_Glow_Color)
					#declare Flares_Streak_Color=1; 
				#else
					#declare Flares_Streak_Color=Flares_Glow_Color;
				#end
			#end
		
			Flares_AddFlareParticle(1,
				pigment {
					cylindrical
					pigment_map {
						[0 Flares_Additive_Blend(0)]
						[1 radial
							pigment_map {
								[.5-(1-Sharpness)/2 Flares_Additive_Blend(0)]
								[.5+(1-Sharpness)/2 radial 
									pigment_map {
										#local Teller=0;
										#local Teller2=0;
										#local MB=.125*MinBrightness;
										#local MBA=.125*(1-MinBrightness);
										#while (Teller<(1-(1/Frequency2)))
											[Teller Flares_Additive_Blend((MB+MBA*mod(Teller2,2))*Flares_Streak_Color*Color)]
											#local Teller2=Teller2+1;
											#local Teller=Teller+.001+((1/Frequency2)*rand(Flares_FlareSeed));
										#end
										[1 Flares_Additive_Blend(0)]
									}
									rotate y*rand(Flares_FlareSeed)*360
									triangle_wave
								]
							}
							triangle_wave
							frequency Frequency1
						]
					}
					poly_wave Power
				},transform{Flares_Streak_Transform}
			)
		#end


#end // flares_parts.inc