// Flares effects
#ifndef(Flares_Inc_Temp)
#declare Flares_Inc_Temp = version;

//Global settings
	// Possible types:
	//  1 - the classic way of doing flares, using lots of little disc-objects.  Needs a high max_trace_level and even then there's a 
	//		  rather low limit on the maximum amount of flares.
	//  2 - the new way, using just 1 plane.  It's sometimes slower, but since there's just one object added to the scene, there's no
	//		  no need for a high max_trace_level.  There is however a limit on the maximum amount of flares (which depends of the number
	//		  of 'parts' it's composed of), but the limit is a lot higher than with type 1.
	#declare Flares_Type=2;

	// Distances between the camera and the "projection-plane" for the flares, and between 2 seperate "projection-planes"
	#declare Flares_Distance=1e-3;
	#declare Flares_Spacing=1e-3;

	// These adjust the global color and size of the flare
	#declare Flares_Color=1;
	#declare Flares_Size=1;

	// Defines how many samples-rays are shot to determine if the flare is visible or not
	#declare Flares_BlockSamples=25;

//Flares Settings:
	#macro Flares_Reset()
		#declare Flares_Glow_Color=1;
		#declare Flares_Glow_Transform=transform {scale 1}
		
		#declare Flares_Rays_Frequency=1;
		#declare Flares_Rays_Seed=0;
		#declare Flares_Rays_Color=1;
		#declare Flares_Rays_Transform=transform {scale 1}
		
		#declare Flares_Streak_Color=1;
		#declare Flares_Streak_Seed=0;
		#declare Flares_Streak_Transform=transform {scale 1}
		
		#declare Flares_Spot_Color=1;
		#declare Flares_Spot_Frequency=1;
		#declare Flares_Spot_Spacing=1;
		#declare Flares_Spot_Seed=0;
		#declare Flares_Spot_Transform=transform {scale 1}
	#end
	Flares_Reset()

//Flares Camera Creation macros:
	#macro Flares_Camera_SetAngle(Angle) #declare Flares_Camera_Angle=Angle; #end
	#macro Flares_Camera_SetRight(Right) #declare Flares_Camera_Right=Right; #end
	#macro Flares_Camera_SetUp(Up) #declare Flares_Camera_Up=Up; #end
	#macro Flares_Camera_SetSky(Sky) #declare Flares_Camera_Sky=Sky; #end
	#macro Flares_Camera_Set(Location,Look_At)
		#declare Flares_Camera_Location=Location;
		#declare Flares_Camera_Look_At=Look_At;
	#end
	#macro Flares_Camera()
		camera {
			location Flares_Camera_Location
			angle Flares_Camera_Angle
			right Flares_Camera_Right
			up Flares_Camera_Up
			sky Flares_Camera_Sky
			look_at Flares_Camera_Look_At
		}
	#end
	#declare Flares_Camera_Location=<0,0,0>;
	#declare Flares_Camera_Look_At=<0,0,1>;
	#declare Flares_Camera_Angle=60;
	#declare Flares_Camera_Right=x*4;
	#declare Flares_Camera_Up=y*3;
	#declare Flares_Camera_Sky=y;
	

//Flares Scene settings (for blocking the flares):
	#macro Flares_Set_Scene(Object)
		#ifdef(Flares_BlockingObject) #undef Flares_BlockingObject #end
		#declare Flares_BlockingObject=Object;
	#end
	#macro Flares_Unset_Scene()
		#ifdef(Flares_BlockingObject) #undef Flares_BlockingObject #end
	#end

//Flares Creation macros:
	#macro Flares_New(effect_location,effect_radius)
		#declare Flares_Location=effect_location*<1,1,1>;
		
		#declare Flares_Blocking=0;
		#ifdef(Flares_BlockingObject)
			#local Average=0;
			#local I=Flares_BlockSamples;
			#local RSeed=seed(1568);
			#while (I>0)
				#local Norm=<0,0,0>;
				#local Loc=trace(Flares_BlockingObject,Flares_Camera_Location,(Flares_Location+<rand(RSeed)-rand(RSeed),rand(RSeed)-rand(RSeed),rand(RSeed)-rand(RSeed)>*effect_radius)-Flares_Camera_Location,Norm);
				//sphere {Loc,1 pigment {red 10}}
				#if ( (vlength(Norm)=0) | (vlength(Flares_Camera_Location-Flares_Location)<vlength(Flares_Camera_Location-Loc)) ) #local Average=Average+1; #end
				#local I=I-1;
			#end
			#declare Flares_Blocking=1-(Average/Flares_BlockSamples);
		#end

		#ifndef (Flares_Plane) Flares_CreatePlane() #end
		#declare Flares_FlareNormal=<0,0,0>;
		#declare Flares_FlareCenter = trace(Flares_Plane,Flares_Camera_Location,vnormalize(Flares_Location-Flares_Camera_Location),Flares_FlareNormal);

		#declare Flares_Rays_Seed = Flares_Rays_Seed+1;
		#declare Flares_Streak_Seed = Flares_Streak_Seed+1;
		#declare Flares_Spot_Seed = Flares_Spot_Seed+1;

		// Some lensflare-calculation I got from Colefax's lenseffects-include file.  Used with permission.
		#declare Flares_CamSkyAngle=<degrees(acos(Flares_Camera_Sky.y/vlength(Flares_Camera_Sky))),0,0>;
		#if (Flares_Camera_Sky.x != 0 | Flares_Camera_Sky.z != 0 )
			#declare Flares_CamSkyAngle=Flares_CamSkyAngle+(y*degrees(atan2(Flares_Camera_Sky.x,Flares_Camera_Sky.z))); #end
		#declare	Flares_CamToLook=vrotate(vrotate(Flares_PlaneNormal,-y*Flares_CamSkyAngle.y),-x*Flares_CamSkyAngle.x);
		#declare Flares_CamToLookAngle=<-degrees(asin(Flares_CamToLook.y/vlength(Flares_CamToLook))),0,0>;   
		#if (Flares_CamToLook.x!=0 | Flares_CamToLook.z !=0) #declare Flares_CamToLookAngle=Flares_CamToLookAngle+(y*degrees(atan2(Flares_CamToLook.x,Flares_CamToLook.z))); #end

		#declare Flares_CamToEffect=<1,1,1>*(Flares_Location-Flares_Camera_Location);
		#declare Flares_CamToEffect=vrotate(vrotate(Flares_CamToEffect,-y*Flares_CamSkyAngle.y),-x*Flares_CamSkyAngle.x);
		#declare Flares_EffectDist=vlength(Flares_CamToEffect);
		#declare Flares_RelEffectLoc=vrotate(vrotate(Flares_CamToEffect,-y*Flares_CamToLookAngle.y),-x*Flares_CamToLookAngle.x);
		#declare Flares_DegFromCenter=degrees(acos(Flares_RelEffectLoc.z/vlength(Flares_RelEffectLoc)));
		#if (Flares_RelEffectLoc.y !=0 | Flares_RelEffectLoc.x !=0)
			#declare Flares_AngleToHoriz=degrees(atan2(Flares_RelEffectLoc.y,Flares_RelEffectLoc.x));
		#else
			#declare Flares_AngleToHoriz=0;
		#end
	
		#declare Flares_Flare_Distance_Scale = 15*effect_radius/pow(vlength(Flares_Location-Flares_Camera_Location),1);
	#end


	#macro Flares_Add()
		#if (Flares_Type=2)
			#ifdef (Flares_FlarePigment)
				object {Flares_Plane
					pigment {Flares_FlarePigment}
					finish {ambient Flares_flarepigmentcounter diffuse 0}
				}
			#end
			#declare Flares_Distance = Flares_Distance + Flares_Spacing;
			Flares_CreatePlane()
			#declare Flares_FlareNormal=<0,0,0>;
			#declare Flares_FlareCenter = trace(Flares_Plane,Flares_Camera_Location,vnormalize(Flares_Location-Flares_Camera_Location),Flares_FlareNormal);
		#end
	#end


// Don't worry about the macros below

//This macro defines the plane on which the lensflare will be drawn
#macro Flares_CreatePlane()
	#declare Flares_FlarePlaneCenter = Flares_Camera_Location+vnormalize(Flares_Camera_Look_At-Flares_Camera_Location)*Flares_Distance;
	#declare Flares_PlaneNormal = vnormalize(Flares_Camera_Look_At-Flares_Camera_Location);
	#declare Flares_Plane =
	plane {
		Flares_PlaneNormal,0
		no_shadow
		no_reflection
		hollow
		translate Flares_FlarePlaneCenter
	}
	//#declare Flares_FlarePigment=pigment {Flares_Additive_Blend(0)} 
	#ifdef (Flares_FlarePigment) #undef Flares_FlarePigment #end
	//#declare Flares_flarepigmentcounter=1;
#end

// This macro calculates the relative place on the plane containing the lensflare:
// FlareParticleLocation(1) will give you the projection of the effect-location onto the plane
// FlareParticleLocation(0) will give you the center of the image
// anything inbetween (or outside of the range) of 0 - 1 will give you an interpolation (or extrapolation) of those locations.
#macro Flares_FlareParticleLocation(Space)
	#local L=Flares_FlarePlaneCenter+Space*(Flares_FlareCenter-Flares_FlarePlaneCenter);
	L
#end

//macro to transform a streak (or any part) so it faces the center of the screen
#macro Flares_TransformToCenter()
	rotate y*Flares_AngleToHoriz
#end

// This is Slime's macro enabling additive-blending of colors. Used with permission.
// The key to creating new lensflare-effects is that you should *never* just use rgb-values, but *always* use this macro!
//
// Color: the color to show
// Additiveness: how much of the background is added to the color (0: only color shows, 1: color + background color shows)
// Transparency: how much of the background replaces the result (0: original result, 1: fully transparent (background color completely replaces the result))
#macro Flares_Additive_Blend(Color)
	// (thanks for this code, Slime !!)
	// (Can't have Additiveness == 1 as the hackish nature of this will cause division by zero)
	#local Additiveness=.9999;
	#local Color=Color*Flares_Color;
	#local Color = (1-Flares_Blocking) * <1,1,1> * Color / (1 - Additiveness);
	rgbt <Color.x, Color.y, Color.z, Additiveness> //Transparency + (1 - Transparency) * Additiveness>
#end


// This macro is the actual flare-creating macro: it adds the given pigment (Pgment) on the given relative place (Space) to the lensflare.
#macro Flares_AddFlareParticle(Space,Pigment, Transform)
	#if ((Flares_FlareNormal.x!=0)|(Flares_FlareNormal.y!=0)|(Flares_FlareNormal.z!=0))
		#switch (Flares_Type)
			#case (1)
				disc {0,y,1
					pigment {Pigment}
					finish {ambient 1 diffuse 0}
					no_shadow
					no_reflection
					hollow
					transform {Transform}
					scale Flares_Distance
					scale Flares_Size
					scale Flares_Flare_Distance_Scale
					rotate x*90
					rotate Flares_CamToLookAngle
					rotate Flares_CamSkyAngle
					translate Flares_FlareParticleLocation(Space)
				}
		
				#declare Flares_Distance = Flares_Distance + Flares_Spacing;
				Flares_CreatePlane()
				#declare Flares_FlareNormal=<0,0,0>;
				#declare Flares_FlareCenter = trace(Flares_Plane,Flares_Camera_Location,vnormalize(Flares_Location-Flares_Camera_Location),Flares_FlareNormal);
				#break
			#case (2)
				#ifndef (Flares_FlarePigment) 
					//#declare Flares_FlarePigment=pigment {Flares_Additive_Blend(0)} 
					#declare Flares_FlarePigment=pigment {
						Pigment
						transform {Transform}
						scale Flares_Distance
						scale Flares_Size
						scale Flares_Flare_Distance_Scale
						rotate x*90
						
						rotate Flares_CamToLookAngle
						rotate Flares_CamSkyAngle
						translate Flares_FlareParticleLocation(Space)
					}
					#declare Flares_flarepigmentcounter=1;
				#else
					
					#declare Flares_FlarePigment=
						pigment {
							average
							pigment_map {
								[Flares_flarepigmentcounter Flares_FlarePigment]
								[1 Pigment
									transform {Transform}
									scale Flares_Distance
									scale Flares_Size
									scale Flares_Flare_Distance_Scale
									rotate x*90
									
									rotate Flares_CamToLookAngle
									rotate Flares_CamSkyAngle
									translate Flares_FlareParticleLocation(Space)
								]
							}
						}
						#declare Flares_flarepigmentcounter=Flares_flarepigmentcounter+1;
					#end
				#break
		#end
	#end
#end


#end //flares.inc