// Abstract 20070711
#include "colors.inc"
#include "skies.inc"
#include "metals.inc"
#include "golds.inc"

sky_sphere {
	S_Cloud1
}

global_settings {assumed_gamma 1.0}  

light_source {<-30, 100, -30> color rgb 1}
light_source {<30, 100, 30> color rgb 1}
light_source {<30, -100, 30> color rgb 1}

camera {
 location <0,9,-10.5>
 look_at <8.5,-6,0>
 //angle 40
}  

#declare Seed=seed(10);    // Seed for the pipes
#declare Seed2=seed(4545); // Seed for the flags

#declare imax=500; // Number of pipes

#declare r_pipe=0.06; // Section of pipe
#declare r_pipe_column=0.02; //Radius of pipe column
#declare s_pipe=0.8; // Distance between pipes
#declare pipe_size=1; // Pipe chunk length
#declare pipe_max_chunks=8; // Pipe max chunks
#declare d_flags=0; // Dispersion of the flags
#declare t_pipe=T_Chrome_5A; //texture{pigment{rgb 1}}; // Pipe texture
#declare t_pipe_column=T_Silver_1A; //texture{pigment{rgb 1}}; // Pipe texture
#declare pipe_max_extent=30; // Max extent of the pipes

// Integer random generator between 0 and m
#macro random(m,m_seed)
    int(rand(m_seed)*m)
#end

//Columns
#declare pipe_columns=union{
	cylinder{<0,-(s_pipe-r_pipe)/2,-(s_pipe-r_pipe)/2> <0,-(s_pipe-r_pipe)/2,(s_pipe-r_pipe)/2> r_pipe_column}
	cylinder{<0,-(s_pipe-r_pipe)/2,(s_pipe-r_pipe)/2> <0,(s_pipe-r_pipe)/2,(s_pipe-r_pipe)/2> r_pipe_column}
	cylinder{<0,(s_pipe-r_pipe)/2,(s_pipe-r_pipe)/2> <0,(s_pipe-r_pipe)/2,-(s_pipe-r_pipe)/2> r_pipe_column}
	cylinder{<0,(s_pipe-r_pipe)/2,-(s_pipe-r_pipe)/2> <0,-(s_pipe-r_pipe)/2,-(s_pipe-r_pipe)/2> r_pipe_column}
}

// Flags
#declare pipe_flag_1=box{<0,-(s_pipe-r_pipe)/2,(s_pipe-r_pipe)/2-r_pipe_column/4> <pipe_size,(s_pipe-r_pipe)/2,(s_pipe-r_pipe)/2+r_pipe_column/4>}
#declare pipe_flag_2=box{<0,(s_pipe-r_pipe)/2,-(s_pipe-r_pipe)/2-r_pipe_column/4> <pipe_size,(s_pipe-r_pipe)/2,(s_pipe-r_pipe)/2+r_pipe_column/4>}
#declare pipe_flag_3=box{<0,-(s_pipe-r_pipe)/2,-(s_pipe-r_pipe)/2-r_pipe_column/4> <pipe_size,(s_pipe-r_pipe)/2,-(s_pipe-r_pipe)/2+r_pipe_column/4>}
#declare pipe_flag_4=box{<0,-(s_pipe-r_pipe)/2,-(s_pipe-r_pipe)/2-r_pipe_column/4> <pipe_size,-(s_pipe-r_pipe)/2,(s_pipe-r_pipe)/2+r_pipe_column/4>}

// Pipe
#macro pipe(start_point,end_point,chunks,v_dir,versus)
	#local pipe_s=union {
		box{<s_pipe/2,-r_pipe,-r_pipe> <chunks*pipe_size-s_pipe/2,r_pipe,r_pipe> translate (s_pipe/2+r_pipe)/2*(+y+z)}
		box{<s_pipe/2,-r_pipe,-r_pipe> <chunks*pipe_size-s_pipe/2,r_pipe,r_pipe> translate (s_pipe/2+r_pipe)/2*(+y-z)}
		box{<s_pipe/2,-r_pipe,-r_pipe> <chunks*pipe_size-s_pipe/2,r_pipe,r_pipe> translate (s_pipe/2+r_pipe)/2*(-y-z)}
		box{<s_pipe/2,-r_pipe,-r_pipe> <chunks*pipe_size-s_pipe/2,r_pipe,r_pipe> translate (s_pipe/2+r_pipe)/2*(-y+z)}
	}

	#local t_offset=0;
	#local r_dir=0;
	#if(v_dir.y=1)
		#local r_dir=z*versus;
	#else
		#if(v_dir.z=1)
			#local r_dir=-y*versus;
		#else
			#if(versus=-1)
				#local t_offset=(-chunks*pipe_size)*x;
			#end
		#end
	#end

	// Init hub
	box{0, s_pipe texture{pigment{rgbt <0,0,1,0.8>}} translate start_point translate -s_pipe/2} 
	// Pipes
	object{pipe_s texture{t_pipe} rotate r_dir*90 translate start_point+t_offset}
	// Columns
	#local i=0;
	#local s_point=start_point;
	#while(i<chunks-1)
		// Columns
		#local s_point=s_point+pipe_size*v_dir*versus;	
		object{pipe_columns texture{t_pipe_column} rotate r_dir*90 translate s_point}
		// Flags
		#if(i>0 & i<chunks-2)
			#local col_flag=random(4+d_flags,Seed2)+1;
			#switch (col_flag)
				#case (1)
					object{pipe_flag_1 texture{pigment{rgbt<rand(Seed2),rand(Seed2),rand(Seed2),0.6>}} rotate r_dir*90 translate s_point}
				#break
				#case (2)
					object{pipe_flag_2 texture{pigment{rgbt<rand(Seed2),rand(Seed2),rand(Seed2),0.6>}} rotate r_dir*90 translate s_point}
				#break
				#case (3)
					object{pipe_flag_3 texture{pigment{rgbt<rand(Seed2),rand(Seed2),rand(Seed2),0.6>}} rotate r_dir*90 translate s_point}
				#break
				#case (4)
					object{pipe_flag_4 texture{pigment{rgbt<rand(Seed2),rand(Seed2),rand(Seed2),0.6>}} rotate r_dir*90 translate s_point}
				#break
			#end
		#end
		// Next chunk
		#local i=i+1;
	#end
	// End hub
	// ToDo: fix
	box{end_point, end_point+s_pipe texture{pigment{rgbt <0,0,1,0.8>}} translate -s_pipe/2}  
#end

// Draw the segment
#macro draw_pipe(start_point)
	// First pipe
	#local chunks=random(pipe_max_chunks,Seed)+1;
	// Versus
	#local vers_axis=rand(Seed);
	#if(vers_axis>=0.5)
		#local step=chunks*pipe_size;
		#local versus=1;
	#else
		#local step=-chunks*pipe_size;
		#local versus=-1;
	#end
	// Axis direction
	#local dir_axis=random(6,Seed)+1;
	// If the same, force a different axis
	#while(last_axis=dir_axis)
		#local dir_axis=random(3,Seed)+1;
	#end
	// Choose the axis - if it point out of the max extent, force a different versus 
	#switch (dir_axis)
		#case (2) // Y
			#local end_point=start_point+step*y;
			#if (end_point.y>pipe_max_extent)
				#local step=-step;
				#local versus=-versus;
				#local end_point=start_point+step*y;
			#end
			#local v_dir=y;
		#break
		#case (3) // Z
			#local end_point=start_point+step*z;
			#if (end_point.z>pipe_max_extent)
				#local step=-step;
				#local versus=-versus;
				#local end_point=start_point+step*z;
			#end
			#local v_dir=z;
		#break
		#else     // X			
			#local end_point=start_point+step*x;
			#if (end_point.x>pipe_max_extent)
				#local step=-step;
				#local versus=-versus;
				#local end_point=start_point+step*x;
			#end
			#local v_dir=x;
	#end
	
	// Draw the pipe trace
	sphere {start_point r_pipe*1.2 texture{pigment{color rgb y}}}
	cylinder{start_point end_point r_pipe/2 texture{pigment{color rgb x}}}
	sphere {end_point r_pipe*1.2 texture{pigment{color rgb y}}}
	// Draw the pipe
	pipe(start_point,end_point,chunks,v_dir,versus)
	// Update parameters
	#declare last_axis=dir_axis;
	#declare start=end_point;
#end

// A certain number of segments 
#local i=1;
#declare start=<0,0,0>;
#declare last_axis=2;
#while (i<=imax)
	draw_pipe(start)
	#local i=i+1;
#end




