#macro cubic_image_map(img, img_size, blur_amount)
 #macro mycells(img_s)
  img
  scale<img_size.x,img_size.y,1>
  translate<img_s.x,img_s.y,0>
 #end
 #macro blend(V)
  pigment_pattern {
   gradient V
   colour_map {
    [.5-blur_amount/2 rgb 0]
    [.5+blur_amount/2 rgb 1]
   }
  }
  cubic_wave
 #end
  blend(x)
  pigment_map{
   [0
    blend(y)
    pigment_map{
     [0 mycells(<1,1>)]
     [1 mycells(<1,0>)]
    }
   ]
   [1
    blend(y)
    pigment_map{
     [0 mycells(<0,1>)]
     [1 mycells(<0,0>)]
    }
   ]
  }
  translate<-(img_size.x/2)/img_size.x,-(img_size.y/2)/img_size.y,0>
  scale<1/img_size.x,1/img_size.y,1>
#end