//////////////////////////////////////////
//                                      //
// Luminous Color Bleeding version 3.0b //
//        2007 Samuel T. Benge          //
//         distribute  freely           //
//                                      //
//////////////////////////////////////////

// Remember to keep the output image size the same as the input image size.....

// Beware of using png files which may have their own gamma values.....

// uncomment the line below for gamma correction if needed
global_settings{assumed_gamma 1}

// global ambient value - do not change
#default{finish{ambient 1}}

// don't change the camera
camera{
 orthographic
 right x*2 up y*2
 location z*-1
 look_at 0 
}

// edit the variables below
// **********************************************************************
// ***********************************

// it all starts here
#declare image_pigment=
pigment{
 image_map{
  
  // your image here
  png"ghost.png"
  
  interpolate 2
 }
  warp{repeat x flip x}
  warp{repeat y flip y}
 #declare image_scale = 2;
 scale image_scale translate (image_scale/2)*<-1,-1,0>
}

// the brightness of the effect
// use values over 1
#declare bright = 1.2755;

// the quality of the effect
// use values between 0 and 1 (with 1 being best)
#declare quality = 1;

// radius of effect
// change independent values for width/height
#declare rad = <2,2>*.065;

#declare rotation = 0;

// color threshold of effect
// use values between 0 and 1
#declare place = .25;

// pw stands for poly_wave
// it affects the threshold value up or down, but with a curve
// 1 = no change, +1 = brighter spots singled out
#declare pw = 1.75;

// intesity of original colors... you shouldn't have to change this
// default 4
#declare intensity = 5;

// ***********************************
// **********************************************************************
// end of variables


// the working code
#declare figm=
function{pigment{image_pigment}}

#declare image=
plane{z,0
 pigment{
  image_pigment
 }
}

#declare imga=
function{
 pigment{
  image_pigment
 }
}

#declare bloom_pigment=
pigment{
 average
 pigment_map{
  [1 function{figm(x,y,z).red} poly_wave pw color_map{[place rgb 1 transmit 1][1 rgb x*intensity]}]
  [1 function{figm(x,y,z).green} poly_wave pw color_map{[place rgb 1 transmit 1][1 rgb y*intensity]}]
  [1 function{figm(x,y,z).blue} poly_wave pw color_map{[place rgb 1 transmit 1][1 rgb z*intensity]}]
 }
}

#declare bloom_pigmenta=
pigment{
 function{figm(x,y,z).grey}
 pigment_map{
  [.5 rgbt<1,1,1,1>]
  [.85 image_pigment]
 }
}
 
#declare bloomed_luminescence=
plane{z,0
 pigment{
  average
  pigment_map{
   #declare rd = 0;
   #while(rd<1)
    #declare pv = 0;
    #while(pv<pi*2)
     [1-pow(rd,.25)
      bloom_pigment
      rotate z*rotation
      translate
      <sin(pv+rd*77)*rd,
       cos(pv+rd*77)*rd,
       0>*rad
      rotate z*-rotation
     ]
     #declare pv = pv + pi*2/rd/42 /quality;
    #end
    #declare rd = rd + 1/10 /quality;
   #end
  }
 }
 finish{ambient bright}
}

object{image translate z*.001}

object{bloomed_luminescence}
