//////////////////////////////////////////
//                                      //
//               ghost.pov              //
//          March 2007 Sam Benge        //
//           Special Thanks to          //
//      Xiaobin Wu and Jianhua Fan      //
//  for their excellent POV-Sub patch   //
//          Distribute freely~          //
//                                      //
//////////////////////////////////////////


// ini settings:
// +fn

#include"transforms.inc"
#include"ghost2_pov.inc"

global_settings{
 assumed_gamma 1.5
 max_trace_level 10
}

#default{ finish{ambient 0 } }

camera{ 
 fisheye
 right x*.5*1.33 up y*.5
 location <0,.5,-20>
 look_at y*4.25
 angle 37*1.5
 aperture .2 focal_point -z*7
 blur_samples 10 variance 0 
} 

// resolution of area_lights
#declare res = 3;
// position of lights
#declare lpos = <-1,.5,0>;
// color of lights
#declare lcol = <1,.95,.9>*3.5;
// fog, sky, and mountain color
#declare air = <.4 .45 .5>;

light_source{
 lpos*100000,lcol
 area_light x*30000,z*30000,res,res
 orient circular
 jitter adaptive 1
}

fog{rgb air distance 10 fog_type 2 fog_alt 1 fog_offset 0}

sky_sphere{
 // mountain range #1
 pigment{
  pigment_pattern{
   planar scale 2 translate -y*1
   poly_wave .5 turbulence .1 lambda 2.5
   translate z*13 translate x*.8 translate y*.025
   scale 4 warp{turbulence .1 lambda 3} scale 1/4
  }
  color_map{[.735 rgb air][.735 rgb air/1.25][1 rgb air]}
 }
 // mountain range #2
 pigment{
  pigment_pattern{
   planar scale 2 translate -y*1
   poly_wave .5 turbulence .2 lambda 2.5
   translate x*24.5
   scale 4 warp{turbulence .1 lambda 3} scale 1/4
  }
  color_map{[.7 rgbt 1][.7 rgb air/2][1 rgbt 1]}
 }
 // sunlight through the fog
 pigment{
  pigment_pattern{spherical scale 2 translate y*1
  Point_At_Trans(lpos)
  poly_wave 1.5
 }
  color_map{[0 rgb air transmit 1][1 rgb lcol]}
 }
}

// All objects in scene must be merged!
// There's an obscure bug in pov which causes
// the translucent object to show less translucency
// when other objects exist in scene, unless merged.
// No fix yet...
#declare obj=
 merge{
  plane{y,0 pigment{rgb 1}}
  object{Layer_0 translate -y*.1 }
  object{Layer_1 translate -y*.1 }
  rotate y*90
  translate<-1.33,0,-7>
 }

light_group{
 // special light for translucency
 light_source{
  lpos*100000,lcol
  area_light x*150000,z*150000,res,res
  orient circular
  jitter adaptive 1
 }
 // visible object
 object{obj
  pigment{rgb 1}
  finish{
   diffuse .55
   brilliance 0
  }
  double_illuminate
  no_shadow
 }
 // object responsible for interior fading
 object{obj
  pigment{rgbt 1}
  finish{diffuse 0}
  interior{
   fade_power 1
   fade_distance .002
   fade_color <1,.5,.5>
   media{absorption 10}
  }
  translate z*.01
  hollow
 }
}