// Truchet pattern 03 - Inscrivible in a unitary cube
// River in a grass land
// ToDo: some random ships
// ToDo: some hills and people
// ToDo: some erosion to the river?

// Textures and materials ------------------------------------------
#declare t_grass = texture {
	pigment{color rgb<0.35,0.65,0.0>}
	normal {bumps 0.75 scale 0.015  }
	finish {ambient 0.1 diffuse 0.8 }
}
#declare t_sabbia = texture {
     pigment {
        granite
        color_map {
           [ 0.0     rgbft <0.670588, 0.505882, 0.321569, 0.0, 0.0> ]
           [ 1.0     rgbft <0.941176, 0.878431, 0.792157, 0.0, 0.0> ]
        }
        turbulence 0.75
        ramp_wave
        //scale 0.1 // Too big at high resolutions
        scale  0.01
     }
}

#declare p_pink = pigment{color rgb <1,0.5,0.5>};
#declare p_violet = pigment{color rgb <0.7,0.5,0.8>};

// The water
#declare c_water = color_map {
	[ 0.00 rgbt <0.4,0.5,0.8, 0.9> ]
	[ 0.90 rgbt <0.4,0.5,0.8, 1> ]
	[ 1.00 rgb <1,1,1> ]
}

#declare t_water = texture {
    pigment{
    //rgbt <0.4,0.5,0.8, 0.9>
    	gradient z 
    	color_map {c_water}
	    turbulence 0.9
    }
               
    normal {
        ripples 0.75
        frequency 1
        translate <-3,0,3>
    }            
    finish {
		diffuse 0.3
		ambient 0.0
        reflection {0.3, 1 fresnel}
        conserve_energy
		specular 0.4
		roughness 0.003
    }
}
#declare i_water = interior {
    ior 1.33
    fade_distance 0.3
    //fade_power 1001
    //fade_color <0.4, 0.5, 0.47>
}

#declare m_water = material {
    texture {t_water}
    interior {i_water}
}

// The sky
#declare p_sky=pigment{      
    bozo
    color_map {
       [ 0.0     rgbft <0.196078, 0.6, 0.8, 0.0, 0.0> ]
       [ 0.1     rgbft <0.196078, 0.6, 0.8, 0.0, 0.0> ]
       [ 0.7     rgbft <0.8, 0.8, 0.833333, 0.0, 0.0> ]
       [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
    }
    turbulence 0.5
    octaves 3
    lambda 6.0
    ramp_wave
    scale  5.0
}
#declare t_sky=texture{      
	pigment {p_sky}
	finish {ambient 1 diffuse 0}
}
// -----------------------------------------------------------------

// The patterns ----------------------------------------------------

// The field with the rivers
#declare tru_pattern=intersection {
	box {<-0.5,0,-0.5> <0.5,1,0.5>}
	difference {
		box {<-0.5,0,-0.5> <0.5,0.3,0.5> texture {t_grass}}
		union {
			// Upper arc
			difference {
				cylinder {<0.5,0,0.5> <0.5,0.35,0.5> 0.65}
				cylinder {<0.5,-0.1,0.5> <0.5,0.4,0.5> 0.35}
			}
			// Lower arc
			difference {
				cylinder {<-0.5,0,-0.5> <-0.5,0.35,-0.5> 0.65}
				cylinder {<-0.5,-0.1,-0.5> <-0.5,0.4,-0.5> 0.35}
			}
		}
	}
}
/*
// The water
#declare tru_water = intersection {
	box {<-0.5,0,-0.5> <0.5,1,0.5>}
	union {
		// Upper arc
		difference {
			cylinder {<0.5,0,0.5> <0.5,0.25,0.5> 0.65}
			cylinder {<0.5,-0.1,0.5> <0.5,0.3,0.5> 0.35}
		}
		// Lower arc
		difference {
			cylinder {<-0.5,0,-0.5> <-0.5,0.25,-0.5> 0.65}
			cylinder {<-0.5,-0.1,-0.5> <-0.5,0.3,-0.5> 0.35}
		}
	}
} 
*/

#declare tru_water=box{<-0.5,0,-0.5> <0.5,0.25,0.5>}
// -----------------------------------------------------------------
/*
#declare r_seed_2=3;
#declare R2 = seed(r_seed_2);
*/
// The boat --------------------------------------------------------
declare boat=union {
	prism { 0.0 ,0.1 , 6
	       <-1.00, -1.0>,
	       < 1.00, -1.00>, 
	       < 1.00, 1.00>, 
	       < 0.00, 2.00>, 
	       <-1.00, 1.00>, 
	       <-1.00, -1.00>
	
	    texture{T_Wood30}
	       
	    scale <0.5,1,1>       
		translate <0,0.2,0> 
	}
	cylinder {<0,0,0> <0,2,0> 0.03
		texture{T_Wood17}
	}
	triangle {
		< 0,2.3,0>
		< 0,0.6,-1.2>  
		< 0,0.6,1.2>
		pigment {rgb 1}
		//pigment {rgb <rand(R2)*255,rand(R2)*255,rand(R2)*255>/255}
	}
	scale 0.1
	translate <.5,0.24,.5>
}
/*
#declare boat=object {boat_base
	translate <0.5,0,0.5>
	rotate <0,45,0>
} 
*/
// -----------------------------------------------------------------
