// Persistence of Vision Ray Tracer Scene Description File
// File: windows_room.pov
// Vers: 3.6.1
// Desc: A recreation of a small spot in the movie theatre where I work 
// Date: 18.08.05 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 31.08.05 (dd.mm.yy)

//Comments
// The main trick for the radiosity was to gather the samples with a bright skysphere, but
// render the final pass with an image as background and a less bright skysphere which will
// appear in reflections.
// Photons can, and should, be taken in pass on their own. Unless the scene is really dependant
// upon the photons for lighting, you should leave them off during radiosity-gathering, as
// photons mostly have small and local effects, which only bog the radiosity down without
// actually changing much of the effect. I also switch arealights off during the radiosity-gathering.

// Note that I've used my Glare-Macros to place the image in the background, you may use your
// own macros or techniques to do so, but I've just commented the appropriate lines in case you
// want to make use of my Macros.

//THE ROOM
// The main and visible area extends from <-2,0,0> to <1,0,-2.5>, the camera is position at
// <1.32,1.1,-3.8>.
// I'm using the left-handed system, so +x is right, +z is back (anything above z=0 is thus inside
// or behind the wall), +y is up. I tried to stick to metrics (1 unit = 1 meter), but it's just a
// rough estimate, as I hadn't intended this to become a full-fledged room until later.

//RADIOSITY NOTES
// With the current settings, the gathering pass at 320x240 took 7 minutes on
// my 2.4Ghz Athlon XP under Win2000, no antialiasing.
// The second pass at 512x384 with antialiasing (commandline: +am2 +a0.3 +r2) took 16.5 minutes.
// (Both were done whilst rendering another image, so it should actually run faster.)


//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

//#include "glare.inc"

#declare Radiosity = 0;
#declare Photons = 0;

#declare Save = 0;

#declare Arealights = 0;

//Adjust these for contrast
#default{finish{ambient 0 diffuse 0.4}}
#declare Light_Intensity = 5; //Actually this is just the value used for the rgb of the main-light...
#declare Radiosity_Brightness = 3.5; //May even be altered between gathering and final pass
#declare Radiosity_Count = 250; //I've used 1100 for the finals in my images
#declare Skysphere_Brightness = 0.75; //Only used when gathering radiosity, not used during final pass

//=====================================================================


global_settings{
  assumed_gamma 1
  max_trace_level 35
  #if (Radiosity)
  radiosity{
    #if (Save)
      pretrace_start 0.2
      pretrace_end 0.0125
      save_file "windows_room.rad"  
      error_bound 0.1
      always_sample on
      nearest_count 4
      minimum_reuse 0.01
    #else
      pretrace_start 1
      pretrace_end 1
      load_file "windows_room.rad"  
      error_bound 0.8
      always_sample off
      nearest_count 8
      minimum_reuse 0.01
    #end
    //normal on
    recursion_limit 2 //Usually sufficient for an interior room
    count Radiosity_Count
    brightness Radiosity_Brightness
  }
  #end
  #if (Photons)
  photons{
    spacing .001
    autostop 0
    #if (Save)
      save_file "windows_room.pho"
    #else
      load_file "windows_room.pho"
    #end
  }
  #end
}

//=====================================================================

sky_sphere{
  pigment{
    gradient y
    color_map{
      #if (Save)
        //Colors used to gather Radiosity
        [0 rgb <.6,.6,1>*Skysphere_Brightness][1 rgb <.8,.8,1>*Skysphere_Brightness]
      #else
        //Colors for reflections (slightly blue, but bright, in this case)
        [0 rgb <.6,.6,1>][1 rgb <.8,.8,1>]
      #end
    }
    scale 2 translate -1
  }
}

#declare Camera_Location = <1.32,1.1,-3.8>;
#declare Camera_Look_At = <-1.51,.85,0>;

camera{
  location Camera_Location
  look_at Camera_Look_At
}           

// Uncomment if you want to use the Glare-Macros to place the background image. Note that the Glare-Macros
// automatically switch the image to no_reflection and no_shadow in order not to mess up reflections with
// a planar background...
/*   
#if (!Save)
  #declare Backdrop = texture{pigment{image_map{jpeg "daylight.jpg"}scale <-1,1,1>}finish{ambient .9 diffuse 0} translate <-.1,.035,0>}
  Glare_PlaceImage(Backdrop,20)
#end
*/

//=====================================================================

light_source{
  <-650,410,-145>
  rgb Light_Intensity
  parallel point_at <0,0,0>
  #if (Arealights)
    #if (!Save) area_light x*10,y*10,25,25 orient circular adaptive 2 #end
  #end
}

//This lightsource is used whenever radiosity is switched off, so that the
//scene isn't entirely black and you can work on it without radiosity.
#if (!Radiosity)
light_source{
  <3,1,-4>
  rgb .2
  shadowless
}
#end

//=====================================================================
//Materials
#declare Glass_Material =
  material{
    texture{
      pigment{rgbt <1,1,1,1>}
      finish{
        reflection{0,1 fresnel exponent .98}
        specular 1 roughness .001
      }
    }
    interior{ior 1.55}
  }

#declare Wall_Material =
texture{
  pigment{rgb .8}
  normal{agate .002 no_bump_scale scale <1,3,1>*.2}
  finish{
    specular .1 roughness .3
  }
}

#declare Chrome =
texture{
	pigment{rgb 0}
	finish{
	  reflection 1
	  ambient 0 diffuse 0
	  specular 3 roughness .01
	  brilliance 4
	  }
	}

//=====================================================================
//Walls and Ceiling
union{
  //Front wall with circular hole
  difference{
    box{<-2.3,-.1,0>,<10,2.6,.3>}
    cylinder{<0,1.6,-.1><0,1.6,.4>,.65}
  }
  //Side wall with rectangular hole
  difference{
    box{<-2,-.1,.5><-2.3,2.6,-7>}
    box{<-1.99,.11,-.2><-2.31,2.21,-2.5>}
  }
  //Right Wall
  box{<4,-.1,.3><4.3,2.6,-7>}
  //Rear wall
  box{<-2,-.1,-5>,<10,2.6,-5.3>}
  //Ceiling
  box{<-2.2,2.5,.3>,<10,2.8,-7.3>}
  texture{Wall_Material}
}

//Floor
box{<-2.3,0,.3>,<10.3,-.3,-7.3>
  pigment{rgb <1,.9,.8>}
  finish{
    specular .8 roughness .01
    reflection{0.05,.1 falloff 2 exponent .8}
  }
}

union{
  //Circular Window Rim
  difference{
    cylinder{<0,1.6,0.1><0,1.6,0.2>,.66}
    cylinder{<0,1.6,0><0,1.6,.4>,.6}
  }
  //Rectangular Window Rim
  difference{
    box{<-2.1,.1,-.15><-2.2,2.3,-2.55>}
    box{<-2,.2,-.3><-2.25,2.1,-2.4>}
  }
  box{<-2.1,1.15,-.15>,<-2.2,1.25,-2.55>}
  box{<-2.1,1.2,-1.45>,<-2.2,2.3,-1.55>}
  pigment{rgb .4}
  finish{
    specular .6 roughness .1
    reflection{0,.6 falloff 2}
  }
}

#if (!Save)
//Windows
union{
  cylinder{<0,1.6,0.12><0,1.6,0.15>,.67}
  //Lower Window
  box{<-2.12,.1,-.1>,<-2.15,1.2,-2.6>}
  //Rght
  box{<-2.12,1.2,-.1>,<-2.15,2.2,-1.5>}
  //Left
  //box{<-2.07,1.2,-1.5>,<-2.1,2.1,-2.6>}
  material{Glass_Material}
}
#end

//Open Window
union{
  difference{
    box{<-2.05,1.2,-1.5><-2.11,2.15,-2.45>}
    box{<-2,1.3,-1.6><-2.15,2.05,-2.35>}
    pigment{rgb .4}
    #if (!Save)
      normal{granite 0.1 scale 0.05}
    #end
    finish{
      specular .6 roughness .1
      reflection{0,.6 falloff 2}
    }
  }
  //Handle
  union{
    cylinder{<-2.05,1.7,-1.55><-2.03,1.7,-1.55>,.03}
    cylinder{<-2.05,1.7,-1.55><-1.99,1.7,-1.55>,.01}
    union{
      sphere{0,.01}
      cylinder{0,y*-.12,.01}
      sphere{y*-.12,.01}
      rotate x*180
      translate <-1.99,1.7,-1.55>
    }
    texture{Chrome}
  }    
  //Glass
  #if (!Save)
  box{<-2.07,1.2,-1.55>,<-2.1,2.1,-2.4>
    material{Glass_Material}
  }
  #end
  translate <2.05,-1.2,0>
  rotate z*-17
  translate <-2.05,1.2,0>
}

//=====================================================================
