// Persistence of Vision Ray Tracer Scene Description File
// File: prep4company.pov - Prepared for Company
// Vers: 3.6.1
// Desc: A recreation of a small spot in the movie theatre where I work 
// Date: 18.08.05 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 25.10.06 (dd.mm.yy)

//Required Files

//Comments
//  When rendering the image, it needs two pre-passes: one to save the radiosity, and another
//  one to save the photons. They can be taken independantly, but don't have to be, the steps
//  how to render the passes are as follows:

// 1. Set Radiosity to 1, Photons to 0 and Save to 1: this renders the first radiosity pass
//    and saves it to disk.
// 2. Set Radiosity to 0, Photons to 1 and Save to 1: this shoots the photons and saves them
//    to disk.
// 3. Set Radiosity to 1, Photons to 1 and Save to 0: the prepasses are loaded for the final
//    render, on which the background-photo is used as well.

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#include "glare.inc"
#include "bsplines.inc"

#declare Radiosity = 1;
#declare Photons = 0;

#declare Save = 0;

#declare Arealights = 0;

#declare Table = 1;
#declare Sofa = 1;
#declare Chair = 1;
#declare Lamp = 1;
#declare Winestuff = 1;

//Adjust these for contrast
#default{finish{ambient 0 diffuse 0.4}}
#declare Light_Intensity = 5;
#declare Radiosity_Brightness = 3.5;
#declare Skysphere_Brightness = 0.75;

global_settings{
  assumed_gamma 1
  max_trace_level 35
  #if (Radiosity)
  radiosity{
    #if (Save)
      pretrace_start 0.2
      pretrace_end 0.0125
      save_file "prep4company.rad"  
      error_bound 0.1
      always_sample on
      nearest_count 4
      minimum_reuse 0.01
    #else
      pretrace_start 1
      pretrace_end 1
      load_file "prep4company.rad"  
      error_bound 0.8
      always_sample off
      nearest_count 8
      minimum_reuse 0.01
    #end
    recursion_limit 2
    count 1100
    //brightness 2.0
    brightness Radiosity_Brightness
  }
  #end
  #if (Photons)
  photons{
    spacing .00075
    autostop 0
    #if (Save)
      save_file "prep4company.pho"
    #else
      load_file "prep4company.pho"
    #end
  }
  #end
}

sky_sphere{
  pigment{
    gradient y
    color_map{
      #if (Save)
        //Colors used to gather Radiosity
        [0 rgb <.5,.7,.9>*Skysphere_Brightness][1 rgb <.65,.85,1>*Skysphere_Brightness]
      #else
        //Colors for reflections        
        [0 rgb <.8,.8,1>][1 rgb <1,1,1>]
      #end
    }
    scale 2 translate -1
  }
}

#declare Camera_Location = <1.32,1.1,-3.8>;
#declare Camera_Look_At = <-1.51,.85,0>;

camera{
  location Camera_Location
  look_at Camera_Look_At
}           

#if (!Save)
  #declare Backdrop = texture{pigment{image_map{jpeg "daylight_low.jpg"}scale <-1,1,1>}finish{ambient .9 diffuse 0} translate <-.1,.035,0>}
  Glare_PlaceImage(Backdrop,20)
#end

light_source{
  <-650,410,-145>
  rgb Light_Intensity
  parallel point_at <0,0,0>
  #if (Arealights)
    #if (!Save) area_light x*10,y*10,25,25 orient circular adaptive 2 #end
  #end
}

#if (!Radiosity)
light_source{
  <3,1,-4>
  rgb .5
  shadowless
}
#end

//Materials
#declare Glass_Material =
  material{
    texture{
      pigment{rgbt <1,1,1,1>}
      finish{
        reflection{0,1 fresnel exponent .98}
        specular 1 roughness .001
      }
    }
    interior{ior 1.55}
  }

//Textures
#declare Leather =
texture{
  pigment{rgb <0.4,0.05,0.05>}
  normal{crackle .0005 no_bump_scale scale .05 turbulence .6}
  finish{
    specular .01 roughness .1 metallic .5
    brilliance 1.7
  }
	}

#declare Chrome =
texture{
	pigment{rgb 0}
	finish{
	  reflection{.4,.9 falloff 2}
	  ambient 0 diffuse 0
	  specular 3 roughness .005
	  brilliance 4
	  }
	}

#declare Dark_Chrome =
texture{
	pigment{rgb 0}
	finish{
	  reflection{.2,.8}
	  ambient 0 diffuse 0
	  specular 2 roughness .01
	  brilliance 3.5
	  }
	}

#declare White_Plastic =
texture{
	pigment{rgb 1}
	finish{
	  specular 2 roughness .01
	  brilliance 1.1
	  }
	}
#declare Black_Plastic =
texture{
	pigment{rgb .01}
	finish{
	  specular 2 roughness .01
	  brilliance 1.1
	  }
	}

#declare Material0 = texture{pigment{rgb x}}

#declare Wall_Material =
texture{
  pigment{rgb .8}
  normal{agate .002 no_bump_scale scale <1,3,1>*.2}
  finish{
    specular .1 roughness .3
  }
}

//Walls and Ceiling
union{
  //Front wall with circular hole
  difference{
    box{<-2.3,-.1,0>,<10,2.6,.3>}
    cylinder{<0,1.6,-.1><0,1.6,.4>,.65}
  }
  //Side wall with rectangular hole
  difference{
    box{<-2,-.1,.5><-2.3,2.6,-7>}
    box{<-1.99,.11,-.2><-2.31,2.21,-2.5>}
  }
  //Right Wall
  box{<4,-.1,.3><4.3,2.6,-7>}
  //Rear wall
  box{<-2,-.1,-5>,<10,2.6,-5.3>}
  //Ceiling
  box{<-2.2,2.5,.3>,<10,2.8,-7.3>}
  texture{Wall_Material}
}

//Floor
box{<-2.3,0,.3>,<10.3,-.3,-7.3>
  pigment{
    image_map{jpeg "parkett_low.jpg"}
    scale <4,1,1>
    rotate <90,90,0>
    translate <-2,0,.3>
  }
  normal{
    bump_map{jpeg "parkett_low.jpg" bump_size 0.01}
    scale <4,1,1>
    rotate <90,90,0>
    translate <-2,0,.3>
  }
  finish{
    specular .8 roughness .01
    reflection{0.05,.1 falloff 2 exponent .8}
  }
}

union{
  //Circular Window Rim
  difference{
    cylinder{<0,1.6,0.1><0,1.6,0.2>,.66}
    cylinder{<0,1.6,0><0,1.6,.4>,.6}
  }
  //Rectangular Window Rim
  difference{
    box{<-2.1,.1,-.15><-2.2,2.3,-2.55>}
    box{<-2,.2,-.3><-2.25,2.1,-2.4>}
  }
  box{<-2.1,1.15,-.15>,<-2.2,1.25,-2.55>}
  box{<-2.1,1.2,-1.45>,<-2.2,2.3,-1.55>}
  pigment{rgb .4}
  finish{
    specular .6 roughness .1
    reflection{0,.6 falloff 2}
  }
}

#if (!Save)
//Windows
union{
  cylinder{<0,1.6,0.12><0,1.6,0.15>,.67}
  //Lower Window
  box{<-2.12,.1,-.1>,<-2.15,1.2,-2.6>}
  //Rght
  box{<-2.12,1.2,-.1>,<-2.15,2.2,-1.5>}
  //Left
  //box{<-2.07,1.2,-1.5>,<-2.1,2.1,-2.6>}
  material{Glass_Material}
}
#end

//Open Window
union{
  difference{
    box{<-2.05,1.2,-1.52><-2.11,2.15,-2.43>}
    box{<-2,1.25,-1.57><-2.15,2.1,-2.38>}
    pigment{rgb .4}
    finish{
      specular .6 roughness .1
      reflection{0,.6 falloff 2}
    }
  }
  //Handle
  union{
    cylinder{<-2.05,1.7,-1.545><-2.03,1.7,-1.545>,.025}
    cylinder{<-2.05,1.7,-1.545><-1.99,1.7,-1.545>,.01}
    union{
      sphere{0,.01}
      cylinder{0,y*-.12,.01}
      sphere{y*-.12,.01}
      rotate x*180
      translate <-1.99,1.7,-1.545>
    }
    texture{Chrome}
  }    
  //Glass
  #if (!Save)
  box{<-2.07,1.2,-1.521>,<-2.09,2.1,-2.429>
    material{Glass_Material}
  }
  #end
  translate <2.05,-1.2,0>
  rotate z*-17
  translate <-2.05,1.2,0>
}


//Sofa
//====
#if (Sofa)

#include "sofa_leather_low.inc"
#include "sofa_metal_low.inc"

#declare Sofa =
  union{
    object{Sofa_Leather_Mesh2 double_illuminate}
    object{Sofa_Metal_Mesh2 photons{target reflection on refraction off collect off}}
    object{Sofa_Metal_Mesh2 scale <-1,1,1> photons{target reflection on refraction off collect off}}
    scale 1/2.5*.75
  }

object{Sofa translate <0,0,-.65>}

#end

//Chair
//=====
#if (Chair)

#include "chair_leather_low.inc"
#include "chair_metal_low.inc"

#declare Chair =
  union{
    object{Chair_Leather_Mesh2 double_illuminate}
    object{Chair_Metal_Mesh2 photons{target reflection on refraction off collect off}}
    object{Chair_Metal_Mesh2 scale <-1,1,1> photons{target reflection on refraction off collect off}}
    scale 1/2.5*.75
  }
  
light_group{

object{Chair rotate y*-134 translate <-.8,0,-2.25>}
light_source{
  <.2,1.8,-4>
  rgb 1.2
  fade_power 2 fade_distance 1.5
  area_light x*2,y*2,10,10 orient circular
}

}
#end

//Table
//=====
#declare Table_Size = <.5,.01,.25>;
#declare Table_Height = .45;
#if (Table)

#declare Leg =
  union{
    cylinder{y*.01,y*(Table_Height-.02),.01}
    sphere{y*(Table_Height-.02),.01}
    sphere{y*.01,.01}
  }

union{
  //Glassplate
  object{
    box{Table_Size*<-1,-1,-1>,Table_Size}
    translate y*Table_Height
    material{Glass_Material}
  }
  //Legs
  union{
    object{Leg translate (Table_Size-.05)*<-1,0,-1>}
    object{Leg translate (Table_Size-.05)*< 1,0,-1>}
    object{Leg translate (Table_Size-.05)*<-1,0, 1>}
    object{Leg translate (Table_Size-.05)*< 1,0, 1>}
    //Straight bars
    cylinder{(Table_Size-.05)*<-1,0,-1>,(Table_Size-.05)*< 1,0,-1>,.009 translate y*Table_Height*.6}
    cylinder{(Table_Size-.05)*< 1,0,-1>,(Table_Size-.05)*< 1,0, 1>,.009 translate y*Table_Height*.6}
    cylinder{(Table_Size-.05)*< 1,0, 1>,(Table_Size-.05)*<-1,0, 1>,.009 translate y*Table_Height*.6}
    cylinder{(Table_Size-.05)*<-1,0, 1>,(Table_Size-.05)*<-1,0,-1>,.009 translate y*Table_Height*.6}
    //Around the glassplate
    union{
      sphere{Table_Size*<-1,0,-1>,Table_Size.y*1.05}
      cylinder{Table_Size*<-1,0,-1>,Table_Size*< 1,0,-1>,Table_Size.y*1.05}
      sphere{Table_Size*< 1,0,-1>,Table_Size.y*1.05}
      cylinder{Table_Size*< 1,0,-1>,Table_Size*< 1,0, 1>,Table_Size.y*1.05}
      sphere{Table_Size*< 1,0, 1>,Table_Size.y*1.05}
      cylinder{Table_Size*< 1,0, 1>,Table_Size*<-1,0, 1>,Table_Size.y*1.05}
      sphere{Table_Size*<-1,0, 1>,Table_Size.y*1.05}
      cylinder{Table_Size*<-1,0, 1>,Table_Size*<-1,0,-1>,Table_Size.y*1.05}
      translate y*Table_Height
    }
    texture{Chrome}
  }
  translate <0,0,-1.5>
  photons{target reflection on refraction on collect off}
}
#end

//Lamp
//====
#if (Lamp)

#declare Lamp_Light1 = array[4]
{<-0.05,1.59,0>,<0,.3,0>,
 <-.2,1.45,0>,<.2,-.2,0>,
}
#declare Lamp_Light2 = array[4]
{<-0.05,1.59,0>,<0,.4,0>,
 <-.2,1.5,0>,<.2,-.2,0>,
}

#declare Light_Tube1 =
  union{
    union{
      Show_BSpline(Lamp_Light1,.015,70)
      texture{Dark_Chrome}
    }
    difference{
      sphere{Lamp_Light1[2],.05}
      sphere{Lamp_Light1[2],.04}
      interior{ior 1.64}
      pigment{rgbf <1,1,1,.2>}
      finish{
        brilliance .5
      }
      double_illuminate
    }
  }

#declare Light_Tube2 =
  union{
    union{
      Show_BSpline(Lamp_Light2,.015,70)
      texture{Dark_Chrome}
    }
    difference{
      sphere{Lamp_Light2[2],.05}
      sphere{Lamp_Light2[2],.04}
      interior{ior 1.64}
      pigment{rgbf <1,1,1,.2>}
      finish{
        brilliance .5
      }
    }
  }

union{
  cylinder{0,y*.03,.2}
  cylinder{0,y*1.5,.02}
  cylinder{y*1.5,y*1.6,.045}
  #declare Lamp_Bar =
  union{
    cylinder{<-.07,1.5,0>,<-.07,1.6,0>,.02}
    cylinder{< .07,1.5,0>,< .07,1.6,0>,.02}
    cylinder{<-.07,1.5,0>,< .07,1.5,0>,.02}
    cylinder{<-.07,1.6,0>,< .07,1.6,0>,.02}
    sphere{< .07,1.5,0>,.02}
    sphere{<-.07,1.5,0>,.02}
    sphere{< .07,1.6,0>,.02}
    sphere{<-.07,1.6,0>,.02}
    box{<-.07,1.5,-.02><.07,1.6,.02>}
  }
  object{Lamp_Bar}
  object{Lamp_Bar rotate y*90}

  object{Light_Tube1}
  object{Light_Tube2 rotate y*90}
  object{Light_Tube1 rotate y*180}
  object{Light_Tube2 rotate y*270}
  texture{Dark_Chrome}
  rotate y*21
  translate <-1.55,0,-.32>
}

//Electricity outlet
superellipsoid{<.15,.15> scale <.03,.05,.05> translate <-2,.2,-.1>
  texture{White_Plastic}
}

#declare Lamp_SwitchPos = <-1.6,0,-.7>;
#declare Lamp_SwitchRot = y*104;

#declare Lamp_Cable = array[8]
{ <-2,.2,-.1>,<.2,0,0>,
  <-1.9,.005,-.4>,<0,0,-.3>,
  Lamp_SwitchPos+y*.005,vrotate(<0,0,.3>,Lamp_SwitchRot),
  <-1.35,.02,-.32>,<-.4,0,0>
}

//Cable and Switch
union{
  //
  cylinder{0,x*.05,.03 translate <-2,.2,-.1>}
  sphere{0,.03 scale <.2,1,1> translate <-1.95,.2,-.1>}
  //Switch
  union{
    superellipsoid{<.15,.15> scale <.05,.02,.07>}
    cylinder{0,y*.04,.02}
    sphere{0,.02 scale <1,.1,1> translate y*.04}
    rotate Lamp_SwitchRot
    translate y*.015+Lamp_SwitchPos
  }
  union{
    Show_BSpline(Lamp_Cable,.005,80)
  }
  texture{Black_Plastic}
}

#end



//Winestuff
//=========
#if (Winestuff)

#declare Winebottle=
union{

//Bottle
lathe{
  bezier_spline
  28,
  //Bottom
  <0, .2>, <.5, .2>,<.7,0>,<.8,0>,
  <.8,0>,<.9,0>,<1, .1>, <1, .2>,
  //Large side
  <1, .2>, <1, 2>, <1, 2>, <1, 3>,
  //Closing in for neck
  <1,3>,<1,4>,<.3,4>,<.3,4.5>,
  //Neck
  <.3,4.5>,<.3,5.5>,<.3,5>,<.3,5.5>,
  //Neck-Round turns inward
  <.3,5.5>,<.35,5.6>,<.25,5.6>,<.25,5.5>,
  //Inside neck
  <.25,5.5>,<.25,5.4>,<.25,4.9>,<.25,4.9>
  pigment{rgbt <.1,.4,.1,.93>}
  interior{
    ior 1.56
    fade_power 2 fade_distance .012 fade_color <.01,.2,.01>
  }
  finish{
    ambient 0 
    specular 1 roughness .001 metallic .8
    reflection{0,.8 fresnel metallic .2 exponent .89}
    conserve_energy
  }
  
  photons{
    target reflection on refraction on collect off
  }
}

//Wine
lathe{
  bezier_spline
  20,
  //Toplayer
  <0,4.9>,<0,4.9>,<.255,4.9>,<.255,4.9>,
  //Inside neck
  <.25,4.9>,<.25,4.9>,<.25,4.4>,<.25,4.3>,
  //Largening out of neck
  <.25,4.3>,<.25,3.9>,<.9,4>,<.9,3>,
  //Larger area inside
  <.9,3>,<.9,2>,<.9,.2>,<.9,.2>
  //Bottom
  <.9,.2>,<.5,.1>,<.7,.3>,<0,.3>
  pigment{rgbt <.6,0,0,.92>}
  interior{
    ior 1.45
    fade_power 2 fade_distance .03 fade_color <.3,.01,.01>
  }
  finish{
    ambient 0 
    specular 1 roughness .0001 metallic .6
    reflection{0,.7 fresnel exponent .89}
  }
  photons{
    target reflection off refraction on collect off
  }
}

//Ettiquete
intersection{
  difference{
    cylinder{y*1.8,y*3,1.01}
    cylinder{y*1.7,y*3.1,1.005}
  }
  box{0,<2,3.1,-2>}
  rotate y*45
  pigment{image_map{jpeg "winebrand.jpg"}
    translate x*.5
    scale <1.5,1.25,1>
    translate <0,1.78,0>
    }
  finish{
    ambient 0
    specular .05 roughness .3
  }
}

}

#declare Wineglass_Texture =
  texture{
    pigment{rgbt <1,1,1,.99>}
    finish{
      ambient 0 
      specular 1 roughness .0001 metallic .6
      reflection{0,.7 fresnel exponent .89}
      conserve_energy
    }
  }
    
#include "wineglass_low.inc"

union{
  //Cloth
  #declare A=0;
  blob{ threshold .85
  #while (A<70)
    #declare Ad=A/79;
    cylinder{<0,0,-.15><0,0,.15>,.004,1
      scale <1.5,1,1>
      translate x*(-.2+.4*Ad)+y*(.014+Table_Height)
      rotate y*2
    }
    #declare A=A+1;
  #end
  pigment{rgb <.8,.8,.7>}
  }

union{
  object{Wineglass_Mesh2
    interior{ior 1.55}
    photons{
      target reflection off refraction on collect off
    }
    scale .9
    translate <1.2,0,-1.4>
  }
  object{Wineglass_Mesh2
    interior{ior 1.55}
    photons{
      target reflection off refraction on collect off
    }
    scale .9
    translate <2.1,0,.25>
  }
  object{Winebottle scale <.8,1,.8> rotate y*12 translate <-1.2,0,.7>}
    scale .05
    translate y*(.018+Table_Height)
  }
  translate <0,0,-1.5>
  photons{target reflection on refraction on collect off}
}

#end

