//texture painter
//rather than getting pixelly textures from photoshop, or uncontrolled pov-internals, lets do a nice tidy line-drawing in SDL
//use sphere sweeps in shades of grey, then map those using a palette

#macro lines() object{union{ #end //unmatched brackets messy
#macro lline(a)
	sphere_sweep {
		linear_spline
		dimension_size(a,1)
		#local ii=0;
		#while (ii < dimension_size(a,1))
			,<a[ii].x,a[ii].y,a[ii].z>, a[ii].t
			#local ii=ii+1;
		#end
	}
#end
#macro cline(a)
	sphere_sweep {
		cubic_spline
		dimension_size(a,1)+2,
		<a[0].x,a[0].y,a[0].z>, a[0].t, //double up, so don't need to think about it when drawing.
		#local ii=0;
		#while (ii < dimension_size(a,1))
			<a[ii].x,a[ii].y,a[ii].z>, a[ii].t,
			#local ii=ii+1;
		#end
		<a[ii-1].x,a[ii-1].y,a[ii-1].z>, a[ii-1].t //double up, so don't need to think about it when drawing.
	}
#end

