//greebles
//I'd love to use isosurfaces but this needs to trace fast for potential use in animation so...
//take a polygon, subdivide and displace.

#macro quad(a,b,c,d,e,f,g,h)
	triangle { a,b,c uv_vectors e,f,g }
	triangle { a,c,d uv_vectors e,g,h }
#end

//greeble macro
/*
set these variables before calling:
	#declare rs=seed(17);
	#declare greebleResX = 54;
	#declare greebleResY = 18;
	#declare greebleSize = 12; //units of res
	#declare numGreebles = 20;
	#declare greebleHeight = .5;

optional variables:
	#declare greebleDebug=off;
*/
//input:
//points - an array of points, should be coplanar, defining a face in clockwise order (as viewed from outside the object)
#macro greebles(points)

	mesh {
	
		//preserve the edge, since we don't know the normal of adjacent greebled polys.
		
		#ifdef(greebleDebug)
		
			//debug: draw just the poly
			quad(
				#local i=0;
				#while ( i < 4 )
					points[i],
					#local i = i+1;
				#end
				0,u,u+v,v
			)
			
		#else
	
			/*	
			subdiv & loft. perhaps using axis-aligned squares regardless of shape, or align to nearest feature.
			greebles that overlap should trash each other (always go to greater displacement)
			avoid specific features for now.
			
			so: div up into grid, then raise randomly placed rectangles to random heights, using a param to control how many to do.
			inter connecting polys: simply double up points on edge of grid, i.e. fill grid(array) with values, then read back dropping polys for faces,
			and more polys for any changes in val.
			*/
			
			#local greebleMap = array[greebleResX][greebleResY];
			//set to 0
			#local iy = 0;
			#while ( iy < greebleResY )
				#local ix = 0;
				#while ( ix < greebleResX )
					#local greebleMap[ix][iy] = 0;
					#local ix=ix+1;
				#end
				#local iy=iy+1;
			#end
		
			//---place greebles!---	
			#local i=0;
			#while ( i < numGreebles )
				#local D = rand(rs)*2-1;
				#local up_down = (rand(rs)>0.5);
				#local W = int(1+rand(rs)*(greebleSize-0.0001));
				#local X = int(rand(rs)*(greebleResX - W + 0.999));
				#local H = int(1+rand(rs)*(greebleSize-0.0001));
				#local Y = int(rand(rs)*(greebleResY - H + 0.999));
				#local iy = Y;
				#while ( iy < Y+H )
					#local ix = X;
					#while ( ix < X+W )
						#if (up_down)
							#local greebleMap[ix][iy] = max(greebleMap[ix][iy],D); //only overwrite if taller
						#else
							#local greebleMap[ix][iy] = min(greebleMap[ix][iy],D); //only overwrite if taller
						#end
						#local ix=ix+1;
					#end
					#local iy=iy+1;
				#end
				#local i=i+1;
			#end
			
			//simple version, draw grid of polys evenly spread over this poly (assume it's 4 sided)
			//all inter-connected by perpendicular polys
			#local J = greebleHeight*vnormalize(vcross(points[1]+points[2]-points[0]-points[3],points[3]+points[2]-points[0]-points[1])); //cross product of average horiz & vert vectors, i.e. normal at center
			
			#local iy = 0;
			#while ( iy <= greebleResY )
				#local ix = 0;
				#while ( ix <= greebleResX )
				
					#local i00=<ix,iy>/<greebleResX,greebleResY>;
					#local i01=<ix+1,iy>/<greebleResX,greebleResY>;
					#local i10=<ix,iy+1>/<greebleResX,greebleResY>;
					#local i11=<ix+1,iy+1>/<greebleResX,greebleResY>;
		
					//bilinear blend			
					#local P00 = i00.x*i00.y*points[0] + i00.x*(1-i00.y)*points[1] + (1-i00.x)*i00.y*points[3] + (1-i00.x)*(1-i00.y)*points[2];
					#local P01 = i01.x*i01.y*points[0] + i01.x*(1-i01.y)*points[1] + (1-i01.x)*i01.y*points[3] + (1-i01.x)*(1-i01.y)*points[2];
					#local P10 = i10.x*i10.y*points[0] + i10.x*(1-i10.y)*points[1] + (1-i10.x)*i10.y*points[3] + (1-i10.x)*(1-i10.y)*points[2];
					#local P11 = i11.x*i11.y*points[0] + i11.x*(1-i11.y)*points[1] + (1-i11.x)*i11.y*points[3] + (1-i11.x)*(1-i11.y)*points[2];
					
					//left edge
					#if ((ix>0 & iy<greebleResY)) #local A = J*greebleMap[ix-1][iy]; #else #local A=0; #end
					#if ((ix<greebleResX & iy<greebleResY)) #local B = J*greebleMap[ix][iy]; #else #local B=0; #end
					#if ( vlength(A-B) > 0.001 ) //avoid pov error on degenerates
						quad (
							P00 + A,
							P00 + B,
							P10 + B,
							P10 + A, //abba!
							i00, i00, i10, i10
						)
					#end
					
					//bottom edge
					#if ((ix<greebleResX & iy>0)) #local A = J*greebleMap[ix][iy-1]; #else #local A=0; #end
					#if ((ix<greebleResX & iy<greebleResY)) #local B = J*greebleMap[ix][iy]; #else #local B=0; #end
					#if ( vlength(A-B) > 0.001 )
						quad (
							P00 + A,
							P00 + B,
							P01 + B,
							P01 + A //abba!
							i00, i00, i01, i01
						)
					#end
					
					//middle
					#if ( ix < greebleResX & iy < greebleResY )
						quad (
							P00 + J*greebleMap[ix][iy],
							P01 + J*greebleMap[ix][iy],
							P11 + J*greebleMap[ix][iy],
							P10 + J*greebleMap[ix][iy],
							i00, i01, i11, i10
						)
					#end
					
					#local ix=ix+1;
				#end
				#local iy=iy+1;
			#end
		#end
	
	} //mesh
#end
