//example scene for greebles.inc
//do varying degrees of greebling on a shape.

#include "rad_def.inc"
#include "greebles.inc"

global_settings {
	assumed_gamma 1
	radiosity { Rad_Settings(Radiosity_Fast,on,on) }
}

#default { pigment { rgb 1 } finish { diffuse .9 ambient 0 } }

sky_sphere {
	pigment {
		pigment_pattern {
			gradient <2,5,-1> scale 2
			colour_map {
				[.5 rgb 0]
				[.5 rgb 1]
				[.8 rgb 1]
				[.9 rgb 0]
			}
		}
		cubic_wave
		pigment_map {
			[0 rgb 0]
			[.9 rgb <.1,.4,.9>]
			[1
				granite
				scale <4,1,1>
				rotate y*30
				poly_wave 1/4
				colour_map {
					[0 rgb <.3,.1,.9>]
					[1 rgb <.1,.4,.9>]
				}
			]
		}
	}
}

camera {
	right		x*image_width/sqrt(image_height*image_width)
	up			y*image_height/sqrt(image_height*image_width)
	direction	z*2
	
	//location <2,-1,-3>*3 look_at z
	//location x*10 look_at 0
	//location -z*10 look_at 0
	//location z*10 look_at 0
	location <3,1,2>*3 look_at 0
}

light_source { <3,2,-1>*1000, rgb 1 }


//simple angel-fish shape
union {
	#declare rs=seed(17);
	#declare greebleResX = 10;
	#declare greebleResY = 10;
	#declare greebleSize = 8;
	#declare numGreebles = 100;
	
	//#declare greebleDebug=on;

	#macro mirrorGreeb( p0, p1, p2, p3 )
		greebles(array[4] { p0, p1, p2, p3 })
		greebles(array[4] { p0*<1,-1,1>, p1*<1,-1,1>, p2*<1,-1,1>, p3*<1,-1,1> })
		greebles(array[4] { p0*<-1,1,1>, p1*<-1,1,1>, p2*<-1,1,1>, p3*<-1,1,1> })
		greebles(array[4] { p0*<-1,-1,1>, p1*<-1,-1,1>, p2*<-1,-1,1>, p3*<-1,-1,1> })
	#end

	union {
		#declare greebleHeight = .01;
		mirrorGreeb(<0,0,-2>, <0,1.1,-1.3>, <.3,.9,-.5>, <.3,0,-1>)
		mirrorGreeb(<0,1.1,-1.3>, <0,2,0>, <.2,1.75,.25>, <.3,.9,-.5>)
		mirrorGreeb(<.3,0,-1>, <.3,.9,-.5>, <.5,.6,.1>, <.5,.2,0>)
		mirrorGreeb(<.3,.9,-.5>, <.2,1.75,.25>, <.3,1.5,.5>, <.5,.6,.1>)
		
		//edges
		#declare greebleResX = 2;
		#declare greebleResY = 10;
		#declare greebleSize = 1;
		#declare numGreebles = 10;
		#declare greebleHeight = .1;
		mirrorGreeb(<.3,0,-1>, <.5,.2,0>, <.3,.2,0>, <.2,0,-1>)
		mirrorGreeb(<.5,.2,0>, <.5,.6,.1>, <.3,.6,.1>, <.3,.2,0>)
		mirrorGreeb(<.5,.6,.1>, <.3,1.5,.5>, <0,1.5,.5>, <.3,.6,.1>)
		
		//top
		#declare greebleHeight = .01;
		#declare greebleResX = 2;
		#declare greebleResY = 4;
		mirrorGreeb(<.3,1.5,.5>, <.2,1.75,.25>, <0,2,0>, <0,1.5,.5>)
	}


	//guts
	union {	
		#declare greebleResX = 48;
		#declare greebleResY = 16;
		#declare greebleSize = 4;
		#declare numGreebles = 500;
		#declare greebleHeight = .15;
		greebles(array[4] { <.2,-.3,-.7>, <.2,.3,-.8>, <.2,.3,1>, <.2,-.3,1> })
		greebles(array[4] { <-.2,-.3,-.7>, <-.2,.3,-.8>, <-.2,.3,1>, <-.2,-.3,1> })
		#declare greebleHeight = .5;
		#declare numGreebles = 100;
		greebles(array[4] { <.2,.3,-.7>, <-.2,.3,-.8>, <-.2,.3,1>, <.2,.3,1> })
		greebles(array[4] { <.2,-.3,-.7>, <-.2,-.3,-.8>, <-.2,-.3,1>, <.2,-.3,1> })
		greebles(array[4] { <-.2,-.3,1>, <-.2,.3,1>, <.2,.3,1>, <.2,-.3,1> })
	}
}


