//texture painter
//rather than getting pixelly textures from photoshop, or uncontrolled pov-internals, lets do a nice tidy line-drawing in SDL
//use sphere sweeps in shades of grey, then map those using a palette

#declare dominus_bird =
	pigment {
		average
		pigment_map {
			#declare cc = 1;
			[cc #declare cc = 2*cc;
				lines()
					//wing
					cline(array[4]{ <.3,0,0,0>, <1,-.2,0,.15>, <4,.2,0,.08>, <6,0,0,0> })
					cline(array[4]{ <.33,-.4,0,0>, <1,-.7,0,.15>, <3,-.3,0,.1>, <5,-.5,0,0> })
					cline(array[4]{ <.23,-.8,0,0>, <.9,-1.05,0,.1>, <2.5,-.8,0,.08>, <4,-1.1,0,0> })
					cline(array[4]{ <.15,-1.1,0,0>, <.8,-1.3,0,.07>, <2,-1.2,0,.04>, <3,-1.5,0,0> })
					cline(array[4]{ <-.3,0,0,0>, <-1,-.2,0,.15>, <-4,.2,0,.08>, <-6,0,0,0> })
					cline(array[4]{ <-.33,-.4,0,0>, <-1,-.7,0,.15>, <-3,-.3,0,.1>, <-5,-.5,0,0> })
					cline(array[4]{ <-.23,-.8,0,0>, <-.9,-1.05,0,.1>, <-2.5,-.8,0,.08>, <-4,-1.1,0,0> })
					cline(array[4]{ <-.15,-1.1,0,0>, <-.8,-1.3,0,.07>, <-2,-1.2,0,.04>, <-3,-1.5,0,0> })
					//eye
					cline(array[5]{ <.3,.4,0,0>, <.2,.4,0,.01>, <.2,.5,0,.02>, <.3,.5,0,.01>, <.3,.4,0,0> })
					//beak
					cline(array[5]{ <.1,.4,0,0>, <.3,.3,0,.07>, <.7,.4,0,.07>, <.8,.2,0,.01>, <.7,.1,0,0> })
					//head
					cline(array[4]{ <-.8,.1,0,0>, <-.3,.2,0,.02>, <0,.8,0,.05>, <.5,.5,0,.0>, })
					//claws
					cline(array[3]{ <.7,-2,0,0>, <.9,-1.7,0,.04>, <.5,-1.8,0,.0> })
					cline(array[3]{ <.5,-2.2,0,0>, <.6,-1.9,0,.04>, <.4,-1.8,0,.0> })
					cline(array[3]{ <.3,-2.2,0,0>, <.2,-1.9,0,.04>, <.4,-1.8,0,.0> })
					cline(array[3]{ <-.7,-2,0,0>, <-.9,-1.7,0,.04>, <-.5,-1.8,0,.0> })
					cline(array[3]{ <-.5,-2.2,0,0>, <-.6,-1.9,0,.04>, <-.4,-1.8,0,.0> })
					cline(array[3]{ <-.3,-2.2,0,0>, <-.2,-1.9,0,.04>, <-.4,-1.8,0,.0> })
				} rgb 0, rgb 1 }
			]
			[cc #declare cc = 2*cc;
				object {
					text {
						ttf "DSNOBL__.TTF"
						"DOMINVS"
						1, 0
						translate -z/2-1.65*x
						scale 1.3
						translate <0,-2.7,0>
					}
				rgb 0, rgb 1 }
			]
			[cc #declare cc = 2*cc;
				lines()
					//border
					#local r=.1;
					lline(array[15]{ <-1,2,0,r>, <1,2,0,r>, <2,1,0,r>, <7,1,0,r>, <7,-.5,0,r>, <4,-2,0,r>, <3,-2,0,r>, <3,-3.5,0,r>,
					<-3,-3.5,0,r>, <-3,-2,0,r>, <-4,-2,0,r>, <-7,-.5,0,r>, <-7,1,0,r>, <-2,1,0,r>, <-1,2,0,r> })
					#local r=.03;
					lline(array[15]{ <-1.2,2.2,0,r>, <1.2,2.2,0,r>, <2.2,1.2,0,r>, <7.2,1.2,0,r>, <7.2,-.6,0,r>, <4.2,-2.1,0,r>, <3.2,-2.1,0,r>, <3.2,-3.3,0,r>,
					<-3.2,-3.3,0,r>, <-3.2,-2.1,0,r>, <-4.2,-2.1,0,r>, <-7.2,-.6,0,r>, <-7.2,1.2,0,r>, <-2.2,1.2,0,r>, <-1.2,2.2,0,r> })
				} rgb 0, rgb 1 }
			]
		}
	}
	
	/*usage:
		#declare col0 = <.3,0,.1>;
		#declare col1 = <1,.9,.3>;
		#declare col2 = .7;
		#declare col3 = .3;
		colour_map {
			#declare cc=cc-1;
			[0/cc rgb col0]
			[1/cc rgb col1]
			[2/cc rgb col2]
			[3/cc rgb col1] //col1,col2 overlap, can do any effect I like. in this case just overwrite
			[4/cc rgb col3]
			[5/cc rgb col3] //col3 overlapping col 1
			[6/cc rgb col3] //overlapping col 2
			[7/cc rgb col3] //all overlapping
		}
	}*/

