#include "greebles.inc"
#declare Seed=seed(841);
camera {
	location <-5,2.5,-5>*1.25
	look_at 0
}
light_source {<-500,500,-750>*2 rgb<.2,.3,.4>*2}
light_source {<150,600,500> rgb <1.5,1.4,1.3>/1.5}
light_source {<-1500,150,500> rgb <.5,.6,.7>}

#declare R=.015;
#declare DefHeight=.03*.1;
#declare Height=R*2*.4;
#declare Detail=8;
#declare AdjustDetail=1;
#declare GreebleConstrain=1;
#declare GreebleHeight=.5;
#declare Diepte=8;

union {
	#declare Points=array[5]{<-2,-2>,<-.5,2>,<0,2>,<0,1>,<-1,-2>}
	#declare Edges=array[5]{1,1,0,1,0}
	#declare BevelEdges=array[5]{1,1,0,1,0}
	#declare A1=union {GreebledRoundPrism(Points,Diepte,R,.125,.125,.25,0) translate z*2}
	object {A1}
	object {A1 scale <-1,1,1>}
	object {A1 scale <1,-1,1>}
	object {A1 scale <-1,-1,1>}

	object {A1 scale <1,1,-1>}
	object {A1 scale <-1,1,-1>}
	object {A1 scale <1,-1,-1>}
	object {A1 scale <-1,-1,-1>}

	VerdeelCone(-2,2,1,1,0,360,Diepte,.0125,.0125)  
	#declare S=
 	union {
		VerdeelSuperellipsoid(
			1,1,1,
			.5,1,
			180,360,
			0,180,
			.0125,.0125,
			.1,.1,
			Diepte/2)
 	}
 	object {S translate -y*2}
	object {S translate -y*2 scale <1,-1,1>}
	pigment {rgb 1}
}
