// Greeble-macros and utilities
// for some weird reason, these don't function properly in POV-Ray 3.6.1, but they work fine in MegaPOV

#ifndef (TRANSFORMS_INC_TEMP) #include "transforms.inc" #end
#ifndef (Seed) #declare Seed=seed(123); #end

//Normal2D gives a vector that is at a 90 angle with the given vector V, in the XZ-plane
#macro Normal2D(V)
	#local R=vnormalize(<V.v,-V.u>);
	R
#end

//draws the beveled end of a beveled prism using the given points in array Points, bevel-width R and bevel-height H
#macro RoundPrism(Points,R,H)
	#local Aantal=dimension_size(Points,1);
	#local Tel=0;
	#local Aantal2=Aantal;
	#local Points2=array[Aantal];
	union {
	#while (Tel<Aantal)
		#local P=Points[Tel];
		#local PVorig=Points[mod(Aantal+Tel-1,Aantal)];
		#local PVolgend=Points[mod(Tel+1,Aantal)];
		#local PVolgend2=Points[mod(Tel+2,Aantal)];

		#local VN1=vnormalize(PVolgend2-PVolgend);
		#local VN2=vnormalize(PVolgend-P);
		
		//enkel als PVolgend2 niet in P->PVolgend 's verlengde ligt, is PVolgend van enig belang
		//anders: PVolgend gelijkstellen aan P en deze randen gewoon niet tekenen
					
		#if (((vlength(VN1-VN2)=0)|(vlength(VN1+VN2)=0))|(vlength(P-PVolgend)=0))
			#local Points[mod(Tel+1,Aantal)]=P;
			#local Aantal2=Aantal2-1;
		#else
			//PVorig kan nu gelijk zijn aan P... fixen:
			#if (vlength(P-PVorig)=0) #local PVorig=Points[mod(Aantal+Tel-2,Aantal)]; #end
			#local N0=vnormalize(Normal2D(P-PVorig))*R;
			#local PB0=PVorig+N0;
			#local PB0Volgend=P+N0;
	
			#local N1=vnormalize(Normal2D(PVolgend-P))*R;
			#local PB1=P+N1;
			#local PB1Volgend=PVolgend+N1;
	
			#local N2=vnormalize(Normal2D(PVolgend2-PVolgend))*R;
			#local PB2=PVolgend+N2;
			#local PB2Volgend=PVolgend2+N2;
			
			//snijpunt tussen PB0-PB0Volgend en PB1-PB1Volgend:
			#local U=((PB1Volgend.x-PB1.x)*(PB0.y-PB1.y)-(PB1Volgend.y-PB1.y)*(PB0.x-PB1.x))
				/
				((PB1Volgend.y-PB1.y)*(PB0Volgend.x-PB0.x)-(PB1Volgend.x-PB1.x)*(PB0Volgend.y-PB0.y));
			#local S1=PB0+(PB0Volgend-PB0)*U-z*H;
	
			//snijpunt tussen PB1-PB1Volgend en PB2-PB2Volgend:
			#local U=((PB2Volgend.x-PB2.x)*(PB1.y-PB2.y)-(PB2Volgend.y-PB2.y)*(PB1.x-PB2.x))
				/
				((PB2Volgend.y-PB2.y)*(PB1Volgend.x-PB1.x)-(PB2Volgend.x-PB2.x)*(PB1Volgend.y-PB1.y));
			#local S2=PB1+(PB1Volgend-PB1)*U-z*H;
			triangle {P,PVolgend,S1}// pigment {rgb Kleur}}
			triangle {PVolgend,S1,S2}// pigment {rgb Kleur}}
			#local Points2[Tel]=S1;
		#end
		#local Tel=Tel+1;
	#end
		#if (Aantal2>2)
		polygon {
			Aantal2,
			#local Tel=0;
			#while (Tel<Aantal)
				#ifdef(Points2[Tel])<Points2[Tel].x,Points2[Tel].y> #end
				#local Tel=Tel+1;
			#end
			translate -z*H
		}
		#end
		rotate x*90
	}
#end


//returns the points (as an array) of the beveled end of a beveled prism using points Points and bevel-width R
#macro GetBeveledPrism(Points,R)
	#local Aantal=dimension_size(Points,1);
	#local Aantal2=Aantal;
	#local Tel=0;
	#local Points2=array[Aantal];
	#while (Tel<Aantal)
		#local P=Points[Tel];
		#local PVorig=Points[mod(Aantal+Tel-1,Aantal)];
		#local PVolgend=Points[mod(Tel+1,Aantal)];
		#local PVolgend2=Points[mod(Tel+2,Aantal)];
		#local VN1=vnormalize(PVolgend2-PVolgend);
		#local VN2=vnormalize(PVolgend-P);
		
		//enkel als PVolgend2 niet in P->PVolgend 's verlengde ligt, is PVolgend van enig belang
		//anders: PVolgend gelijkstellen aan P en deze randen gewoon niet tekenen

		#if (((vlength(VN1-VN2)=0)|(vlength(VN1+VN2)=0))|(vlength(P-PVolgend)=0))
			#local Points[mod(Tel+1,Aantal)]=P;
			#local Aantal2=Aantal2-1;
		#else
			//PVorig kan nu gelijk zijn aan P... fixen:
			#if (vlength(P-PVorig)=0) #local PVorig=Points[mod(Aantal+Tel-2,Aantal)]; #end
			#local N0=vnormalize(Normal2D(P-PVorig))*R;
			#local PB0=PVorig+N0;
			#local PB0Volgend=P+N0;
	
			#local N1=vnormalize(Normal2D(PVolgend-P))*R;
			#local PB1=P+N1;
			#local PB1Volgend=PVolgend+N1;
	
			#local N2=vnormalize(Normal2D(PVolgend2-PVolgend))*R;
			#local PB2=PVolgend+N2;
			#local PB2Volgend=PVolgend2+N2;
			
			//snijpunt tussen PB0-PB0Volgend en PB1-PB1Volgend:
			#local U=((PB1Volgend.x-PB1.x)*(PB0.y-PB1.y)-(PB1Volgend.y-PB1.y)*(PB0.x-PB1.x))
				/
				((PB1Volgend.y-PB1.y)*(PB0Volgend.x-PB0.x)-(PB1Volgend.x-PB1.x)*(PB0Volgend.y-PB0.y));
			#local S1=PB0+(PB0Volgend-PB0)*U;
	
			//snijpunt tussen PB1-PB1Volgend en PB2-PB2Volgend:
			#local U=((PB2Volgend.x-PB2.x)*(PB1.y-PB2.y)-(PB2Volgend.y-PB2.y)*(PB1.x-PB2.x))
				/
				((PB2Volgend.y-PB2.y)*(PB1Volgend.x-PB1.x)-(PB2Volgend.x-PB2.x)*(PB1Volgend.y-PB1.y));
			#local S2=PB1+(PB1Volgend-PB1)*U;
			#local Points2[Tel]=vrotate(S1,x*90);
		#end
		#local Tel=Tel+1;
	#end
	#local Points3=array[Aantal2];
	#local Tel=0;
	#local Tel2=0;
	#while (Tel<Aantal)
		#ifdef(Points2[Tel]) #local Points3[Tel2]=Points2[Tel]; #local Tel2=Tel2+1; #end
		#local Tel=Tel+1;
	#end
	Points3
#end


//gives the points of the polygon that is formed by clipping the polygon formed by points Points with the plane in TestObject
//this macro is only guaranteed to work with convex polygons.  It works with some non-convex polygons, but only if the number of
//intersection-points between the polygon and the plane equals 2
#macro ClipPolygon(Points,TestObject)
	#local TestObjectOrigineel=object {TestObject}
	#local TestObject=object {TestObject rotate -x*90}
	
	#local NieuwAantal=0;

	#local Aantal=dimension_size(Points,1);
	#local Tel=0;
	//eerste loop: checken hoeveel punten er zijn
	#while (Tel<Aantal)
		#local Punt=Points[Tel];
		#if (Tel>0) #local VorigPunt=Points[Tel-1];
		#else #local VorigPunt=Points[Aantal-1]; #end
		//	If 'previous' and 'current' are both inside: Output 'current.'
		//	If 'previous' is inside, and 'current' is outside: Output the intersection point of the corresponding edge and the clipping boundary.
		#if ((inside(TestObject,Punt)&inside(TestObject,VorigPunt))
			 |(!inside(TestObject,Punt)&inside(TestObject,VorigPunt))) #local NieuwAantal=NieuwAantal+1;
		//	If 'previous' and 'current' are both outside: Do nothing.
		//	If 'previous' is outside, and 'current' is inside: Output the intersection point, and then output 'current.'
		#else #if (inside(TestObject,Punt)& !inside(TestObject,VorigPunt)) #local NieuwAantal=NieuwAantal+2; #end
		#end		
		#local Tel=Tel+1;
	#end
	#if (NieuwAantal>2)
	#local NieuwePunten=array[NieuwAantal];
	#local I=0;
	//tweede loop: punten in array steken
	#local Tel=0;
	#while (Tel<Aantal)
		#local Punt=Points[Tel];
		#if (Tel>0) #local VorigPunt=Points[Tel-1];
		#else #local VorigPunt=Points[Aantal-1]; #end
		//	If 'previous' and 'current' are both inside: Output 'current.'
		#if (inside(TestObject,Punt)&inside(TestObject,VorigPunt)) 
			#local NieuwePunten[I]=Punt*<1,1,1>; #local I=I+1;
		//	If 'previous' is inside, and 'current' is outside: Output the intersection point of the corresponding edge and the clipping boundary.
		#else #if (!inside(TestObject,Punt)&inside(TestObject,VorigPunt))
			#local IntersectionP=trace(TestObjectOrigineel,<Punt.u,0,Punt.v>,<VorigPunt.u-Punt.u,0,VorigPunt.v-Punt.v>); #local IntersectionPoint=<IntersectionP.x,IntersectionP.z>;
			#local NieuwePunten[I]=IntersectionPoint*<1,1,1>; #local I=I+1;
		//	If 'previous' and 'current' are both outside: Do nothing.
		//	If 'previous' is outside, and 'current' is inside: Output the intersection point, and then output 'current.'
			#else #if (inside(TestObject,Punt)& !inside(TestObject,VorigPunt)) 
				#local IntersectionP=trace(TestObjectOrigineel,<Punt.u,0,Punt.v>,<VorigPunt.u-Punt.u,0,VorigPunt.v-Punt.v>); #local IntersectionPoint=<IntersectionP.x,IntersectionP.z>;
				#local NieuwePunten[I]=IntersectionPoint*<1,1,1>; #local I=I+1;
				#local NieuwePunten[I]=Punt*<1,1,1>; #local I=I+1;
				#end
			#end
		#end
		#local Tel=Tel+1;
	#end
	//derde loop: kijken hoeveel unieke punten er zijn
	#local AantalUniekePunten=0;
	#local Tel=1;
	#local Seed=seed(2);
	#while (Tel<I)
		#if (vlength(NieuwePunten[Tel]-NieuwePunten[Tel-1])>0) 
			#local AantalUniekePunten=AantalUniekePunten+1;
		#end
		#local Tel=Tel+1;
	#end
	#if (vlength(NieuwePunten[0]-NieuwePunten[I-1])>0) #local AantalUniekePunten=AantalUniekePunten+1; #end
	//vierde loop: unieke punten opslaan
	#local UniekePunten=array[AantalUniekePunten];
	#local J=0;
	#if (vlength(NieuwePunten[0]-NieuwePunten[I-1])>0) #local UniekePunten[0]=NieuwePunten[0]; #local J=1; #end
	#local Tel=1;
	#local Seed=seed(2);
	#while (Tel<I)
		#if (vlength(NieuwePunten[Tel]-NieuwePunten[Tel-1])>0) 
			#local UniekePunten[J]=NieuwePunten[Tel];
			#local J=J+1;
		#end
		#local Tel=Tel+1;
	#end
	#else
		#local UniekePunten=array[1]{<0,0>}
	#end
	UniekePunten
#end

//macro used in subdividing a polygon for greeble-cells
//it decreases a given value X with a random number between 1 and 3.5
#macro Verlaag(X)
	#local R=X-(1+rand(Seed)*2.5);
	R
#end

//adds dummy greebles to a polygon formed by the prism Prism
//this actually adds NO greebles! it's just a macro to make it possible to test 
//a specific greeble-cell pattern with or without the greebles
#macro PrismGreeblesDummy(Prism,Detail,Height,Scale)
	#local Min=min_extent(Prism);
	#local Max=max_extent(Prism);

	//cilindertjes
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Size=(.05+rand(Seed)*.25)*Scale;
		#local Depth=(Height/2)+rand(Seed)*Height/2;
		#local Location=<1,0,1>*(Min+<rand(Seed),0,rand(Seed)>*(Max-Min));
		#if (inside(Prism,Location))
		#local Dummy=rand(Seed);
		#end
		#local Aantal=Aantal-1;
	#end
	//vakjes
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Depth=(Height/2)+rand(Seed)*Height/2;
		#local Location=<1,0,1>*(Min+<rand(Seed),0,rand(Seed)>*(Max-Min));
		#if (inside(Prism,Location))
			// eerst kijken hoe groot het mag worden, in beide richtingen:
			#local EindXMax=trace(Prism,Location,x);
			#local EindZMax=trace(Prism,Location,z);
			#local Depth=(Height/2)+rand(Seed)*Height/2;
			#local Eind=<Location.x+(EindXMax.x-Location.x)*(.01+rand(Seed)*.99),Location.z+(EindZMax.z-Location.z)*(.01+rand(Seed)*.99)>;
			#local P1=<Location.x,Location.z>;
			#local P2=<Location.x,Eind.v>;
			#local P3=Eind;
			#local P4=<Eind.u,Location.z>;
		#end
		#local Aantal=Aantal-1;
	#end
	//buisjes 1
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Depth=(Height/2)+rand(Seed)*Height/2;
		#local Location=<1,0,1>*(Min+<rand(Seed),0,rand(Seed)>*(Max-Min));
		#if (inside(Prism,Location))
			// eerst kijken hoe groot het mag worden
			#local EindXMax=trace(Prism,Location,x);
			#local Depth=(Height/2)+rand(Seed)*Height/2;
			#local Eind=<Location.x+(EindXMax.x-Location.x)*rand(Seed),Location.z>;
			
			#local P1=<Location.x,Location.z>;
			#local P2=Eind;
		#end
		#local Aantal=Aantal-1;
	#end
	//buisjes 2
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Depth=(Height/2)+rand(Seed)*Height/2;
		#local Location=<1,0,1>*(Min+<rand(Seed),0,rand(Seed)>*(Max-Min));
		#if (inside(Prism,Location))
			// eerst kijken hoe groot het mag worden
			#local EindMax=trace(Prism,Location,z);
			#local Depth=(Height/2)+rand(Seed)*Height/2;
			#local Eind=<Location.x,Location.z+(EindMax.z-Location.z)*rand(Seed)>;
			
			#local P1=<Location.x,Location.z>;
			#local P2=Eind;
		#end
		#local Aantal=Aantal-1;
	#end
#end
		
//adds greebles to a polygon formed by the prism Prism, using:
// - at most [Detail] cylindrical elements
// - at most [Detail] box-like panneling elements
// - at most [Detail] horizontal tubes
// - at most [Detail] vertical tubes
// the maximum height of the greebles is given by Height, 
// and the scale (not the maximum size) of the cylindrical elements is given by Scale
#macro PrismGreebles2(Prism,Detail,Height,Scale)
#if (Detail<0) PrismGreeblesDummy(Prism,-Detail,Height,Scale) #else
	#local Min=min_extent(Prism);
	#local Max=max_extent(Prism);

	//cilindertjes
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Size=(.05+rand(Seed)*.25)*Scale;
		#local Depth=(Height/2)+rand(Seed)*Height/2;
		#local Location=<1,0,1>*(Min+<rand(Seed),0,rand(Seed)>*(Max-Min));
		#if (inside(Prism,Location))
			superellipsoid {<1,.1+rand(Seed)*.3> rotate x*90 scale <Size,Depth,Size> translate Location}
		#end
		#local Aantal=Aantal-1;
	#end
	//vakjes
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Depth=(Height/2)+rand(Seed)*Height/2;
		#local Location=<1,0,1>*(Min+<rand(Seed),0,rand(Seed)>*(Max-Min));
		#if (inside(Prism,Location))
			// eerst kijken hoe groot het mag worden, in beide richtingen:
			#local EindXMax=trace(Prism,Location,x);
			#local EindZMax=trace(Prism,Location,z);
			#local Depth=(Height/2)+rand(Seed)*Height/2;
			#local Eind=<Location.x+(EindXMax.x-Location.x)*(.01+rand(Seed)*.99),Location.z+(EindZMax.z-Location.z)*(.01+rand(Seed)*.99)>;
			#local P1=<Location.x,Location.z>;
			#local P2=<Location.x,Eind.v>;
			#local P3=Eind;
			#local P4=<Eind.u,Location.z>;
			#if (vlength(P1-P2)!=0) cylinder {<P1.u,0,P1.v>,<P2.u,0,P2.v>,Depth} #end
			#if (vlength(P2-P3)!=0) cylinder {<P2.u,0,P2.v>,<P3.u,0,P3.v>,Depth} #end
			#if (vlength(P3-P4)!=0) cylinder {<P3.u,0,P3.v>,<P4.u,0,P4.v>,Depth} #end
			#if (vlength(P4-P1)!=0) cylinder {<P4.u,0,P4.v>,<P1.u,0,P1.v>,Depth} #end
			sphere {<P1.u,0,P1.v>,Depth}sphere {<P2.u,0,P2.v>,Depth}
			sphere {<P3.u,0,P3.v>,Depth}sphere {<P4.u,0,P4.v>,Depth}
			prism {
				linear_spline
				linear_sweep
				0,Depth,
				5
				P1,P2,P3,P4,P1
			}
		#end
		#local Aantal=Aantal-1;
	#end
	//buisjes 1
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Depth=(Height/2)+rand(Seed)*Height/2;
		#local Location=<1,0,1>*(Min+<rand(Seed),0,rand(Seed)>*(Max-Min));
		#if (inside(Prism,Location))
			// eerst kijken hoe groot het mag worden
			#local EindXMax=trace(Prism,Location,x);
			#local Depth=(Height/2)+rand(Seed)*Height/2;
			#local Eind=<Location.x+(EindXMax.x-Location.x)*rand(Seed),Location.z>;
			
			#local P1=<Location.x,Location.z>;
			#local P2=Eind;
			#if (vlength(P1-P2)!=0) cylinder {<P1.u,0,P1.v>,<P2.u,0,P2.v>,Depth} #end
			sphere {<P1.u,0,P1.v>,Depth}sphere {<P2.u,0,P2.v>,Depth}
		#end
		#local Aantal=Aantal-1;
	#end
	//buisjes 2
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Depth=(Height/2)+rand(Seed)*Height/2;
		#local Location=<1,0,1>*(Min+<rand(Seed),0,rand(Seed)>*(Max-Min));
		#if (inside(Prism,Location))
			// eerst kijken hoe groot het mag worden
			#local EindMax=trace(Prism,Location,z);
			#local Depth=(Height/2)+rand(Seed)*Height/2;
			#local Eind=<Location.x,Location.z+(EindMax.z-Location.z)*rand(Seed)>;
			
			#local P1=<Location.x,Location.z>;
			#local P2=Eind;
			#if (vlength(P1-P2)!=0) cylinder {<P1.u,0,P1.v>,<P2.u,0,P2.v>,Depth} #end
			sphere {<P1.u,0,P1.v>,Depth}sphere {<P2.u,0,P2.v>,Depth}
		#end
		#local Aantal=Aantal-1;
	#end
	#end
#end

//adds greebles to a polygon formed by the prism Prism, using:
// - at most [Detail] cylindrical elements
// - at most [Detail] box-like panneling elements
// - at most [Detail] horizontal tubes
// - at most [Detail] vertical tubes
// the maximum height of the greebles is given by Height, 
// and the scale (not the maximum size) of the cylindrical elements is given by Scale
// the results should be almost the same as with PrismGreebles2(...)
#macro PrismGreebles(Prism,Detail,Height,Scale,Bevel)
	//#local Points=GetBeveledPrism(Points,Bevel);
	#local Min=min_extent(Prism)+Bevel;
	#local Max=max_extent(Prism)-Bevel;
	#local Size=Max-Min;
	//cilindertjes
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Radius=(.05+rand(Seed)*.25)*Scale;
		#local Min2=Min+Radius;
		#local Max2=Max-Radius;
		#local Begin=Min2+(Max2-Min2)*rand(Seed);
		#local FinalHeight=Height*.001+(rand(Seed)*Height*.999);
		
		superellipsoid {<1,.1+rand(Seed)*.9> rotate x*90 scale <Radius,FinalHeight,Radius> translate <Begin.x,0,Begin.z>}
		
		#local Aantal=Aantal-1;
	#end
	//vakjes
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Begin=Min+(Max-Min)*rand(Seed);
		#local Eind=Begin+(Max-Begin)*rand(Seed);
		#local FinalHeight=Height*.001+(rand(Seed)*Height*.999);
		#local Depth=min(min(Size.x,Size.z)/4,FinalHeight*2);
			#local P1=<Begin.x+Depth,Begin.z+Depth>;
			#local P2=<Begin.x+Depth,Eind.z-Depth>;
			#local P3=<Eind.x-Depth,Eind.z-Depth>;
			#local P4=<Eind.x-Depth,Begin.z+Depth>;
			#if (vlength(P1-P2)!=0) cylinder {<P1.u,0,P1.v>,<P2.u,0,P2.v>,Depth} #end
			#if (vlength(P2-P3)!=0) cylinder {<P2.u,0,P2.v>,<P3.u,0,P3.v>,Depth} #end
			#if (vlength(P3-P4)!=0) cylinder {<P3.u,0,P3.v>,<P4.u,0,P4.v>,Depth} #end
			#if (vlength(P4-P1)!=0) cylinder {<P4.u,0,P4.v>,<P1.u,0,P1.v>,Depth} #end
			sphere {<P1.u,0,P1.v>,Depth}sphere {<P2.u,0,P2.v>,Depth}
			sphere {<P3.u,0,P3.v>,Depth}sphere {<P4.u,0,P4.v>,Depth}
			prism {
				linear_spline
				linear_sweep
				0,Depth,
				5
				P1,P2,P3,P4,P1
			}
		#local Aantal=Aantal-1;
	#end
	//buisjes X-richting
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Radius=(Height/2)+rand(Seed)*Height/2; //(.05+rand(Seed)*.25)*Scale;
		#local Begin=Min+(Max-Min)*rand(Seed);
		#local Eind=Begin+(Max-Begin)*rand(Seed);
		#local Eind=<Eind.x,0,Begin.z>; //+min(Radius,Max.z-Begin.z)>;
		#local FinalHeight=Height*.001+(rand(Seed)*Height*.999);
			cylinder {<Begin.x,0,Begin.z>,Eind,min(Radius,Max.x-Begin.x)}
			sphere {<Begin.x,0,Begin.z>,min(Radius,Max.x-Begin.x)}
			sphere {Eind,min(Radius,Max.x-Begin.x)}
		#local Aantal=Aantal-1;
	#end
	//buisjes Z-richting
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Radius=(Height/2)+rand(Seed)*Height/2; //(.05+rand(Seed)*.25)*Scale;
		#local Begin=Min+(Max-Min)*rand(Seed);
		#local Eind=Begin+(Max-Begin)*rand(Seed);
		#local Eind=<Begin.x,0,Eind.z>;//<Begin.x+min(Radius,Max.x-Begin.x),0,Eind.z>;
		#local FinalHeight=Height*.001+(rand(Seed)*Height*.999);
			cylinder {<Begin.x,0,Begin.z>,Eind,min(Radius,Max.x-Begin.x)}
			sphere {<Begin.x,0,Begin.z>,min(Radius,Max.x-Begin.x)}
			sphere {Eind,min(Radius,Max.x-Begin.x)}
		#local Aantal=Aantal-1;
	#end
#end


//this macro creates greeble-cells and adds greebles onto a polygon defined by points Points.
//the subdivision is recursive with a recursion-depth of at most Diepte.
//every greeble-cell will be a beveled prism with a bevel-width of Radius
//if defined, the following variables will also be used:
// DefHeight (default: .1) : the minimum height of the greeble-cells, also affecting the height of the greebles
// Height (default: .05) : the maximum added height of the greeble-cells, also affecting the height of the greebles
// Detail (default: 5) : the amount of greebles to be added (see the greeble-macros for more information)
// GreebleConstrain (default: on) : a boolean.  if true, the greebles will never "leak out" of the greeble-cell, but they might have sharper edges, and it will render slower
// GreebleHeight (default: 1) : a multiplier-value for the greebles
// AdjustDetail (default: on) : a boolean. if true, the amount of greebles will be adjusted to the size of the greeble-cell
#macro VerdeelPolygon(Points,Diepte,Radius)
	#ifndef(Seed) #declare Seed=seed(1); #end
	#if (Diepte<0)
		#ifndef (DefHeight) #local DefHeight=.1; #end
		#ifndef (Height) #local Height=.05; #end
		#ifndef (Detail) #local Detail=5; #end
		#ifndef (AdjustDetail) #local AdjustDetail=1; #end
		#ifndef (GreebleConstrain) #local GreebleConstrain=1; #end
		#ifndef (GreebleHeight) #local GreebleHeight=1; #end
		#local Tel=0; #local Aantal=dimension_size(Points,1);
		#local Prism=prism {-.0001,DefHeight+Height*5,Aantal+1 
			#while (Tel<Aantal)
				#local PTel=Points[Tel]; <PTel.x,PTel.y>
				#local Tel=Tel+1;
			#end
			#local PTel=Points[0]; <PTel.x,PTel.y>
		}
		intersection {
			#local FinalHeight=(DefHeight+rand(Seed)*Height);
			#local Min=min_extent(Prism);
			#local Max=max_extent(Prism);
			#local Size=Max-Min;
			union {
				RoundPrism(Points,min(min(Size.x,Size.z)/8,Radius),FinalHeight)
			#if ((Size.x>Radius)&(Size.z>Radius))
				//greebles enkel plaatsen als er voldoende plaats is
				#if (AdjustDetail) #local D=Detail*((Size.x*Size.z)); #else #local D=Detail; #end
				intersection {
					union {PrismGreebles2(Prism,D,GreebleHeight*((.65*Radius)+(.06*Radius)*rand(Seed)),7*Radius) translate y*FinalHeight}
					#if (GreebleConstrain) object {Prism} #end
				}
			#end
			}
		}
	#else
		//min en max uitzoeken:
		#local Min=Points[0];
		#local Max=Points[0];
		#local Tel=1;
		#local Aantal=dimension_size(Points,1);
		#while (Tel<Aantal)
			#if (Points[Tel].u<Min.u) #local Min=<Points[Tel].u,Min.v>; #end
			#if (Points[Tel].v<Min.v) #local Min=<Min.u,Points[Tel].v>; #end

			#if (Points[Tel].u>Max.u) #local Max=<Points[Tel].u,Max.v>; #end
			#if (Points[Tel].v>Max.v) #local Max=<Max.u,Points[Tel].v>; #end
			#local Tel=Tel+1;
		#end
		//experimentje: altijd over een vierkant werken om te verdelen !
		#local Midden=(Min+Max)/2;
		#local Width=max(Max.u-Min.u,Max.v-Min.v);
		#local PercentageU=.5+(rand(Seed)-rand(Seed))*.5*.5;
		#local PercentageV=.61803399*PercentageU;
		#local Loc=(Midden-<Width,Width>) + (<Width,Width>*2*<PercentageU,PercentageV>);
		#local Points1=ClipPolygon(Points,plane {x,Loc.u});
		#local Points1=ClipPolygon(Points1,plane {z,Loc.v});
		#if (dimension_size(Points1,1)>1)
			VerdeelPolygon(Points1,Verlaag(Diepte),Radius)
		#end

		#local Points1=ClipPolygon(Points,plane {-x,-Loc.u});
		#local Points1=ClipPolygon(Points1,plane {z,Loc.v});
		#if (dimension_size(Points1,1)>1)
			VerdeelPolygon(Points1,Verlaag(Diepte),Radius)
		#end
		
		#local Points1=ClipPolygon(Points,plane {x,Loc.u});
		#local Points1=ClipPolygon(Points1,plane {-z,-Loc.v});
		#if (dimension_size(Points1,1)>1)
			VerdeelPolygon(Points1,Verlaag(Diepte),Radius)
		#end

		#local Points1=ClipPolygon(Points,plane {-x,-Loc.u});
		#local Points1=ClipPolygon(Points1,plane {-z,-Loc.v});
		#if (dimension_size(Points1,1)>1)
			VerdeelPolygon(Points1,Verlaag(Diepte),Radius)
		#end
	#end
#end

// draws a beveled prism formed by points Points, with height PrismHeight (or PrismHeight*2 if Mirrored is true)
// with added bevel-height BevelHeight and bevelwidth Bevel, subdivided recursively into greeblecells with
// maximum recursion-depth Diepte, and greeblecell-bevelwidth Radius
// all extra variables of VerdeelPolygon also apply to this macro, and also these variables will have effect:
//   Edges (array of the same size as Points) : states which edges should be drawn
//   BevelEdges (array of the same size as Points) : multiplier-values for the bevel-width per edge
#macro GreebledRoundPrism(Points,Diepte,Radius,Bevel,BevelHeight,PrismHeight,Mirrored)
	#local Aantal=dimension_size(Points,1);
	#local Aantal2=Aantal;
	#local checkEdges=false;
	#local checkBevel=false;
	#ifdef(Edges) #if (dimension_size(Edges,1)=Aantal) #local checkEdges=true; #end	#end
	#ifdef(BevelEdges) #if (dimension_size(BevelEdges,1)=Aantal) #local checkBevel=true; #end #end
	#local Tel=0;
	#local Points2=array[Aantal];
	#local Hoek=degrees(atan2(BevelHeight,Bevel));
	union {
	#while (Tel<Aantal)
		#local P=Points[Tel];
		#local PVorig=Points[mod(Aantal+Tel-1,Aantal)];
		#local PVolgend=Points[mod(Tel+1,Aantal)];
		#local PVolgend2=Points[mod(Tel+2,Aantal)];
		
		#local VN1=vnormalize(PVolgend2-PVolgend);
		#local VN2=vnormalize(PVolgend-P);
		
		//enkel als PVolgend2 niet in P->PVolgend 's verlengde ligt, is PVolgend van enig belang
		//anders: PVolgend gelijkstellen aan P en deze randen gewoon niet tekenen
		
		#if (((vlength(VN1-VN2)=0)|(vlength(VN1+VN2)=0))|(vlength(P-PVolgend)=0))
			#local Points[mod(Tel+1,Aantal)]=P;
			#local Aantal2=Aantal2-1;
		#else
			//PVorig kan nu gelijk zijn aan P... fixen:
			#if (vlength(P-PVorig)=0) #local PVorig=Points[mod(Aantal+Tel-2,Aantal)]; #end
	
			#local N0Multiplier=1;
			#local N1Multiplier=1;
			#local N2Multiplier=1;
			#if (checkBevel)
				#local N0Multiplier=.001+BevelEdges[mod(Aantal+Tel-1,Aantal)]*.999;
				#local N1Multiplier=.001+BevelEdges[Tel]*.999;
				#local N2Multiplier=.001+BevelEdges[mod(Tel+1,Aantal)]*.999;
			#end
			
			#local N0=vnormalize(Normal2D(P-PVorig))*Bevel*N0Multiplier;
			#local PB0=PVorig+N0;
			#local PB0Volgend=P+N0;
	
			#local N1=vnormalize(Normal2D(PVolgend-P))*Bevel*N1Multiplier;
			#local PB1=P+N1;
			#local PB1Volgend=PVolgend+N1;
	
			#local N2=vnormalize(Normal2D(PVolgend2-PVolgend))*Bevel*N2Multiplier;
			#local PB2=PVolgend+N2;
			#local PB2Volgend=PVolgend2+N2;
			
			//snijpunt tussen PB0-PB0Volgend en PB1-PB1Volgend:
			#local U=((PB1Volgend.x-PB1.x)*(PB0.y-PB1.y)-(PB1Volgend.y-PB1.y)*(PB0.x-PB1.x))
				/
				((PB1Volgend.y-PB1.y)*(PB0Volgend.x-PB0.x)-(PB1Volgend.x-PB1.x)*(PB0Volgend.y-PB0.y));
			#local S1=PB0+(PB0Volgend-PB0)*U;
	
			//snijpunt tussen PB1-PB1Volgend en PB2-PB2Volgend:
			#local U=((PB2Volgend.x-PB2.x)*(PB1.y-PB2.y)-(PB2Volgend.y-PB2.y)*(PB1.x-PB2.x))
				/
				((PB2Volgend.y-PB2.y)*(PB1Volgend.x-PB1.x)-(PB2Volgend.x-PB2.x)*(PB1Volgend.y-PB1.y));
			#local S2=PB1+(PB1Volgend-PB1)*U;
			
			#local TPs=array[4]{P*<1,1,1>,PVolgend*<1,1,1>,S2*<1,1,1>,S1*<1,1,1>}
			#local Axis=TPs[1]-TPs[0]; #local Axis=<Axis.x,0,Axis.y>;
			
			#local TPs0=TPs[0];
			#local TPXVerschil=TPs[1].x-TPs[0].x;
			#if (TPXVerschil=0) 
			#local TPHoek=0; #else#local TPHoek=degrees(atan2(TPs[1].y-TPs[0].y,TPXVerschil));
	      #end
	      #local TPs1=array[4];
			#local TPs1[0]=vrotate(TPs[0], -z*TPHoek);
			#local TPs1[1]=vrotate(TPs[1], -z*TPHoek);
			#local TPs1[2]=vrotate(TPs[2], -z*TPHoek);
			#local TPs1[3]=vrotate(TPs[3], -z*TPHoek);
			#local Dummy=Diepte;
			#local Diepte=Diepte*Bevel;
			#local Prism1=
			union {
				VerdeelPolygon(TPs1,Diepte*(Bevel/PrismHeight),Radius)
				rotate -y*TPHoek
				
				translate -<TPs0.x,0,TPs0.y>
				
				Reorient_Trans(Axis, z)
				matrix <
					1,BevelHeight/Bevel,0,
					0,1,0,
					0,0,1,
					0,0,0
				>
				Reorient_Trans(z,Axis)
				translate <TPs0.x,0,TPs0.y>
				translate y*PrismHeight
			}
			object {Prism1}
			#if (Mirrored) object {Prism1 scale <1,-1,1>} #end
			#local Diepte=Dummy;
			#if (PrismHeight>0)
				#local doEdge=true;
				#if (checkEdges) #if (!Edges[Tel]) #local doEdge=false; #end #end
				#if (doEdge)
					//de wanden van de prism !
					//lengte: TPs[1]-TPs[0]
					//breedte: PrismHeight
					#local WandLengte=vlength(TPs[1]-TPs[0]);
					#if (Mirrored) #local TPW=array[4]{<-PrismHeight,0>,<-PrismHeight,WandLengte>,<PrismHeight,WandLengte>,<PrismHeight,0>}
					#else #local TPW=array[4]{<-PrismHeight/2,0>,<-PrismHeight/2,WandLengte>,<PrismHeight/2,WandLengte>,<PrismHeight/2,0>} #end
					union {
						VerdeelPolygon(TPW,Diepte,Radius)
						rotate z*90
						Reorient_Trans(z,Axis)
						translate <TPs[0].x,0,TPs[0].y>
						#if (!Mirrored) translate y*PrismHeight/2 #end
					}
				#end
			#end
			
			#local Points2[Tel]=S1;
		#end
		#local Tel=Tel+1;
	#end
		#local Points3=array[Aantal2];
		#local Tel=0;
		#local Tel2=0;
		#while (Tel<Aantal)
			#ifdef(Points2[Tel]) #local Points3[Tel2]=Points2[Tel]; #local Tel2=Tel2+1; #end
			#local Tel=Tel+1;
		#end
		#local Prism1=
		union {VerdeelPolygon(Points3,Diepte,Radius) //Metaal() 
			translate y*BevelHeight translate y*PrismHeight}
		object {Prism1}
		#if (Mirrored) object {Prism1 scale <1,-1,1>} #end
	}
#end



//cylindrical greebles:

//draws a cone-segment of a cone along the y-axis going from y=StartHeight with radius Radius to y=EindHeight with radius Radius2
//the segment goes from start-angle StartHoek to end-angle EindHoek
//the segment will be a triangle-mesh.  The resolution of the mesh is defined by MaxLength (where MaxLength is the maximum length
//of a single triangle)
//the segment will be beveled with bevel-width Bevel and bevel-height BevelHeight
#macro RoundConeSegment(StartHeight,EindHeight,Radius,Radius2,StartHoek,EindHoek,Bevel,BevelHeight,MaxLength)
	#local Start=y*(StartHeight+Bevel);
	#local Eind=y*(EindHeight-Bevel);
	#local Start2=y*StartHeight;
	#local Eind2=y*EindHeight;
		#local StartHoek2=StartHoek+degrees(Bevel/Radius);
		#local EindHoek2=EindHoek-degrees(Bevel/Radius);
		#local TotaleLengte=radians(EindHoek-StartHoek)*(Radius+BevelHeight);
		#local Aantal=max(int(TotaleLengte/MaxLength),1);
		#local Tel=0;
		mesh {
			triangle {
				vrotate(<Radius,StartHeight,0>,y*StartHoek),
				vrotate(<Radius2,EindHeight,0>,y*StartHoek),
				vrotate(<Radius+BevelHeight,StartHeight+Bevel,0>,y*StartHoek2)
			}
			triangle {
				vrotate(<Radius2,EindHeight,0>,y*StartHoek),
				vrotate(<Radius2+BevelHeight,EindHeight-Bevel,0>,y*StartHoek2),
				vrotate(<Radius+BevelHeight,StartHeight+Bevel,0>,y*StartHoek2)
			}
			triangle {
				vrotate(<Radius2,EindHeight,0>,y*StartHoek),
				vrotate(<Radius2,EindHeight,0>,y*StartHoek2),
				vrotate(<Radius2+BevelHeight,EindHeight-Bevel,0>,y*StartHoek2)
			}
			triangle {
				vrotate(<Radius,StartHeight,0>,y*StartHoek),
				vrotate(<Radius+BevelHeight,StartHeight+Bevel,0>,y*StartHoek2),
				vrotate(<Radius,StartHeight,0>,y*StartHoek2)
			}

			triangle {
				vrotate(<Radius,StartHeight,0>,y*EindHoek),
				vrotate(<Radius2,EindHeight,0>,y*EindHoek),
				vrotate(<Radius+BevelHeight,StartHeight+Bevel,0>,y*EindHoek2)
			}
			triangle {
				vrotate(<Radius2,EindHeight,0>,y*EindHoek),
				vrotate(<Radius2+BevelHeight,EindHeight-Bevel,0>,y*EindHoek2),
				vrotate(<Radius+BevelHeight,StartHeight+Bevel,0>,y*EindHoek2)
			}
			triangle {
				vrotate(<Radius2,EindHeight,0>,y*EindHoek),
				vrotate(<Radius2,EindHeight,0>,y*EindHoek2),
				vrotate(<Radius2+BevelHeight,EindHeight-Bevel,0>,y*EindHoek2)
			}
			triangle {
				vrotate(<Radius,StartHeight,0>,y*EindHoek),
				vrotate(<Radius+BevelHeight,StartHeight+Bevel,0>,y*EindHoek2),
				vrotate(<Radius,StartHeight,0>,y*EindHoek2)
			}

			#while (Tel<Aantal)
				#local H1=StartHoek2+(EindHoek2-StartHoek2)*(Tel/Aantal);
				#local H2=StartHoek2+(EindHoek2-StartHoek2)*((Tel+1)/Aantal);
				#local P1=vrotate(<Radius+BevelHeight,StartHeight+Bevel,0>,y*H1);
				#local P2=vrotate(<Radius2+BevelHeight,EindHeight-Bevel,0>,y*H1);
				#local P3=vrotate(<Radius2+BevelHeight,EindHeight-Bevel,0>,y*H2);
				#local P4=vrotate(<Radius+BevelHeight,StartHeight+Bevel,0>,y*H2);
				#local Rverschil=(Radius-Radius2);
				#local Hverschil=(StartHeight-EindHeight);
				#local Hoek=-degrees(atan2(Rverschil,Hverschil));
				#local N1=vrotate(vrotate(x,z*Hoek),y*H1);
				#local N2=vrotate(vrotate(x,z*Hoek),y*H2);
				smooth_triangle {P1,N1,P2,N1,P4,N2}
				smooth_triangle {P2,N1,P3,N2,P4,N2}
				#local P2B=vrotate(<Radius2,EindHeight,0>,y*H1);
				#local P3B=vrotate(<Radius2,EindHeight,0>,y*H2);
				triangle {P2,P2B,P3}
				triangle {P2B,P3B,P3}

				#local P2B=vrotate(<Radius,StartHeight,0>,y*H2);
				#local P3B=vrotate(<Radius,StartHeight,0>,y*H1);
				triangle {P2B,P1,P3B}
				triangle {P1,P4,P2B}
				#local Tel=Tel+1;
			#end
		}
#end

//gives the interpolated point between points H1 and H2 at interpolation-point P
#macro PointAt(H1,H2,P)
	#local R=H1+(H2-H1)*P;
	R
#end

//adds greebles to the cone segment of a cone along the y-axis going from y=StartHeight with radius Radius to y=EindHeight with radius Radius2
//the segment goes from start-angle StartHoek to end-angle EindHoek
//the segment is beveled with bevel-width Bevel and bevel-height BevelHeight
//the segment will have 
// - at most [Detail] cylindrical components
// - at most [Detail] cone-segment panneling-like components (again: triangle mesh, with a resolution defined by MaxLength)
// - at most [Detail] horizontal tubes
// - at most [Detail] vertical tubes
#macro ConeGreeble(StartHeight,EindHeight,Radius1,Radius2,StartHoek,EindHoek,Bevel,BevelHeight,MaxLength,Detail)
	#local Start=(StartHeight+Bevel);
	#local Eind=(EindHeight-Bevel);
	#local StartH=StartHoek+degrees(Bevel/Radius1);
	#local EindH=EindHoek-degrees(Bevel/Radius1);

	#local Rverschil=(Radius1-Radius2);
	#local Hverschil=(StartHeight-EindHeight);
	#local Hoek=-degrees(atan2(Rverschil,Hverschil));

	//cilindertjes:
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Size=(Bevel*.01)+rand(Seed)*Bevel*.99*2;
		#local Hoek=StartH+(EindH-StartH)*rand(Seed);
		#local HoogteP=rand(Seed);
		#local Hoogte=Start+(Eind-Start)*HoogteP;
		#local Depth=BevelHeight/2+rand(Seed)*BevelHeight/2;
		#local Radius=PointAt(Radius1,Radius2,HoogteP);
		superellipsoid {<1,.1+rand(Seed)*.3> rotate y*90 rotate z*Hoek scale <Depth,Size,Size> translate x*Radius rotate y*Hoek translate y*Hoogte}
		#local Aantal=Aantal-1;
	#end
	//vakjes:
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local HoogtePS=rand(Seed);
		#local HoogtePE=rand(Seed);
		#local S=Start+(Eind-Start)*HoogtePS;
		#local E=S+(Eind-S)*HoogtePE;
		#local HoogtePE=HoogtePS+(1-HoogtePS)*HoogtePE;
		#local SH=StartH+(EindH-StartH)*rand(Seed);
		#local EH=SH+(EindH-SH)*rand(Seed);
		#local H=BevelHeight/2+rand(Seed)*BevelHeight/2;
		#local Radius=PointAt(Radius1,Radius2,HoogtePS);
		#local RadiusB=PointAt(Radius1,Radius2,HoogtePE);
		RoundConeSegment(S,E,Radius,RadiusB,SH,EH,Bevel/2,H,AantalStapjes)
		#local Aantal=Aantal-1;
	#end
	//verticale buisjes
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local HoogtePS=rand(Seed);
		#local HoogtePE=rand(Seed);
		#local S=Start+(Eind-Start)*HoogtePS;
		#local E=S+(Eind-S)*HoogtePE;
		#local HoogtePE=HoogtePS+(1-HoogtePS)*HoogtePE;
		#local SH=StartH+(EindH-StartH)*rand(Seed);
		#local H=(BevelHeight/2+rand(Seed)*BevelHeight/2)/2;
		#local Radius=PointAt(Radius1,Radius2,HoogtePS);
		#local RadiusB=PointAt(Radius1,Radius2,HoogtePE);
		cylinder {<Radius,S,0>,<RadiusB,E,0>,H rotate y*SH}
		sphere {<Radius,S,0>,H rotate y*SH}
		sphere {<RadiusB,E,0>,H rotate y*SH}
		#local Aantal=Aantal-1;
	#end
	//horizontale buisjes simuleren, toruskes zouden wsl te traag gaan
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local HoogtePS=rand(Seed);
		#local S=Start+(Eind-Start)*HoogtePS;
		#local H=BevelHeight/2+rand(Seed)*BevelHeight/2;
		#local H=min((Eind-S),H*2)/2;
		#local E=S+H*2;
		#local HoogtePE=(E-StartHeight)/abs(Hverschil);
		#local SH=StartH+(EindH-StartH)*rand(Seed);
		#local EH=SH+(EindH-SH)*rand(Seed);
		#local Radius=PointAt(Radius1,Radius2,HoogtePS);
		#local RadiusB=PointAt(Radius1,Radius2,HoogtePE);
		RoundConeSegment(S,E,Radius,RadiusB,SH,EH,H,H,AantalStapjes)
		#local Aantal=Aantal-1;
	#end
#end

// subdivides the cone-segment along the y-axis starting at y=StartHeight with radius Radius1 and ending at y=EindHeight with radius Radius2
// with the segment starting at agnel StartHoek and ending at EindHoek recursively with a maximum recursion-depth of Diepte
// into beveledd greeble-cells (cone segments) with bevel-width Bevel and bevel-height BevelHeight
// every greeble-cell will get greebles if Detail > 0
// if Detail isn't declared, it defaults to 5
#macro VerdeelCone(StartHeight,EindHeight,Radius1,Radius2,StartHoek,EindHoek,Diepte,Bevel,BevelHeight)
	#local Start=y*(StartHeight+Bevel);
	#local Eind=y*(EindHeight-Bevel);
	#local Start2=y*StartHeight;
	#local Eind2=y*EindHeight;
	#if (Diepte<0)
		#ifndef(Detail) #local Detail=5; #end
		#local H=rand(Seed)*BevelHeight;
		#ifndef(MaxSegmentLength) #local AantalStapjes=Bevel; //(eigenlijk de maximale lengte van een segment)
		#else #local AantalStapjes= MaxSegmentLength; #end
		RoundConeSegment(StartHeight,EindHeight,Radius1,Radius2,StartHoek,EindHoek,Bevel,H,AantalStapjes)
		#if (Detail>0) ConeGreeble(StartHeight,EindHeight,Radius1+H,Radius2+H,StartHoek,EindHoek,Bevel,H,AantalStapjes,Detail) #end
	#else
		// eerst es checken of 't nie onvoorstelbaar ongelijk verdeeld is:
		#local Lengte=radians(EindHoek-StartHoek)*Radius1;
		#local Hoogte=EindHeight-StartHeight;
		
		#local PercentageU=.5+(rand(Seed)-rand(Seed))*.5*.9;
		#local PercentageV=.5+(rand(Seed)-rand(Seed))*.5*.9;
		#local MidHeight=StartHeight+(EindHeight-StartHeight)*PercentageU;
		#local MidHoek=StartHoek+(EindHoek-StartHoek)*PercentageV;
		#local RadiusM=Radius1+(Radius2-Radius1)*PercentageU;
		// als't 2 keer zo hoog als breed is (of nog hoger), dan ff enkel in de hoogte bijsnijden:
		#if ((Hoogte>(Lengte*2))&(rand(Seed)>.125))
			VerdeelCone(StartHeight,MidHeight,Radius1,RadiusM,StartHoek,EindHoek,Verlaag(Diepte),Bevel,BevelHeight)
			VerdeelCone(MidHeight,EindHeight,RadiusM,Radius2,StartHoek,EindHoek,Verlaag(Diepte),Bevel,BevelHeight)
		// als't 2 keer lager dan breed is (of nog lager), dan ff enkel in de breedte bijsnijden:
		#else 
			#if (((Hoogte*2)<Lengte)&(rand(Seed)>.125))
				VerdeelCone(StartHeight,EindHeight,Radius1,Radius2,StartHoek,MidHoek,Verlaag(Diepte),Bevel,BevelHeight)
				VerdeelCone(StartHeight,EindHeight,Radius1,Radius2,MidHoek,EindHoek,Verlaag(Diepte),Bevel,BevelHeight)
			#else
				VerdeelCone(StartHeight,MidHeight,Radius1,RadiusM,StartHoek,MidHoek,Verlaag(Diepte),Bevel,BevelHeight)
				VerdeelCone(MidHeight,EindHeight,RadiusM,Radius2,StartHoek,MidHoek,Verlaag(Diepte),Bevel,BevelHeight)
				
				VerdeelCone(StartHeight,MidHeight,Radius1,RadiusM,MidHoek,EindHoek,Verlaag(Diepte),Bevel,BevelHeight)
				VerdeelCone(MidHeight,EindHeight,RadiusM,Radius2,MidHoek,EindHoek,Verlaag(Diepte),Bevel,BevelHeight)
			#end
		#end
	#end
#end


//superellipsoidal greebles

//gives the point on the superellipsoid with controlvalues n1 and n2, with radii Rx, Ry, Rz, at angles F,B
#macro SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,F,B)
	#local CosF=cos(radians(F));
	#local SinF=sin(radians(F));
	#local CosB=cos(radians(B));
	#local SinB=sin(radians(B));
	#local PowCos1=sgn(CosF)*pow(abs(CosF),n1);
	#local PowCos2=sgn(CosB)*pow(abs(CosB),n2);
	#local PowSin1=sgn(SinF)*pow(abs(SinF),n1);
	#local PowSin2=sgn(SinB)*pow(abs(SinB),n2);
	#local Punt=<
		Rx*PowCos1*PowCos2,
		Ry*PowSin1,
		Rz*PowCos1*PowSin2
	>;
	Punt
#end
//gives the normal of the the point on the superellipsoid with controlvalues n1 and n2, with radii Rx, Ry, Rz, at angles F,B
#macro SuperEllipsoidNormal(Rx,Ry,Rz,n1,n2,F,B)
	#local CosF=cos(radians(F));
	#local SinF=sin(radians(F));
	#local CosB=cos(radians(B));
	#local SinB=sin(radians(B));
	#if (n1=2) #local n1=2.00001; #end
	#if (n2=2) #local n2=2.00001; #end
	#local PowCos1=sgn(CosF)*pow(abs(CosF),2-n1);
	#local PowCos2=sgn(CosB)*pow(abs(CosB),2-n2);
	#local PowSin1=sgn(SinF)*pow(abs(SinF),2-n1);
	#local PowSin2=sgn(SinB)*pow(abs(SinB),2-n2);
	#local Normal=<
		(1/Rx)*PowCos1*PowCos2,
		(1/Ry)*PowSin1,
		(1/Rz)*PowCos1*PowSin2
	>;
	Normal
#end

// draws a beveled superellipsoid-segment with radii Rx1,Ry1 and Rz1, controlvalues n11 and n21, going from angles F11,B11 to F21, B21
// with bevel-width Bevel1 and bevel-height BevelHeight1, as a triangle mesh with a resolution defined by StepF1 and StepB1
#macro SuperEllipsoidSegment(Rx1,Ry1,Rz1,n11,n21,F11,F21,B11,B21,Bevel1,BevelHeight1,StepF1,StepB1)
	#local n1=n11;
	#local n2=n21;
	#local F1=F11;
	#local F2=F21;
	#local B1=B11;
	#local B2=B21;
	#local Bevel=Bevel1;
	#local BevelHeight=BevelHeight1;
	#local StepF=StepF1;
	#local StepB=StepB1;
	
	
	#local Rx=Rx1; #local Ry=Ry1; #local Rz=Rz1;
	#local f1=F1; #local f2=F2;
	#local b1=B1; #local b2=B2;
	
	#local Radius=(Rx+Ry+Rz)/3;

	
	#local F1=F1+degrees(Bevel/Radius);
	#local F2=F2-degrees(Bevel/Radius);

	#local B1=B1+degrees(Bevel/Radius);
	#local B2=B2-degrees(Bevel/Radius);
	
	#local TotaleLengteF=radians(F2-F1)*(Radius+BevelHeight);
	#local AantalF=max(int(TotaleLengteF/StepF),1);

	#local TotaleLengteB=radians(B2-B1)*(Radius+BevelHeight);
	#local AantalB=max(int(TotaleLengteB/StepB),1);

	#if ((B2-B1)>180) #local B2=B1+180; #end
	#if ((F2-F1)>360) #local F2=F1+360; #end
	
	//hoekje 'linksonder'
		#local P1=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f1,b1);
		#local P2=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,F1,b1);
		#local P3=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,F1,B1);
		#local P4=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f1,B1);
		triangle {P1,P2,P3}
		triangle {P1,P3,P4}
	//hoekje 'linksboven'
		#local P1=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,F2,b1);
		#local P2=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f2,b1);
		#local P3=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f2,B1);
		#local P4=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,F2,B1);
		triangle {P1,P2,P4}
		triangle {P2,P3,P4}
	//hoekje 'rechtsboven'
		#local P1=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,F2,B2);
		#local P2=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f2,B2);
		#local P3=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f2,b2);
		#local P4=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,F2,b2);
		triangle {P1,P2,P3}
		triangle {P1,P3,P4} 
	//hoekje 'rechtsonder'
		#local P1=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f1,B2);
		#local P2=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,F1,B2);
		#local P3=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,F1,b2);
		#local P4=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f1,b2);
		triangle {P1,P2,P4}
		triangle {P2,P3,P4}
		
	
	#local TelF=0;
	#while (TelF<AantalF)
		//F-rand, B gaat van b1 naar B1, in 1 stap...
		#local FA=F1+(F2-F1)*(TelF/AantalF);
		#local FB=F1+(F2-F1)*((TelF+1)/AantalF);

		#local P1=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,FA,b1);
		#local P2=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,FB,b1);
		#local P3=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,FB,B1);
		#local P4=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,FA,B1);
		triangle {P1,P2,P4}
		triangle {P2,P3,P4}

		//F-rand, B gaat van B2 naar b2, in 1 stap...
		#local P1=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,FA,B2);
		#local P2=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,FB,B2);
		#local P3=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,FB,b2);
		#local P4=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,FA,b2);
		triangle {P1,P2,P4}
		triangle {P2,P3,P4}
		
		#local TelF=TelF+1;
	#end

	#local TelB=0;
	#while (TelB<AantalB)
		//B-rand, F gaat van f1 naar F1, in 1 stap...
		#local BA=B1+(B2-B1)*(TelB/AantalB);
		#local BB=B1+(B2-B1)*((TelB+1)/AantalB);

		#local P1=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f1,BA);
		#local P2=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,F1,BA);
		#local P3=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,F1,BB);
		#local P4=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f1,BB);
		triangle {P1,P2,P4}
		triangle {P2,P3,P4}

		//B-rand, F gaat van F2 naar f2, in 1 stap...
		#local P1=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,F2,BA);
		#local P2=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f2,BA);
		#local P3=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,f2,BB);
		#local P4=SuperEllipsoidPoint(Rx+BevelHeight,Ry+BevelHeight,Rz+BevelHeight,n1,n2,F2,BB);
		triangle {P1,P2,P4}
		triangle {P2,P3,P4}

		#local TelB=TelB+1;
	#end
	

	#local Rx=Rx+BevelHeight;
	#local Ry=Ry+BevelHeight;
	#local Rz=Rz+BevelHeight;
	#local TelF=0;
	#while (TelF<AantalF)
		#local TelB=0;
		#while (TelB<AantalB)
			#local FA=F1+(F2-F1)*(TelF/AantalF);
			#local FB=F1+(F2-F1)*((TelF+1)/AantalF);
			#local BA=B1+(B2-B1)*(TelB/AantalB);
			#local BB=B1+(B2-B1)*((TelB+1)/AantalB);

			#local P1=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,FA,BA);
			#local P2=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,FB,BA);
			#local P3=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,FB,BB);
			#local P4=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,FA,BB);
			//triangle {P1,P2,P4}
			//triangle {P2,P3,P4}
   
			#local N1=SuperEllipsoidNormal(Rx,Ry,Rz,n1,n2,FA,BA);
			#local N2=SuperEllipsoidNormal(Rx,Ry,Rz,n1,n2,FB,BA);
			#local N3=SuperEllipsoidNormal(Rx,Ry,Rz,n1,n2,FB,BB);
			#local N4=SuperEllipsoidNormal(Rx,Ry,Rz,n1,n2,FA,BB);
			smooth_triangle {P1,N1,P2,N2,P4,N4}
			smooth_triangle {P2,N2,P3,N3,P4,N4}
		
			#local TelB=TelB+1;
		#end 
		#local TelF=TelF+1;
	#end
#end

// adds greebles to the superellipsoid-segment with radii Rx1,Ry1 and Rz1, controlvalues n11 and n21, going from angles F11,B11 to F21, B21
// with bevel-width Bevel1 and bevel-height BevelHeight1 with:
//  - at most [Detail] cylindrical components
//  - at most [Detail] superellipsoid-segment panelling-like components
//  - at most [Detail] vertical tubes
//  - at most [Detail] horizontal tubes
//  all components except cylindrical components are created as a triangle mesh with resolutions defined by StepF1 and StepB1
#macro SuperEllipsoidGreeble(Rx1,Ry1,Rz1,n11,n21,F11,F21,B11,B21,Bevel1,BevelHeight1,Detail,StepF1,StepB1)
	#local n1=n11;
	#local n2=n21;
	#local F1=F11;
	#local F2=F21;
	#local B1=B11;
	#local B2=B21;
	#local Bevel=Bevel1;
	#local BevelHeight=BevelHeight1;
	#local StepF=StepF1;
	#local StepB=StepB1;
	
	
	#local Rx=Rx1; #local Ry=Ry1; #local Rz=Rz1;

	#local f1=F1; #local f2=F2;
	#local b1=B1; #local b2=B2;
	
	#local Radius=(Rx+Ry+Rz)/3;

	#local BevelRadius=degrees(Bevel/Radius);
	
	#local F1=F1+degrees(Bevel/Radius);
	#local F2=F2-degrees(Bevel/Radius);

	#local B1=B1+degrees(Bevel/Radius);
	#local B2=B2-degrees(Bevel/Radius);
	
	#local Rx=Rx+BevelHeight;
	#local Ry=Ry+BevelHeight;
	#local Rz=Rz+BevelHeight;
	
	//cylindertjes
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Size=(Bevel*.01)+rand(Seed)*Bevel*.99;
		#local Depth=BevelHeight/2+rand(Seed)*BevelHeight/2;
		#local FM=F1+(F2-F1)*rand(Seed);
		#local BM=B1+(B2-B1)*rand(Seed);
		#local Loc=SuperEllipsoidPoint(Rx,Ry,Rz,n1,n2,FM,BM);
		#local Norm=SuperEllipsoidNormal(Rx,Ry,Rz,n1,n2,FM,BM);
		superellipsoid {<1,.1+rand(Seed)*.3> rotate x*90 scale <Size,Depth,Size> 
			Point_At_Trans(Norm)
			translate Loc
		}
		#local Aantal=Aantal-1;
	#end
	//vakjes
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Depth=BevelHeight/2+rand(Seed)*BevelHeight/2;
		#local FM=F1+(F2-F1)*rand(Seed);
		#local FE=FM+(F2-FM)*rand(Seed);
		#if ((FE-FM)>(BevelRadius*2))
		#local BM=B1+(B2-B1)*rand(Seed);
		#local BE=BM+(B2-BM)*rand(Seed);
		#if ((BE-BM)>(BevelRadius*2))
		SuperEllipsoidSegment(Rx,Ry,Rz,n1,n2,FM,FE,BM,BE,Bevel,Depth,StepF,StepB)
		#end #end
		#local Aantal=Aantal-1;
	#end
	//buisjes in de F-richting
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Depth=BevelHeight/2+rand(Seed)*BevelHeight/2;
		#local FM=F1+(F2-F1)*rand(Seed);
		#local FE=FM+BevelRadius*2;
		#local BM=B1+(B2-B1)*rand(Seed);
		#local BE=BM+(B2-BM)*rand(Seed);
		#if ((BE-BM)>(BevelRadius*2))
		SuperEllipsoidSegment(Rx,Ry,Rz,n1,n2,FM,FE,BM,BE,Bevel,Depth,StepF,StepB)
		#end
		#local Aantal=Aantal-1;
	#end
	//buisjes in de B-richting
	#local Aantal=rand(Seed)*Detail;
	#while (Aantal>0)
		#local Depth=BevelHeight/2+rand(Seed)*BevelHeight/2;
		#local FM=F1+(F2-F1)*rand(Seed);
		#local FE=FM+(F2-FM)*rand(Seed);
		#if ((FE-FM)>(BevelRadius*2))
		#local BM=B1+(B2-B1)*rand(Seed);
		#local BE=BM+BevelRadius*2;
		SuperEllipsoidSegment(Rx,Ry,Rz,n1,n2,FM,FE,BM,BE,Bevel,Depth,StepF,StepB)
		#end
		#local Aantal=Aantal-1;
	#end
#end


//this macro subdivides the superellipsoid-segment with radii Rx, Ry and Rz, and control-values n1 and n2 going from angles
//F1 and B1 to F2 and B2 recursively (with a maximum recursion depth of  Diepte) into beveled superellipsoid-segments (as triangle 
//meshes with resolutions defined by StepF and StepB) with bevel-width Bevel and bevel-height BevelHeight.
//it also adds greebles, if Detail>0.  If Detail isn't declared, it defaults to 5
#macro VerdeelSuperellipsoid(Rx,Ry,Rz,n1,n2,F1,F2,B1,B2,Bevel,BevelHeight,StepF,StepB,Diepte)
	#if (Diepte<0)
		#local Scale=BevelHeight*(.5+rand(Seed)*.5);
		SuperEllipsoidSegment(Rx,Ry,Rz,n1,n2,F1,F2,B1,B2,Bevel,Scale,StepF,StepB)
		#ifndef (Detail) #local Detail=5; #end
		SuperEllipsoidGreeble(Rx,Ry,Rz,n1,n2,F1,F2,B1,B2,Bevel,Scale,Detail,StepF,StepB)
	#else
		#local PercentageU=.5+(rand(Seed)-rand(Seed))*.5*.6;
		#local PercentageV=.5+(rand(Seed)-rand(Seed))*.5*.6;
		#local FM=F1+(F2-F1)*PercentageU;
		#local BM=B1+(B2-B1)*PercentageV;
		VerdeelSuperellipsoid(Rx,Ry,Rz,n1,n2,F1,FM,B1,BM,Bevel,BevelHeight,StepF,StepB,Verlaag(Diepte))
		VerdeelSuperellipsoid(Rx,Ry,Rz,n1,n2,FM,F2,B1,BM,Bevel,BevelHeight,StepF,StepB,Verlaag(Diepte))
		VerdeelSuperellipsoid(Rx,Ry,Rz,n1,n2,F1,FM,BM,B2,Bevel,BevelHeight,StepF,StepB,Verlaag(Diepte))
		VerdeelSuperellipsoid(Rx,Ry,Rz,n1,n2,FM,F2,BM,B2,Bevel,BevelHeight,StepF,StepB,Verlaag(Diepte))
	#end
#end
