// Persistence of Vision Ray Tracer Scene Description File
// File: logoedge.pov
// Vers: 3.6
// Desc: Demo scene for the edgemesh macro, using pov logo
// Date: May 2006
// Auth: Thibaut Jonckheere
// Coypright : you can use and modify this file for any use 
//            as long as credit to the original work is given
 
 
// render with +H400 +W800 (or similar ratio) 
#version 3.6;

#include "colors.inc"

// include the macro which compute the edges
#include "EdgeMesh01.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------
 
#declare PdV= <.0, 1, -7.0>;
#declare LaT= <0.0, 0.0,  0.0>;
 
camera {
  location PdV 
  direction 1.5*z
  right     x*image_width/image_height
  look_at  LaT 
}

//background{LightBlue}

sky_sphere {
  pigment {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }    rotate x*10
}


light_source {
  <-2, 5, -4>*1000           
  color rgb <1, 1, 1>
  parallel
  point_at 0  
}

// ----------------------------------------
 
#declare Toonf = finish{ambient 0.4 diffuse 0.7 brilliance 0.3};
#declare Flatf = finish{ambient 1.0 diffuse 0.};
 
 
#declare Mlogo_WingsMat1 =
  texture{
      pigment{  rgb <0.486667, 0.346667, 1.00000>}
      finish{ Toonf phong 0.6 phong_size 60}
}    
#declare Mlogo_WingsMat2 =  Mlogo_WingsMat1;
#declare Mlogo_WingsMat3 =  Mlogo_WingsMat1;
#include"logo2.inc"      //logo2.inc contains the geometry of the 3 objects forming the logo                                                                                           
#declare Logo= union{
 object{Logo2_Arch}
 object{Logo2_Cone}
 object{Logo2_Sphere}
}
difference{
 plane{y,min_extent(Logo2_Cone).y-0.02  }
 plane{-z, -50}
 texture{pigment{ForestGreen} finish{Toonf ambient 0.1}}  
 }
//-----------we place the first logo------------------------
#declare Yrot1=20;  #declare Trans1=<2.65,0,0>;
object{Logo rotate y*Yrot1 translate Trans1}

//----------Edges for this logo.  Note that the inverse transformation is applied to the PdV used !
//Edges for the arch  
#declare PdV1=PdV - Trans1;   
#declare PdV1=vrotate(PdV1,<0,-Yrot1,0>);
#declare Cyltex= texture{pigment{rgb <0,0,0.3*1>} finish{ambient 1 diffuse 0} }
#declare Cylrad=0.012;
#declare Cylrad2=0.006;   
#declare Normthresh = .1;
#declare MeshFile = "logo2_arch_mesh.inc";
#declare EdgeFile = "logo2_arch_edge_perl.inc";
#declare LogoArchEdge=sphere{1,0};
#declare LogoArchNormEdge=sphere{1,0};
EdgeMesh01(MeshFile,EdgeFile,LogoArchEdge,LogoArchNormEdge,Normthresh,Cylrad,Cylrad2,Cyltex,PdV1)    

//Edges for the cone
#declare PdV1=PdV- Trans1; 
#declare PdV1=vrotate(PdV1,<0,-Yrot1,0>);
#declare Cyltex= texture{pigment{rgb <0,0,0.3*1>} finish{ambient 1 diffuse 0} }
#declare Cylrad=0.012;
#declare Cylrad2=0.006;   
#declare Normthresh = .1;
#declare MeshFile = "logo2_cone_mesh.inc";
#declare EdgeFile = "logo2_cone_edge_perl.inc";
#declare LogoConeEdge=sphere{1,0};
#declare LogoConeNormEdge=sphere{1,0};
EdgeMesh01(MeshFile,EdgeFile,LogoConeEdge,LogoConeNormEdge,Normthresh,Cylrad,Cylrad2,Cyltex,PdV1)    

//Edges for the sphere
#declare PdV1=PdV-Trans1; 
#declare PdV1=vrotate(PdV1,<0,-Yrot1,0>);
#declare Cyltex= texture{pigment{rgb <0,0,0.3*1>} finish{ambient 1 diffuse 0} }
#declare Cylrad=0.012;
#declare Cylrad2=0.006;   
#declare Normthresh = .1;
#declare MeshFile = "logo2_sphere_mesh.inc";
#declare EdgeFile = "logo2_sphere_edge_perl.inc";
#declare LogoSphereEdge=sphere{1,0};
#declare LogoSphereNormEdge=sphere{1,0};
EdgeMesh01(MeshFile,EdgeFile,LogoSphereEdge,LogoSphereNormEdge,Normthresh,Cylrad,Cylrad2,Cyltex,PdV1)

#declare Edges= union{
object{LogoArchEdge}
object{LogoArchNormEdge}    
object{LogoConeEdge}
object{LogoConeNormEdge} 
object{LogoSphereEdge}
object{LogoSphereNormEdge}
}

object{Edges rotate y*Yrot1 translate Trans1}          

          
          
//---------we place the second logo     (nb: we reload the inc file, to change the texture)
#declare Mlogo_WingsMat1 =
  texture{
      pigment{ LightBlue}
      finish{ Flatf}
}
#declare Mlogo_WingsMat2 =  Mlogo_WingsMat1;
#declare Mlogo_WingsMat3 =  Mlogo_WingsMat1;
#include"logo2.inc"                                                                                                 
#declare Logo= union{
 object{Logo2_Arch}
 object{Logo2_Cone}
 object{Logo2_Sphere}
}
#declare Yrot2=-20; #declare Trans2=<-2.65,0,0>;
object{Logo rotate y*Yrot2 translate Trans2}

//----------Edges for this logo.  Note that the inverse transformation is applied to the PdV used !
//Edges for the arch  
#declare PdV1=PdV - Trans2;   
#declare PdV1=vrotate(PdV1,<0,-Yrot2,0>);
#declare Cyltex= texture{pigment{rgb <0,0,0.>} finish{ambient 1 diffuse 0} }
#declare Cylrad=0.012*2;
#declare Cylrad2=0.006*2;   
#declare Normthresh = .01;
#declare MeshFile = "logo2_arch_mesh.inc";
#declare EdgeFile = "logo2_arch_edge_perl.inc";
#declare LogoArchEdge=sphere{1,0};
#declare LogoArchNormEdge=sphere{1,0};
EdgeMesh01(MeshFile,EdgeFile,LogoArchEdge,LogoArchNormEdge,Normthresh,Cylrad,Cylrad2,Cyltex,PdV1)    

//Edges for the cone
#declare PdV1=PdV-Trans2; 
#declare PdV1=vrotate(PdV1,<0,-Yrot2,0>);
#declare Cyltex= texture{pigment{rgb <0,0,0.>} finish{ambient 1 diffuse 0} }
#declare Cylrad=0.012*2;
#declare Cylrad2=0.006*2;   
#declare Normthresh = .1;
#declare MeshFile = "logo2_cone_mesh.inc";
#declare EdgeFile = "logo2_cone_edge_perl.inc";
#declare LogoConeEdge=sphere{1,0};
#declare LogoConeNormEdge=sphere{1,0};
EdgeMesh01(MeshFile,EdgeFile,LogoConeEdge,LogoConeNormEdge,Normthresh,Cylrad,Cylrad2,Cyltex,PdV1)    

//Edges for the sphere
#declare PdV1=PdV-Trans2; 
#declare PdV1=vrotate(PdV1,<0,-Yrot2,0>);
#declare Cyltex= texture{pigment{rgb <0,0,0.>} finish{ambient 1 diffuse 0} }
#declare Cylrad=0.012*2;
#declare Cylrad2=0.006*2;   
#declare Normthresh = .1;
#declare MeshFile = "logo2_sphere_mesh.inc";
#declare EdgeFile = "logo2_sphere_edge_perl.inc";
#declare LogoSphereEdge=sphere{1,0};
#declare LogoSphereNormEdge=sphere{1,0};
EdgeMesh01(MeshFile,EdgeFile,LogoSphereEdge,LogoSphereNormEdge,Normthresh,Cylrad,Cylrad2,Cyltex,PdV1)

#declare Edges= union{
object{LogoArchEdge}
object{LogoArchNormEdge}    
object{LogoConeEdge}
object{LogoConeNormEdge} 
object{LogoSphereEdge}
object{LogoSphereNormEdge}
}

object{Edges rotate y*Yrot2 translate Trans2}          

  
  
//---------we place the thirdlogo     (nb: we reload the inc file, to change the texture)
#declare LogoPigment =
pigment {
   planar scale (max_extent(Logo2_Arch).y+abs(min_extent(Logo2_Cone).y) ) translate y*min_extent(Logo2_Cone)
   color_map {
      [0.0, color <0.4, 0.4, 1.0>] // Blue
      [0.5, color <0.4, 0.9, 0.4>] // Green
      [1.0, color <1.0, 0.4, 0.4>] // Red
      
   }
}  
#declare LogoPigmentEdge = 
pigment {
   planar scale  (max_extent(Logo2_Arch).y+abs(min_extent(Logo2_Cone).y) ) translate y*min_extent(Logo2_Cone)
   color_map { 
      [0.0, color <0.4, 0.4, 1.0>/4] // Blue
      [0.5, color <0.4, 0.9, 0.4>/4] // Green
      [1.0, color <1.0, 0.4, 0.4>/4] // Red
   }
}
#declare Mlogo_WingsMat1 =
  texture{
      pigment{ LogoPigment}
      finish{ Toonf}
} 
#declare Mlogo_WingsMat2 =  Mlogo_WingsMat1;
#declare Mlogo_WingsMat3 =  Mlogo_WingsMat1;


#include"logo2.inc"                                                                                                 
#declare Logo= union{
 object{Logo2_Arch}
 object{Logo2_Cone}
 object{Logo2_Sphere}
}
#declare Yrot2=-10;    
#declare Trans3=<0,0,.5> ;
object{Logo  translate Trans3}

//----------Edges for this logo.  Note that the inverse transformation is applied to the PdV used !
//Edges for the arch  
#declare PdV1=PdV - Trans3;   
#declare Cyltex= texture{pigment{LogoPigmentEdge} finish{ambient 1 diffuse 0} }
#declare Cylrad=0.012*1.5;
#declare Cylrad2=0.006*1.5;   
#declare Normthresh = .01;
#declare MeshFile = "logo2_arch_mesh.inc";
#declare EdgeFile = "logo2_arch_edge_perl.inc";
#declare LogoArchEdge=sphere{1,0};
#declare LogoArchNormEdge=sphere{1,0};
EdgeMesh01(MeshFile,EdgeFile,LogoArchEdge,LogoArchNormEdge,Normthresh,Cylrad,Cylrad2,Cyltex,PdV1)    

//Edges for the cone
#declare PdV1=PdV-Trans3;
#declare PdV1=vrotate(PdV1,<0,-Yrot2,0>);
#declare Cyltex= texture{pigment{LogoPigmentEdge} finish{ambient 1 diffuse 0} }
#declare Cylrad=0.012*1.5;
#declare Cylrad2=0.006*1.5;   
#declare Normthresh = .1;
#declare MeshFile = "logo2_cone_mesh.inc";
#declare EdgeFile = "logo2_cone_edge_perl.inc";
#declare LogoConeEdge=sphere{1,0};
#declare LogoConeNormEdge=sphere{1,0};
EdgeMesh01(MeshFile,EdgeFile,LogoConeEdge,LogoConeNormEdge,Normthresh,Cylrad,Cylrad2,Cyltex,PdV1)    

//Edges for the sphere
#declare PdV1=PdV-Trans3; 
#declare PdV1=vrotate(PdV1,<0,-Yrot2,0>);
#declare Cyltex= texture{pigment{LogoPigmentEdge} finish{ambient 1 diffuse 0} }
#declare Cylrad=0.012*1.5;
#declare Cylrad2=0.006*1.5;   
#declare Normthresh = .1;
#declare MeshFile = "logo2_sphere_mesh.inc";
#declare EdgeFile = "logo2_sphere_edge_perl.inc";
#declare LogoSphereEdge=sphere{1,0};
#declare LogoSphereNormEdge=sphere{1,0};
EdgeMesh01(MeshFile,EdgeFile,LogoSphereEdge,LogoSphereNormEdge,Normthresh,Cylrad,Cylrad2,Cyltex,PdV1)

#declare Edges= union{
object{LogoArchEdge}
object{LogoArchNormEdge}    
object{LogoConeEdge}
object{LogoConeNormEdge} 
object{LogoSphereEdge}
object{LogoSphereNormEdge}
}

object{Edges translate Trans3}          
          