#!/usr/bin/perl -w                                                                                       

#//author : Thibaut Jonckheere
#//date : May 2006
#//coypright : you can use and modify this file for any use 
#//            as long as credit to the original work is given

#perl script to construct the edge structure of a given mesh fron the face indices structure
#-------------------------------------------------------------------------------------------------------

$meshdata= "< logo2_arch_face.inc";
open(F_in,$meshdata) or die "probleme a l'ouverture du fichier $meshdata #!";

$edgedata= "> logo2_arch_edge_perl.inc";
open(F_out,$edgedata) or die "probleme a l'ouverture du fichier $edgedata #!";



#we read the file : the face info is contained in one big line
$line = <F_in>;
@donnees= split(/,/,$line);
close(F_in);

#Nf is the number of face - each face contains 3 vertex indices
$Nf=$donnees[0];

for($iloop=1;$iloop<$Nf+1;$iloop++) {
  $faces[$iloop-1][0]= $donnees[3*$iloop-2];
  $faces[$iloop-1][1]= $donnees[3*$iloop-1];
  $faces[$iloop-1][2]= $donnees[3*$iloop];
}

#for($iloop=0;$iloop<$Nf;$iloop++) {
#  print STDOUT "\n face $iloop : <$faces[$iloop][0], $faces[$iloop][1], $faces[$iloop][2]> ";
#}

#we fill the edge array, where we will put the edge info
for($iloop=0;$iloop<(3/2)*$Nf;$iloop++) {
  $edge[$iloop][0]=0;
  $edge[$iloop][1]=0;
  $edge[$iloop][2]=0.5;
  $edge[$iloop][3]=0.5;
 # print STDOUT "\n iloop=$iloop, $edge[$iloop][0],$edge[$iloop][1],$edge[$iloop][2],$edge[$iloop][3],";
}


$Nedge=0;
for($iloop=0;$iloop<$Nf;$iloop++) {
  $flagxy=0;
  $flagyz=0;
  $flagzx=0; 
  $vertx= $faces[$iloop][0];
  $verty= $faces[$iloop][1];
  $vertz= $faces[$iloop][2];
  for($Jloop=0;$Jloop<$Nedge;$Jloop++){
   $vertA=$edge[$Jloop][0];
   $vertB=$edge[$Jloop][1];
   #we first look if we have meet the edges of this face before
    if($flagxy==0){
      if(abs($vertA - $vertx)+abs($vertB - $verty)==0){
        $edge[$Jloop][3] = $edge[$Jloop][3] + $iloop - 0.5;
        $flagxy=1;
      }
       if(abs($vertA - $verty)+abs($vertB - $vertx)==0){
        $edge[$Jloop][3] = $edge[$Jloop][3] + $iloop - 0.5;
        $flagxy=1;
      }
    }
    if($flagyz==0){
      if(abs($vertA - $verty)+abs($vertB - $vertz)==0){
        $edge[$Jloop][3] = $edge[$Jloop][3] + $iloop - 0.5;
        $flagyz=1;
      }
       if(abs($vertA - $vertz)+abs($vertB - $verty)==0){
        $edge[$Jloop][3] = $edge[$Jloop][3] + $iloop - 0.5;
        $flagyz=1;
      }
    }
    if($flagzx==0){
      if(abs($vertA - $vertz)+abs($vertB - $vertx)==0){
        $edge[$Jloop][3] = $edge[$Jloop][3] + $iloop - 0.5;
        $flagzx=1;
      }
      if(abs($vertA - $vertx)+abs($vertB - $vertz)==0){
        $edge[$Jloop][3] = $edge[$Jloop][3] + $iloop - 0.5;
        $flagzx=1;
      }
    }
    if($flagxy+$flagyz+$flagzx==3){
      $Jloop=$Nedge;
    }

  }  #end of the Jloop loop

    #the edges of this face which have not been met before are added in the array
    if($flagxy==0){
      $edge[$Nedge][0]=$vertx;
      $edge[$Nedge][1]=$verty;
      $edge[$Nedge][2]=$iloop;
      $Nedge=$Nedge+1;
    }
    if($flagyz==0){
      $edge[$Nedge][0]=$verty;
      $edge[$Nedge][1]=$vertz;
      $edge[$Nedge][2]=$iloop;
      $Nedge=$Nedge+1;
    }
    if($flagzx==0){
      $edge[$Nedge][0]=$vertz;
      $edge[$Nedge][1]=$vertx;
      $edge[$Nedge][2]=$iloop;
      $Nedge=$Nedge+1;
    }

    if($Nedge/100 - int($Nedge/100)==0){
      print STDOUT "\n Nedge = $Nedge   et   iloop = $iloop";
    }

}  #end of the Iloop loop

 print STDOUT "\n Fin : Nedge = $Nedge   et   iloop = $iloop";



 print F_out "$Nedge,";
 for($iloop=0;$iloop<$Nedge;$iloop++) {
  print F_out "$edge[$iloop][0],$edge[$iloop][1],$edge[$iloop][2],$edge[$iloop][3],";
 #print STDOUT "\n iloop=$iloop, $edge[$iloop][0],$edge[$iloop][1],$edge[$iloop][2],$edge[$iloop][3],";
}


close(F_out);
