// March 2006 
// author : Thibaut Jonckheere
// Macro to create the edges of a given object
// input : mesh structure of the object + edge structure (computed independently) 
// Coypright : you can use and modify this file for any use 
//            as long as credit to the original work is given  


  

//MeshFile: the file containing the mesh info
//EdgeFile: the file containing the edge info
//EdgeObject: on output, contains the object defining the silouhette edge (union of cylinders)
//EdgeNormObject: on output, contains the object defining the crease edges (union of cylinders)
//Normthresh: threshold for the crease edge
// Cylrad : radius of the cylinders defining the silouhette edge
// Cylrad2 : radius of the cylinders defining the crease edges
// Cyltex : texture of the cylinders  
// PdV : effective point of vue  

#macro EdgeMesh01(MeshFile,EdgeFile,EdgeObject,EdgeNormObject,Normthresh,Cylrad,Cylrad2,Cyltex,PdV)
#fopen Mesh_data MeshFile read                     
// we read the vertice info (number, then coordinates of each vertices)
#declare Nv=100;
#read(Mesh_data,Nv)
#debug concat(" Nv= ",str(Nv,3,1)," \n")
#declare V= array[Nv];
#declare V[0]=<0,0,0>;
#declare I=0;
#while(I<Nv)
 #read(Mesh_data,V[I])
 #declare I=I+1; 
#end
// We read the normal info (number, then vector for each normal)
#declare Nn=100;
#read(Mesh_data,Nn)
#declare Normals= array[Nn];
#declare Normals[0]=<0,0,0>;
#declare I=0;
#while(I<Nn)
 #read(Mesh_data,Normals[I]) 
 #declare I=I+1; 
#end
//we read the faces indices
#declare Nf=100;
#read(Mesh_data,Nf)
#declare A=<0,0,0>;#declare B=0;
#declare Faces= array[Nf];
#declare Faces[0]=<0,0,0>;
#declare I=0;
//loop on the faces 
#while(I<Nf)
  #read(Mesh_data,A,B) 
  #declare Faces[I]=A; 
  #declare I=I+1; 
#end
//#fclose Mesh_data  

//we read the normal indices info
#declare Nni=100;
#read (Mesh_data,Nni)
#declare A=<0,0,0>;
#declare Normal_indices= array[Nni];
#declare Normal_indices[0] = <0,0,0>;
#declare I=0;
#while(I<Nni)
  #read(Mesh_data,A)
  #declare  Normal_indices[I]=A;
  #declare I=I+1;
#end 

#fclose Mesh_data
  


//we read the edge structure
#fopen Edge_array EdgeFile read           
#read(Edge_array,Nedge)
#declare Edge= array[Nedge];
#debug concat("\n Nedge = ",str(Nedge,4,0)) 
#local I=0;
   #while(I<Nedge)
     #read(Edge_array,V1,V2,V3,V4)
     #declare Edge[I]=<V1,V2,V3,V4>;
     #local I=I+1;
   #end
#fclose Edge_array                

// we construct the silouhette edge
#declare  EdgeObject= union{
  #local I=0;
  #while (I<Nedge) 
    // we compute the normals for the two Normal_indices sharing this edge
   #local N1= 1/3*(Normals[Normal_indices[Edge[I].z].x] + Normals[Normal_indices[Edge[I].z].y] +  Normals[Normal_indices[Edge[I].z].z]);
    #local N2= 1/3*(Normals[Normal_indices[Edge[I].t].x] + Normals[Normal_indices[Edge[I].t].y] +  Normals[Normal_indices[Edge[I].t].z]);
    #declare  Viewvec= vnormalize((1/2)*(V[Edge[I].x]+V[Edge[I].y]) - PdV);
    #if(vdot(N2,Viewvec)*vdot(N1,Viewvec)<0.00)
     cylinder{ V[Edge[I].x],V[Edge[I].y],Cylrad no_shadow}
      //sphere { (V[Edge[I].x]+V[Edge[I].y])/2,Cylrad no_shadow}
    #end  
    #local I=I+1;
  #end 
  texture{Cyltex}
}
 
//we construct the crease edges
#declare EdgeNormObject = union{
  #local I=0;
  #while (I<Nedge) 
    // we compute the normals for the two Normal_indices sharing this edge
    #if((abs(Normal_indices[Edge[I].z].x - Edge[I].x)) * (abs(Normal_indices[Edge[I].z].x - Edge[I].y)) )   
       #local N1= Normals[Normal_indices[Edge[I].z].x];
    #else
      #if((abs(Normal_indices[Edge[I].z].y - Edge[I].x)) * (abs(Normal_indices[Edge[I].z].y - Edge[I].y)) ) 
       #local N1= Normals[Normal_indices[Edge[I].z].y];
      #else
       #local N1= Normals[Normal_indices[Edge[I].z].z];
      #end    
    #end    
    #if((abs(Normal_indices[Edge[I].t].x - Edge[I].x)) * (abs(Normal_indices[Edge[I].t].x - Edge[I].y)) )   
       #local N2= Normals[Normal_indices[Edge[I].t].x];
    #else
      #if((abs(Normal_indices[Edge[I].t].y - Edge[I].x)) * (abs(Normal_indices[Edge[I].t].y - Edge[I].y)) ) 
       #local N2= Normals[Normal_indices[Edge[I].t].y];
      #else
       #local N2= Normals[Normal_indices[Edge[I].t].z];
      #end    
    #end   
    #if(vdot(N2,N1)<Normthresh)
     cylinder{ V[Edge[I].x],V[Edge[I].y],Cylrad2 no_shadow} 
   sphere { (V[Edge[I].x]+V[Edge[I].y])/2,Cylrad2 no_shadow}
    #end  
    #local I=I+1;
  #end 
  texture{Cyltex}
} 


#end  //end of macro 