#!/usr/bin/perl

# ascii2df3
# parameter:
# - src_file : string containing the file name to read from
# - dest_file: string containing the file name to write to
sub ascii2df3
{
	my ($src_file, $dest_file) = @_;
	my $buffer;
	my $counter = 1;
	
	open (INFILE, "<$src_file") or die "can't open $src_file \n";
	open (OUTFILE, ">$dest_file") or die "can't open $dest_file \n";
	
	binmode OUTFILE;
	
	$buffer = <INFILE>;
	print OUTFILE pack(n,$buffer);
	$buffer = <INFILE>;
	print OUTFILE pack(n,$buffer);
	$buffer = <INFILE>;
	print OUTFILE pack(n,$buffer);

	while ($buffer = <INFILE>)
	{
		#print "$counter : $buffer\n";
		print OUTFILE pack(n,$buffer);
		$counter++;
	}	
	
	close INFILE;
	close OUTFILE;
}

sub main
{
	my $param_count = @ARGV;

	if ($param_count == 0)
	{
		print "\nusage: perl ascii2df3.pl infile [outfile]\n\n";
	}
	else
	{
		my $infile_name = $ARGV[0];
		my $outfile_name;
	
		if ($param_count > 1)
		{
			$outfile_name = $ARGV[1];
		}
		else
		{
			$outfile_name = $infile_name;
			$outfile_name =~ s/\..+\Z/\.df3/i;
		}
		print "will read from $infile_name\nand write to $outfile_name\n";
	
		ascii2df3($infile_name, $outfile_name );
	}
}

main()
