///Scene Description File:  QM_Random.pov
///Random Alphabetic Quadratic Map Generator  // 
///By Dave Matthews, Minnesota West Community and Technical College//
///May 19, 2006

/*  Set final_frame=Howmany to render Howmany random alphabet attractors:

The family of quadratic maps:  x_N+1 = C0 + C1*x_N + C2*x_N*x_N + C3*x_N*y_N + C4*y_N + C5*y_N*y_N
                                  y_N+1 = C6 + C7*x_N + C8*x_N*x_N + C9*x_N*y_N + C10*y_N + C11*y_N*y_N 
                                  
Some examples are given in:  http://mathworld.wolfram.com/StrangeAttractor.html

S. Sprott looked at the family of maps with coefficients in the range { -1.2, 1.2 } coded by letters:
A = -1.2, B = -1.1, ... Y = 1.2 (This file also generates Z = 1.3.  You can remove that option by simply 
changing the "26" to "25" throughout the FillArray macro)

According to Sprott, as quoted at MathWorld, the 12-letter strings correspond, in about 1.6 % of the cases, 
to chaotic strange attractors.  

In many more cases, they will correspond to 1-dimensional loop attractors - also with chaotic orbits, but not "strange," or cluster point 
(a few isolated dots) attractors, and, most commonly, they will diverge, and you'll see a blank graph.

This file discards attractors that diverge, or that converge to 32 or fewer cluster points (you can change this number).

The variable CT tells how many random strings had to be generated before a suitable string was found.

*/

#declare RSeed = 4133;         //change this number to generate other sets of attractors 


#default { finish{ambient 0.9} } // since there's no light


#declare Cen = <0, 0>;     // Camera Center
#declare Fac = 24;         // Camera width = 4*Fac, height = 3*Fac

#declare N_Of_Pts = 12000;   
#declare Rad = 0.13;
#declare Eps = 0.000001;   //Decision factor on whether a cluster point has been reached
#declare ClusterPts = 32;  //Maximum number of cluster points disallowed (Actual number of ClusterPts > ClusterPts will render) 
#declare BailOut = 1000000; //When orbits are greater than sqrt(BailOut) from (0,0), we say the orbit diverges

#declare XStart = 0;       //Considering orbits with starting point (0, 0)
#declare YStart = 0;

#macro FillArray(C, L)
#declare C[0] =   floor(26*rand(L))/10 - 1.2; 
#declare C[1] =   floor(26*rand(L))/10 - 1.2;
#declare C[2] =   floor(26*rand(L))/10 - 1.2;
#declare C[3] =   floor(26*rand(L))/10 - 1.2;
#declare C[4] =   floor(26*rand(L))/10 - 1.2;
#declare C[5] =   floor(26*rand(L))/10 - 1.2;

#declare C[6] =  floor(26*rand(L))/10 - 1.2;
#declare C[7] =  floor(26*rand(L))/10 - 1.2;
#declare C[8] =  floor(26*rand(L))/10 - 1.2;
#declare C[9] =  floor(26*rand(L))/10 - 1.2;
#declare C[10] = floor(26*rand(L))/10 - 1.2;
#declare C[11] = floor(26*rand(L))/10 - 1.2;
#end

#declare C_A = array[12];

#declare R1 = seed (RSeed + frame_number); 

#declare I = 0;  

#declare CT = 0;

#while ((I < N_Of_Pts-2) & (CT < 1000))  

#declare CT = CT + 1;


FillArray(C_A,R1) 
#declare X0 = XStart;
#declare Y0 = YStart;

#declare Flag = 1; 
#declare Cluster=array[ClusterPts];
#local fd = 0;
#while (fd<ClusterPts)
#declare Cluster[fd]=<0,0>;
#local fd = fd+1;
#end 

#declare I = 0;
#while ((I < N_Of_Pts) & (X0*X0 + Y0*Y0 < BailOut ) & Flag) 
#if (I > 4000)
sphere { 0, Rad  scale (1 + 0.1*I/N_Of_Pts) pigment { color rgb <0.4*I/N_Of_Pts,0.7*(I/N_Of_Pts)*(I/N_Of_Pts),0> }  translate 10*<X0,0,Y0>}
#end
#declare XN = C_A[0] + C_A[1]*X0 + C_A[2]*X0*X0 + C_A[3]*X0*Y0 + C_A[4]*Y0 + C_A[5]*Y0*Y0;
#declare YN = C_A[6] + C_A[7]*X0 + C_A[8]*X0*X0 + C_A[9]*X0*Y0 + C_A[10]*Y0 + C_A[11]*Y0*Y0; 
 
 
#local Top = 20;
#local fd = 0;
#while (fd < ClusterPts)
#local Top = min(Top,vlength(<XN,YN> - Cluster[fd]));
#local fd = fd + 1;
#end

#if (Top < Eps) #declare Flag = 0;
#else 
#local fd = 0;
#while (fd < ClusterPts - 1)
#declare Cluster[fd] = Cluster[fd+1];
#local fd = fd+1;
#end
#declare Cluster[ClusterPts - 1] = <XN,YN>;
#declare X0 = XN;
#declare Y0 = YN;

#end  

#declare I = I + 1;
#end  

#end

cylinder { <-80*Fac,-1,  0>, <80*Fac,-1,  0>, .005*Fac pigment { color rgb z } } // x-axis
cylinder { <0, -1, -80*Fac>, <0, -1, 80*Fac>, .005*Fac pigment { color rgb z } } // y-axis

plane { y, -1 pigment { checker pigment { color rgb <0.7, 0.9, 1> } pigment { color rgb <0.93, 1, 1> } scale 4}  } //background grid


// Here's the orthographic camera.  The "4" and "3" are for the width to height ratio of the render.  Change
// these if you use other dimensions in your render!
camera {orthographic location <Cen.x,20,Cen.y> look_at <Cen.x,0,Cen.y> right 4*x*Fac up 3*y*Fac }   
 

union {
text   { ttf "timrom.ttf", concat("C0:  ",str(C_A[0],0,1),"  ",chr(10*(C_A[0]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-20>}
text   { ttf "timrom.ttf", concat("C1:  ",str(C_A[1],0,1),"  ",chr(10*(C_A[1]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-22>}
text   { ttf "timrom.ttf", concat("C2:  ",str(C_A[2],0,1),"  ",chr(10*(C_A[2]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-24>}
text   { ttf "timrom.ttf", concat("C3:  ",str(C_A[3],0,1),"  ",chr(10*(C_A[3]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-26>}  
text   { ttf "timrom.ttf", concat("C4:  ",str(C_A[4],0,1),"  ",chr(10*(C_A[4]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-28>}
text   { ttf "timrom.ttf", concat("C5:  ",str(C_A[5],0,1),"  ",chr(10*(C_A[5]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-30>}
text   { ttf "timrom.ttf", concat("C6:  ",str(C_A[6],0,1),"  ",chr(10*(C_A[6]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-32>}
text   { ttf "timrom.ttf", concat("C7:  ",str(C_A[7],0,1),"  ",chr(10*(C_A[7]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-34>}
text   { ttf "timrom.ttf", concat("C8:  ",str(C_A[8],0,1),"  ",chr(10*(C_A[8]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-36>}
text   { ttf "timrom.ttf", concat("C9:  ",str(C_A[9],0,1),"  ",chr(10*(C_A[9]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-38>}
text   { ttf "timrom.ttf", concat("C10: ",str(C_A[10],0,1),"  ",chr(10*(C_A[10]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-40>}
text   { ttf "timrom.ttf", concat("C11: ",str(C_A[11],0,1),"  ",chr(10*(C_A[11]+1.2)+65)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-42>} 
text   { ttf "timrom.ttf", concat("CT:  ",str(CT,0,0)),  0.1,  0  pigment { color 0.7*x } 
          scale <2.2,2,1> rotate 90*x translate <25,1,-44>} 
translate <10,0,12> }
