// Paolo Gibellini, 16/05/2006
// Abstract flight through hills slices
// birds.inc is a povworld object

#include "textures.inc" 
#include "functions.inc"
#include "birds.inc"

global_settings {
  	assumed_gamma 1.0
}

camera{
    location <0, 2, -2>
    look_at <0,0.5,0>
    angle 80
}


light_source{ <1500,2500,-2500> color rgb <1,1,1> }

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}


plane{ <0,1,0>, 0 
       texture{ 
		pigment { 
         image_map { 
            function 10,10 { 
               pigment { checker 1,0 scale .5  }
            }
         }
         rotate x*90
      	} 
       } 
} 

#declare f_hills2=function(x, y, z,ma,mi) {
	min(abs(sin(y*3*pi)-sin(x*3*pi))*f_noise3d(x,0,z)*0.8,ma)
};

#declare h_max=2; // empiric
#declare n_slices=10;
#declare i=h_max/n_slices;
#while(i<h_max)

	#declare h=height_field {
	      function 100,100 {
			pigment {
				function {f_hills2(x,y,z,i,i-1)}
	            ramp_wave
	            turbulence 0.2
	            //turbulence 0.7
	            octaves 7
	            lambda 0.5
	            omega 0.5
	            scale 0.5
	         }      
	      }
	    smooth
	    translate <-0.5,0,-0.5>
	    scale <10,3,10>/2
	}
	 
	
	#declare fh=object {
		difference{
			object {h}
			box {<-10,-1,10> <10,(i-h_max/n_slices+0.15),-10>}
		}
	    
	}
	object{fh 
		pigment {rgb 1}
	    finish {specular 0.1 roughness 2}
	}
	object{fh 
		//pigment {rgbf <0,0.8,0,0.9>} 
		pigment {rgbf <0.6,0.7,1.0,0.9>} 
		
	    finish {specular 0.1 roughness 2}
		translate <0,0.3,2>
	}
	#declare i=i+(h_max/n_slices)*2; 
#end

object { Bird (clock)
	scale 0.05
	translate <-1,1,0.4>
  	rotate <0,-160,0>
}     
