
#version 3.6;

global_settings {assumed_gamma 1.0}

camera {location  <-15,5,-10> look_at <-1,0,0> angle 30}

background {rgb 0}

light_source {<-30, 100, -30> color rgb 1}

// --- some textures ---
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare Texture1 = texture {   pigment {
     cells 
       colour_map {
          [0.0 rgb <0.4,0.4,0.5>]
          [1.0 rgb <0.3,0.3,0.4>]
       }
       scale 0.5
     }
 finish {phong 1 metallic}
}
#declare Texture2 = texture {T_Stone8 scale 3}
#declare Texture3 = texture {T_Stone13 scale 3}

// individual greeble textures will be chosen from within this texture map
#declare tmap = texture_map{
   [0.0 Texture2]
   [0.5 Texture1]
   [1.0 Texture3]
}   
// ----------------------


#declare R=seed(66);    // main random number seed


#declare TorusPart = intersection {
  torus { 0.6, 0.3 }
  box {<-1,0,0><1,0.3,1>}
}



#macro Greeble(X, Y, D, minD, maxD, tmap, R)
  // ===========================================================================
  // The parameters are:
  // X,Y   dimensions:  the greeble plate will cover the box <-X,0,-Y><X,0,Y>
  // D     current recursion depth:  always set this to zero in the initial call
  // minD  minimum recursion depth:  controls the size of the largest unit
  // maxD  maximum recursion depth:  controls the size of the smallest unit
  // tmap  texture map:  the textures will be randomly selected from this
  // R     random number seed
  // ===========================================================================

  // === Consider splitting the zone into smaller bits ===
  #if (((D < maxD) & (rand(R) < 0.7)) | (D < minD)) // split the greeble zone
    #local S1 = int(rand(R)*14);
    #switch (S1) 
      #case (0) // SPlit into three identical subunits
        #if (X>Y)
          #local G = object{Greeble(X/3, Y,  D+1, minD, maxD, tmap, R)};
          union {
            object {G}
            object {G translate x*X*2/3}
            object {G translate -x*X*2/3}
          }      
        #else
          #local G = object {Greeble(X, Y/3,  D+1, minD, maxD, tmap, R)};
          union {
            object {G}
            object {G translate z*Y*2/3}
            object {G translate -z*Y*2/3}
          }      
        #end
      #break
      #case (1) // SPlit into two identical subunits
        #if (X>Y)
          #local G = object{Greeble(X/2, Y,  D+1, minD, maxD, tmap, R)};
          union {
            object {G translate x*X*0.5}
            object {G translate -x*X*0.5}
          }      
        #else
          #local G = object {Greeble(X, Y/2,  D+1, minD, maxD, tmap, R)};
          union {
            object {G translate z*Y*0.5}
            object {G translate -z*Y*0.5}
          }      
        #end
      #break
      #range (2,7) // Simple X Split
       union {
        object {Greeble(X/2, Y,  D+1, minD, maxD, tmap, R) translate 0.5*x*X}
        object {Greeble(X/2, Y,  D+1, minD, maxD, tmap, R) translate -0.5*x*X}
       }
      #break
      #range (8,13) // Simple Y Split
       union {
        object {Greeble(X, Y/2,  D+1, minD, maxD, tmap, R) translate 0.5*z*Y}
        object {Greeble(X, Y/2,  D+1, minD, maxD, tmap, R) translate -0.5*z*Y}
       }
      #break
    #end      
  #else
  
    //  ===   Choose a Greeble unit ===
    #local G1 = int(rand(R)*7);
    #local XY = min(X,Y);
    
    #switch (G1)
      #case (0) // Half Torus  
        #if (X>Y)
          union {
            box {<-X,0,-Y><X,min(X,Y)*0.01,Y>}
            object {TorusPart scale <Y,Y/3,Y> rotate y*90 translate x*(X-Y)}
            object {TorusPart scale <Y,Y/3,Y> rotate -y*90 translate x*(Y-X)}
            cylinder {<X,0,0><-X,0,0>0.3 scale <(X-Y)/X,Y/3,Y> translate z*Y*0.6}
            cylinder {<X,0,0><-X,0,0>0.3 scale <(X-Y)/X,Y/3,Y> translate -z*Y*0.6}
        #else
          union {
            box {<-X,0,-Y><X,min(X,Y)*0.01,Y>}
            object {TorusPart scale <X,X/3,X> translate z*(Y-X)}
            object {TorusPart scale <X,X/3,X> rotate -y*180 translate z*(X-Y)}
            cylinder {<0,0,Y><0,0,-Y>0.3 scale <X,X/3,(Y-X+0.00001)/Y> translate x*X*0.6}
            cylinder {<0,0,Y><0,0,-Y>0.3 scale <X,X/3,(Y-X+0.00001)/Y> translate -x*X*0.6}
        #end
      #break
      #case (1) // Box with subgreeble
        #if (D<maxD) 
          union {
            object {Greeble(X,Y,D+1,minD,maxD,tmap,R) scale 0.75 translate min(X,Y)*0.2*y}
            box {<-X,0,-Y><X,min(X,Y)*0.2,Y>}
        #else
           box {<-X,0,-Y><X,min(X,Y)*0.2,Y>
        #end
      #break
      #case (2) // Rings
        union {
          box {<-X,0,-Y><X,min(X,Y)*0.05,Y>}
          #local C = difference {
            cylinder {0,<0,0.1*XY,0>,XY*0.9}
            cylinder {0,<0,0.2*XY,0>,XY*0.7}
          }
        #if (X>Y)
          object {C translate x*(X-Y)}
          object {C translate x*(Y-X)}
          #if (X>Y*3)
            object {C}
          #end
        #else
          object {C translate z*(X-Y)}
          object {C translate z*(Y-X)}
          #if (Y>X*3)
            object {C}
          #end
        #end
      #break
      #case (3) // Cylinder with rounded ends
        #if (X>Y)
          union {
            box {<-X,0,-Y><X,min(X,Y)*0.05,Y>}
            sphere {<X-Y,0,0>,Y scale <0.8,0.2,0.8>}
            sphere {<Y-X,0,0>,Y scale <0.8,0.2,0.8>}
            cylinder {<X-Y,0,0>,<Y-X,0,0>,Y scale <0.8,0.2,0.8>}
        #else
          union {
            box {<-X,0,-Y><X,min(X,Y)*0.05,Y>}
            sphere {<0,0,X-Y>,X scale <0.8,0.2,0.8>}
            sphere {<0,0,Y-X>,X scale <0.8,0.2,0.8>}
            #if (Y-X>0.00001)
              //#debug concat("X=",str(X,-1,-1)," Y=",str(Y,-1,-1),"\n")
              cylinder {<0,0,X-Y>,<0,0,Y-X>,X scale <0.8,0.2,0.8>}
            #end
        #end
      #break
      #case (4) // Hollow Boxen
        union {
          box {<-X,0,-Y><X,XY*0.05,Y>}
          difference {
            box {<-X*.8,0,-Y*.8><X*.8,XY*0.1,Y*.8>}
            box {<-X*.8+XY*.2,0,-Y*.8+XY*.2><X*.8-XY*.2,XY*0.15,Y*.8-XY*.2>}
          }
          #if (D<maxD) 
            object {Greeble(X*.8-XY*.2,Y*.8-XY*.2,D+1,minD,maxD,tmap,R) translate XY*0.1*y}
          #end
      #break
      #case (5) // Diagonal box with subgeeble which may overlap
        #local rot = int(rand(R)*8)*45;
          union {
            box {<-X,0,-Y><X,min(X,Y)*0.05,Y>}
            box {<-XY,0,-XY><XY,XY,XY> scale <0.7,0.2,0.7> rotate y*rot}
            #if (D<maxD) 
              object {Greeble(XY,XY,D+1,minD,maxD,tmap,R) scale 0.65 translate XY*0.2*y rotate y*rot}
            #end
      #break
      #case (6) // multiple cylinders
        union {
          box {<-X,0,-Y><X,XY*0.05,Y>}
          #local rad = XY/5;
          #local XX=-X+rad;
          #while (XX<X-rad)
            #local YY=-Y+rad;
            #while (YY<Y-rad)
              #if (rand(R)<0.6)
                cylinder {<XX,0,YY><XX,0.2*XY,YY>,rad}
              #end
              #local YY=YY+rad*2;
            #end
            #local XX=XX+rad*2;
          #end
      #break
    #end // of #switch() statement
      
        #local C=rand(R);
        texture {function{C} texture_map{tmap} scale XY translate x*rand(R)*100}
    }
  #end
#end

// ==== Build a simple ship from five greebled plates =====


#declare Plate1 = object {Greeble(5,1,0,5,10,tmap,R) scale <1,3,1>}
#declare Plate2 = object {Greeble(5,1,0,5,10,tmap,R) scale <1,3,1>}
#declare Plate3 = object {Greeble(1,1,0,5,9,tmap,R) scale <1,3,1>}
#declare Plate4 = object {Greeble(2,1.5,0,5,9,tmap,R) scale <1,3,1>}
#declare Plate5 = object {Greeble(0.2,1.5,0,5,7,tmap,R) scale <1,3,1>}


#declare Hull =
union {
  #declare H = 1;
  object {Plate1 translate <0,H,0>}
  object {Plate2 translate <0,H,0> rotate x*90}
  object {Plate1 translate <0,H,0> rotate x*90*2}
  object {Plate2 translate <0,H,0> rotate x*90*3}
  object {Plate3 rotate z*90 translate <-5,0,0> }
  rotate x*45
}                                                          

#declare spar = union {
  object {Plate4 translate y*0.2}
  object {Plate5 rotate z*90 translate <-2,0,0>}
}

#declare Ship = union {
  object {Hull translate -z*2.5}
  object {Hull rotate x*90 translate z*2.5}
  object {spar translate -x*1.5}
}

object {Ship rotate <-15,0,-10>}    
