#version 3.6;
#include "colors.inc"
#include "skies.inc"
#include "shapes.inc"
#include "shapes2.inc"


#include "math.inc"
#include "transforms.inc"
sky_sphere{S_Cloud1}


#declare Sk=0.75;
#declare Sj=0.75;
#declare maxshape = 26;
#declare maxprism = 6;




plane{y,0 pigment{color rgb .05}}

               
#declare R=seed(1);

#include "Building7.inc"

#declare CITY = union {

#declare J=0;
#while (J<=7)
  #declare K=0;
  #while (K<=7)
    #declare W=5+int(rand(R)*10);
    #declare D=5+int(rand(R)*7);
    #declare F=20+int(rand(R)*(10-sqrt(J*J+K*K))*6 );
    #declare T=int(rand(R)*41)+1;
    #declare RB=0;
    #if (rand(R) < 0.8)
      #declare RB=1;
    #end
    #declare I=1;
    #while (I<512)
      #if (rand(R) < 0.2)
        #declare RB=RB+I;
      #end
      #declare I=I*2;
    #end
    #if (RB = 0)
      #declare RB=1;
    #end
    #if (rand(R) < 0.1)
      #declare RB=RB+512;
    #end
    #declare Shape=int(rand(R)*maxshape);
    #declare Prism=int(rand(R)*maxprism);
    
    Building(W,D,F,<200*J,0,200*K>,T, RB, Shape, Prism)
    
    
    #declare K=K+Sk;
  #end	
  #declare J=J+Sj;
#end

}

global_settings {assumed_gamma 1.0}


#declare ZZ=-1500;
#while (ZZ<=3000)
  #declare XX=-4500;
  #while (XX<=0)
    object {CITY translate <XX,0,ZZ>}
    #declare XX=XX+1500;
  #end
  #declare ZZ=ZZ+1500;
#end  
                                   
                                   

#declare S = spline {natural_spline
-0.4, <1500, 450, -1500-600+180>
 0.0, <625,600,-1500>
 0.2, <500,620,-1500+180*2>
 0.3, <400,600,-1500+180*3>
 0.4, <220,550,-1500+180*4> 
 0.5, <50, 500, -600>
 0.6, <0, 450, -600+180>
 
 1.0, <-875, 600, 0>
 1.2, <-900,620,180*2>
} 
 
camera {
  location 0
  look_at <0,-0.33,1>
  translate <0,0.4,0.4>
  Spline_Trans (S, clock, y, 0.05, 0.25)
}

// Move the light source in parallel with the camera location
// So that the lighting on the final building is the same as the first
 
light_source {<-3000, 10000, -3000>+S(clock) color rgb 2}

 