// File for testing an individual building

#version 3.6;
global_settings {assumed_gamma 1.0
}

#include "colors.inc"
#include "skies.inc"
#include "shapes.inc"
#include "shapes2.inc"

camera{
  location <800,800,-1200>
  look_at<0,100,0>
  angle 18	
}
light_source {<-3000, 10000, -3000> color rgb 2.5}
plane{y,0 pigment{color rgb .25}}


               
#declare R=seed(10);

#include "Building7.inc"

// The parameters are Width, Depth, Height, Translation, Texture Number, Roof Bits, Shape
//
// Texture Numbers are normally 1 to 41, 
//         0 is a special test texture 
//         which has a plain mid-gray base layer
//         for testing the upper layers
//
// Roof Bits  is a bit encoded number indicating the roof furniture
//         e.g. bit 1  is a perimeter wall
//              bit 32 is a central radio tower
//         so 33 is perimeter wall and radio tower
//
// Shape   There are currently 15 building shapes
//         out of range shape numbers are treated as simple rectangles
//
// Prism   Only works with shape numbers that represent "Prism" buildings
//         Indicates the shape of the prism
//           1 = octagon
//           else Triangle
//
// Some shapes are incompatible with some roof furniture bits, so those
// bits are switched off before the roof is drawn

Building(12,10,20,<0,0,0>,41,513,0,3)


/*

#declare Bod = union {
  cylinder{0,y*5,1.5}
  sphere {y*5.5,1}
  pigment {rgb 0.15}
}

#declare M=0;
#while (M<40)
  #declare XX=150*rand(R)-75;
  #declare ZZ=150*rand(R)-75;
  #declare Norm = <0,0,0>;
  #declare P = trace(B, <XX,10000000,ZZ>, -y, Norm);
  #if (vlength(Norm) = 0)
    object {Bod  translate <XX,0,ZZ>}
  #else
    object {Bod translate P}
  #end
  #declare M=M+1;
#end

*/