// Isn't there an easier way to do this???
#macro BitMask (A,B)
  #local I=1;
  #local C=0;
  #while (I<1024)
    #if ( (mod(floor(A/I),2)) & (mod(floor(B/I),2)) )
      #local C=C+I;
    #end
    #local I=I*2;
  #end
  (C)  
#end



//make a compound building
#macro Building(W, D, H, translation, Tile, RoofBits, Shape, Prism)
  // Arrays that match Scale and Reflection parameters to tile designs
#local N=43;
#local S=array[N+1]{1,
      24,30,24,24,33, 26,26,24,36,24,
      48,50,40,24,24, 34,54,34,15,24,
      40,24,48,38,40, 60,24,50,25,60,      
      50,48,24,30,90, +60,52,30,30,8,
      30,32,40
      }
  #local Ref=array[N+1]{0.0,
      0.1,0.1,0.1,0.0,0.0, 0.1,0.0,0.0,0.0,0.0,
      0.0,0.1,0.0,0.0,0.0, 0.0,0.0,0.0,0.0,0.0,
      0.1,0.0,0.0,0.1,0.1, 0.1,0.0,0.0,0.1,0.1,
      0.0,0.0,0.0,0.0,0.1, 0.0,0.1,0.0,0.1,0.0,
      0.0,0.0,0.1
      }

  #switch (Prism)
    #case (1) // Octagon
      #declare P=9;
      #declare Path = array[P] {<-0.5,0.25>,<-0.25,0.5>,<0.25,0.5>,<0.5,0.25>,<0.5,-0.25>,<0.25,-0.5>,<-0.25,-0.5>,<-0.5,-0.25>,<-0.5,0.25>}
    #break
    #case (2) // Hexagon
      #declare P=7;
      #declare Path = array[P] {<0.5,0>,<0.25,0.433>,<-0.25,0.433>,<-0.5,0>,<-0.25,-0.433>,<0.25,-0.433>,<0.5,0>}
    #break
    #case (3) // Pentagon
      #declare P=6;
      #declare Path = array[P] {<0.5,0>,<0.154,0.475>,<-0.406,0.294>,<-0.406,-0.294>,<0.154,-0.475>,<0.5,0>}
    #break
    #case (4) // Pentagram
      #declare P=6;
      #declare Path = array[P] {<0.5,0>,<-0.406,0.294>,<0.154,-0.475>,<0.154,0.475>,<-0.406,-0.294>,<0.5,0>}
    #break
    #case (5) // clipped rectangle
      #declare P=6;
      #declare Path = array[P] {<0.5,0.5>,<-0.5,0.5>,<-0.5,0.25>,<0.25,-0.5><0.5,-0.5><0.5,0.5>}
    #break
    #else // Triangle
      #declare P=4;
      #declare Path = array[4] {<0.5,0>,<-0.25,-0.433>,<-0.25,0.433><0.5,0>}
    #break
  #end
   

  #local Thick = 3;
  #local File = concat("T",str(Tile,0,0),".jpg");
  #local F = concat("R",str(int(rand(R)*10)+1,0,0),".jpg");
  

  #local Tex = texture {
    pigment {image_map{jpeg File} scale S[Tile]}
    finish{reflection Ref[Tile]}
  }
  texture {
    pigment {rgbf <1-rand(R)*0.1-0.1,1-rand(R)*0.2,1-rand(R)*0.2,  1>}
  }
  texture {
    pigment {cells
      colour_map {
        [0 rgbf <1,1,1,1>]
        [1 rgbf <0.93,0.93,0.93,1>]
      }
      scale 28
    }
  }
  texture {
    pigment {cells
      colour_map {
        [0 rgbf <1,1,1,1>]
        [1 rgbf <0.93,0.93,0.93,1>]
      }
      scale 65
    }
  }
  
  

  #local RTex1 = texture {
    pigment {rgb rand(R)*0.15+0.1}
  }
  texture {
    pigment {cells
      colour_map {
        [0 rgbf <1,1,1,1>]
        [1 rgbf <0.97,0.97,0.97,1>]
      }
      scale 8
    }
  }
  texture {
    pigment {cells
      colour_map {
        [0 rgbf <1,1,1,1>]
        [1 rgbf <0.97,0.97,0.97,1>]
      }
      scale 5
    }
  }


  #local RTex2 = texture{
    pigment {image_map{jpeg F interpolate 2} rotate x*90 scale <W*10,1,D*10> }
  }
  texture {
    pigment {cells
      colour_map {
        [0 rgbf <1,1,1,1>]
        [1 rgbf <0.93,0.93,0.93,1>]
      }
      scale 15
    }
  }



  
  #switch (Shape)
    #case (1) // Cross
      Part(W, W*0.4, H, translation, BitMask(RoofBits, 1023-128-1))
      Part(W*0.4, W, H, translation, BitMask(RoofBits, 1023-128-1))
    #break
    #case (2) // Step 1
      Part(W, D, H*0.75, translation, RoofBits)
      Part(W*0.85, D*0.85, H, translation, RoofBits)
    #break
    #case (3) // Step 2
      Part(W, D, H*0.4, translation, BitMask(RoofBits, 1023-128))
      Part(W*0.6, D, H, translation, RoofBits)
    #break
    #case (4) // Step 3
      Part(W, D, H*0.5, translation, BitMask(RoofBits, 1023-128))
      Part(W, D*0.65, H, translation, RoofBits)
    #break
    #case (5) // Double Step
      Part(W, D, H*0.2, translation, BitMask(RoofBits, 1023-128))
      Part(W*0.7, D*0.9, H*0.75, translation, BitMask(RoofBits, 1023-128))
      Part(W*0.5, D*0.65, H, translation, RoofBits)
    #break
    #case (6) // Slip Cross
      Part(W, D, H*0.8, translation, BitMask(RoofBits, 1023-128-8-16))
      Part(D*0.8, W*0.8, H, translation, RoofBits)
    #break
    #case (7) // H
      Part(W, D*0.3, H, translation, BitMask(RoofBits, 1023-128-8-16-1-32-64))
      Part(W*0.3, D, H, translation-<W*3.5,0,0>, BitMask(RoofBits, 1023-128-8-16-1))
      Part(W*0.3, D, H, translation+<W*3.5,0,0>, BitMask(RoofBits, 1023-128-8-16-1))
    #break
    #case (8) // H
      Part(W*0.5, D, H, translation, BitMask(RoofBits, 1023-128-8-16-1))
      Part(W, D*0.4, H*0.9, translation-<0,0,D*4>, BitMask(RoofBits, 1023-128-8-16-1-32-64))
      Part(W, D*0.4, H*0.9, translation+<0,0,D*4>, BitMask(RoofBits, 1023-128-8-16-1-32-64))
    #break
    #case (9) // Cylinder
      CylPart(W, H, translation, RoofBits)
    #break
    #case (10) // Stepped cylinder
      CylPart(W, H*0.8, translation, BitMask(RoofBits, 512+7))
      CylPart(W*0.8, H, translation, RoofBits)
    #break
    #case (11) // Trefoil
      CylPart(W*0.8, H*0.85, translation+W*5*<sin(0),0,cos(0)>, BitMask(RoofBits, 521+1))
      CylPart(W*0.8, H*0.85, translation+W*5*<sin(2*pi/3),0,cos(2*pi/3)>, BitMask(RoofBits, 521+1))
      CylPart(W*0.8, H*0.85, translation+W*5*<sin(4*pi/3),0,cos(4*pi/3)>, BitMask(RoofBits, 521+1))
      CylPart(W, H, translation, RoofBits)
    #break
    #case (12) // Four corners
      Part(W, D, H, translation, RoofBits)
      Part(W*0.4, D*0.4, H*0.9, translation+<W*5,0,D*5>, BitMask(RoofBits, 1023-128))
      Part(W*0.4, D*0.4, H*0.9, translation+<-W*5,0,D*5>, BitMask(RoofBits, 1023-128))
      Part(W*0.4, D*0.4, H*0.9, translation+<W*5,0,-D*5>, BitMask(RoofBits, 1023-128))
      Part(W*0.4, D*0.4, H*0.9, translation+<-W*5,0,-D*5>, BitMask(RoofBits, 1023-128))
    #break
    #case (13) // Flats
      Part(W/3, D*2/3, H, translation-<W*10/3,0,D*5/3>, BitMask(RoofBits, 1023-24-96))
      Part(W/3, D*2/3, H, translation,  BitMask(RoofBits, 1023-24))
      Part(W/3, D*2/3, H, translation+<W*10/3,0,D*5/3>,  BitMask(RoofBits, 1023-24-96))
    #break
    #case (14) // Flats
      Part(W*2/3, D/3, H, translation-<W*5/3,0,D*10/3>, BitMask(RoofBits, 1023-24-96))
      Part(W*2/3, D/3, H, translation,  BitMask(RoofBits, 1023-24))
      Part(W*2/3, D/3, H, translation+<W*5/3,0,D*10/3>,  BitMask(RoofBits, 1023-24-96))
    #break
    #case (15) // Prism
      ComplexPart(W,D,H, translation, RoofBits)
    #break
    #case (16) // Stepped Prism
      ComplexPart(W*0.6,D*0.6,H, translation, RoofBits)
      ComplexPart(W*0.8,D*0.8,H*0.9, translation, RoofBits)
      ComplexPart(W,D,H*0.75, translation, RoofBits)
    #break
    #case (17) // Stepped Rotated Prism
      ComplexPart(W*0.6,D*0.6,H, translation, RoofBits)
      object {ComplexPart(W*0.8,D*0.8,H*0.85,  <0,0,0>, RoofBits) rotate y*180/(P-1)  translate translation}
      ComplexPart(W,D,H*0.6, translation, RoofBits)
    #break
    #case (18) // Stepped Rotated square 1
      object {Part(W, W, H*0.75, <0,0,0>, RoofBits) rotate y*45 translate translation}
      Part(W*0.8, W*0.8, H, translation, RoofBits)
    #break
    #case (19) // Stepped Rotated square 2
      Part(W*0.6, W*0.6, H, translation, RoofBits)
      object {Part(W, W, H*0.8, <0,0,0>, RoofBits) rotate y*45 translate translation}
      Part(W, W, H*0.8, translation, RoofBits)
    #break
    #case (20) // Spiral of cylinders
      CylPart(W*0.6, H, translation+W*1.5*<1,0,1>, RoofBits)
      CylPart(W*0.6, H*0.8,  translation+W*1.5*<1,0,-1>, RoofBits)
      CylPart(W*0.6, H*0.65, translation+W*1.5*<-1,0,-1>, RoofBits)
      CylPart(W*0.6, H*0.55, translation+W*1.5*<-1,0,1>, RoofBits)
    #break
    #case (21) // Spiral of rectangles
      Part(W*0.6, D*0.6, H, translation+W*1.5*<1,0,1>, RoofBits)
      Part(W*0.6, D*0.6, H*0.6, translation+W*1.5*<1,0,-1>, RoofBits)
      Part(W*0.6, D*0.6, H*0.4, translation+W*1.5*<-1,0,-1>, RoofBits)
      Part(W*0.6, D*0.6, H*0.3, translation+W*1.5*<-1,0,1>, RoofBits)
    #break
    #else // Simple rectangle
      Part(W, D, H, translation, RoofBits)
    #break

  #end
#end  



//make part of a building
#macro Part(W, D, H, translation,RoofBits)
  union {
    // Roof
    box {<0,H*10,0><W*10,H*10+Thick,D*10>
      texture{RTex2}
    }
    // Roof Furniture
    Roof(W,D,H,RoofBits)    
    // Wall 1
    box {<0,0,0><W*10,H*10,Thick>
      texture{Tex}
    }
    // Wall 2
    box {<0,0,0><Thick,H*10,D*10>
      texture{Tex rotate 90*y}
    }
    // Wall 1
    box {<0,0,D*10><W*10,H*10,D*10-Thick>
      texture{Tex}
    }
    // Wall 2
    box {<W*10,0,0><W*10-Thick,H*10,D*10>
      texture{Tex rotate 90*y}
    }
    translate translation-<W*5,0,D*5>
  }
#end



//make complex part of a building
#macro ComplexPart(W, D, H, translation, RoofBits)
  union {
    // Roof
    prism{linear_sweep linear_spline
      H*10, H*10+Thick,
      P,
      #local I=0;
      #while (I<P)
        #local X1=W*10*Path[I].u;
        #local Z1=W*10*Path[I].v;
        <X1,Z1>
        #local I=I+1;
      #end
      texture{RTex2}
    }

    // Roof Furniture
    ComplexRoof(W,D,H,RoofBits,Path,P)    
    // Walls
    #local I=0;
    #while (I<P-1)
      #local X1=W*10*Path[I].u;
      #local X2=W*10*Path[I+1].u;
      #local Z1=W*10*Path[I].v;
      #local Z2=W*10*Path[I+1].v;
      
      #local L = vlength(<X2,0,Z2>-<X1,0,Z1>)/2;
      
      box {<-L,0,0><L,H*10,0.1>
        texture{Tex}
        rotate -y*(180/pi * atan2(Z2-Z1,X2-X1))
        translate (<X2,0,Z2>+<X1,0,Z1>)/2
      }
      #local I=I+1;
    #end
    translate translation
  }
#end



//make cylindical part of a building
#macro CylPart(W, H, translation, RoofBits)
  union {
    // Roof
    cylinder {<0,H*10,0><0,H*10+Thick,0>, W*5
      texture{RTex2}
    }
    // Roof Furniture
    CylRoof(W,D,RoofBits)    
    // Main cylinder
    cylinder {0,y*H*10,W*5
      texture{Tex}
    }
    translate translation
  }
#end


#macro Roof(W,D,H,Bits)
  #if (mod(Bits,2))
    difference {
      box {<0,H*10,0><W*10,H*10+6,D*10>}
      box {<3,H*10,3><W*10-3,H*10+10,D*10-3>}
      texture {RTex1}
    }
  #end
  #if (mod(floor(Bits/2),2))
    union {
      box {<W,H*10,D><W*3,H*10+5,D*9>}
      box {<W*4,H*10,D><W*6,H*10+5,D*9>}
      box {<W*7,H*10,D><W*9,H*10+5,D*9>}
      texture {RTex2}
    }
  #end
  #if (mod(floor(Bits/4),2))
    union {
      box {<W,H*10,D><W*9,H*10+5,D*3>}
      box {<W,H*10,D*4><W*9,H*10+5,D*6>}
      box {<W,H*10,D*7><W*9,H*10+5,D*9>}
      texture {RTex2}
    }
  #end
  #if (mod(floor(Bits/8),2))
    union {
      #local I=0.5;
      #while (I<5)
        box {<W*I,H*10,D*I><W*(10-I),H*10+3+I*5,D*(10-I)>}
        #local I=I+0.5;
      #end
      texture {RTex1}
    }
  #end
  #if (mod(floor(Bits/16),2))
   union {
     #local SR=min(W/4,D/4)*10;
     sphere {<W*2.5,H*10-SR+10,D*2.5>, SR}
     sphere {<W*7.5,H*10-SR+10,D*2.5>, SR}
     sphere {<W*2.5,H*10-SR+10,D*7.5>, SR}
     sphere {<W*7.5,H*10-SR+10,D*7.5>, SR}
     texture {RTex1}
   }
  #end
  #if (mod(floor(Bits/32),2))
    object {Pyramid2
     scale <15,80,15>
     translate <W*5,H*10+3,D*5>
     texture {RTex1}
   }
  #end
  #if (mod(floor(Bits/64),2))
    object {Pyramid2
     rotate y*45
     scale <15,80,15>
     translate <W*5,H*10+3,D*5>
     texture {RTex1}
   }
  #end  
  #if (mod(floor(Bits/128),2))
    union {
      #local I=0;
      #while (I<=W*10)
        box {<-2,-6,-2><2,7,2>
          rotate y*45
          translate <I,H*10,0>
        }
        box {<-2,-6,-2><2,7,2>
          rotate y*45
          translate <I,H*10,D*10>
        }
        #declare I=I+10;
      #end
      #local I=0;
      #while (I<=D*10)
        box {<-2,-6,-2><2,7,2>
          rotate y*45
          translate <0,H*10,I>
        }
        box {<-2,-6,-2><2,7,2>
          rotate y*45
          translate <W*10,H*10,I>
        }
        #declare I=I+10;
      #end
     texture {RTex1}
   }
  #end  
  #if (mod(floor(Bits/256),2))
    union {
      box {<-3,-7,-3><3,9,3>
        translate <0,H*10,0>
      }
      box {<-3,-7,-3><3,9,3>
        translate <W*10,H*10,0>
      }
      box {<-3,-7,-3><3,9,3>
        translate <0,H*10,D*10>
      }
      box {<-3,-7,-3><3,9,3>
        translate <W*10,H*10,D*10>
      }
     texture {RTex1}
    }
  #end
  #if (mod(floor(Bits/512),2))
    union {
      box {<-2,0,-2><2,H*10,2> translate <0,0,0>}
      box {<-2,0,-2><2,H*10,2> translate <W*10,0,0>}
      box {<-2,0,-2><2,H*10,2> translate <W*10,0, D*10>}
      box {<-2,0,-2><2,H*10,2> translate <0,0, D*10>}
      #local I=0;
      #while (I<10)
        cylinder {<0,I*H,0>    <W*10,(I+2)*H,0>,1}
        cylinder {<0,(I+2)*H,0><W*10,(I+2)*H,0>,1}
        cylinder {<0,(I+2)*H,0><W*10,I*H,0>,1}
        cylinder {<0,I*H,D*10>    <W*10,(I+2)*H,D*10>,1}
        cylinder {<0,(I+2)*H,D*10><W*10,(I+2)*H,D*10>,1}
        cylinder {<0,(I+2)*H,D*10><W*10,I*H,D*10>,1}
        cylinder {<0,I*H,0>    <0,(I+2)*H,D*10>,1}
        cylinder {<0,(I+2)*H,0><0,(I+2)*H,D*10>,1}
        cylinder {<0,(I+2)*H,0><0,I*H,D*10>,1}
        cylinder {<W*10,I*H,0>    <W*10,(I+2)*H,D*10>,1}
        cylinder {<W*10,(I+2)*H,0><W*10,(I+2)*H,D*10>,1}
        cylinder {<W*10,(I+2)*H,0><W*10,I*H,D*10>,1}
        #local I=I+2;
      #end
      texture {RTex1}
    }
  #end
#end

#macro CylRoof(W,D,Bits)
  #if (mod(Bits,2))
    difference {
      cylinder {<0,H*10,0><0,H*10+6,0>,W*5}
      cylinder {<0,H*10,0><0,H*10+10,0>,W*5-1}
      texture {RTex1}
    }
  #end
  #if (mod(floor(Bits/2),2))
    union {
      torus {W*4,6 translate y*H*10}
      torus {W*3,6 translate y*H*10}
      torus {W*2,6 translate y*H*10}
      torus {W*1,6 translate y*H*10}
      texture {RTex2}
    }
  #end
  #if (mod(floor(Bits/4),2))
    torus {W*5+3,3 translate y*H*10
      texture {RTex1}
    }
  #end
  #if (mod(floor(Bits/8),2))
    union {
      #local I=0.5;
      #while (I<W)
        cylinder {<0,H*10,0><0,H*10+3+I*5,0>,W*5-I*5}
        #local I=I+1;
      #end
      texture {RTex2}
    }
  #end
  #if (mod(floor(Bits/16),2))
   #local SR=W*3.5;
   sphere {<0,H*10-SR+10,0>, SR
     texture {RTex1}
   }
  #end
  #if (mod(floor(Bits/32),2))
    object {Pyramid2
     scale <15,80,15>
     translate <0,H*10+3,0>
     texture {RTex1}
   }
  #end
  #if (mod(floor(Bits/64),2))
    object {Pyramid2
     rotate y*45
     scale <15,80,15>
     translate <0,H*10+3,0>
     texture {RTex1}
   }
  #end  
  #if (mod(floor(Bits/128),2))
    union {
      #local I=0;
      #while (I<=360)
        box {<-2,-6,-2><2,7,2>
          rotate y*45
          translate <W*5,H*10,0>
          rotate y*I
        }
        #declare I=I+15;
      #end
     texture {RTex1}
   }
  #end  
  #if (mod(floor(Bits/256),2))
    union {
      box {<-3,-7,-3><3,9,3>
        translate <W*5,H*10,0>
      }
      box {<-3,-7,-3><3,9,3>
        translate <-W*5,H*10,0>
      }
      box {<-3,-7,-3><3,9,3>
        translate <0,H*10,W*5>
      }
      box {<-3,-7,-3><3,9,3>
        translate <0,H*10,-W*5>
      }
     texture {RTex1}
    }
  #end
#end  

#macro ComplexRoof(W,D,H,Bits,Path,P)
  #if (mod(Bits,2))
   union {
    #local I=0;
    #while (I<P-1)
      #local X1=W*10*Path[I].u;
      #local X2=W*10*Path[I+1].u;
      #local Z1=W*10*Path[I].v;
      #local Z2=W*10*Path[I+1].v;
      
      cylinder {<X1,H*10+4,Z1>,<X2,H*10+4,Z2>,2}
      sphere {<X1,H*10+4,Z1>,2}
      #local I=I+1;
    #end
    texture {RTex1}
   } 
  #end
  #if (mod(floor(Bits/8),2))
    prism{conic_sweep linear_spline
      -1, 0,
      P,
      #local I=0;
      #while (I<P)
        #local X1=W*10*Path[I].u;
        #local Z1=W*10*Path[I].v;
        <X1,Z1>
        #local I=I+1;
      #end
      scale <-1,D*5,-1>
      texture{RTex1}
      translate y*(H*10+D*5+3)
    }
  #end
  #if (mod(floor(Bits/16),2))
   #local SR=W*2.5;
   sphere {<0,H*10-SR+10,0>, SR
     texture {RTex1}
   }
  #end
  #if (mod(floor(Bits/32),2))
    object {Pyramid2
     scale <15,80,15>
     translate <0,H*10+3,0>
     texture {RTex1}
   }
  #end
  #if (mod(floor(Bits/64),2))
    object {Pyramid2
     rotate y*45
     scale <15,80,15>
     translate <0,H*10+3,0>
     texture {RTex1}
   }
  #end  
  #if (mod(floor(Bits/256),2))
   union {
    #local I=0;
    #while (I<P-1)
      #local X1=W*10*Path[I].u;
      #local X2=W*10*Path[I+1].u;
      #local Z1=W*10*Path[I].v;
      #local Z2=W*10*Path[I+1].v;
      
      cylinder {<X1,H*10-10,Z1>,<X1,H*10+6,Z1>,4}
      #local I=I+1;
    #end
    texture {RTex1}
   }
  #end
#end
