// Persistence of Vision Ray Tracer Scene Description File
// File: CityScape.pov
// Vers: 3.5
// Desc:
// Date:
// Auth:Bryan Valencia

// Standard pre-defined colors
//
#include "colors.inc"
#include "skies.inc"
sky_sphere{S_Cloud1}
               
//the texture jpeg is hard-coded to be a 10x10 grid of tiles.
//1 tile is chosen for each building, and the same tile is used recursively over the whole thing.
//the difference between the 2 textures is only the reflection factor - it was taking too long with all the buildings reflecting.               
//the 'origin' tile, (lower left) is used for all the rooftops.

#declare BuildingTexture1 = texture{
	uv_mapping 
	pigment{
		image_map{jpeg "10x10.jpg"
			map_type 0
			interpolate 0
		}		
	}
	normal{
		bump_map{
			jpeg "10x10.jpg"
			map_type 0
			interpolate 0
		}    10
	}
	finish{reflection 0.4}
}

#declare BuildingTexture2 = texture{
	uv_mapping 
	pigment{
		image_map{jpeg "10x10.jpg"
			map_type 0
			interpolate 0
		}		
	}
	normal{
		bump_map{
			jpeg "10x10.jpg"
			map_type 0
			interpolate 0
		}    10
	}	
}


#declare R=seed(2);

/*
1    2
------ 2
|\   |
| \  |
|  \ |
|   \|
------ 1
3    4
A,B
*/


#macro UV(A,B,which) //the indices (0-9) of the cell we're using
	#local u1 = A/10;
	#local u2 = u1+0.1;
	#local v1 = B/10; 
	#local v2 = v1+0.1;
	#if (which=1)
		//            1       3       4
		uv_vectors <u1,v2>,<u1,v1>,<u2,v1>
	#else
		//			  1       2       4
		uv_vectors <u1,v2>,<u2,v2>,<u2,v1>		
	#end
#end

#macro Square(p1,p2,p3,p4,tilex, tiley)
	#local u1 = tilex/10;
	#local u2 = u1+0.1;
	#local v1 = tiley/10; 
	#local v2 = v1+0.1;

//	mesh{
		triangle{p1, p3, p4 uv_vectors <u1,v2>,<u1,v1>,<u2,v1>}	
		triangle{p1, p2, p4 uv_vectors <u1,v2>,<u2,v2>,<u2,v1>}	
//		texture{BuildingTexture}
//	}	
#end

//make a building
#macro Building(Width, Depth, Stories, translation) //width and depth in squares (10 feet)
	#declare Tile1 = int(rand(R)*10);
	#declare Tile2 = int(rand(R)*10);
	
	mesh{
//roof (always gets the home tile)
		Square(
			<0,Stories*10,Depth*10>,
			<Width*10,Stories*10,Depth*10>,
			<0,Stories*10,0>,
			<Width*10,Stories*10,0>,0,0
		)
		#declare A=0;
		#while (A<Width)
			#declare B=0;
			#while (B<Stories)
//back wall
				Square(
					<A*10,		B*10,		Depth*10>,
					<A*10+10,	B*10,		Depth*10>,
					<A*10,		B*10+10,	Depth*10>,
					<A*10+10,	B*10+10,	Depth*10>,
					Tile1,Tile2
				)
//front wall
				Square(
					<A*10,		B*10,		0>,
					<A*10+10,	B*10,		0>,
					<A*10,		B*10+10,	0>,
					<A*10+10,	B*10+10,	0>,
					Tile1,Tile2
				)
				
				#declare B=B+1;
			#end
			#declare A=A+1;
		#end



		#declare A=0;
		#while (A<Depth)
			#declare B=0;
			#while (B<Stories)
//side 1
				Square(
					<0,	B*10,		A*10>,
					<0,	B*10,		A*10+10>,
					<0,	B*10+10,	A*10>,
					<0,	B*10+10,	A*10+10>,
					Tile1,Tile2
				)
//side 2
				Square(
					<Width*10,	B*10,		A*10>,
					<Width*10,	B*10,		A*10+10>,
					<Width*10,	B*10+10,	A*10>,
					<Width*10,	B*10+10,	A*10+10>,
					Tile1,Tile2
				)				
				#declare B=B+1;
			#end
			#declare A=A+1;
		#end
		#declare A=rand(R);
		#if (A>0.6)
			texture{BuildingTexture1}		
		#else
			texture{BuildingTexture2}		
		#end
		
		translate translation		
	}	

#end

#declare J=-5;
#while (J<5)
	#declare K=-5;
	#while (K<5)
		#declare W=5+int(rand(R)*10);
		#declare D=5+int(rand(R)*10);
		#declare F=1+int(rand(R)*(10-sqrt(J*J+K*K))*8 );
		Building(W,D,F,<200*J,0,200*K>)
		#declare K=K+1;
	#end	
	#declare J=J+1;
#end

//This is the mosaic
/*
#declare A=0;
#while (A<10)
	#declare B=0;
	#while (B<10)		
		Square(<A,B+1,0>,<A+1,B+1,0>,<A,B,0>,<A+1,B,0>,A,B)
		#declare B=B+1;
	#end
	#declare A=A+1;
#end
*/


camera{
	location <1200,50,-1200> 
	look_at<0,50,0>
}

light_source{<-1,1,-1>*10000 color rgb 2 
	spotlight
	point_at <0,0,0>
	parallel
}


plane{y,0 pigment{color rgb .5}}



global_settings{
  max_trace_level 10
  ambient_light <.1,0,.3>
}   

