/* @file:	seashore.pov
 * @desc:	Attempting to have a seashore
 * @date:	04/10/2005
 * @auth:	Paolo Gibellini
 * @ack:	Christoph Hormann for waves tutorial
 *			pov-wiki for sand tutorial
 *			Sebastian H. for photons suggestions
 *			Tim Nikias for caustics suggestions
 *			David El Tom for blurred reflection and many useful suggestions 
 *			Torn for the fast fish used in scc
 * @note:	For a faster preview set 0 to blur_acqua variable
 * @todo:	Add some pebbles and maybe a sea star.
 *			Better shoal distribution (actually a simple sinusoid with some random)
 *			Increase comments and translate variable names in english.
 *			Final render (a week?).
 */
#include "functions.inc"

// Water visible or totally transparent (some underwater effect)?
#declare acqua_visibile=1;
// Night effect?
#declare notturno=0;
// Blurred texture?
#declare blur_acqua=1;
// How much blur //40; // How many rays to shoot  // 4 works (~ 1 hr) // 5 is better but slower (~ 10 hrs)
#declare quanta_blur=5;
// Photons or not?
#declare con_fotoni=1;
// Having or not water surface? 
#declare vedi_acqua=1;
// Having or not sand surface? 
#declare vedi_sabbia=1;
// Having or not fishes? 
#declare vedi_pesci=1;
// Three big fishes or a shoal of little fishes?
#declare tre_pescioni=0;
// How many fishes in the shoal?
#declare quanti_pesci=50;
// Golden sand or not?
#declare sabbia_dorata=1;
// Photon set (related to my tests) 5 is the set in attachment
#declare set_fotoni=5;


// radiosity (global illumination) settings
global_settings {
	#if(notturno)
	  	radiosity {
		    pretrace_start 0.08           // start pretrace at this size
		    pretrace_end   0.04           // end pretrace at this size
		    count 35                      // higher -> higher quality (1..1600) [35]
		    nearest_count 5               // higher -> higher quality (1..10) [5]
		    error_bound 1.8               // higher -> smoother, less accurate [1.8]
		    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
		    low_error_factor .5           // reduce error_bound during last pretrace step
		    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
		    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
		    brightness 1                  // brightness of radiosity effects (0..1) [1]
		
		    adc_bailout 0.01/2
		    //normal on                   // take surface normals into account [off]
		    //media on                    // take media into account [off]
		    //save_file "radiosity05.file"       // save radiosity data
		    load_file "radiosity05.file"       // load saved radiosity data
		    //always_sample off           // turn sampling in final trace off [on]
		    //max_sample 1.0              // maximum brightness of samples
	  	}
	#else
		assumed_gamma 1.0
	#end
	#if(con_fotoni)
	  	photons {
	      	spacing 0.01 //0.003
	     	//save_file "photons05.file"
	      	#switch(set_fotoni)
	      		#case(0)
	      			load_file "photons.file"
	      		#break
	      		#case(2)
	      			load_file "photons02.file"
	      		#break
	      		#case(4)
	      			load_file "photons04.file"
	      		#break
	      		#else
	      			load_file "photons05.file"
	      	#end
	    }
	    max_trace_level 10
    #end
}

// ----------------------------------------
camera {
  location  <0.0, 5, -7.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}
// ----------------------------------------
// Light ----------------------------------
#if(!notturno)
	light_source {
		<0, 0, 0>
		color rgb <1, 1, 1>
		translate <1500,2500,-2500>
		#if(con_fotoni)
			photons {
			    reflection off
			    refraction on
		 	}
		#end		 
	}
	// Supplementar light
	light_source{<0,2,2> color rgb <1, 1, 1>}
#end
// ----------------------------------------

// Textures -------------------------------
#declare t_sabbiosa=texture {
     pigment {
        granite
        color_map {
           [ 0.0     rgbft <0.670588, 0.505882, 0.321569, 0.0, 0.0> ]
           [ 1.0     rgbft <0.941176, 0.878431, 0.792157, 0.0, 0.0> ]
        }
        turbulence 0.75
        ramp_wave
        scale  0.01
     }
}
#declare t_sabbia_oro=texture {
     pigment {
        granite
        color_map {
           [ 0.0     rgbft <1, 0.827, 0.141, 0.0, 0.0> ]
           [ 1.0     rgbft <0.470588, 0.305882, 0.121569, 0.0, 0.0> ]
        }
        turbulence 0.75
        ramp_wave
        scale  0.01
     }
}

#if(sabbia_dorata)
	#declare t_sabbia=t_sabbia_oro;
#else
	#declare t_sabbia=t_sabbiosa;
#end

// This material arises from Christoph Hormann tutorial
// and was step by step modified following p.b.i. people
// indications (see credits above)
#declare m_water = color_map {
	[ 0.00 rgbt <0.217,0.552,0.877, 0.9> ]
	[ 0.90 rgbt <0.137,0.437,0.697, 0.95> ]
	[ 1.00 rgb <1,1,1> ]
}

#if(acqua_visibile)
	#if(blur_acqua)
		#declare BlurAmount = .75;// Amount of blurring  --- 0.2 works but .75 I like better
		#declare BlurSamples = quanta_blur; //How many rays to shoot   --- 40 for my pc is impossible. 5 is not too bad
		#declare BlurTranslation=4; //Default 10 //4 works
		
		#declare t_water = texture {
			average texture_map {
				#declare Ind = 0; 
		     	#declare S = seed(0); 
		      	#while(Ind < BlurSamples) 
		        	[1 // The pigment of the object: 
				    pigment{
				    	rgbt <0.217,0.552,0.877, 0.9>
				    	/*
				    	gradient z 
				    	color_map {m_water}
					    turbulence 0.9
					    */
				    }
		           // The surface finish: 
				    finish {
						diffuse 0.3
						ambient 0.0
				        reflection {0.3, 1 fresnel}
				        conserve_energy
						specular 0.3
						roughness 0.003
				    }
		           	// This is the actual trick:
		           	normal { 
		           		//bumps BlurAmount 
				        ripples BlurAmount
				        frequency 1
		             	translate <rand(S),rand(S),rand(S)>*BlurTranslation 
		             	scale 1000 
		             	//scale 0.001
		           	} 
		        	] 
		        	#declare Ind = Ind+1; 
		    	#end 
		    } 
		} 
	#else
		#declare t_water = texture {
		    pigment{
		    	rgbt <0.217,0.552,0.877, 0.9>
		    	/*
		    	gradient z 
		    	color_map {m_water}
			    turbulence 0.9
			    */
		    }
		    normal {
		        ripples 0.75
		        frequency 1
		        translate <-3,0,3>
		    }
		    finish {
				diffuse 0.3
				ambient 0.0
		        reflection {0.3, 1 fresnel}
		        conserve_energy
				specular 0.3
				roughness 0.003
		    }
		}
	#end
#else
	#declare t_water = texture {
	    pigment{
	    	rgbt <1,1,1,1>
	    }
	}
#end

#declare i_water =interior {
    ior 1.33
    fade_distance 0.3
	fade_power 1000
    fade_color <0.217,0.552,0.877>
}

#declare m_acqua =material {
    texture {t_water}
    interior {i_water}
}

#declare t_torn_fish=texture{
	pigment {
		bozo 
        color_map {
           [ 0.0     rgb <1, 1, 1> ]
           [ 0.8     rgb <0.5, 0.5, 0.5> ]
           [ 1.0     rgb <0.9,0.9,0.9> ]
        }
		scale .1
	}
	finish{phong.4 ambient.3}
}
// ----------------------------------------

// Objects --------------------------------
#declare sand=isosurface {
	function {
		y-sin(x*3*pi)*0.1-f_noise3d(x,y,z)-sin(z*2*pi)*0.1*f_noise3d(0,0,z)
	}
	accuracy 0.01
  	contained_by {box {<-5,-0.6,-5>, < 5, 1.2, 5>}}
  	max_gradient 2.0
}

#declare water=isosurface {
	function {
		y-sin(x*2*pi)*0.03-f_noise3d(x,0,z)*0.3
	}
  	contained_by {box {<-5,-2,-5>, < 5, 1, 5>}}
	accuracy 0.01
}
/*
#declare t_pesce=texture {
     pigment {rgb <1,0,0>}
}

#declare pesce=sphere{<0,0,0> 0.4 scale <0.2,0.2,1> texture {t_pesce}}
*/

// Torn fish ----------------------
#declare torn_fish=union{
	lathe {cubic_spline 6,v-u,v,<.3,.5>,u/5,-v,-2*v rotate-90*z} 
	disc{0,z,.5 clipped_by{sphere{x,1}}}
	disc{0,z,.5 clipped_by{sphere{x,1}} translate -x}
	scale 0.5 // Ora il pesce  lungo 1
	rotate <0,90,0>
}
// --------------------------------

#declare pesce=object{
	torn_fish
	texture{t_torn_fish}
}
// ----------------------------------------


// Scene ----------------------------------
plane {
	y, -1
  	texture {t_sabbia}
}

#if(vedi_sabbia)    
	object {sand
	  	texture {t_sabbia}
	  	translate <0,-0.2,0>
	}     
#end

#if(vedi_acqua)
	object {water
	  	material {m_acqua}
		#if(con_fotoni)
		  	photons {
			    target
			    reflection off
			    refraction on
			    collect off
		  	}
		#end
		translate <0,2,0>
	}
#end

#if(vedi_pesci)
	#if(tre_pescioni)
		//Tre Pescioni
		object {pesce scale 0.8 translate <0,2,0> rotate <0,30,0>}
		object {pesce scale 0.8 translate <0,2,-2> rotate <0,-20,0>}
		object {pesce scale 0.8 translate <0,2,-3> rotate <0,10,0>}
	#else
		/*
		object {pesce rotate <0,90,0>}
		sphere {<0,0,0> 0.5 pigment{rgbf <1,0,0,0.9>} translate <0,0,0>}
		*/
		#declare S1 = seed(123);
		#declare pz=0;
		#while(pz>-3)
			#declare pz=pz-3/quanti_pesci;
			#declare px=1+sin(2*pi*(pz/-3))-0.2+rand(S1)*0.4;
			#declare py=1.2+rand(S1)*0.8;
			object {pesce scale 0.3 rotate <0,rand(S1)*30,0> translate <px,py,pz>}			
		#end
	#end
#end

//cylinder {<-2,-2,-2> <2,4,2> 0.1 pigment{rgb <1,0,0> }}
